/*
 * Decompiled with CFR 0.152.
 */
package server.Management.unixServer;

import at.tugraz.genome.crypt.DesEncrypter;
import at.tugraz.genome.usermanagement.server.unixserver.VO.LdapAccountVO;
import com.opensymphony.module.user.provider.ejb.entity.ldap.LdapEntries;
import com.opensymphony.module.user.provider.ejb.entity.ldap.LdapEntriesHome;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import server.Management.Management;
import server.Management.samba.LdapOcMappings;
import server.Management.samba.LdapOcMappingsHome;
import server.Management.samba.OrganizationalunitsLdap;
import server.Management.samba.OrganizationalunitsLdapHome;
import server.Management.unixServer.UnixServer;
import server.Management.unixServer.UnixServerHome;
import server.Management.unixServer.UnixServerVO;
import server.Management.user.UserManagement;
import server.Management.user.UserManagementHome;

public class UnixServerManagerBean
extends Management
implements SessionBean {
    SessionContext sessionContext;
    private static final transient Log logger_ = LogFactory.getLog((Class)(class$server$Management$unixServer$UnixServerManagerBean == null ? (class$server$Management$unixServer$UnixServerManagerBean = UnixServerManagerBean.class$("server.Management.unixServer.UnixServerManagerBean")) : class$server$Management$unixServer$UnixServerManagerBean));
    private String ldap_dc;
    static /* synthetic */ Class class$server$Management$unixServer$UnixServerManagerBean;
    static /* synthetic */ Class class$server$Management$user$UserManagementHome;
    static /* synthetic */ Class class$server$Management$unixServer$UnixServerHome;
    static /* synthetic */ Class class$server$Management$samba$OrganizationalunitsLdapHome;
    static /* synthetic */ Class class$com$opensymphony$module$user$provider$ejb$entity$ldap$LdapEntriesHome;
    static /* synthetic */ Class class$server$Management$samba$LdapOcMappingsHome;

    public void ejbCreate() throws CreateException {
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("UserManagement");
            UserManagementHome userManagementHome = (UserManagementHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$server$Management$user$UserManagementHome == null ? (class$server$Management$user$UserManagementHome = UnixServerManagerBean.class$("server.Management.user.UserManagementHome")) : class$server$Management$user$UserManagementHome));
            UserManagement um = userManagementHome.create();
            this.ldap_dc = um.getLdapTreeRoot();
            logger_.info((Object)("ldap_dc :" + this.ldap_dc));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CreateException(e.getMessage());
        }
    }

    public void ejbRemove() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    public Collection getAllServers() {
        logger_.info((Object)"getAllServers");
        Vector<UnixServerVO> result = new Vector<UnixServerVO>();
        try {
            InitialContext ctx = new InitialContext();
            Object userref = ctx.lookup("UnixServer");
            UnixServerHome serverHome = (UnixServerHome)PortableRemoteObject.narrow((Object)userref, (Class)(class$server$Management$unixServer$UnixServerHome == null ? (class$server$Management$unixServer$UnixServerHome = UnixServerManagerBean.class$("server.Management.unixServer.UnixServerHome")) : class$server$Management$unixServer$UnixServerHome));
            Object refOrganizationalunitsLdap = ctx.lookup("OrganizationalunitsLdap");
            OrganizationalunitsLdapHome organizationalunitsLdapHome = (OrganizationalunitsLdapHome)PortableRemoteObject.narrow((Object)refOrganizationalunitsLdap, (Class)(class$server$Management$samba$OrganizationalunitsLdapHome == null ? (class$server$Management$samba$OrganizationalunitsLdapHome = UnixServerManagerBean.class$("server.Management.samba.OrganizationalunitsLdapHome")) : class$server$Management$samba$OrganizationalunitsLdapHome));
            Iterator it = serverHome.findAll().iterator();
            while (it.hasNext()) {
                UnixServer us = (UnixServer)it.next();
                UnixServerVO vo = new UnixServerVO(us);
                OrganizationalunitsLdap ouEO = organizationalunitsLdapHome.findByOU(us.getServername());
                vo.setDescription(ouEO.getDescription());
                result.add(vo);
            }
            logger_.debug((Object)"...done");
            return result;
        }
        catch (NamingException ex) {
            logger_.error((Object)ex);
        }
        catch (FinderException ex) {
            logger_.error((Object)ex);
        }
        return result;
    }

    public UnixServerVO getServer(String name) {
        logger_.info((Object)("getServer " + name));
        try {
            InitialContext ctx = new InitialContext();
            Object userref = ctx.lookup("UnixServer");
            UnixServerHome serverHome = (UnixServerHome)PortableRemoteObject.narrow((Object)userref, (Class)(class$server$Management$unixServer$UnixServerHome == null ? (class$server$Management$unixServer$UnixServerHome = UnixServerManagerBean.class$("server.Management.unixServer.UnixServerHome")) : class$server$Management$unixServer$UnixServerHome));
            UnixServerVO usVO = new UnixServerVO(serverHome.findByName(name));
            Object refOrganizationalunitsLdap = ctx.lookup("OrganizationalunitsLdap");
            OrganizationalunitsLdapHome organizationalunitsLdapHome = (OrganizationalunitsLdapHome)PortableRemoteObject.narrow((Object)refOrganizationalunitsLdap, (Class)(class$server$Management$samba$OrganizationalunitsLdapHome == null ? (class$server$Management$samba$OrganizationalunitsLdapHome = UnixServerManagerBean.class$("server.Management.samba.OrganizationalunitsLdapHome")) : class$server$Management$samba$OrganizationalunitsLdapHome));
            OrganizationalunitsLdap ouEO = organizationalunitsLdapHome.findByOU(usVO.getServername());
            usVO.setDescription(ouEO.getDescription());
            return usVO;
        }
        catch (NamingException ex) {
            logger_.error((Object)ex);
        }
        catch (FinderException ex) {
            logger_.error((Object)ex);
        }
        return null;
    }

    public boolean addServer(String servername, String ip, String pass, String description) {
        logger_.info((Object)("addServer " + servername));
        if (servername == null || servername.length() < 1) {
            return false;
        }
        DesEncrypter des = new DesEncrypter("User12!Man");
        try {
            InitialContext ctx = new InitialContext();
            Object userref = ctx.lookup("UnixServer");
            UnixServerHome serverHome = (UnixServerHome)PortableRemoteObject.narrow((Object)userref, (Class)(class$server$Management$unixServer$UnixServerHome == null ? (class$server$Management$unixServer$UnixServerHome = UnixServerManagerBean.class$("server.Management.unixServer.UnixServerHome")) : class$server$Management$unixServer$UnixServerHome));
            servername = servername.toLowerCase();
            String dn_ = "OU=" + servername + "," + this.ldap_dc;
            Object ref = ctx.lookup("LdapEntries");
            LdapEntriesHome ldapHome = (LdapEntriesHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$ldap$LdapEntriesHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$ldap$LdapEntriesHome = UnixServerManagerBean.class$("com.opensymphony.module.user.provider.ejb.entity.ldap.LdapEntriesHome")) : class$com$opensymphony$module$user$provider$ejb$entity$ldap$LdapEntriesHome));
            try {
                logger_.debug((Object)("searching for dn : " + dn_));
                ldapHome.findByDN(dn_);
                logger_.error((Object)("found " + dn_ + "... do seems to be a bug !!!"));
                return false;
            }
            catch (FinderException ex1) {
                try {
                    logger_.debug((Object)"creating ldap entries:");
                    Object refOrganizationalunitsLdap = ctx.lookup("OrganizationalunitsLdap");
                    OrganizationalunitsLdapHome organizationalunitsLdapHome = (OrganizationalunitsLdapHome)PortableRemoteObject.narrow((Object)refOrganizationalunitsLdap, (Class)(class$server$Management$samba$OrganizationalunitsLdapHome == null ? (class$server$Management$samba$OrganizationalunitsLdapHome = UnixServerManagerBean.class$("server.Management.samba.OrganizationalunitsLdapHome")) : class$server$Management$samba$OrganizationalunitsLdapHome));
                    logger_.debug((Object)" creating OrganizationalunitsLdap entry");
                    OrganizationalunitsLdap ouEO = organizationalunitsLdapHome.create(dn_, servername, description);
                    Object refLdapOcMappings = ctx.lookup("LdapOcMappings");
                    LdapOcMappingsHome ldapOcMappingsHome = (LdapOcMappingsHome)PortableRemoteObject.narrow((Object)refLdapOcMappings, (Class)(class$server$Management$samba$LdapOcMappingsHome == null ? (class$server$Management$samba$LdapOcMappingsHome = UnixServerManagerBean.class$("server.Management.samba.LdapOcMappingsHome")) : class$server$Management$samba$LdapOcMappingsHome));
                    logger_.debug((Object)" getting LdapOcMappings entry");
                    LdapOcMappings mapping = ldapOcMappingsHome.findbyName("organizationalUnit");
                    logger_.debug((Object)("found:" + mapping.getName() + " " + mapping.getId()));
                    logger_.debug((Object)("searching for parententry: " + this.ldap_dc));
                    LdapEntries parentEntry = ldapHome.findByDN(this.ldap_dc);
                    logger_.debug((Object)("found parent " + parentEntry.getDn()));
                    ldapHome.create(dn_, new Long(mapping.getId().intValue()), parentEntry.getId(), ouEO.getId());
                    logger_.debug((Object)"created sucessfully LDAP entry");
                }
                catch (FinderException fe) {
                    logger_.error((Object)("finder Exception " + (Object)((Object)fe)));
                    return false;
                }
                catch (CreateException ex) {
                    logger_.error((Object)ex);
                    return false;
                }
                serverHome.create(servername, ip, des.encrypt(pass));
                logger_.debug((Object)"created sucessfully Server entry ...done");
                return true;
            }
        }
        catch (NamingException ex) {
            logger_.error((Object)ex);
        }
        catch (CreateException ex) {
            logger_.error((Object)ex);
        }
        return false;
    }

    public boolean setServerPassword(String servername, String password) {
        logger_.info((Object)("setServerPassword " + servername));
        if (servername == null || servername.length() < 1) {
            return false;
        }
        servername = servername.toLowerCase();
        DesEncrypter des = new DesEncrypter("User12!Man");
        try {
            InitialContext ctx = new InitialContext();
            Object userref = ctx.lookup("UnixServer");
            UnixServerHome serverHome = (UnixServerHome)PortableRemoteObject.narrow((Object)userref, (Class)(class$server$Management$unixServer$UnixServerHome == null ? (class$server$Management$unixServer$UnixServerHome = UnixServerManagerBean.class$("server.Management.unixServer.UnixServerHome")) : class$server$Management$unixServer$UnixServerHome));
            UnixServer us = serverHome.findByName(servername);
            us.setPasswordDES(des.encrypt(password));
            return true;
        }
        catch (NamingException ex) {
            logger_.error((Object)ex);
        }
        catch (FinderException fe) {
            logger_.error((Object)fe);
        }
        return false;
    }

    public boolean editUnixServer(String serverName, String ip, String pass, String description) {
        logger_.info((Object)("editUnixServer " + serverName));
        if (serverName == null) {
            return false;
        }
        DesEncrypter des = new DesEncrypter("User12!Man");
        try {
            InitialContext ctx = new InitialContext();
            Object userref = ctx.lookup("UnixServer");
            UnixServerHome serverHome = (UnixServerHome)PortableRemoteObject.narrow((Object)userref, (Class)(class$server$Management$unixServer$UnixServerHome == null ? (class$server$Management$unixServer$UnixServerHome = UnixServerManagerBean.class$("server.Management.unixServer.UnixServerHome")) : class$server$Management$unixServer$UnixServerHome));
            UnixServer us = serverHome.findByName(serverName);
            us.setIp(ip);
            us.setPasswordDES(des.encrypt(pass));
            String servername = us.getServername().toLowerCase();
            Object refOrganizationalunitsLdap = ctx.lookup("OrganizationalunitsLdap");
            OrganizationalunitsLdapHome organizationalunitsLdapHome = (OrganizationalunitsLdapHome)PortableRemoteObject.narrow((Object)refOrganizationalunitsLdap, (Class)(class$server$Management$samba$OrganizationalunitsLdapHome == null ? (class$server$Management$samba$OrganizationalunitsLdapHome = UnixServerManagerBean.class$("server.Management.samba.OrganizationalunitsLdapHome")) : class$server$Management$samba$OrganizationalunitsLdapHome));
            OrganizationalunitsLdap ouEO = organizationalunitsLdapHome.findByOU(servername);
            ouEO.setDescription(description);
            return true;
        }
        catch (NamingException ex) {
            logger_.error((Object)ex);
        }
        catch (FinderException fe) {
            logger_.error((Object)fe);
        }
        return false;
    }

    public boolean deleteServer(String servername) {
        logger_.info((Object)("deleteServer " + servername));
        if (servername == null) {
            return false;
        }
        servername = servername.toLowerCase();
        String dn_ = "OU=" + servername + "," + this.ldap_dc;
        UnixServer server = null;
        try {
            InitialContext ctx = new InitialContext();
            Object userref = ctx.lookup("UnixServer");
            UnixServerHome serverHome = (UnixServerHome)PortableRemoteObject.narrow((Object)userref, (Class)(class$server$Management$unixServer$UnixServerHome == null ? (class$server$Management$unixServer$UnixServerHome = UnixServerManagerBean.class$("server.Management.unixServer.UnixServerHome")) : class$server$Management$unixServer$UnixServerHome));
            server = serverHome.findByName(servername);
            logger_.debug((Object)("found server:" + server.getServername()));
            Object ref = ctx.lookup("LdapEntries");
            LdapEntriesHome ldapHome = (LdapEntriesHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$ldap$LdapEntriesHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$ldap$LdapEntriesHome = UnixServerManagerBean.class$("com.opensymphony.module.user.provider.ejb.entity.ldap.LdapEntriesHome")) : class$com$opensymphony$module$user$provider$ejb$entity$ldap$LdapEntriesHome));
            LdapEntries ldapEntry = ldapHome.findByDN(dn_);
            if (ldapEntry != null) {
                try {
                    Iterator iter = ldapHome.findByParent(ldapEntry.getId()).iterator();
                    while (iter.hasNext()) {
                        LdapEntries usernodes = (LdapEntries)iter.next();
                        logger_.debug((Object)("remove node" + usernodes.getDn()));
                        usernodes.remove();
                    }
                }
                catch (FinderException fe) {
                    logger_.info((Object)"no nodes found!");
                }
            }
            Object refOrganizationalunitsLdap = ctx.lookup("OrganizationalunitsLdap");
            OrganizationalunitsLdapHome organizationalunitsLdapHome = (OrganizationalunitsLdapHome)PortableRemoteObject.narrow((Object)refOrganizationalunitsLdap, (Class)(class$server$Management$samba$OrganizationalunitsLdapHome == null ? (class$server$Management$samba$OrganizationalunitsLdapHome = UnixServerManagerBean.class$("server.Management.samba.OrganizationalunitsLdapHome")) : class$server$Management$samba$OrganizationalunitsLdapHome));
            OrganizationalunitsLdap ouEO = organizationalunitsLdapHome.findByOU(servername);
            ouEO.remove();
            ldapEntry.remove();
            server.remove();
        }
        catch (FinderException ex) {
            logger_.error((Object)ex);
        }
        catch (EJBException ex) {
            logger_.error((Object)ex);
        }
        catch (NamingException ex) {
            logger_.error((Object)ex);
        }
        catch (RemoveException ex) {
            logger_.error((Object)ex);
        }
        return false;
    }

    public Collection getAllAcountsOfServer(String servername) {
        Vector<LdapAccountVO> result;
        block6: {
            if (servername == null) {
                return null;
            }
            servername = servername.toLowerCase();
            String dn_ = "OU=" + servername + "," + this.ldap_dc;
            Iterator iter = null;
            result = new Vector<LdapAccountVO>();
            try {
                InitialContext ctx = new InitialContext();
                Object ref = ctx.lookup("LdapEntries");
                LdapEntriesHome ldapHome = (LdapEntriesHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$ldap$LdapEntriesHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$ldap$LdapEntriesHome = UnixServerManagerBean.class$("com.opensymphony.module.user.provider.ejb.entity.ldap.LdapEntriesHome")) : class$com$opensymphony$module$user$provider$ejb$entity$ldap$LdapEntriesHome));
                LdapEntries parentEntry = ldapHome.findByDN(dn_);
                Object refLdapOcMappings = ctx.lookup("LdapOcMappings");
                LdapOcMappingsHome ldapOcMappingsHome = (LdapOcMappingsHome)PortableRemoteObject.narrow((Object)refLdapOcMappings, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$ldap$LdapEntriesHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$ldap$LdapEntriesHome = UnixServerManagerBean.class$("com.opensymphony.module.user.provider.ejb.entity.ldap.LdapEntriesHome")) : class$com$opensymphony$module$user$provider$ejb$entity$ldap$LdapEntriesHome));
                LdapOcMappings mapping = ldapOcMappingsHome.findbyName("posixAccount");
                iter = ldapHome.findByParent(parentEntry.getId()).iterator();
                if (iter == null) break block6;
                while (iter.hasNext()) {
                    LdapEntries entry = (LdapEntries)iter.next();
                    if (entry.getOcMapId().longValue() != mapping.getId().longValue()) continue;
                    result.add(new LdapAccountVO(entry));
                }
            }
            catch (FinderException ex) {
                logger_.error((Object)ex);
            }
            catch (ClassCastException ex) {
                logger_.error((Object)ex);
            }
            catch (NamingException ex) {
                logger_.error((Object)ex);
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

