/*
 * Decompiled with CFR 0.152.
 */
package server.Management.user;

import at.tugraz.genome.crypt.DesEncrypter;
import at.tugraz.genome.usermanagement.server.MessageBean;
import at.tugraz.genome.usermanagement.server.application.VO.ApplicationVO;
import at.tugraz.genome.usermanagement.server.authentication.cache.CookieKeyCache;
import at.tugraz.genome.usermanagement.server.config.ConfigLoader;
import at.tugraz.genome.usermanagement.server.group.VO.SmallGroupVO;
import at.tugraz.genome.usermanagement.server.institut.VO.InstitutMembersVO;
import at.tugraz.genome.usermanagement.server.institut.VO.InstitutVO;
import at.tugraz.genome.usermanagement.server.right.VO.RightOfResourceVO;
import at.tugraz.genome.usermanagement.server.user.VO.ExtendedUserVO;
import at.tugraz.genome.usermanagement.server.user.VO.PwdUserVO;
import at.tugraz.genome.usermanagement.server.user.VO.UserVO;
import at.tugraz.genome.usermanagement.server.user.VOFactory.ExtendedUserVOFactory;
import at.tugraz.genome.usermanagement.server.user.VOFactory.UserVOFactory;
import at.tugraz.genome.usermanagement.server.user.cache.ExtendedUserVOCache;
import at.tugraz.genome.util.GeneralComparator;
import com.opensymphony.module.access.AccessManager;
import com.opensymphony.module.access.provider.BaseProvider;
import com.opensymphony.module.access.provider.ejb.OsAdminsHome;
import com.opensymphony.module.access.provider.ejb.OsGroupInRealm;
import com.opensymphony.module.access.provider.ejb.OsGroupInRealmHome;
import com.opensymphony.module.access.provider.ejb.OsLogging;
import com.opensymphony.module.access.provider.ejb.OsLoggingHome;
import com.opensymphony.module.access.provider.ejb.OsUserInRealm;
import com.opensymphony.module.access.provider.ejb.OsUserInRealmHome;
import com.opensymphony.module.access.provider.ejb.admin.OsLastlogin;
import com.opensymphony.module.access.provider.ejb.admin.OsLastloginHome;
import com.opensymphony.module.access.provider.ejb.admin.OsUserChangepassword;
import com.opensymphony.module.access.provider.ejb.admin.OsUserChangepasswordHome;
import com.opensymphony.module.access.provider.ejb.institut.OsInstitutMembers;
import com.opensymphony.module.access.provider.ejb.institut.OsInstitutMembersHome;
import com.opensymphony.module.propertyset.PropertiesException;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.ejb.types.StringEntityHome;
import com.opensymphony.module.propertyset.ejb.types.VO.DataEntityVO;
import com.opensymphony.module.propertyset.ejb.types.VO.DateEntityVO;
import com.opensymphony.module.propertyset.ejb.types.VO.DecimalEntityVO;
import com.opensymphony.module.propertyset.ejb.types.VO.NumberEntityVO;
import com.opensymphony.module.propertyset.ejb.types.VO.PropertySetVO;
import com.opensymphony.module.propertyset.ejb.types.VO.StringEntityVO;
import com.opensymphony.module.user.DuplicateEntityException;
import com.opensymphony.module.user.EntityNotFoundException;
import com.opensymphony.module.user.Group;
import com.opensymphony.module.user.ImmutableException;
import com.opensymphony.module.user.User;
import com.opensymphony.module.user.UserManager;
import com.opensymphony.module.user.provider.ejb.entity.OsUser;
import com.opensymphony.module.user.provider.ejb.entity.OsUserBean;
import com.opensymphony.module.user.provider.ejb.entity.OsUserHome;
import com.opensymphony.module.user.provider.ejb.entity.ldap.LdapEntries;
import com.opensymphony.module.user.provider.ejb.entity.ldap.LdapEntriesHome;
import com.opensymphony.module.user.provider.ejb.entity.login.OsLoginFailuresHome;
import com.opensymphony.module.user.provider.ejb.entity.password.OsPasswordOldFour;
import com.opensymphony.module.user.provider.ejb.entity.password.OsPasswordOldFourHome;
import com.opensymphony.module.user.provider.ejb.entity.password.OsPasswordPeriode;
import com.opensymphony.module.user.provider.ejb.entity.password.OsPasswordPeriodeHome;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import server.Management.Management;
import server.Management.institut.InstitutManagerBean;
import server.Management.rights.RightsManagementBean;
import server.Management.samba.GroupmembersLdap;
import server.Management.samba.GroupmembersLdapHome;
import server.Management.samba.GroupsLdap;
import server.Management.samba.GroupsLdapHome;
import server.Management.samba.LdapEntryObjclasses;
import server.Management.samba.LdapEntryObjclassesHome;
import server.Management.samba.LdapOcMappings;
import server.Management.samba.LdapOcMappingsHome;
import server.Management.samba.OrganizationalunitsLdap;
import server.Management.samba.OrganizationalunitsLdapHome;
import server.Management.samba.OrganizationsLdap;
import server.Management.samba.OrganizationsLdapHome;
import server.Management.samba.SambaDomainLdap;
import server.Management.samba.SambaDomainLdapHome;
import server.Management.samba.ejb.SambaGroup;
import server.Management.samba.ejb.SambaGroupHome;
import server.Management.samba.ejb.SambaProject;
import server.Management.samba.ejb.SambaProjectHome;
import server.Management.samba.vo.SambaDomainComputerVO;
import server.Management.samba.vo.SambaGroupVO;
import server.Management.samba.vo.SambaParameters;
import server.Management.samba.vo.SambaProjectVO;
import server.Management.unixServer.SSHConnection;
import server.Management.user.passwd.NTPasswd;
import server.Management.util.DBSequence;
import server.Management.util.DBSequenceHome;
import server.Management.util.FilterDoubleEntries;
import server.Management.util.MailManager;
import server.Management.util.MessageFromServer;
import server.Management.util.ServerConstants;

public class UserManagementBean
extends Management
implements SessionBean {
    private SessionContext sessionContext;
    private UserManager userManager_;
    private AccessManager accessManager_;
    private User user_;
    private static final transient Log logger_ = LogFactory.getLog((Class)(class$server$Management$user$UserManagementBean == null ? (class$server$Management$user$UserManagementBean = UserManagementBean.class$("server.Management.user.UserManagementBean")) : class$server$Management$user$UserManagementBean));
    static /* synthetic */ Class class$server$Management$user$UserManagementBean;
    static /* synthetic */ Class class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome;
    static /* synthetic */ Class class$com$opensymphony$module$user$provider$ejb$entity$password$OsPasswordOldFourHome;
    static /* synthetic */ Class class$com$opensymphony$module$user$provider$ejb$entity$password$OsPasswordPeriodeHome;
    static /* synthetic */ Class class$com$opensymphony$module$access$provider$ejb$admin$OsUserChangepasswordHome;
    static /* synthetic */ Class class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome;
    static /* synthetic */ Class class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome;
    static /* synthetic */ Class class$com$opensymphony$module$access$provider$ejb$OsAdminsHome;
    static /* synthetic */ Class class$com$opensymphony$module$access$provider$ejb$institut$OsInstitutMembersHome;
    static /* synthetic */ Class class$com$opensymphony$module$access$provider$ejb$admin$OsLastloginHome;
    static /* synthetic */ Class class$com$opensymphony$module$access$provider$ejb$OsLoggingHome;
    static /* synthetic */ Class class$com$opensymphony$module$user$provider$ejb$entity$login$OsLoginFailuresHome;
    static /* synthetic */ Class class$server$Management$samba$GroupmembersLdapHome;
    static /* synthetic */ Class class$com$opensymphony$module$propertyset$ejb$types$StringEntityHome;
    static /* synthetic */ Class class$server$Management$samba$SambaDomainLdapHome;
    static /* synthetic */ Class class$server$Management$samba$OrganizationalunitsLdapHome;
    static /* synthetic */ Class class$server$Management$samba$GroupsLdapHome;
    static /* synthetic */ Class class$com$opensymphony$module$user$provider$ejb$entity$ldap$LdapEntriesHome;
    static /* synthetic */ Class class$server$Management$samba$LdapEntryObjclassesHome;
    static /* synthetic */ Class class$server$Management$samba$LdapOcMappingsHome;
    static /* synthetic */ Class class$server$Management$samba$ejb$SambaGroupHome;
    static /* synthetic */ Class class$server$Management$util$DBSequenceHome;
    static /* synthetic */ Class class$server$Management$samba$OrganizationsLdapHome;
    static /* synthetic */ Class class$server$Management$samba$ejb$SambaProjectHome;

    public void ejbRemove() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    public void ejbCreate() throws CreateException {
        this.userManager_ = UserManager.getInstance();
        this.accessManager_ = AccessManager.getInstance();
    }

    public MessageBean createUser(String username, String fullname, String password, boolean strongPassword, String changePeriode) throws ImmutableException, DuplicateEntityException {
        username = username.toLowerCase();
        logger_.info((Object)("createUser " + username));
        String decryptedPassword = new DesEncrypter(CookieKeyCache.getInstance().getKey()).decrypt(password);
        logger_.info((Object)("decryptedUserPassword: " + decryptedPassword));
        if (username == null || fullname == null || decryptedPassword == null) {
            return new MessageBean("user data was null, cannot create new user");
        }
        if (username.length() == 0) {
            return new MessageBean("user name has zero length, cannot create new user");
        }
        if (strongPassword && (ConfigLoader.getInstance().getProperties().getProperty("strongPasswords") == null || ConfigLoader.getInstance().getProperties().getProperty("strongPasswords").toUpperCase().equals("YES"))) {
            if (decryptedPassword != null && decryptedPassword.length() < 8) {
                return new MessageBean("password must execced 8 characters, cannot create new user");
            }
            if (!decryptedPassword.matches("(.)*([0-9])+(.)*")) {
                return new MessageBean("password must contain at least one number (0-9), cannot create new user");
            }
            if (!decryptedPassword.matches("(.)*(\\p{Punct})+(.)*")) {
                return new MessageBean("password must contain at least special character (!@#$%^&*()), cannot create new user");
            }
        }
        try {
            try {
                logger_.debug((Object)"createUser");
                this.userManager_.createUser(username);
                logger_.debug((Object)"createUser ...done");
            }
            catch (DuplicateEntityException ex) {
                throw new DuplicateEntityException("user already exists");
            }
            catch (ImmutableException ex) {
                throw new ImmutableException("cannot create user " + ex.toString());
            }
            User user = null;
            try {
                user = this.userManager_.getUser(username);
            }
            catch (EntityNotFoundException e) {
                return new MessageBean("internal error, cannot create new user : " + e);
            }
            user.setFullName(fullname);
            user.setPassword(decryptedPassword);
            logger_.debug((Object)"getting OSUser for setting variables");
            InitialContext ctx = new InitialContext();
            Object userref = ctx.lookup("OsUser");
            OsUserHome userHome = (OsUserHome)PortableRemoteObject.narrow((Object)userref, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome = UserManagementBean.class$("com.opensymphony.module.user.provider.ejb.entity.OsUserHome")) : class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome));
            OsUser osuser = userHome.findByName(username);
            NTPasswd sambaPasswords = new NTPasswd(decryptedPassword);
            osuser.setNt_pw(sambaPasswords.getNtPassword());
            osuser.setLm_pw(sambaPasswords.getLmPassword());
            logger_.debug((Object)"getting OSUser for setting variables ...done");
            logger_.debug((Object)"getting OsPasswordOldFour");
            Object passwordref = ctx.lookup("OsPasswordOldFour");
            OsPasswordOldFourHome passwordHome = (OsPasswordOldFourHome)PortableRemoteObject.narrow((Object)passwordref, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$password$OsPasswordOldFourHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$password$OsPasswordOldFourHome = UserManagementBean.class$("com.opensymphony.module.user.provider.ejb.entity.password.OsPasswordOldFourHome")) : class$com$opensymphony$module$user$provider$ejb$entity$password$OsPasswordOldFourHome));
            OsPasswordOldFour passwd = passwordHome.create(username);
            passwd.setCurrentpwd(new Long(1L));
            passwd.setOne(sambaPasswords.getNtPassword());
            logger_.debug((Object)"getting OsPasswordOldFour ...done");
            logger_.debug((Object)"getting OsPasswordPeriode");
            Object perioderef = ctx.lookup("OsPasswordPeriode");
            OsPasswordPeriodeHome passwordPeriodeHome = (OsPasswordPeriodeHome)PortableRemoteObject.narrow((Object)perioderef, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$password$OsPasswordPeriodeHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$password$OsPasswordPeriodeHome = UserManagementBean.class$("com.opensymphony.module.user.provider.ejb.entity.password.OsPasswordPeriodeHome")) : class$com$opensymphony$module$user$provider$ejb$entity$password$OsPasswordPeriodeHome));
            int months = 0;
            int weeks = 0;
            int years = 0;
            String periode_txt = ServerConstants.PERIODE_WEEKLY;
            if (changePeriode.equals(ServerConstants.PERIODE_NEVER)) {
                periode_txt = ServerConstants.PERIODE_NEVER;
            } else if (changePeriode.equals(ServerConstants.PERIODE_YEARLY)) {
                periode_txt = ServerConstants.PERIODE_YEARLY;
                years = 1;
            } else if (changePeriode.equals(ServerConstants.PERIODE_BI_YEARLY)) {
                periode_txt = ServerConstants.PERIODE_BI_YEARLY;
                months = 1;
            } else if (changePeriode.equals(ServerConstants.PERIODE_MONTHLY)) {
                periode_txt = ServerConstants.PERIODE_MONTHLY;
                months = 1;
            } else if (changePeriode.equals(ServerConstants.PERIODE_WEEKLY)) {
                periode_txt = ServerConstants.PERIODE_WEEKLY;
                weeks = 1;
            }
            OsPasswordPeriode passwdPeriode = passwordPeriodeHome.create(username, periode_txt);
            long currentDate = System.currentTimeMillis();
            passwdPeriode.setPwdate(new Long(currentDate));
            logger_.debug((Object)("periode" + periode_txt));
            if (periode_txt.equals(ServerConstants.PERIODE_NEVER)) {
                passwdPeriode.setPeriod(new Long(0L));
                logger_.debug((Object)"getting OsPasswordPeriode ... done");
                logger_.info((Object)"createUser ...done");
                return new MessageBean();
            }
            long expiredate = (long)weeks * 7L * 24L * 3600L * 1000L + (long)months * 31L * 24L * 3600L * 1000L + (long)years * 365L * 24L * 3600L * 1000L + currentDate;
            osuser.setPassMustChangeTime(new Long(expiredate / 1000L));
            passwdPeriode.setPeriod(new Long(expiredate));
            logger_.debug((Object)("expiredate " + expiredate));
            logger_.debug((Object)"getting OsPasswordPeriode ... done");
            logger_.info((Object)"createUser ...done");
            MessageBean message = new MessageBean();
            message.setError(false);
            return message;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new MessageBean("internal error, cannot create new user : " + e);
        }
    }

    public Vector getAllUsers() {
        logger_.info((Object)"getAllUsers ");
        Vector<UserVO> listOfUsers = new Vector<UserVO>();
        List users = null;
        try {
            if (this.userManager_ == null) {
                return null;
            }
            users = this.userManager_.getUsers();
            Iterator iterator = users.iterator();
            while (iterator.hasNext()) {
                User user = (User)iterator.next();
                String username = user.getName();
                if (username.endsWith("$") || username.startsWith("prj_")) continue;
                PropertySet properties = user.getPropertySet();
                listOfUsers.add(UserVOFactory.getUserVO(username));
            }
            Collections.sort(listOfUsers, new GeneralComparator("at.tugraz.genome.usermanagement.server.user.VO.UserVO", "getName", "java.lang.String"));
        }
        catch (Exception e) {
            logger_.fatal((Object)("Error : " + e.toString()));
            return null;
        }
        return listOfUsers;
    }

    public ExtendedUserVO getUserVOExtended(String name) {
        return this.getUserVOExtended(name, false);
    }

    public ExtendedUserVO getUserVOExtended(String name, boolean ignoreCache) {
        logger_.info((Object)("getUserVOExtended " + name));
        if (name == null || name.length() == 0) {
            return null;
        }
        logger_.debug((Object)("get UserVO of User : " + name));
        try {
            ExtendedUserVO vo = ExtendedUserVOFactory.getUserVO(name, ignoreCache);
            return vo;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Collection getKeysOfUser(String name) {
        logger_.info((Object)("getKeysOfUser " + name));
        if (name.length() == 0) {
            return null;
        }
        try {
            try {
                return this.userManager_.createUser(name).getPropertySet().getKeys();
            }
            catch (PropertiesException ex) {
                return null;
            }
            catch (DuplicateEntityException ex) {
                return null;
            }
            catch (ImmutableException ex) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean addPropertyToUser(String name, int type, String key, Object value) {
        logger_.info((Object)("addPropertyToUser " + name));
        if (name == null || key == null || value == null) {
            return false;
        }
        if (name.length() == 0 || key.length() == 0) {
            return false;
        }
        try {
            User user = this.userManager_.getUser(name);
            PropertySet properties = user.getPropertySet();
            switch (type) {
                case 5: {
                    properties.setString(key, (String)value);
                    return true;
                }
                case 1: {
                    if (((String)value).equals("1") || ((String)value).toLowerCase().equals("true")) {
                        properties.setBoolean(key, true);
                    } else {
                        properties.setBoolean(key, false);
                    }
                    return true;
                }
                case 10: {
                    properties.setData(key, (byte[])value);
                    return true;
                }
                case 7: {
                    properties.setDate(key, (Long)value);
                    return true;
                }
                case 4: {
                    properties.setDouble(key, (Double)value);
                    return true;
                }
                case 2: {
                    properties.setInt(key, (Integer)value);
                    return true;
                }
                case 3: {
                    properties.setLong(key, (Long)value);
                    return true;
                }
                case 8: {
                    properties.setObject(key, value);
                    return true;
                }
                case 6: {
                    properties.setText(key, (String)value);
                    return true;
                }
                case 9: {
                    properties.setXML(key, (Document)value);
                    return true;
                }
            }
            return false;
        }
        catch (EntityNotFoundException ex) {
            return false;
        }
    }

    public MessageBean setPassword(String name, String password, String changePeriode, boolean strong, boolean sendMail) {
        logger_.info((Object)("setPassword " + name));
        String decryptedPassword = new DesEncrypter(CookieKeyCache.getInstance().getKey()).decrypt(password);
        logger_.info((Object)("decryptedUserPassword: " + decryptedPassword));
        if (name == null || name.length() == 0 || decryptedPassword == null || decryptedPassword.length() == 0) {
            logger_.error((Object)"setPassword(): username or password null");
            return new MessageBean("given name or password is null");
        }
        try {
            InitialContext ctx = new InitialContext();
            Object userref = ctx.lookup("OsUser");
            OsUserHome userHome = (OsUserHome)PortableRemoteObject.narrow((Object)userref, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome = UserManagementBean.class$("com.opensymphony.module.user.provider.ejb.entity.OsUserHome")) : class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome));
            OsUser osuser = userHome.findByName(name);
            User user = this.userManager_.getUser(name);
            user.setPassword(decryptedPassword);
            String emailaddress = user.getEmail();
            String newPasswordHash = null;
            try {
                logger_.debug((Object)"calculating new NTPasswd hash");
                NTPasswd ntPW = new NTPasswd(decryptedPassword);
                newPasswordHash = ntPW.getNtPassword();
            }
            catch (Exception ex6) {
                return new MessageBean("internal error, cannot create Windows NT password");
            }
            if (strong && ConfigLoader.getInstance().getProperties().getProperty("strongPasswords").toUpperCase().equals("YES")) {
                if (decryptedPassword != null && decryptedPassword.length() < 8) {
                    return new MessageBean("password must execced 8 characters");
                }
                if (!decryptedPassword.matches("(.)*([0-9])+(.)*")) {
                    return new MessageBean("password must contain at least one number (0-9)");
                }
                if (!decryptedPassword.matches("(.)*(\\p{Punct})+(.)*")) {
                    return new MessageBean("password must contain at least special character (!@#$%^&*())");
                }
                OsPasswordOldFourHome passwordHome = null;
                String oldPasswordHash = null;
                try {
                    logger_.debug((Object)"check older four strong passwords..");
                    Object passwordref = ctx.lookup("OsPasswordOldFour");
                    oldPasswordHash = osuser.getNt_pw();
                    passwordHome = (OsPasswordOldFourHome)PortableRemoteObject.narrow((Object)passwordref, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$password$OsPasswordOldFourHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$password$OsPasswordOldFourHome = UserManagementBean.class$("com.opensymphony.module.user.provider.ejb.entity.password.OsPasswordOldFourHome")) : class$com$opensymphony$module$user$provider$ejb$entity$password$OsPasswordOldFourHome));
                    OsPasswordOldFour passwd = passwordHome.findByUsername(name);
                    if (newPasswordHash.equals(passwd.getOne())) {
                        logger_.error((Object)"password one is equal, password allready used before");
                        return new MessageBean("new password already used before");
                    }
                    if (newPasswordHash.equals(passwd.getTwo())) {
                        logger_.error((Object)"password two is equal, password allready used before");
                        return new MessageBean("new password already used before");
                    }
                    if (newPasswordHash.equals(passwd.getThree())) {
                        logger_.error((Object)"password three is equal, password already used before");
                        return new MessageBean("new password already used before");
                    }
                    if (newPasswordHash.equals(passwd.getFour())) {
                        logger_.error((Object)"password four is equal, password allready used before");
                        return new MessageBean("new password already used before");
                    }
                }
                catch (FinderException ex2) {
                    logger_.debug((Object)"password not yet changed, create new entry");
                    try {
                        OsPasswordOldFour pass = passwordHome.create(name);
                        pass.setCurrentpwd(new Long(0L));
                        pass.setOne(oldPasswordHash);
                    }
                    catch (CreateException ex5) {
                        return new MessageBean("internal error, cannot create new entry for password duration");
                    }
                }
                catch (NamingException ex2) {
                    return new MessageBean("internal error, cannot create new entry for password duration");
                }
            }
            logger_.debug((Object)"change password periode in database");
            Object perioderef = null;
            OsPasswordPeriode passwdPeriode = null;
            OsPasswordPeriodeHome passwordPeriodeHome = null;
            try {
                InitialContext context = new InitialContext();
                perioderef = context.lookup("OsPasswordPeriode");
                passwordPeriodeHome = (OsPasswordPeriodeHome)PortableRemoteObject.narrow((Object)perioderef, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$password$OsPasswordPeriodeHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$password$OsPasswordPeriodeHome = UserManagementBean.class$("com.opensymphony.module.user.provider.ejb.entity.password.OsPasswordPeriodeHome")) : class$com$opensymphony$module$user$provider$ejb$entity$password$OsPasswordPeriodeHome));
                passwdPeriode = passwordPeriodeHome.findByUsername(name);
            }
            catch (NamingException ex7) {
                logger_.error((Object)ex7);
                return new MessageBean("internal error, cannot set periode of password changing");
            }
            catch (FinderException ex8) {
                try {
                    passwdPeriode = passwordPeriodeHome.create(name, ServerConstants.PERIODE_MONTHLY);
                    logger_.debug((Object)("created new passwdPeriode for user " + name));
                }
                catch (CreateException ex9) {
                    logger_.error((Object)ex9);
                    return new MessageBean("internal error, cannot set periode of password changing");
                }
            }
            long currentDate = System.currentTimeMillis();
            passwdPeriode.setPwdate(new Long(currentDate));
            int days = 0;
            int months = 0;
            int weeks = 0;
            int years = 0;
            String periode_txt = ServerConstants.PERIODE_WEEKLY;
            if (changePeriode.equals(ServerConstants.PERIODE_NEVER)) {
                periode_txt = ServerConstants.PERIODE_NEVER;
            } else if (changePeriode.equals(ServerConstants.PERIODE_YEARLY)) {
                periode_txt = ServerConstants.PERIODE_YEARLY;
                years = 1;
            } else if (changePeriode.equals(ServerConstants.PERIODE_BI_YEARLY)) {
                periode_txt = ServerConstants.PERIODE_BI_YEARLY;
                days = 183;
            } else if (changePeriode.equals(ServerConstants.PERIODE_MONTHLY)) {
                periode_txt = ServerConstants.PERIODE_MONTHLY;
                months = 1;
            } else if (changePeriode.equals(ServerConstants.PERIODE_WEEKLY)) {
                periode_txt = ServerConstants.PERIODE_WEEKLY;
                weeks = 1;
            } else {
                weeks = 1;
            }
            passwdPeriode.setPwdtype(periode_txt);
            long expiredate = 0L;
            if (periode_txt.equals(ServerConstants.PERIODE_NEVER)) {
                passwdPeriode.setPeriod(new Long(0L));
                expiredate = OsUserBean.PASS_MUST_CHANGE_TIME_NEVER;
                logger_.debug((Object)"getting OsPasswordPeriode ... done");
            } else {
                expiredate = (long)weeks * 7L * 24L * 3600L * 1000L + (long)months * 31L * 24L * 3600L * 1000L + (long)years * 365L * 24L * 3600L * 1000L + (long)days * 24L * 3600L * 1000L + currentDate;
                logger_.debug((Object)("weeks: " + weeks + ", months: " + months + ", years: " + years));
                passwdPeriode.setPeriod(new Long(expiredate));
                logger_.info((Object)("set new passwdPeriode " + expiredate / 86400000L + " for user: " + name));
            }
            OsPasswordOldFour changePW = null;
            OsPasswordOldFourHome passwordHome = null;
            try {
                ctx = new InitialContext();
                Object passwordrefOld = ctx.lookup("OsPasswordOldFour");
                passwordHome = (OsPasswordOldFourHome)PortableRemoteObject.narrow((Object)passwordrefOld, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$password$OsPasswordOldFourHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$password$OsPasswordOldFourHome = UserManagementBean.class$("com.opensymphony.module.user.provider.ejb.entity.password.OsPasswordOldFourHome")) : class$com$opensymphony$module$user$provider$ejb$entity$password$OsPasswordOldFourHome));
                changePW = passwordHome.findByUsername(name);
                logger_.debug((Object)"set old four passwords...");
                Long currentPwd = changePW.getCurrentpwd();
                if (currentPwd == null) {
                    currentPwd = new Long(0L);
                }
                long currentPW = currentPwd;
                currentPW = (changePW.getCurrentpwd() + 1L) % 5L;
                if (currentPW == 0L) {
                    currentPW = 1L;
                }
                changePW.setCurrentpwd(new Long(currentPW));
                if (currentPW == 1L) {
                    changePW.setOne(newPasswordHash);
                }
                if (currentPW == 2L) {
                    changePW.setTwo(newPasswordHash);
                }
                if (currentPW == 3L) {
                    changePW.setThree(newPasswordHash);
                }
                if (currentPW == 4L) {
                    changePW.setFour(newPasswordHash);
                }
            }
            catch (NamingException ex4) {
                return new MessageBean("internal server error, cannot find OsPasswordOldFour");
            }
            catch (FinderException ex10) {
                logger_.debug((Object)("password of user " + name + "changed the first time"));
                try {
                    changePW = passwordHome.create(name);
                }
                catch (CreateException ex11) {
                    return new MessageBean("internal server error, cannot create oldfour");
                }
            }
            logger_.debug((Object)"setting NT && LM Password ");
            NTPasswd sambaPasswords = null;
            try {
                sambaPasswords = new NTPasswd(decryptedPassword);
                osuser.setNt_pw(sambaPasswords.getNtPassword());
                osuser.setLm_pw(sambaPasswords.getLmPassword());
                osuser.setPassLastSetTime(new Long(currentDate / 1000L));
                osuser.setPassCanChangeTime(new Long(currentDate / 1000L));
                if (periode_txt.equals(ServerConstants.PERIODE_NEVER)) {
                    osuser.setPassMustChangeTime(new Long(expiredate));
                } else {
                    osuser.setPassMustChangeTime(new Long(expiredate / 1000L));
                }
            }
            catch (Exception ex1) {
                ex1.printStackTrace();
                return new MessageBean("internal server error, set Windows NT passwords");
            }
            logger_.debug((Object)"delete flag for passwordchange");
            Object changePWref = ctx.lookup("OsUserChangepassword");
            OsUserChangepasswordHome passwordChangeHome = (OsUserChangepasswordHome)PortableRemoteObject.narrow((Object)changePWref, (Class)(class$com$opensymphony$module$access$provider$ejb$admin$OsUserChangepasswordHome == null ? (class$com$opensymphony$module$access$provider$ejb$admin$OsUserChangepasswordHome = UserManagementBean.class$("com.opensymphony.module.access.provider.ejb.admin.OsUserChangepasswordHome")) : class$com$opensymphony$module$access$provider$ejb$admin$OsUserChangepasswordHome));
            try {
                OsUserChangepassword flag = passwordChangeHome.findByPrimaryKey(name);
                flag.remove();
                logger_.debug((Object)("userHasToChangePasswordFlag deleted for  " + name));
            }
            catch (RemoveException ex3) {
                ex3.printStackTrace();
            }
            catch (FinderException ex3) {
                // empty catch block
            }
            logger_.debug((Object)"Updating Cache");
            ExtendedUserVOCache.getInstance().updateUser(name);
            if (emailaddress != null && sendMail) {
                logger_.debug((Object)"sending mail");
                String messageToUser = ConfigLoader.getInstance().getProperties().getProperty("changePassword1");
                messageToUser = messageToUser + " " + name + "\n";
                messageToUser = messageToUser + ConfigLoader.getInstance().getProperties().getProperty("changePassword2");
                messageToUser = messageToUser + " \"" + decryptedPassword + "\"";
                MailManager.send(emailaddress, messageToUser);
                logger_.info((Object)("send user : " + name + " a email with new password to address: " + emailaddress));
            }
            MessageBean msg = new MessageBean("action successfull");
            msg.setError(false);
            logger_.info((Object)"...done setPassword");
            return msg;
        }
        catch (NamingException ne) {
            ne.printStackTrace();
            return new MessageBean("internal server error, naming exception");
        }
        catch (FinderException fe) {
            fe.printStackTrace();
            return new MessageBean("internal server error, cannot find user");
        }
        catch (EntityNotFoundException ex) {
            logger_.error((Object)ex);
            return new MessageBean("internal server error, cannot find user");
        }
        catch (ImmutableException ex) {
            logger_.error((Object)ex);
            return new MessageBean("internal server error, cannot change password of user");
        }
    }

    public Vector getApplicationsForUser(String username) {
        logger_.info((Object)("getApplicationsForUser " + username));
        if (username == null) {
            return null;
        }
        logger_.debug((Object)("try get App for " + username));
        Vector<ApplicationVO> appList = new Vector<ApplicationVO>();
        User user = null;
        InitialContext ctx = null;
        Iterator iter = null;
        Iterator iter2 = null;
        try {
            user = UserManager.getInstance().getUser(username);
        }
        catch (EntityNotFoundException ex1) {
            return new Vector();
        }
        Vector groupList = new Vector(user.getGroups());
        logger_.debug((Object)("will look for group enabled in applications, user in " + groupList.size() + " groups"));
        try {
            ctx = new InitialContext();
            Object groupref = ctx.lookup("OsGroupInRealm");
            OsGroupInRealmHome grouphome = null;
            grouphome = (OsGroupInRealmHome)PortableRemoteObject.narrow((Object)groupref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome = UserManagementBean.class$("com.opensymphony.module.access.provider.ejb.OsGroupInRealmHome")) : class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome));
            iter = groupList.iterator();
            Vector groupRealmList = null;
            while (iter.hasNext()) {
                try {
                    groupRealmList = new Vector(grouphome.findAllRealmsOfGroup(((SmallGroupVO)iter.next()).getName()));
                }
                catch (FinderException ex2) {
                    logger_.debug((Object)"group not enabled in an application");
                }
                iter2 = groupRealmList.iterator();
                while (iter2.hasNext()) {
                    OsGroupInRealm app = (OsGroupInRealm)iter2.next();
                    logger_.debug((Object)("add application " + app.getRealm()));
                    appList.add(new ApplicationVO(app.getRealm()));
                }
            }
            logger_.debug((Object)("size of Apps from groups: " + appList.size()));
        }
        catch (NamingException ex3) {
            ex3.printStackTrace();
        }
        try {
            ctx = new InitialContext();
            Object ref = ctx.lookup("OsUserInRealm");
            OsUserInRealmHome home = null;
            home = (OsUserInRealmHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome = UserManagementBean.class$("com.opensymphony.module.access.provider.ejb.OsUserInRealmHome")) : class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome));
            Vector realmList = new Vector(home.findAllRealmsOfUser(username));
            logger_.debug((Object)("size of Apps: " + realmList.size()));
            iter = realmList.iterator();
            while (iter.hasNext()) {
                OsUserInRealm userInRealm = (OsUserInRealm)iter.next();
                appList.add(new ApplicationVO(userInRealm.getRealm()));
            }
            return FilterDoubleEntries.filterApplications(appList);
        }
        catch (NamingException ex) {
            logger_.error((Object)ex);
        }
        catch (FinderException ex) {
            logger_.error((Object)ex);
        }
        return new Vector();
    }

    public boolean deleteUser(String username) {
        logger_.info((Object)("deleteUser " + username));
        if (username == null) {
            return false;
        }
        if (username.equalsIgnoreCase("admin")) {
            return false;
        }
        Long userid = null;
        InitialContext ctx = null;
        try {
            User user = this.userManager_.getUser(username);
            List userGroups = user.getGroups();
            Iterator iter = userGroups.iterator();
            while (iter.hasNext()) {
                Group group = this.userManager_.getGroup(((SmallGroupVO)iter.next()).getName());
                logger_.debug((Object)("delete user from group " + group.getName()));
                user.removeFromGroup(group);
            }
            logger_.debug((Object)("delete user " + username));
            try {
                try {
                    ctx = new InitialContext();
                    Object userref = ctx.lookup("OsUser");
                    OsUserHome userHome = (OsUserHome)PortableRemoteObject.narrow((Object)userref, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome = UserManagementBean.class$("com.opensymphony.module.user.provider.ejb.entity.OsUserHome")) : class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome));
                    OsUser osuser = userHome.findByName(username);
                    userid = osuser.getId();
                    if (osuser.getDomain() != null) {
                        logger_.debug((Object)("delete user on samba server" + username));
                        SSHConnection sshConnection = new SSHConnection(this.getOrganizationalunitsLdap4CurrentDomain().getOu());
                        sshConnection.deleteUser(username, osuser.getUidNumber());
                        logger_.debug((Object)"delete user on samba server... done");
                    }
                    logger_.debug((Object)"delete the ldap entry");
                    UserManagementBean.removeUserLdapEntry(userid, "OU=users," + this.getOrganizationalunitsLdap4CurrentDomain().getDn());
                    logger_.debug((Object)"deleting user from samba projects");
                    try {
                        Object returnvalue = null;
                        DataSource ds = (DataSource)ctx.lookup("java:comp/env/MySqlDS");
                        Connection con = ds.getConnection();
                        Statement stmtE = con.createStatement();
                        stmtE.executeUpdate("delete from samba_project_user where userid = '" + userid + "'");
                        stmtE.close();
                        con.close();
                    }
                    catch (SQLException sqlex) {
                        logger_.error((Object)("Exception in sql Statement:" + sqlex));
                    }
                }
                catch (ObjectNotFoundException ex2) {
                    System.out.println("I am now in the caught exception");
                    System.out.println(ex2.toString());
                }
                catch (RemoveException ex2) {
                    ex2.printStackTrace();
                }
                catch (FinderException ex2) {
                    ex2.printStackTrace();
                }
                catch (NamingException ex2) {
                    ex2.printStackTrace();
                }
                catch (Exception ex2) {
                    System.out.println("I am now in the caught full exception");
                }
                logger_.debug((Object)"delete from template userList");
                this.accessManager_ = AccessManager.getInstance();
                Vector appList = new Vector(this.accessManager_.getResourceProviders());
                iter = appList.iterator();
                while (iter.hasNext()) {
                    Object userInRealm;
                    Object home;
                    Object ref;
                    String realm = ((BaseProvider)iter.next()).getRealm();
                    try {
                        ref = ctx.lookup("OsUserInRealm");
                        home = (OsUserInRealmHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome == null ? UserManagementBean.class$("com.opensymphony.module.access.provider.ejb.OsUserInRealmHome") : class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome));
                        userInRealm = home.findUserInRealm(username, realm);
                        userInRealm.remove();
                    }
                    catch (RemoveException ex) {
                        ex.printStackTrace();
                    }
                    catch (FinderException ex) {
                        logger_.debug((Object)("no user in OsUserInRealm found for application  " + realm));
                    }
                    catch (NamingException ex) {
                        ex.printStackTrace();
                    }
                    logger_.debug((Object)"delete from admin list");
                    try {
                        ctx = new InitialContext();
                        ref = ctx.lookup("OsAdmins");
                        home = (OsAdminsHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsAdminsHome == null ? UserManagementBean.class$("com.opensymphony.module.access.provider.ejb.OsAdminsHome") : class$com$opensymphony$module$access$provider$ejb$OsAdminsHome));
                        userInRealm = home.findByRealmAndUsername(realm, username);
                        userInRealm.remove();
                    }
                    catch (RemoveException ex) {
                        ex.printStackTrace();
                    }
                    catch (FinderException ex) {
                        logger_.debug((Object)("no user in OsAdmins found for appliaction " + realm));
                    }
                    catch (NamingException ex) {
                        ex.printStackTrace();
                    }
                }
                logger_.debug((Object)"delete the keys for user");
                PropertySet properties = user.getPropertySet();
                Vector keys = new Vector(properties.getKeys());
                iter = keys.iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    logger_.debug((Object)("will delete key " + key + " of user " + username));
                    properties.remove(key);
                }
                user.remove();
            }
            catch (ImmutableException ex) {
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            logger_.debug((Object)"remove user as memeber of institut");
            try {
                OsInstitutMembersHome home = null;
                ctx = new InitialContext();
                Object ref = ctx.lookup("OsInstitutMembers");
                home = (OsInstitutMembersHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$institut$OsInstitutMembersHome == null ? (class$com$opensymphony$module$access$provider$ejb$institut$OsInstitutMembersHome = UserManagementBean.class$("com.opensymphony.module.access.provider.ejb.institut.OsInstitutMembersHome")) : class$com$opensymphony$module$access$provider$ejb$institut$OsInstitutMembersHome));
                OsInstitutMembers member = (OsInstitutMembers)home.findByUsername(username, true).iterator().next();
                member.remove();
            }
            catch (FinderException ex1) {
                logger_.debug((Object)"user not found in institutemembers");
            }
            catch (RemoveException ex1) {
                ex1.printStackTrace();
            }
            catch (NamingException ex1) {
                ex1.printStackTrace();
            }
            catch (NoSuchElementException nsx) {
                logger_.debug((Object)"user not found in institutemembers");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            logger_.debug((Object)"remove last Passwords");
            try {
                Object passwordref = ctx.lookup("OsPasswordOldFour");
                OsPasswordOldFourHome passwordHome = (OsPasswordOldFourHome)PortableRemoteObject.narrow((Object)passwordref, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$password$OsPasswordOldFourHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$password$OsPasswordOldFourHome = UserManagementBean.class$("com.opensymphony.module.user.provider.ejb.entity.password.OsPasswordOldFourHome")) : class$com$opensymphony$module$user$provider$ejb$entity$password$OsPasswordOldFourHome));
                OsPasswordOldFour passwd = passwordHome.findByUsername(username);
                passwd.remove();
            }
            catch (RemoveException ex3) {
                logger_.error((Object)("OsPasswordOldFour : " + (Object)((Object)ex3)));
            }
            catch (FinderException ex3) {
                logger_.error((Object)("OsPasswordOldFour : " + (Object)((Object)ex3)));
            }
            catch (NamingException ex3) {
                logger_.error((Object)("OsPasswordOldFour : " + ex3));
            }
            logger_.debug((Object)"remove lastlogin");
            try {
                Object lastloginref = ctx.lookup("OsLastlogin");
                OsLastloginHome osLastloginHome = (OsLastloginHome)PortableRemoteObject.narrow((Object)lastloginref, (Class)(class$com$opensymphony$module$access$provider$ejb$admin$OsLastloginHome == null ? (class$com$opensymphony$module$access$provider$ejb$admin$OsLastloginHome = UserManagementBean.class$("com.opensymphony.module.access.provider.ejb.admin.OsLastloginHome")) : class$com$opensymphony$module$access$provider$ejb$admin$OsLastloginHome));
                OsLastlogin osLastlogin = osLastloginHome.findByUsername(username);
                osLastlogin.remove();
            }
            catch (RemoveException ex4) {
                ex4.printStackTrace();
            }
            catch (FinderException ex4) {
                logger_.debug((Object)("OsLastlogin : user not found " + username));
            }
            catch (NamingException ex4) {
                ex4.printStackTrace();
            }
            logger_.debug((Object)"remove logging");
            try {
                Object loggingref = ctx.lookup("OsLogging");
                OsLoggingHome osLoggingHome = (OsLoggingHome)PortableRemoteObject.narrow((Object)loggingref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsLoggingHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsLoggingHome = UserManagementBean.class$("com.opensymphony.module.access.provider.ejb.OsLoggingHome")) : class$com$opensymphony$module$access$provider$ejb$OsLoggingHome));
                Collection osLoggings = osLoggingHome.findByUsername(username);
                Vector v = new Vector(osLoggings);
                int i = 0;
                while (i < v.size()) {
                    OsLogging osLogging = (OsLogging)v.get(i);
                    try {
                        osLogging.remove();
                    }
                    catch (RemoveException ex4) {
                        ex4.printStackTrace();
                    }
                    ++i;
                }
            }
            catch (FinderException ex4) {
                logger_.debug((Object)("OsLogging : user not found " + username));
            }
            catch (NamingException ex4) {
                ex4.printStackTrace();
            }
            logger_.debug((Object)"remove loginfailures");
            try {
                Object failure = ctx.lookup("OsLoginFailures");
                OsLoginFailuresHome home = (OsLoginFailuresHome)PortableRemoteObject.narrow((Object)failure, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$login$OsLoginFailuresHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$login$OsLoginFailuresHome = UserManagementBean.class$("com.opensymphony.module.user.provider.ejb.entity.login.OsLoginFailuresHome")) : class$com$opensymphony$module$user$provider$ejb$entity$login$OsLoginFailuresHome));
                home.findbyName(username).remove();
            }
            catch (FinderException ex) {
            }
            catch (RemoveException ex) {
                ex.printStackTrace();
            }
            catch (NamingException ex) {
                ex.printStackTrace();
            }
            try {
                Object perioderef = ctx.lookup("OsPasswordPeriode");
                OsPasswordPeriodeHome passwordPeriodeHome = (OsPasswordPeriodeHome)PortableRemoteObject.narrow((Object)perioderef, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$password$OsPasswordPeriodeHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$password$OsPasswordPeriodeHome = UserManagementBean.class$("com.opensymphony.module.user.provider.ejb.entity.password.OsPasswordPeriodeHome")) : class$com$opensymphony$module$user$provider$ejb$entity$password$OsPasswordPeriodeHome));
                OsPasswordPeriode passwdPeriode = passwordPeriodeHome.findByUsername(username);
                passwdPeriode.remove();
            }
            catch (RemoveException ex4) {
                ex4.printStackTrace();
            }
            catch (FinderException ex4) {
                logger_.debug((Object)("OsPasswordPeriode : user not found " + username));
            }
            catch (NamingException ex4) {
                ex4.printStackTrace();
            }
            try {
                Object refGroupMembersLdap = ctx.lookup("GroupmembersLdap");
                GroupmembersLdapHome groupmembersLdapHome = (GroupmembersLdapHome)PortableRemoteObject.narrow((Object)refGroupMembersLdap, (Class)(class$server$Management$samba$GroupmembersLdapHome == null ? (class$server$Management$samba$GroupmembersLdapHome = UserManagementBean.class$("server.Management.samba.GroupmembersLdapHome")) : class$server$Management$samba$GroupmembersLdapHome));
                Vector v = new Vector(groupmembersLdapHome.findByUserName(username));
                int i = 0;
                while (i < v.size()) {
                    GroupmembersLdap gml = (GroupmembersLdap)v.get(i);
                    gml.remove();
                    ++i;
                }
            }
            catch (RemoveException ex4) {
                ex4.printStackTrace();
            }
            catch (FinderException ex4) {
                logger_.debug((Object)("user not found " + username));
            }
            catch (NamingException ex4) {
                ex4.printStackTrace();
            }
            logger_.debug((Object)"deleted user successfully");
            ExtendedUserVOCache.getInstance().removeUser(username);
            return true;
        }
        catch (EntityNotFoundException ex) {
            return true;
        }
    }

    public boolean setUserVO(ExtendedUserVO vo, boolean isAdmin) {
        boolean success;
        block42: {
            Serializable data;
            String key;
            logger_.info((Object)("setUserVO " + vo.getName()));
            if (vo == null) {
                return false;
            }
            success = true;
            PropertySetVO peropertiesVO = vo.getProperties();
            HashMap dataVO = peropertiesVO.getDataEntityVO();
            HashMap dateVO = peropertiesVO.getDateEntityVO();
            HashMap decimalVO = peropertiesVO.getDecimalEntityVO();
            HashMap numberVO = peropertiesVO.getNumberEntityVO();
            HashMap stringVO = peropertiesVO.getStringEntityVO();
            User user = null;
            try {
                user = this.userManager_.getUser(vo.getName());
            }
            catch (EntityNotFoundException ex) {
                logger_.error((Object)("user " + vo.getName() + "not found"));
                return false;
            }
            PropertySet properties = user.getPropertySet();
            PropertySetVO propertiesVO = vo.getProperties();
            Vector existingKeys = new Vector(properties.getKeys());
            Vector userKeys = new Vector(propertiesVO.getKeys());
            if (existingKeys.size() > userKeys.size()) {
                logger_.debug((Object)"!! keys has been deleted");
                Iterator iter = existingKeys.iterator();
                while (iter.hasNext()) {
                    String key2 = (String)iter.next();
                    logger_.debug((Object)("key: " + key2));
                    if (propertiesVO.exists(key2)) continue;
                    logger_.info((Object)("key " + key2 + " was deleted"));
                    if (!(key2.equals("fullName") || key2.equals("expiredate") || key2.equals("startdate") || key2.equals("email"))) {
                        properties.remove(key2);
                        continue;
                    }
                    logger_.error((Object)(key2 + " property is not allowed to be deleted"));
                }
            }
            logger_.info((Object)("email " + vo.getEmail()));
            logger_.info((Object)("fullName " + vo.getFullname()));
            logger_.info((Object)("expiredate " + vo.getExpireDate()));
            logger_.info((Object)("startdate " + vo.getStartDate()));
            properties.setString("email", vo.getEmail());
            properties.setString("fullName", vo.getFullname());
            properties.setDate("expiredate", vo.getExpireDate());
            properties.setDate("startdate", vo.getStartDate());
            Set set = null;
            Iterator iter = null;
            logger_.debug((Object)"update data info");
            set = dataVO.keySet();
            iter = set.iterator();
            while (iter.hasNext()) {
                key = (String)iter.next();
                data = (DataEntityVO)dataVO.get(key);
                properties.setData(((DataEntityVO)data).getKey(), ((DataEntityVO)data).getBytes());
            }
            logger_.info((Object)"update decimal info");
            set = decimalVO.keySet();
            iter = set.iterator();
            while (iter.hasNext()) {
                key = (String)iter.next();
                data = (DecimalEntityVO)decimalVO.get(key);
                if (((DecimalEntityVO)data).getType() == 4) {
                    logger_.info((Object)("update decimal info.... " + ((DecimalEntityVO)data).getKey()));
                    properties.setDouble(((DecimalEntityVO)data).getKey(), ((DecimalEntityVO)data).getValue());
                    continue;
                }
                logger_.error((Object)("unknown type in userVO => dataType, Key: " + ((DecimalEntityVO)data).getKey()));
                success = false;
            }
            logger_.debug((Object)"update string info");
            set = stringVO.keySet();
            iter = set.iterator();
            while (iter.hasNext()) {
                key = (String)iter.next();
                data = (StringEntityVO)stringVO.get(key);
                if (data == null) {
                    logger_.fatal((Object)("Stringproperty is null ! with key: " + key));
                    continue;
                }
                logger_.debug((Object)("got key: " + key + ", value: " + ((StringEntityVO)data).getValue()));
                if (((StringEntityVO)data).getValue() == null) {
                    ((StringEntityVO)data).setValue("");
                }
                if (!(((StringEntityVO)data).getValue().trim().length() != 0 || ((StringEntityVO)data).getKey().equals("email") && ((StringEntityVO)data).getKey().equals("startdate") && ((StringEntityVO)data).getKey().equals("institut") && ((StringEntityVO)data).getKey().equals("expiredate") && ((StringEntityVO)data).getKey().equals("fullName"))) {
                    properties.remove(((StringEntityVO)data).getKey());
                }
                if (!isAdmin) {
                    if (!((StringEntityVO)data).getKey().equals("disabledRealmList")) {
                        properties.setString(((StringEntityVO)data).getKey(), ((StringEntityVO)data).getValue());
                        continue;
                    }
                    logger_.debug((Object)("user is not allowed to change key: " + ((StringEntityVO)data).getKey()));
                    continue;
                }
                properties.setString(key, ((StringEntityVO)data).getValue());
                logger_.debug((Object)("updated key: " + key + ", value: " + ((StringEntityVO)data).getValue()));
            }
            logger_.debug((Object)"update date info");
            set = dateVO.keySet();
            iter = set.iterator();
            while (iter.hasNext()) {
                key = (String)iter.next();
                data = (DateEntityVO)dateVO.get(key);
                properties.setDate(((DateEntityVO)data).getKey(), ((DateEntityVO)data).getValue());
            }
            logger_.debug((Object)"update number info");
            set = numberVO.keySet();
            iter = set.iterator();
            while (iter.hasNext()) {
                key = (String)iter.next();
                data = (NumberEntityVO)numberVO.get(key);
                if (((NumberEntityVO)data).getType() == 1) {
                    if (((NumberEntityVO)data).getNumber() > 0L) {
                        properties.setBoolean(((NumberEntityVO)data).getKey(), true);
                        continue;
                    }
                    properties.setBoolean(((NumberEntityVO)data).getKey(), false);
                    continue;
                }
                if (((NumberEntityVO)data).getType() == 2) {
                    properties.setInt(((NumberEntityVO)data).getKey(), ((NumberEntityVO)data).getNumber().intValue());
                    continue;
                }
                if (((NumberEntityVO)data).getType() == 3) {
                    properties.setLong(((NumberEntityVO)data).getKey(), ((NumberEntityVO)data).getNumber());
                    continue;
                }
                logger_.error((Object)("unknown type in userVO => NumberEntityVO, Key: " + ((NumberEntityVO)data).getKey() + ", type " + ((NumberEntityVO)data).getType()));
                success = false;
            }
            logger_.debug((Object)("OsUserChangepassword (update flag (changePW))" + vo.isHasToChangePassword()));
            OsUserChangepasswordHome passwordHome = null;
            try {
                InitialContext ctx = new InitialContext();
                Object ref = ctx.lookup("OsUserChangepassword");
                passwordHome = (OsUserChangepasswordHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$admin$OsUserChangepasswordHome == null ? (class$com$opensymphony$module$access$provider$ejb$admin$OsUserChangepasswordHome = UserManagementBean.class$("com.opensymphony.module.access.provider.ejb.admin.OsUserChangepasswordHome")) : class$com$opensymphony$module$access$provider$ejb$admin$OsUserChangepasswordHome));
                OsUserChangepassword chgPw = passwordHome.findByPrimaryKey(vo.getName());
                if (vo.isHasToChangePassword()) break block42;
                try {
                    chgPw.remove();
                }
                catch (RemoveException ex) {
                    logger_.error((Object)ex);
                }
                catch (EJBException ex) {
                    logger_.error((Object)ex);
                }
                logger_.debug((Object)"deleted password flag");
            }
            catch (FinderException ex) {
                if (vo.isHasToChangePassword()) {
                    logger_.debug((Object)"no flag yet set, now set a new one");
                    try {
                        passwordHome.create(vo.getName());
                    }
                    catch (CreateException ex2) {
                        logger_.error((Object)("cannot create a new flag" + (Object)((Object)ex2)));
                    }
                }
            }
            catch (NamingException ex) {
                logger_.error((Object)ex);
            }
        }
        Object perioderef = null;
        OsPasswordPeriode passwdPeriode = null;
        OsPasswordPeriodeHome passwordPeriodeHome = null;
        OsUserHome userHome = null;
        OsUser osuser = null;
        try {
            InitialContext context = new InitialContext();
            Object userref = context.lookup("OsUser");
            userHome = (OsUserHome)PortableRemoteObject.narrow((Object)userref, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome = UserManagementBean.class$("com.opensymphony.module.user.provider.ejb.entity.OsUserHome")) : class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome));
            osuser = userHome.findByName(vo.getName());
            perioderef = context.lookup("OsPasswordPeriode");
            passwordPeriodeHome = (OsPasswordPeriodeHome)PortableRemoteObject.narrow((Object)perioderef, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$password$OsPasswordPeriodeHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$password$OsPasswordPeriodeHome = UserManagementBean.class$("com.opensymphony.module.user.provider.ejb.entity.password.OsPasswordPeriodeHome")) : class$com$opensymphony$module$user$provider$ejb$entity$password$OsPasswordPeriodeHome));
            passwdPeriode = passwordPeriodeHome.findByUsername(vo.getName());
        }
        catch (NamingException ex7) {
            ex7.printStackTrace();
        }
        catch (FinderException ex8) {
            try {
                passwdPeriode = passwordPeriodeHome.create(vo.getName(), vo.getChangePeriode());
                logger_.debug((Object)("created new passwdPeriode for user " + vo.getName()));
            }
            catch (CreateException ex9) {
                ex9.printStackTrace();
            }
        }
        long currentDate = System.currentTimeMillis();
        passwdPeriode.setPwdate(new Long(currentDate));
        if (vo.getChangePeriode().equals(ServerConstants.PERIODE_NEVER)) {
            passwdPeriode.setPeriod(new Long(0L));
            logger_.debug((Object)("passwdPeriode : never ! for user " + vo.getName()));
            passwdPeriode.setPwdtype(ServerConstants.PERIODE_NEVER);
            osuser.setPassMustChangeTime(new Long(OsUserBean.PASS_MUST_CHANGE_TIME_NEVER));
        } else {
            String periode_txt = ServerConstants.PERIODE_WEEKLY;
            int years = 0;
            int months = 0;
            int weeks = 0;
            int days = 0;
            if (vo.getChangePeriode().equals(ServerConstants.PERIODE_YEARLY)) {
                years = 1;
            }
            if (vo.getChangePeriode().equals(ServerConstants.PERIODE_BI_YEARLY)) {
                days = 183;
            }
            if (vo.getChangePeriode().equals(ServerConstants.PERIODE_MONTHLY)) {
                months = 1;
            }
            if (vo.getChangePeriode().equals(ServerConstants.PERIODE_WEEKLY)) {
                weeks = 1;
            }
            passwdPeriode.setPwdtype(vo.getChangePeriode());
            logger_.debug((Object)("periode days: " + days + ", weeks: " + weeks + ", months: " + months + ", years: " + years));
            long expiredate = (long)weeks * 7L * 24L * 3600L * 1000L + (long)months * 31L * 24L * 3600L * 1000L + (long)years * 365L * 24L * 3600L * 1000L + (long)days * 24L * 3600L * 1000L + currentDate;
            passwdPeriode.setPeriod(new Long(expiredate));
            osuser.setPassMustChangeTime(new Long(expiredate / 1000L));
            logger_.info((Object)("set new passwdPeriode " + expiredate / 86400000L + " for user: " + vo.getName()));
        }
        ExtendedUserVOCache.getInstance().updateUser(vo.getName());
        if (success) {
            logger_.debug((Object)"UserVO updated successfully");
            return true;
        }
        logger_.error((Object)"UserVO updated NOT successfully");
        return false;
    }

    private boolean checkRealm(String realm) {
        logger_.info((Object)("checkRealm " + realm));
        this.accessManager_ = this.getAccessManager();
        Vector v = new Vector(this.accessManager_.getResourceProviders());
        Iterator iter = v.iterator();
        while (iter.hasNext()) {
            String tmp = ((BaseProvider)iter.next()).getRealm();
            if (!tmp.equals(realm)) continue;
            return true;
        }
        return false;
    }

    public ExtendedUserVO getUserByIDExtended(Long ID) {
        logger_.info((Object)("getUserByIDExtended " + ID));
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("OsUser");
            OsUser osUser = null;
            OsUserHome home = (OsUserHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome = UserManagementBean.class$("com.opensymphony.module.user.provider.ejb.entity.OsUserHome")) : class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome));
            try {
                osUser = home.findByPrimaryKey(ID);
                ExtendedUserVO vo = ExtendedUserVOFactory.getUserVO(osUser.getName(), false);
                return vo;
            }
            catch (FinderException ex) {
                logger_.error((Object)ex.toString());
                return null;
            }
        }
        catch (NamingException ex) {
            logger_.error((Object)ex.toString());
            return null;
        }
    }

    public UserVO getUserVO(String name) {
        logger_.info((Object)("getUserVO " + name));
        if (name == null || name.length() == 0) {
            return null;
        }
        logger_.debug((Object)("get UserVO of User : " + name));
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("OsUser");
            OsUser osUser = null;
            OsUserHome home = (OsUserHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome = UserManagementBean.class$("com.opensymphony.module.user.provider.ejb.entity.OsUserHome")) : class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome));
            try {
                osUser = home.findByName(name);
                UserVO vo = UserVOFactory.getUserVO(osUser);
                return vo;
            }
            catch (FinderException ex) {
                logger_.error((Object)ex.toString());
                return null;
            }
        }
        catch (NamingException ex) {
            logger_.error((Object)ex.toString());
            return null;
        }
    }

    public static UserVO getUserByID(Long userId) {
        logger_.info((Object)("getUserByID " + userId));
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("OsUser");
            OsUser osUser = null;
            OsUserHome home = (OsUserHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome = UserManagementBean.class$("com.opensymphony.module.user.provider.ejb.entity.OsUserHome")) : class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome));
            try {
                osUser = home.findByPrimaryKey(userId);
                UserVO vo = UserVOFactory.getUserVO(osUser);
                vo.setID(userId);
                return vo;
            }
            catch (FinderException ex) {
                logger_.error((Object)ex.toString());
                return null;
            }
        }
        catch (ClassCastException ex) {
            logger_.error((Object)ex.toString());
            return null;
        }
        catch (NamingException ex) {
            logger_.error((Object)ex.toString());
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    public MessageFromServer existsUser(String username, String fullname, String email) {
        username = username.toLowerCase();
        UserManagementBean.logger_.info((Object)("existsUser " + username));
        if (username == null || fullname == null || email == null) {
            return null;
        }
        message = new MessageFromServer();
        checkAll = false;
        try {
            user = this.userManager_.getUser(username);
            checkAll = true;
            message = new MessageFromServer("\n user with this username exists already in database !\n");
            UserManagementBean.logger_.info((Object)"Setting Error Message to true from existsUser: ");
            message.setError(true);
            return message;
        }
        catch (EntityNotFoundException ex) {
            UserManagementBean.logger_.info((Object)"user with this username does not exist in database");
            home = null;
            try {
                ctx = new InitialContext();
                ref = ctx.lookup("StringEntity");
                home = (StringEntityHome)PortableRemoteObject.narrow((Object)ref, (Class)(UserManagementBean.class$com$opensymphony$module$propertyset$ejb$types$StringEntityHome == null ? (UserManagementBean.class$com$opensymphony$module$propertyset$ejb$types$StringEntityHome = UserManagementBean.class$("com.opensymphony.module.propertyset.ejb.types.StringEntityHome")) : UserManagementBean.class$com$opensymphony$module$propertyset$ejb$types$StringEntityHome));
            }
            catch (ClassCastException ex) {
                UserManagementBean.logger_.error((Object)ex);
                return null;
            }
            catch (NamingException ex) {
                UserManagementBean.logger_.error((Object)ex);
                return null;
            }
            entity = null;
            fullnameReverse = "";
            strTokenizer = new StringTokenizer(fullname);
            ** while (strTokenizer.hasMoreTokens())
        }
lbl-1000:
        // 1 sources

        {
            fullnameReverse = strTokenizer.nextToken() + fullnameReverse;
            continue;
        }
lbl34:
        // 1 sources

        try {
            entity = home.findByValue(fullname);
            message.setMessage("user with this fullname exists, maybe user is already in database\n");
            message.setError(false);
        }
        catch (FinderException ex) {
            UserManagementBean.logger_.info((Object)"user with this fullname does not exists");
        }
        try {
            entity = home.findByValue(email);
            message.concat("user with this email adress exists, maybe user is already in database\n");
            message.setError(false);
            return message;
        }
        catch (FinderException ex) {
            UserManagementBean.logger_.info((Object)"user with this does email does not exists");
            message = new MessageFromServer("user is not in database");
            message.setError(false);
            return message;
        }
    }

    public Long getUserIDFromName(String name) {
        logger_.info((Object)("getUserIDFromName " + name));
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("OsUser");
            OsUser osUser = null;
            OsUserHome home = (OsUserHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome = UserManagementBean.class$("com.opensymphony.module.user.provider.ejb.entity.OsUserHome")) : class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome));
            try {
                osUser = home.findByName(name);
                return osUser.getId();
            }
            catch (FinderException ex) {
                logger_.info((Object)"User with this name is not available");
                return null;
            }
        }
        catch (NamingException ex) {
            logger_.error((Object)ex.getMessage());
            return null;
        }
    }

    public boolean checkPassword(String username, String password) {
        logger_.info((Object)("checkPassword " + username));
        String decryptedPassword = new DesEncrypter(CookieKeyCache.getInstance().getKey()).decrypt(password);
        this.userManager_ = UserManager.getInstance();
        try {
            boolean result = this.userManager_.getUser(username).authenticate(decryptedPassword);
            logger_.debug((Object)("checkPassword: " + result));
            return result;
        }
        catch (EntityNotFoundException ex) {
            return false;
        }
    }

    public boolean setUserChangePassword(String username) {
        logger_.info((Object)("setUserChangePassword " + username));
        if (username == null) {
            return false;
        }
        try {
            InitialContext ctx = new InitialContext();
            Object userref = ctx.lookup("OsUser");
            OsUserHome userHome = (OsUserHome)PortableRemoteObject.narrow((Object)userref, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome = UserManagementBean.class$("com.opensymphony.module.user.provider.ejb.entity.OsUserHome")) : class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome));
            Long id = userHome.findByName(username).getId();
            Object ref = ctx.lookup("OsUserChangepassword");
            OsUserChangepasswordHome passwordHome = (OsUserChangepasswordHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$admin$OsUserChangepasswordHome == null ? (class$com$opensymphony$module$access$provider$ejb$admin$OsUserChangepasswordHome = UserManagementBean.class$("com.opensymphony.module.access.provider.ejb.admin.OsUserChangepasswordHome")) : class$com$opensymphony$module$access$provider$ejb$admin$OsUserChangepasswordHome));
            passwordHome.create(username);
            logger_.debug((Object)("user: " + username + " has to change his/her password"));
            ExtendedUserVOCache.getInstance().updateUser(username);
            return true;
        }
        catch (CreateException ex) {
            logger_.error((Object)ex);
            return false;
        }
        catch (FinderException ex) {
            logger_.error((Object)ex);
            return false;
        }
        catch (NamingException ex) {
            logger_.error((Object)ex);
            return false;
        }
    }

    public Vector getAllUsersExtended(boolean includeGlobalyDisabledUsers) {
        return this.getAllUsersExtended(includeGlobalyDisabledUsers, false);
    }

    public Vector getAllUsersExtended(boolean includeGlobalyDisabledUsers, boolean excludeUsersWithOutSambaAccount) {
        logger_.info((Object)"getAllUsersExtended ");
        Vector<ExtendedUserVO> listOfUsers = new Vector<ExtendedUserVO>();
        List users = null;
        try {
            if (this.userManager_ == null) {
                return null;
            }
            users = this.userManager_.getUsers();
            Iterator iterator = users.iterator();
            while (iterator.hasNext()) {
                User user = (User)iterator.next();
                String username = user.getName();
                if (username.endsWith("$") || username.startsWith("prj_")) continue;
                ExtendedUserVO vo = ExtendedUserVOFactory.getUserVO(user.getName(), false);
                if (excludeUsersWithOutSambaAccount && vo.getWindowsDomain() == "not available" || !vo.isApplicationAuthenticationEnabled() && !includeGlobalyDisabledUsers) continue;
                listOfUsers.add(vo);
            }
            Collections.sort(listOfUsers, new GeneralComparator("at.tugraz.genome.usermanagement.server.user.VO.ExtendedUserVO", "getName", "java.lang.String"));
        }
        catch (Exception e) {
            logger_.fatal((Object)("Error : " + e.toString()));
            e.printStackTrace();
            return null;
        }
        return listOfUsers;
    }

    public Collection findUserVOByRegEx(String regex, String realm) {
        logger_.info((Object)("findUserVOByRegEx " + regex));
        boolean startsWith = false;
        boolean endsWith = false;
        if (regex.toCharArray()[regex.length() - 1] == '*') {
            startsWith = true;
        }
        if (regex.toCharArray()[0] == '*') {
            endsWith = true;
        }
        if (startsWith && endsWith || !startsWith && !endsWith) {
            return new Vector();
        }
        StringTokenizer tokenizer = new StringTokenizer(regex, "*");
        regex = tokenizer.nextToken();
        Vector<UserVO> result = new Vector<UserVO>();
        List users = null;
        users = this.userManager_.getUsers();
        Iterator iter = users.iterator();
        while (iter.hasNext()) {
            User user = (User)iter.next();
            String name = user.getName();
            String fullName = "";
            if (user.getFullName() != null && user.getFullName().length() > 0) {
                fullName = user.getFullName().trim();
            }
            if (startsWith && fullName.startsWith(regex) && this.isInApplication(name, realm)) {
                result.add(UserVOFactory.getUserVO(name));
            }
            if (!endsWith || !fullName.endsWith(regex) || !this.isInApplication(name, realm)) continue;
            result.add(UserVOFactory.getUserVO(name));
        }
        return FilterDoubleEntries.filterUsers(result);
    }

    public Collection findUserVOExtendedByRegEx(String regex, String realm) {
        logger_.info((Object)("findUserVOByRegEx " + regex));
        boolean startsWith = false;
        boolean endsWith = false;
        if (regex.toCharArray()[regex.length() - 1] == '*') {
            startsWith = true;
        }
        if (regex.toCharArray()[0] == '*') {
            endsWith = true;
        }
        if (startsWith && endsWith || !startsWith && !endsWith) {
            return new Vector();
        }
        StringTokenizer tokenizer = new StringTokenizer(regex, "*");
        regex = tokenizer.nextToken();
        Vector<ExtendedUserVO> result = new Vector<ExtendedUserVO>();
        List users = null;
        users = this.userManager_.getUsers();
        Iterator iter = users.iterator();
        while (iter.hasNext()) {
            User user = (User)iter.next();
            String name = user.getName();
            String fullName = "";
            if (user.getFullName() != null && user.getFullName().length() > 0) {
                fullName = user.getFullName().trim();
            }
            if (startsWith && fullName.startsWith(regex) && this.isInApplication(name, realm)) {
                result.add(ExtendedUserVOFactory.getUserVO(name, false));
            }
            if (!endsWith || !fullName.endsWith(regex) || !this.isInApplication(name, realm)) continue;
            result.add(ExtendedUserVOFactory.getUserVO(name, false));
        }
        return FilterDoubleEntries.filterUsers(result);
    }

    private boolean isInApplication(String username, String realm) {
        logger_.info((Object)("isInApplication " + username + " " + realm));
        boolean isEnabled = false;
        Vector applications = this.getApplicationsForUser(username);
        int i = 0;
        while (i != applications.size()) {
            ApplicationVO vo = (ApplicationVO)applications.get(i);
            if (vo.getApplicationname().equalsIgnoreCase(realm)) {
                isEnabled = true;
            }
            ++i;
        }
        return isEnabled;
    }

    public static OrganizationalunitsLdap getOrganizationalunitsLdap4CurrentDomain() throws Exception {
        String domain = null;
        try {
            domain = ConfigLoader.getInstance().getProperties().getProperty("activeDomain");
            if (domain == null) {
                logger_.error((Object)"No Domain specified ind properties file");
                throw new Exception("No Domain specified ind properties file  !!!!");
            }
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("SambaDomainLdap");
            SambaDomainLdapHome sambaDomainLdapHome = (SambaDomainLdapHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$server$Management$samba$SambaDomainLdapHome == null ? (class$server$Management$samba$SambaDomainLdapHome = UserManagementBean.class$("server.Management.samba.SambaDomainLdapHome")) : class$server$Management$samba$SambaDomainLdapHome));
            SambaDomainLdap smbLDAP = sambaDomainLdapHome.findByDomain(domain);
            if (smbLDAP != null) {
                String hostName = smbLDAP.getSambaPDCHostname();
                Object refOU = ctx.lookup("OrganizationalunitsLdap");
                OrganizationalunitsLdapHome organizationalunitsLdapHome = (OrganizationalunitsLdapHome)PortableRemoteObject.narrow((Object)refOU, (Class)(class$server$Management$samba$OrganizationalunitsLdapHome == null ? (class$server$Management$samba$OrganizationalunitsLdapHome = UserManagementBean.class$("server.Management.samba.OrganizationalunitsLdapHome")) : class$server$Management$samba$OrganizationalunitsLdapHome));
                OrganizationalunitsLdap organizationalunitsLdap = organizationalunitsLdapHome.findByOU(hostName);
                return organizationalunitsLdap;
            }
        }
        catch (FinderException fex) {
            logger_.error((Object)("No Domain found in Database for " + domain));
            fex.printStackTrace();
            throw new Exception("No Domain found in Database for " + domain);
        }
        catch (NamingException nex) {
            nex.printStackTrace();
        }
        return null;
    }

    public boolean createSambaAccount4User(String username, String fullname, String domain, String email, String logonScript, String loginShell, String profilePath, String winHomeDir, String sambaHomeDir, String dirDrive, String userSid, Long uId, Long samba_groupId) {
        block6: {
            username = username.toLowerCase();
            logger_.info((Object)("createSambaAccount4User " + username));
            try {
                OsUser user = this.setSambaData(username, domain, logonScript, loginShell, profilePath, winHomeDir, sambaHomeDir, dirDrive, userSid, uId, samba_groupId);
                if (user == null) break block6;
                try {
                    OrganizationalunitsLdap organizationalunitsLdap = this.getOrganizationalunitsLdap4CurrentDomain();
                    InitialContext ctx = new InitialContext();
                    Object refGroupLdap = ctx.lookup("GroupsLdap");
                    GroupsLdapHome groupsLdapHome = (GroupsLdapHome)PortableRemoteObject.narrow((Object)refGroupLdap, (Class)(class$server$Management$samba$GroupsLdapHome == null ? (class$server$Management$samba$GroupsLdapHome = UserManagementBean.class$("server.Management.samba.GroupsLdapHome")) : class$server$Management$samba$GroupsLdapHome));
                    GroupsLdap groupsLdap = groupsLdapHome.findByCN("smb_user");
                    Object refGroupMembersLdap = ctx.lookup("GroupmembersLdap");
                    GroupmembersLdapHome groupmembersLdapHome = (GroupmembersLdapHome)PortableRemoteObject.narrow((Object)refGroupMembersLdap, (Class)(class$server$Management$samba$GroupmembersLdapHome == null ? (class$server$Management$samba$GroupmembersLdapHome = UserManagementBean.class$("server.Management.samba.GroupmembersLdapHome")) : class$server$Management$samba$GroupmembersLdapHome));
                    groupmembersLdapHome.create(username, groupsLdap.getId());
                    if (organizationalunitsLdap != null) {
                        if (user.getLdapAuthenticationEnabled() == 1L) {
                            this.addUserLdapEntry(username, "OU=users," + organizationalunitsLdap.getDn());
                        }
                        SSHConnection sshConnection = new SSHConnection(organizationalunitsLdap.getOu());
                        return sshConnection.addUser(username, user.getUidNumber(), fullname, user.getGidNumber(), email);
                    }
                    ExtendedUserVOCache.getInstance().updateUser(username);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static void removeUserLdapEntry(Long userid, String parentDN) throws NamingException, FinderException, RemoveException {
        InitialContext ctx = new InitialContext();
        Object refLdapEntries = ctx.lookup("LdapEntries");
        LdapEntriesHome ldapHome = (LdapEntriesHome)PortableRemoteObject.narrow((Object)refLdapEntries, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$ldap$LdapEntriesHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$ldap$LdapEntriesHome = UserManagementBean.class$("com.opensymphony.module.user.provider.ejb.entity.ldap.LdapEntriesHome")) : class$com$opensymphony$module$user$provider$ejb$entity$ldap$LdapEntriesHome));
        Object refLdapEntryObjclasses = ctx.lookup("LdapEntryObjclasses");
        LdapEntryObjclassesHome ldapEntryObjclassesHome = (LdapEntryObjclassesHome)PortableRemoteObject.narrow((Object)refLdapEntryObjclasses, (Class)(class$server$Management$samba$LdapEntryObjclassesHome == null ? (class$server$Management$samba$LdapEntryObjclassesHome = UserManagementBean.class$("server.Management.samba.LdapEntryObjclassesHome")) : class$server$Management$samba$LdapEntryObjclassesHome));
        LdapEntries parentDnEO = ldapHome.findByDN(parentDN);
        Vector ldap = new Vector(ldapHome.findByParentAndKeyVal(parentDnEO.getId(), userid));
        Iterator iter = ldap.iterator();
        while (iter.hasNext()) {
            LdapEntries entry = (LdapEntries)iter.next();
            logger_.debug((Object)("delete ldap entry with dn : " + entry.getDn()));
            Vector eoc_V = new Vector(ldapEntryObjclassesHome.findEntryID(entry.getId()));
            Iterator eoc_i = eoc_V.iterator();
            while (eoc_i.hasNext()) {
                LdapEntryObjclasses eoc = (LdapEntryObjclasses)eoc_i.next();
                logger_.debug((Object)("removing LdapEntryObjclasses " + eoc.getOcName()));
                eoc.remove();
            }
            entry.remove();
        }
        logger_.debug((Object)"ldap entry deleted successfully");
    }

    private boolean addUserLdapEntry(String username, String parentDN) {
        logger_.info((Object)("addUserLdapEntry " + username + " " + parentDN));
        InitialContext ctx = null;
        OsUserHome userHome = null;
        try {
            ctx = new InitialContext();
            Object userref = ctx.lookup("OsUser");
            userHome = (OsUserHome)PortableRemoteObject.narrow((Object)userref, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome = UserManagementBean.class$("com.opensymphony.module.user.provider.ejb.entity.OsUserHome")) : class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome));
            OsUser user = null;
            Object ldaptree = null;
            user = userHome.findByName(username);
            Long userid = user.getId();
            Object refLdapEntries = ctx.lookup("LdapEntries");
            LdapEntriesHome ldapEntryHome = (LdapEntriesHome)PortableRemoteObject.narrow((Object)refLdapEntries, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$ldap$LdapEntriesHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$ldap$LdapEntriesHome = UserManagementBean.class$("com.opensymphony.module.user.provider.ejb.entity.ldap.LdapEntriesHome")) : class$com$opensymphony$module$user$provider$ejb$entity$ldap$LdapEntriesHome));
            LdapEntries parentDnEO = ldapEntryHome.findByDN(parentDN);
            Object refLdapOcMappings = ctx.lookup("LdapOcMappings");
            LdapOcMappingsHome ldapOcMappingsHome = (LdapOcMappingsHome)PortableRemoteObject.narrow((Object)refLdapOcMappings, (Class)(class$server$Management$samba$LdapOcMappingsHome == null ? (class$server$Management$samba$LdapOcMappingsHome = UserManagementBean.class$("server.Management.samba.LdapOcMappingsHome")) : class$server$Management$samba$LdapOcMappingsHome));
            LdapOcMappings posixAccount = ldapOcMappingsHome.findbyName("posixAccount");
            LdapEntries currEntry = ldapEntryHome.create("UID=" + username + "," + parentDN, new Long(posixAccount.getId().longValue()), parentDnEO.getId(), userid);
            Object refLdapEntryObjclasses = ctx.lookup("LdapEntryObjclasses");
            LdapEntryObjclassesHome ldapEntryObjclassesHome = (LdapEntryObjclassesHome)PortableRemoteObject.narrow((Object)refLdapEntryObjclasses, (Class)(class$server$Management$samba$LdapEntryObjclassesHome == null ? (class$server$Management$samba$LdapEntryObjclassesHome = UserManagementBean.class$("server.Management.samba.LdapEntryObjclassesHome")) : class$server$Management$samba$LdapEntryObjclassesHome));
            ldapEntryObjclassesHome.create(currEntry.getId(), "sambaSAMAccount");
            ldapEntryObjclassesHome.create(currEntry.getId(), "shadowAccount");
            ldapEntryObjclassesHome.create(currEntry.getId(), "inetOrgPerson");
            ldapEntryObjclassesHome.create(currEntry.getId(), "top");
            return true;
        }
        catch (FinderException fex) {
            fex.printStackTrace();
            return false;
        }
        catch (NamingException nex) {
            nex.printStackTrace();
            return false;
        }
        catch (CreateException cex) {
            cex.printStackTrace();
            return false;
        }
    }

    public boolean removeLdapEntry(String dn) {
        logger_.info((Object)("removeLdapEntry " + dn));
        InitialContext ctx = null;
        Object userHome = null;
        try {
            ctx = new InitialContext();
            Object refLdapEntries = ctx.lookup("LdapEntries");
            LdapEntriesHome ldapEntryHome = (LdapEntriesHome)PortableRemoteObject.narrow((Object)refLdapEntries, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$ldap$LdapEntriesHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$ldap$LdapEntriesHome = UserManagementBean.class$("com.opensymphony.module.user.provider.ejb.entity.ldap.LdapEntriesHome")) : class$com$opensymphony$module$user$provider$ejb$entity$ldap$LdapEntriesHome));
            LdapEntries currentEntry = ldapEntryHome.findByDN(dn);
            Object refLdapEntryObjclasses = ctx.lookup("LdapEntryObjclasses");
            LdapEntryObjclassesHome ldapEntryObjclassesHome = (LdapEntryObjclassesHome)PortableRemoteObject.narrow((Object)refLdapEntryObjclasses, (Class)(class$server$Management$samba$LdapEntryObjclassesHome == null ? (class$server$Management$samba$LdapEntryObjclassesHome = UserManagementBean.class$("server.Management.samba.LdapEntryObjclassesHome")) : class$server$Management$samba$LdapEntryObjclassesHome));
            Vector v = new Vector(ldapEntryObjclassesHome.findEntryID(currentEntry.getId()));
            int i = 0;
            while (i < v.size()) {
                LdapEntryObjclasses eo = (LdapEntryObjclasses)v.get(i);
                logger_.debug((Object)("removing LdapEntryObjclasses " + eo.getOcName()));
                eo.remove();
                ++i;
            }
            logger_.debug((Object)("removing LdapEntries " + currentEntry.getDn()));
            currentEntry.remove();
            return true;
        }
        catch (FinderException fex) {
            fex.printStackTrace();
            return false;
        }
        catch (NamingException nex) {
            nex.printStackTrace();
            return false;
        }
        catch (RemoveException cex) {
            cex.printStackTrace();
            return false;
        }
    }

    public boolean updateSambaData(String username, String logonScript, String loginShell, String dirDrive, Long samba_groupId) {
        logger_.info((Object)("updateSambaData " + username));
        if (username == null) {
            logger_.error((Object)"cannot set windows data, not sufficient data received");
            return false;
        }
        try {
            InitialContext ctx = new InitialContext();
            Object userref = ctx.lookup("OsUser");
            OsUserHome userHome = (OsUserHome)PortableRemoteObject.narrow((Object)userref, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome = UserManagementBean.class$("com.opensymphony.module.user.provider.ejb.entity.OsUserHome")) : class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome));
            OsUser user = userHome.findByName(username);
            user.setLogin_script(logonScript);
            user.setDir_drive(dirDrive);
            Long oldSamba_groupId = user.getSambaGroupId();
            user.setSambaGroupId(samba_groupId);
            user.setLoginShell(loginShell);
            OrganizationalunitsLdap organizationalunitsLdap = this.getOrganizationalunitsLdap4CurrentDomain();
            UserManagementBean.removeUserLdapEntry(user.getId(), "OU=users," + this.getOrganizationalunitsLdap4CurrentDomain().getDn());
            if (user.getLdapAuthenticationEnabled() == 1L) {
                this.addUserLdapEntry(username, "OU=users," + organizationalunitsLdap.getDn());
            }
            if (samba_groupId != null) {
                UserManagementBean.reorganizeSambaProjectRights4User(username);
            }
            SSHConnection sshConnection = new SSHConnection(organizationalunitsLdap.getOu());
            ExtendedUserVOCache.getInstance().updateUser(username);
            return sshConnection.invalidateCache();
        }
        catch (FinderException ex) {
            logger_.info((Object)("could not find user " + username));
        }
        catch (NamingException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    private OsUser setSambaData(String username, String domain, String logonScript, String loginShell, String profilePath, String winHomeDir, String sambaHomeDir, String dirDrive, String userSid, Long uId, Long samba_groupId) throws Exception {
        if (username == null) {
            logger_.error((Object)"cannot set windows data, not sufficient data received");
            return null;
        }
        logger_.debug((Object)"setWindowsData");
        try {
            GroupsLdap groupsLdapDomain;
            InitialContext ctx = new InitialContext();
            Object userref = ctx.lookup("OsUser");
            OsUserHome userHome = (OsUserHome)PortableRemoteObject.narrow((Object)userref, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome = UserManagementBean.class$("com.opensymphony.module.user.provider.ejb.entity.OsUserHome")) : class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome));
            OsUser user = userHome.findByName(username);
            Object refGroupLdap = ctx.lookup("GroupsLdap");
            GroupsLdapHome groupsLdapHome = (GroupsLdapHome)PortableRemoteObject.narrow((Object)refGroupLdap, (Class)(class$server$Management$samba$GroupsLdapHome == null ? (class$server$Management$samba$GroupsLdapHome = UserManagementBean.class$("server.Management.samba.GroupsLdapHome")) : class$server$Management$samba$GroupsLdapHome));
            try {
                groupsLdapDomain = groupsLdapHome.findByCN("Domain Users");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            Object refGroupMembersLdap = ctx.lookup("GroupmembersLdap");
            GroupmembersLdapHome groupmembersLdapHome = (GroupmembersLdapHome)PortableRemoteObject.narrow((Object)refGroupMembersLdap, (Class)(class$server$Management$samba$GroupmembersLdapHome == null ? (class$server$Management$samba$GroupmembersLdapHome = UserManagementBean.class$("server.Management.samba.GroupmembersLdapHome")) : class$server$Management$samba$GroupmembersLdapHome));
            try {
                groupmembersLdapHome.findLdapGroupsId(groupsLdapDomain.getId());
                logger_.debug((Object)"found DomainUser in LDAP Tree in table Groupmembers");
            }
            catch (FinderException fe) {
                logger_.debug((Object)"will create new  DomainUser in LDAP Tree in table Groupmembers");
                groupmembersLdapHome.create(username, groupsLdapDomain.getId());
            }
            user.setDomain(domain);
            user.setLogin_script(logonScript);
            user.setWorkstations("false");
            user.setProfilePath(profilePath);
            user.setDir_drive(dirDrive);
            user.setUser_sid(userSid);
            user.setHomeDirectory(sambaHomeDir);
            user.setSambaDir(winHomeDir);
            user.setUidNumber(uId);
            user.setGidNumber(groupsLdapDomain.getGidNumber());
            Long oldSamba_groupId = user.getSambaGroupId();
            user.setSambaGroupId(samba_groupId);
            user.setLoginShell(loginShell);
            user.setAcctCtrl("[U          ]");
            if (samba_groupId != null) {
                UserManagementBean.reorganizeSambaProjectRights4User(username);
            }
            return user;
        }
        catch (FinderException ex) {
            ex.printStackTrace();
        }
        catch (CreateException ex) {
            ex.printStackTrace();
        }
        catch (NamingException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public boolean deleteProperty(String username, String propertyKey, int type) {
        if (username == null || propertyKey == null) {
            return false;
        }
        logger_.debug((Object)("will delete property " + propertyKey + " of user " + username));
        if (username.length() == 0 || propertyKey.length() == 0) {
            return false;
        }
        if (propertyKey.equalsIgnoreCase("fullName")) {
            return false;
        }
        if (propertyKey.equalsIgnoreCase("expiredate")) {
            return false;
        }
        if (propertyKey.equalsIgnoreCase("startdate")) {
            return false;
        }
        if (propertyKey.equalsIgnoreCase("email")) {
            return false;
        }
        try {
            User user = this.userManager_.getUser(username);
            PropertySet properties = user.getPropertySet();
            properties.remove(propertyKey);
            ExtendedUserVOCache.getInstance().updateUser(username);
            return true;
        }
        catch (PropertiesException ex) {
            return false;
        }
        catch (EntityNotFoundException ex) {
            return false;
        }
    }

    public boolean setStatusOfUserForApplicationLogin(String username, boolean status) {
        if (username == null) {
            return false;
        }
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("OsUser");
            OsUser osUser = null;
            OsUserHome home = (OsUserHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome = UserManagementBean.class$("com.opensymphony.module.user.provider.ejb.entity.OsUserHome")) : class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome));
            try {
                osUser = home.findByName(username);
                if (status) {
                    osUser.setApplicationAuthenticationEnabled(new Long(1L));
                    logger_.info((Object)"enabled user for all applications");
                } else {
                    osUser.setApplicationAuthenticationEnabled(new Long(0L));
                    logger_.info((Object)"disabled user for all applications");
                }
                ExtendedUserVOCache.getInstance().updateUser(username);
                return true;
            }
            catch (FinderException ex) {
                logger_.error((Object)ex.toString());
                return false;
            }
        }
        catch (NamingException ex1) {
            ex1.printStackTrace();
            return false;
        }
    }

    public void buildCache() {
        logger_.info((Object)"build up Cache for users");
    }

    public Collection getSambaGroups() {
        logger_.info((Object)"getSambaGroups");
        Vector<SambaGroupVO> result = new Vector<SambaGroupVO>();
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("SambaGroup");
            SambaGroupHome sambaGroupHome = (SambaGroupHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$server$Management$samba$ejb$SambaGroupHome == null ? (class$server$Management$samba$ejb$SambaGroupHome = UserManagementBean.class$("server.Management.samba.ejb.SambaGroupHome")) : class$server$Management$samba$ejb$SambaGroupHome));
            Iterator it = sambaGroupHome.findAll().iterator();
            while (it.hasNext()) {
                SambaGroup smbGroup = (SambaGroup)it.next();
                SambaGroupVO vo = new SambaGroupVO(smbGroup.getId(), smbGroup.getDisplayName(), smbGroup.getName());
                result.add(vo);
            }
        }
        catch (Exception ex) {
            logger_.error((Object)("Exception:" + ex));
        }
        return result;
    }

    public SambaParameters getSambaInitialProperties() {
        boolean smbEnabled = false;
        String sambaEnabled = ConfigLoader.getInstance().getProperties().getProperty("sambaServerEnabled");
        if (sambaEnabled == null) {
            smbEnabled = false;
        } else if (sambaEnabled.equalsIgnoreCase("YES")) {
            smbEnabled = true;
        } else if (sambaEnabled.equalsIgnoreCase("ON")) {
            smbEnabled = true;
        } else if (sambaEnabled.equalsIgnoreCase("TRUE")) {
            smbEnabled = true;
        }
        if (smbEnabled) {
            String domain = ConfigLoader.getInstance().getProperties().getProperty("activeDomain");
            try {
                InitialContext ctx = new InitialContext();
                Object ref = ctx.lookup("SambaDomainLdap");
                SambaDomainLdapHome sambaDomainLdapHome = (SambaDomainLdapHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$server$Management$samba$SambaDomainLdapHome == null ? (class$server$Management$samba$SambaDomainLdapHome = UserManagementBean.class$("server.Management.samba.SambaDomainLdapHome")) : class$server$Management$samba$SambaDomainLdapHome));
                SambaDomainLdap smbLDAP = sambaDomainLdapHome.findByDomain(domain);
                if (smbLDAP == null) {
                    logger_.error((Object)("No Domain found in Database for " + domain));
                    throw new Exception("No Domain found in Database for " + domain);
                }
                Long uid = this.getUniqueUId();
                long sidExt = uid * 2L + new Long(smbLDAP.getSambaAlgorithmicRidBase());
                String userSID = smbLDAP.getSambaSID() + "-" + sidExt;
                SambaParameters sp = new SambaParameters(uid, smbEnabled, smbLDAP.getSambaSID(), smbLDAP.getSambaPDCHostname(), smbLDAP.getDirDrive(), smbLDAP.getSambaHomeDir(), smbLDAP.getWindowsHomeDir(), smbLDAP.getProfilePath(), smbLDAP.getSambaDomainName(), smbLDAP.getLoginShell(), smbLDAP.getSambaDefaultLogonScript(), userSID, smbLDAP.getSambaProjectPath());
                return sp;
            }
            catch (Exception ex) {
                logger_.error((Object)("Exception:" + ex));
            }
        }
        return null;
    }

    private Long getUniqueUId() {
        logger_.debug((Object)"getUniqueUId");
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("DBSequence");
            DBSequenceHome dbSequenceHome = (DBSequenceHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$server$Management$util$DBSequenceHome == null ? (class$server$Management$util$DBSequenceHome = UserManagementBean.class$("server.Management.util.DBSequenceHome")) : class$server$Management$util$DBSequenceHome));
            DBSequence dBSequence = dbSequenceHome.create();
            return dBSequence.getSequence("UserId");
        }
        catch (Exception ex) {
            logger_.error((Object)("Exception:" + ex));
            return null;
        }
    }

    private Long getUniqueGId() {
        logger_.debug((Object)"getUniqueGId");
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("DBSequence");
            DBSequenceHome dbSequenceHome = (DBSequenceHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$server$Management$util$DBSequenceHome == null ? (class$server$Management$util$DBSequenceHome = UserManagementBean.class$("server.Management.util.DBSequenceHome")) : class$server$Management$util$DBSequenceHome));
            DBSequence dBSequence = dbSequenceHome.create();
            return dBSequence.getSequence("GId");
        }
        catch (Exception ex) {
            logger_.error((Object)("Exception:" + ex));
            return null;
        }
    }

    private Long getUniqueId(String sequenceName) {
        logger_.debug((Object)("getUniqueId for " + sequenceName));
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("DBSequence");
            DBSequenceHome dbSequenceHome = (DBSequenceHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$server$Management$util$DBSequenceHome == null ? (class$server$Management$util$DBSequenceHome = UserManagementBean.class$("server.Management.util.DBSequenceHome")) : class$server$Management$util$DBSequenceHome));
            DBSequence dBSequence = dbSequenceHome.create();
            return dBSequence.getSequence(sequenceName);
        }
        catch (Exception ex) {
            logger_.error((Object)("Exception:" + ex));
            return null;
        }
    }

    public String getLdapTreeRoot() throws NamingException, FinderException, Exception {
        String domain = ConfigLoader.getInstance().getProperties().getProperty("activeDomain");
        if (domain == null) {
            logger_.error((Object)"No Domain specified ind properties file");
            throw new Exception("No Domain specified ind properties file  !!!!");
        }
        InitialContext ctx = new InitialContext();
        Object refOrganizationsLdap = ctx.lookup("OrganizationsLdap");
        OrganizationsLdapHome organizationsLdapHome = (OrganizationsLdapHome)PortableRemoteObject.narrow((Object)refOrganizationsLdap, (Class)(class$server$Management$samba$OrganizationsLdapHome == null ? (class$server$Management$samba$OrganizationsLdapHome = UserManagementBean.class$("server.Management.samba.OrganizationsLdapHome")) : class$server$Management$samba$OrganizationsLdapHome));
        OrganizationsLdap orgLDAP = organizationsLdapHome.findByDC(domain);
        return orgLDAP.getDn();
    }

    public boolean addSambaProject(SambaProjectVO projectVO) {
        return this.addSambaProject(projectVO, null, null, null);
    }

    public boolean addSambaProject(SambaProjectVO projectVO, Long gid_r_t, Long gid_w_t, Long uid_t) {
        logger_.info((Object)"addSambaProject");
        projectVO.setId(this.getUniqueId("Project"));
        String domain = ConfigLoader.getInstance().getProperties().getProperty("activeDomain");
        if (domain == null) {
            logger_.error((Object)"Domain not found in config file");
            return false;
        }
        try {
            Long gid_w;
            Long gid_r;
            InitialContext ctx = new InitialContext();
            Object refSambaDomainLdap = ctx.lookup("SambaDomainLdap");
            SambaDomainLdapHome sambaDomainLdapHome = (SambaDomainLdapHome)PortableRemoteObject.narrow((Object)refSambaDomainLdap, (Class)(class$server$Management$samba$SambaDomainLdapHome == null ? (class$server$Management$samba$SambaDomainLdapHome = UserManagementBean.class$("server.Management.samba.SambaDomainLdapHome")) : class$server$Management$samba$SambaDomainLdapHome));
            SambaDomainLdap smbLDAP = sambaDomainLdapHome.findByDomain(domain);
            String servername = smbLDAP.getSambaPDCHostname();
            Object ref = ctx.lookup("SambaProject");
            SambaProjectHome sambaProjectHome = (SambaProjectHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$server$Management$samba$ejb$SambaProjectHome == null ? (class$server$Management$samba$ejb$SambaProjectHome = UserManagementBean.class$("server.Management.samba.ejb.SambaProjectHome")) : class$server$Management$samba$ejb$SambaProjectHome));
            if (gid_r_t == null || gid_w_t == null) {
                gid_r = this.getUniqueGId();
                gid_w = this.getUniqueGId();
            } else {
                gid_r = gid_r_t;
                gid_w = gid_w_t;
            }
            String projectNameUser_ = "prj_" + projectVO.getName().trim().toLowerCase().replaceAll(" ", "") + "_u";
            Object userref = ctx.lookup("OsUser");
            OsUserHome userHome = (OsUserHome)PortableRemoteObject.narrow((Object)userref, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome = UserManagementBean.class$("com.opensymphony.module.user.provider.ejb.entity.OsUserHome")) : class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome));
            OsUser user = userHome.create(null, projectNameUser_, true);
            SambaParameters smbParams = this.getSambaInitialProperties();
            Long uid_ = uid_t == null ? smbParams.getUId() : uid_t;
            this.setSambaData(projectNameUser_, domain, null, smbParams.getLoginShell(), null, null, smbParams.getProjectPath().replaceAll("\\$projectname", projectVO.getName().trim().toLowerCase()), smbParams.getDirDrive(), smbParams.getUserSID(), uid_, null);
            this.addUserLdapEntry(projectNameUser_, "OU=users," + this.getOrganizationalunitsLdap4CurrentDomain().getDn());
            SambaProject sambaProject = sambaProjectHome.create(projectVO, gid_r, gid_w, smbLDAP.getSambaSID(), smbLDAP.getSambaAlgorithmicRidBase(), this.getOrganizationalunitsLdap4CurrentDomain());
            SSHConnection sshCon = new SSHConnection(servername);
            if (sshCon.addProject(projectVO.getName(), projectNameUser_, user.getUidNumber(), sambaProject.getProjectPermission("read").getGroupsLdap().getCn(), sambaProject.getProjectPermission("write").getGroupsLdap().getCn(), sambaProject.getProjectPermission("read").getGroupsLdap().getGidNumber())) {
                this.reorganizeSambaProjectRights4Project(sambaProject.getId());
                return true;
            }
            logger_.info((Object)"could not create Project in script");
            return false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger_.error((Object)("Exception in addSambaProject:" + ex));
            return false;
        }
    }

    public boolean editSambaProject(SambaProjectVO projectVO) {
        logger_.info((Object)"editSambaProject");
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("SambaProject");
            SambaProjectHome sambaProjectHome = (SambaProjectHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$server$Management$samba$ejb$SambaProjectHome == null ? (class$server$Management$samba$ejb$SambaProjectHome = UserManagementBean.class$("server.Management.samba.ejb.SambaProjectHome")) : class$server$Management$samba$ejb$SambaProjectHome));
            SambaProject smbPrj = sambaProjectHome.findByPrimaryKey(projectVO.getId());
            smbPrj.edit(projectVO);
            this.reorganizeSambaProjectRights4Project(smbPrj.getId());
            return true;
        }
        catch (Exception ex) {
            logger_.error((Object)("Exception:" + ex));
            return false;
        }
    }

    public SambaProjectVO getSambaProject(String projectName) {
        logger_.info((Object)("getSambaProject " + projectName));
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("SambaProject");
            SambaProjectHome sambaProjectHome = (SambaProjectHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$server$Management$samba$ejb$SambaProjectHome == null ? (class$server$Management$samba$ejb$SambaProjectHome = UserManagementBean.class$("server.Management.samba.ejb.SambaProjectHome")) : class$server$Management$samba$ejb$SambaProjectHome));
            SambaProject smbPrj = sambaProjectHome.findByName(projectName);
            SambaProjectVO smbPrjVO = new SambaProjectVO(smbPrj);
            return smbPrjVO;
        }
        catch (Exception ex) {
            logger_.error((Object)("Exception:" + ex));
            return null;
        }
    }

    public SambaProjectVO getSambaProject(Long id) {
        logger_.info((Object)("getSambaProject " + id));
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("SambaProject");
            SambaProjectHome sambaProjectHome = (SambaProjectHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$server$Management$samba$ejb$SambaProjectHome == null ? (class$server$Management$samba$ejb$SambaProjectHome = UserManagementBean.class$("server.Management.samba.ejb.SambaProjectHome")) : class$server$Management$samba$ejb$SambaProjectHome));
            SambaProject smbPrj = sambaProjectHome.findByPrimaryKey(id);
            SambaProjectVO smbPrjVO = new SambaProjectVO(smbPrj);
            return smbPrjVO;
        }
        catch (Exception ex) {
            logger_.error((Object)("Exception:" + ex));
            return null;
        }
    }

    public boolean removeSambaProject(Long id) {
        logger_.info((Object)("removeSambaProject " + id));
        try {
            String domain = ConfigLoader.getInstance().getProperties().getProperty("activeDomain");
            if (domain == null) {
                logger_.error((Object)"No Domain specified ind properties file");
                return false;
            }
            InitialContext ctx = new InitialContext();
            Object refSambaDomainLdap = ctx.lookup("SambaDomainLdap");
            SambaDomainLdapHome sambaDomainLdapHome = (SambaDomainLdapHome)PortableRemoteObject.narrow((Object)refSambaDomainLdap, (Class)(class$server$Management$samba$SambaDomainLdapHome == null ? (class$server$Management$samba$SambaDomainLdapHome = UserManagementBean.class$("server.Management.samba.SambaDomainLdapHome")) : class$server$Management$samba$SambaDomainLdapHome));
            SambaDomainLdap smbLDAP = sambaDomainLdapHome.findByDomain(domain);
            String servername = smbLDAP.getSambaPDCHostname();
            SSHConnection sshCon = new SSHConnection(servername);
            Object ref = ctx.lookup("SambaProject");
            SambaProjectHome sambaProjectHome = (SambaProjectHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$server$Management$samba$ejb$SambaProjectHome == null ? (class$server$Management$samba$ejb$SambaProjectHome = UserManagementBean.class$("server.Management.samba.ejb.SambaProjectHome")) : class$server$Management$samba$ejb$SambaProjectHome));
            SambaProject smbPrj = sambaProjectHome.findByPrimaryKey(id);
            String projectNameUser_ = "prj_" + smbPrj.getName().trim().toLowerCase().replaceAll(" ", "") + "_u";
            Object userref = ctx.lookup("OsUser");
            OsUserHome userHome = (OsUserHome)PortableRemoteObject.narrow((Object)userref, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome = UserManagementBean.class$("com.opensymphony.module.user.provider.ejb.entity.OsUserHome")) : class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome));
            OsUser user = userHome.findByName(projectNameUser_);
            Long userId = user.getId();
            Long uid = user.getUidNumber();
            user.remove();
            UserManagementBean.removeUserLdapEntry(userId, "OU=users," + this.getOrganizationalunitsLdap4CurrentDomain().getDn());
            if (sshCon.deleteProject(smbPrj.getName(), projectNameUser_, uid)) {
                smbPrj.remove();
                logger_.info((Object)"removed Project sucessfully");
                return true;
            }
            return false;
        }
        catch (RemoveException ex) {
            logger_.error((Object)("Remove Exception:" + ex.getMessage()));
        }
        catch (FinderException ex) {
            logger_.error((Object)("Finder Exception:" + ex.getMessage()));
        }
        catch (NamingException ex) {
            logger_.error((Object)("Naming Exception:" + ex.getMessage()));
        }
        catch (Exception e) {
            logger_.error((Object)("Exception:" + e.getMessage()));
        }
        return false;
    }

    public Collection getAllSambaProjects() {
        logger_.info((Object)"getSambaProjects");
        Vector<SambaProjectVO> result = new Vector<SambaProjectVO>();
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("SambaProject");
            SambaProjectHome sambaProjectHome = (SambaProjectHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$server$Management$samba$ejb$SambaProjectHome == null ? (class$server$Management$samba$ejb$SambaProjectHome = UserManagementBean.class$("server.Management.samba.ejb.SambaProjectHome")) : class$server$Management$samba$ejb$SambaProjectHome));
            Iterator it = sambaProjectHome.findAll().iterator();
            while (it.hasNext()) {
                SambaProjectVO smbPrjVO = new SambaProjectVO((SambaProject)it.next());
                result.add(smbPrjVO);
            }
        }
        catch (Exception ex) {
            logger_.error((Object)("Exception:" + ex));
        }
        logger_.debug((Object)"...done");
        return result;
    }

    public boolean addSambaDomainComputer(SambaDomainComputerVO comp) {
        InitialContext ctx = null;
        Object sgHome = null;
        String domain = ConfigLoader.getInstance().getProperties().getProperty("activeDomain");
        if (domain == null) {
            logger_.error((Object)"No Domain specified ind properties file");
            return false;
        }
        try {
            OrganizationalunitsLdap organizationalunitsLdap = this.getOrganizationalunitsLdap4CurrentDomain();
            ctx = new InitialContext();
            Object refSambaDomainLdap = ctx.lookup("SambaDomainLdap");
            SambaDomainLdapHome sambaDomainLdapHome = (SambaDomainLdapHome)PortableRemoteObject.narrow((Object)refSambaDomainLdap, (Class)(class$server$Management$samba$SambaDomainLdapHome == null ? (class$server$Management$samba$SambaDomainLdapHome = UserManagementBean.class$("server.Management.samba.SambaDomainLdapHome")) : class$server$Management$samba$SambaDomainLdapHome));
            SambaDomainLdap smbLDAP = sambaDomainLdapHome.findByDomain(domain);
            String servername = smbLDAP.getSambaPDCHostname();
            Object refGroupLdap = ctx.lookup("GroupsLdap");
            GroupsLdapHome groupsLdapHome = (GroupsLdapHome)PortableRemoteObject.narrow((Object)refGroupLdap, (Class)(class$server$Management$samba$GroupsLdapHome == null ? (class$server$Management$samba$GroupsLdapHome = UserManagementBean.class$("server.Management.samba.GroupsLdapHome")) : class$server$Management$samba$GroupsLdapHome));
            GroupsLdap groupsLdapDomain = groupsLdapHome.findByCN("Domain Computers");
            Object userref = ctx.lookup("OsUser");
            OsUserHome userHome = (OsUserHome)PortableRemoteObject.narrow((Object)userref, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome = UserManagementBean.class$("com.opensymphony.module.user.provider.ejb.entity.OsUserHome")) : class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome));
            OsUser user = userHome.create(null, comp.getName(), false);
            Long uid = this.getUniqueUId();
            user.setUidNumber(uid);
            user.setDescription(comp.getDescription());
            user.setAcctCtrl("[W          ]");
            long sidExt = uid * 2L + new Long(smbLDAP.getSambaAlgorithmicRidBase()) + 1L;
            logger_.debug((Object)("sidExt " + sidExt));
            String userSID = smbLDAP.getSambaSID() + "-" + sidExt;
            user.setHomeDirectory("/dev/null");
            user.setUser_sid(userSID);
            user.setDomain(domain);
            user.setGidNumber(groupsLdapDomain.getGidNumber());
            user.setSambaDir(comp.getMacAddress());
            Object refLdapOcMappings = ctx.lookup("LdapOcMappings");
            LdapOcMappingsHome ldapOcMappingsHome = (LdapOcMappingsHome)PortableRemoteObject.narrow((Object)refLdapOcMappings, (Class)(class$server$Management$samba$LdapOcMappingsHome == null ? (class$server$Management$samba$LdapOcMappingsHome = UserManagementBean.class$("server.Management.samba.LdapOcMappingsHome")) : class$server$Management$samba$LdapOcMappingsHome));
            LdapOcMappings ocMapping = ldapOcMappingsHome.findbyName("posixAccount");
            Object refLdapEntries = ctx.lookup("LdapEntries");
            LdapEntriesHome ldapEntryHome = (LdapEntriesHome)PortableRemoteObject.narrow((Object)refLdapEntries, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$ldap$LdapEntriesHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$ldap$LdapEntriesHome = UserManagementBean.class$("com.opensymphony.module.user.provider.ejb.entity.ldap.LdapEntriesHome")) : class$com$opensymphony$module$user$provider$ejb$entity$ldap$LdapEntriesHome));
            LdapEntries parentDnEO = ldapEntryHome.findByDN("OU=computers," + organizationalunitsLdap.getDn());
            ldapEntryHome.create("UID=" + comp.getName() + "," + parentDnEO.getDn(), new Long(ocMapping.getId().longValue()), parentDnEO.getId(), user.getId());
            SSHConnection sshCon = new SSHConnection(servername);
            sshCon.addDomainComputer(comp.getName(), comp.getDescription());
        }
        catch (Exception ex) {
            logger_.error((Object)("Exception:" + ex));
            ex.printStackTrace();
        }
        return false;
    }

    public SambaDomainComputerVO getSambaDomainComputer(String computerName) {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            Object userref = null;
            userref = ctx.lookup("OsUser");
            OsUserHome userHome = (OsUserHome)PortableRemoteObject.narrow((Object)userref, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome = UserManagementBean.class$("com.opensymphony.module.user.provider.ejb.entity.OsUserHome")) : class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome));
            OsUser user = userHome.findByName(computerName);
            SambaDomainComputerVO comp = new SambaDomainComputerVO(user);
            return comp;
        }
        catch (NamingException nEx) {
            logger_.error((Object)("Exception:" + nEx));
        }
        catch (FinderException cEx) {
            logger_.error((Object)("Exception:" + (Object)((Object)cEx)));
        }
        return null;
    }

    public SambaDomainComputerVO getSambaDomainComputer(Long id) {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            Object userref = null;
            userref = ctx.lookup("OsUser");
            OsUserHome userHome = (OsUserHome)PortableRemoteObject.narrow((Object)userref, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome = UserManagementBean.class$("com.opensymphony.module.user.provider.ejb.entity.OsUserHome")) : class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome));
            OsUser user = userHome.findByPrimaryKey(id);
            SambaDomainComputerVO comp = new SambaDomainComputerVO(user);
            return comp;
        }
        catch (NamingException nEx) {
            logger_.error((Object)("Exception:" + nEx));
        }
        catch (FinderException cEx) {
            logger_.error((Object)("Exception:" + (Object)((Object)cEx)));
        }
        return null;
    }

    public Collection getAllSambaDomainComputers() {
        InitialContext ctx = null;
        Object sgHome = null;
        Vector<SambaDomainComputerVO> result = new Vector<SambaDomainComputerVO>();
        try {
            ctx = new InitialContext();
            Object userref = null;
            userref = ctx.lookup("OsUser");
            OsUserHome userHome = (OsUserHome)PortableRemoteObject.narrow((Object)userref, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome = UserManagementBean.class$("com.opensymphony.module.user.provider.ejb.entity.OsUserHome")) : class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome));
            Collection coll = userHome.findAll();
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                OsUser userEO = (OsUser)it.next();
                if (!userEO.getName().endsWith("$")) continue;
                SambaDomainComputerVO comp = new SambaDomainComputerVO(userEO);
                result.add(comp);
            }
        }
        catch (NamingException nEx) {
            logger_.error((Object)("Exception:" + nEx));
        }
        catch (FinderException cEx) {
            logger_.error((Object)("Exception:" + (Object)((Object)cEx)));
        }
        return result;
    }

    public boolean editSambaDomainComputer(SambaDomainComputerVO comp) {
        logger_.info((Object)("editSambaDomainComputer " + comp.getName()));
        InitialContext ctx = null;
        Object sgHome = null;
        try {
            String domain = ConfigLoader.getInstance().getProperties().getProperty("activeDomain");
            if (domain == null) {
                logger_.error((Object)"No Domain specified ind properties file");
                return false;
            }
            ctx = new InitialContext();
            Object refSambaDomainLdap = ctx.lookup("SambaDomainLdap");
            SambaDomainLdapHome sambaDomainLdapHome = (SambaDomainLdapHome)PortableRemoteObject.narrow((Object)refSambaDomainLdap, (Class)(class$server$Management$samba$SambaDomainLdapHome == null ? (class$server$Management$samba$SambaDomainLdapHome = UserManagementBean.class$("server.Management.samba.SambaDomainLdapHome")) : class$server$Management$samba$SambaDomainLdapHome));
            SambaDomainLdap smbLDAP = sambaDomainLdapHome.findByDomain(domain);
            String servername = smbLDAP.getSambaPDCHostname();
            SSHConnection sshCon = new SSHConnection(servername);
            Object userref = null;
            userref = ctx.lookup("OsUser");
            OsUserHome userHome = (OsUserHome)PortableRemoteObject.narrow((Object)userref, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome = UserManagementBean.class$("com.opensymphony.module.user.provider.ejb.entity.OsUserHome")) : class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome));
            OsUser user = userHome.findByName(comp.getName());
            user.setDescription(comp.getDescription());
            user.setSambaDir(comp.getMacAddress());
            sshCon.invalidateCache();
            return true;
        }
        catch (NamingException nEx) {
            logger_.error((Object)("Exception:" + nEx));
        }
        catch (FinderException cEx) {
            logger_.error((Object)("Exception:" + (Object)((Object)cEx)));
        }
        return false;
    }

    public boolean removeSambaDomainComputer(Long id) {
        logger_.info((Object)("removeSambaDomainComputer " + id));
        InitialContext ctx = null;
        Object sgHome = null;
        try {
            String domain = ConfigLoader.getInstance().getProperties().getProperty("activeDomain");
            if (domain == null) {
                logger_.error((Object)"No Domain specified ind properties file");
                return false;
            }
            ctx = new InitialContext();
            Object refSambaDomainLdap = ctx.lookup("SambaDomainLdap");
            SambaDomainLdapHome sambaDomainLdapHome = (SambaDomainLdapHome)PortableRemoteObject.narrow((Object)refSambaDomainLdap, (Class)(class$server$Management$samba$SambaDomainLdapHome == null ? (class$server$Management$samba$SambaDomainLdapHome = UserManagementBean.class$("server.Management.samba.SambaDomainLdapHome")) : class$server$Management$samba$SambaDomainLdapHome));
            SambaDomainLdap smbLDAP = sambaDomainLdapHome.findByDomain(domain);
            String servername = smbLDAP.getSambaPDCHostname();
            SSHConnection sshCon = new SSHConnection(servername);
            Object userref = null;
            userref = ctx.lookup("OsUser");
            OsUserHome userHome = (OsUserHome)PortableRemoteObject.narrow((Object)userref, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome = UserManagementBean.class$("com.opensymphony.module.user.provider.ejb.entity.OsUserHome")) : class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome));
            OsUser user = userHome.findByPrimaryKey(id);
            sshCon.deleteDomainComputer(user.getName());
            UserManagementBean.removeUserLdapEntry(user.getId(), "OU=computers," + this.getOrganizationalunitsLdap4CurrentDomain().getDn());
            user.remove();
            return true;
        }
        catch (NamingException nEx) {
            logger_.error((Object)("Exception:" + nEx));
        }
        catch (FinderException cEx) {
            logger_.error((Object)("Exception:" + (Object)((Object)cEx)));
        }
        catch (RemoveException cEx) {
            logger_.error((Object)("Exception:" + (Object)((Object)cEx)));
        }
        catch (Exception e) {
            logger_.error((Object)("Exception:" + e.getMessage()));
        }
        return false;
    }

    public static boolean reorganizeSambaProjectRights4User(String username) {
        block14: {
            logger_.info((Object)("reorganizeSambaProjectRights4User " + username));
            boolean user_r = false;
            boolean user_w = false;
            try {
                InitialContext ctx = new InitialContext();
                Object userref = ctx.lookup("OsUser");
                OsUserHome userHome = (OsUserHome)PortableRemoteObject.narrow((Object)userref, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome = UserManagementBean.class$("com.opensymphony.module.user.provider.ejb.entity.OsUserHome")) : class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome));
                OsUser user = userHome.findByName(username);
                Object refGroupMembersLdap = ctx.lookup("GroupmembersLdap");
                GroupmembersLdapHome groupmembersLdapHome = (GroupmembersLdapHome)PortableRemoteObject.narrow((Object)refGroupMembersLdap, (Class)(class$server$Management$samba$GroupmembersLdapHome == null ? (class$server$Management$samba$GroupmembersLdapHome = UserManagementBean.class$("server.Management.samba.GroupmembersLdapHome")) : class$server$Management$samba$GroupmembersLdapHome));
                Vector groupMemebersLdap_Vect = new Vector(groupmembersLdapHome.findByUserName(username));
                Object refGroupLdap = ctx.lookup("GroupsLdap");
                GroupsLdapHome groupsLdapHome = (GroupsLdapHome)PortableRemoteObject.narrow((Object)refGroupLdap, (Class)(class$server$Management$samba$GroupsLdapHome == null ? (class$server$Management$samba$GroupsLdapHome = UserManagementBean.class$("server.Management.samba.GroupsLdapHome")) : class$server$Management$samba$GroupsLdapHome));
                GroupsLdap groupsLdapDomainUser = groupsLdapHome.findByCN("Domain Users");
                GroupsLdap groupsLdapSMBUser = groupsLdapHome.findByCN("smb_user");
                logger_.debug((Object)("found " + groupsLdapDomainUser.getDisplayName()));
                int i = 0;
                while (i < groupMemebersLdap_Vect.size()) {
                    GroupmembersLdap groupmembersLdap = (GroupmembersLdap)groupMemebersLdap_Vect.get(i);
                    if (groupmembersLdap.getGroupId().longValue() != groupsLdapDomainUser.getId().longValue() && groupmembersLdap.getGroupId().longValue() != groupsLdapSMBUser.getId().longValue()) {
                        logger_.debug((Object)"this is not the CN=Domain Users entry -> I will delete it");
                        logger_.debug((Object)("was in group: " + groupmembersLdap.getGroupId()));
                        groupmembersLdap.remove();
                    }
                    ++i;
                }
                if (user.getLdapAuthenticationEnabled() != 1L) break block14;
                Object refSmbProj = ctx.lookup("SambaProject");
                SambaProjectHome sambaProjectHome = (SambaProjectHome)PortableRemoteObject.narrow((Object)refSmbProj, (Class)(class$server$Management$samba$ejb$SambaProjectHome == null ? (class$server$Management$samba$ejb$SambaProjectHome = UserManagementBean.class$("server.Management.samba.ejb.SambaProjectHome")) : class$server$Management$samba$ejb$SambaProjectHome));
                Iterator projects = sambaProjectHome.findAll().iterator();
                while (projects.hasNext()) {
                    user_r = false;
                    user_w = false;
                    SambaProject smbPrj = (SambaProject)projects.next();
                    Long groupsId_r = smbPrj.getProjectPermission("read").getGroupsLdap().getId();
                    Long groupsId_w = smbPrj.getProjectPermission("write").getGroupsLdap().getId();
                    Iterator it_r = smbPrj.getSambaGroup_ReadVO().iterator();
                    while (it_r.hasNext()) {
                        SambaGroupVO vo = (SambaGroupVO)it_r.next();
                        if (vo.getId().longValue() != user.getSambaGroupId().longValue()) continue;
                        logger_.debug((Object)("Adding for project " + smbPrj.getName() + " from SambaGroup " + vo.getDisplayName() + " User " + user.getName() + " to read hash"));
                        user_r = true;
                        break;
                    }
                    Iterator itUsers_r = smbPrj.getSambaUser_ReadVO().iterator();
                    while (itUsers_r.hasNext()) {
                        UserVO currUser = (UserVO)itUsers_r.next();
                        if (currUser.getID().longValue() != user.getId().longValue()) continue;
                        logger_.debug((Object)("Adding User " + user.getName()));
                        user_r = true;
                        break;
                    }
                    Iterator it_w = smbPrj.getSambaGroup_WriteVO().iterator();
                    while (it_w.hasNext()) {
                        SambaGroupVO vo = (SambaGroupVO)it_w.next();
                        if (vo.getId().longValue() != user.getSambaGroupId().longValue()) continue;
                        logger_.debug((Object)("Adding from SambaGroup " + vo.getDisplayName() + " User " + user.getName() + " to write hash"));
                        user_w = true;
                        break;
                    }
                    Iterator itUsers_w = smbPrj.getSambaUser_WriteVO().iterator();
                    while (itUsers_w.hasNext()) {
                        UserVO currUser = (UserVO)itUsers_w.next();
                        if (currUser.getID().longValue() != user.getId().longValue()) continue;
                        logger_.debug((Object)("Adding User " + user.getName()));
                        user_w = true;
                        break;
                    }
                    if (user_r) {
                        logger_.debug((Object)("writing groupmembersLdap for read " + username + " " + groupsId_r));
                        groupmembersLdapHome.create(username, groupsId_r);
                    }
                    if (!user_w) continue;
                    logger_.debug((Object)("writing groupmembersLdap for write " + username + " " + groupsId_w));
                    groupmembersLdapHome.create(username, groupsId_w);
                }
            }
            catch (FinderException ex) {
                logger_.debug((Object)ex.getMessage());
            }
            catch (RemoveException ex) {
                ex.printStackTrace();
            }
            catch (NamingException ex) {
                ex.printStackTrace();
            }
            catch (CreateException ex) {
                ex.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private boolean reorganizeSambaProjectRights4Project(Long projectId) {
        logger_.debug((Object)("reorganizeSambaProjectRights4Project " + projectId));
        try {
            Hashtable<String, String> user_r = new Hashtable<String, String>();
            Hashtable<String, String> user_w = new Hashtable<String, String>();
            InitialContext ctx = new InitialContext();
            Object refSmbProj = ctx.lookup("SambaProject");
            SambaProjectHome sambaProjectHome = (SambaProjectHome)PortableRemoteObject.narrow((Object)refSmbProj, (Class)(class$server$Management$samba$ejb$SambaProjectHome == null ? (class$server$Management$samba$ejb$SambaProjectHome = UserManagementBean.class$("server.Management.samba.ejb.SambaProjectHome")) : class$server$Management$samba$ejb$SambaProjectHome));
            SambaProject smbPrj = sambaProjectHome.findByPrimaryKey(projectId);
            Long groupsId_r = smbPrj.getProjectPermission("read").getGroupsLdap().getId();
            Long groupsId_w = smbPrj.getProjectPermission("write").getGroupsLdap().getId();
            Object refGroupMembersLdap = ctx.lookup("GroupmembersLdap");
            GroupmembersLdapHome groupmembersLdapHome = (GroupmembersLdapHome)PortableRemoteObject.narrow((Object)refGroupMembersLdap, (Class)(class$server$Management$samba$GroupmembersLdapHome == null ? (class$server$Management$samba$GroupmembersLdapHome = UserManagementBean.class$("server.Management.samba.GroupmembersLdapHome")) : class$server$Management$samba$GroupmembersLdapHome));
            Vector groups_R_Vect = new Vector(groupmembersLdapHome.findLdapGroupsId(groupsId_r));
            Vector groups_W_Vect = new Vector(groupmembersLdapHome.findLdapGroupsId(groupsId_w));
            int i = 0;
            while (i < groups_R_Vect.size()) {
                GroupmembersLdap gmLDAP = (GroupmembersLdap)groups_R_Vect.get(i);
                gmLDAP.remove();
                ++i;
            }
            int i2 = 0;
            while (i2 < groups_W_Vect.size()) {
                GroupmembersLdap gmLDAP = (GroupmembersLdap)groups_W_Vect.get(i2);
                gmLDAP.remove();
                ++i2;
            }
            Object userref = ctx.lookup("OsUser");
            OsUserHome userHome = (OsUserHome)PortableRemoteObject.narrow((Object)userref, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome = UserManagementBean.class$("com.opensymphony.module.user.provider.ejb.entity.OsUserHome")) : class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome));
            Iterator it_r = smbPrj.getSambaGroup_ReadVO().iterator();
            while (it_r.hasNext()) {
                SambaGroupVO vo = (SambaGroupVO)it_r.next();
                Iterator itUsers_r = userHome.findBySambaGroupId(vo.getId()).iterator();
                while (itUsers_r.hasNext()) {
                    OsUser user = (OsUser)itUsers_r.next();
                    if (user.getLdapAuthenticationEnabled() != 1L) continue;
                    logger_.debug((Object)("Adding from SambaGroup " + vo.getDisplayName() + " User " + user.getName() + " to read hash"));
                    user_r.put(user.getName(), "");
                }
            }
            Iterator itUsers_r = smbPrj.getSambaUser_Read().iterator();
            while (itUsers_r.hasNext()) {
                OsUser user = (OsUser)itUsers_r.next();
                if (user.getLdapAuthenticationEnabled() != 1L) continue;
                logger_.debug((Object)("Adding User [R]" + user.getName()));
                user_r.put(user.getName(), "");
            }
            Iterator it_w = smbPrj.getSambaGroup_WriteVO().iterator();
            while (it_w.hasNext()) {
                SambaGroupVO vo = (SambaGroupVO)it_w.next();
                Iterator itUsers_w = userHome.findBySambaGroupId(vo.getId()).iterator();
                while (itUsers_w.hasNext()) {
                    OsUser user = (OsUser)itUsers_w.next();
                    if (user.getLdapAuthenticationEnabled() != 1L) continue;
                    logger_.debug((Object)("Adding from SambaGroup " + vo.getDisplayName() + " User " + user.getName() + " to write hash"));
                    user_w.put(user.getName(), "");
                }
            }
            Iterator itUsers_w = smbPrj.getSambaUser_Write().iterator();
            while (itUsers_w.hasNext()) {
                OsUser user = (OsUser)itUsers_w.next();
                if (user.getLdapAuthenticationEnabled() != 1L) continue;
                logger_.debug((Object)("Adding User [W]" + user.getName()));
                user_w.put(user.getName(), "");
            }
            Enumeration e_r = user_r.keys();
            while (e_r.hasMoreElements()) {
                groupmembersLdapHome.create((String)e_r.nextElement(), groupsId_r);
            }
            Enumeration e_w = user_w.keys();
            while (e_w.hasMoreElements()) {
                groupmembersLdapHome.create((String)e_w.nextElement(), groupsId_w);
            }
            return true;
        }
        catch (FinderException ex) {
            logger_.debug((Object)ex.getMessage());
        }
        catch (RemoveException ex) {
            ex.printStackTrace();
        }
        catch (NamingException ex) {
            ex.printStackTrace();
        }
        catch (CreateException ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public Vector getPwdUsers(Vector usersOfInstitute, boolean excludeInactives) {
        Vector<PwdUserVO> allUsers = new Vector<PwdUserVO>();
        boolean acceptPwd = false;
        try {
            InitialContext ctx = new InitialContext();
            Object refOsUser = ctx.lookup("OsUser");
            OsUserHome osUserHome = (OsUserHome)PortableRemoteObject.narrow((Object)refOsUser, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome = UserManagementBean.class$("com.opensymphony.module.user.provider.ejb.entity.OsUserHome")) : class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome));
            Object refInstituteManager = ctx.lookup("InstitutManager");
            Vector<OsUser> returnedUsers = new Vector<OsUser>();
            if (usersOfInstitute == null || usersOfInstitute.size() < 1) {
                returnedUsers = new Vector(osUserHome.findAll());
            } else {
                int i = 0;
                while (i != usersOfInstitute.size()) {
                    returnedUsers.add(osUserHome.findByName(((InstitutMembersVO)usersOfInstitute.get(i)).getUsername()));
                    ++i;
                }
            }
            Iterator users = returnedUsers.iterator();
            while (users.hasNext()) {
                OsUser user = (OsUser)users.next();
                boolean addUser = false;
                if (excludeInactives) {
                    if (user.getApplicationAuthenticationEnabled() != null && user.getApplicationAuthenticationEnabled() > 0L) {
                        addUser = true;
                    }
                } else {
                    addUser = true;
                }
                if (!addUser || user.getName().startsWith("prj_") || user.getName().endsWith("$") || user.getName().equalsIgnoreCase("admin") || user.getName().equalsIgnoreCase("administrator")) continue;
                User aUser = this.userManager_.getUser(user.getName());
                InstitutVO mainInstitute = InstitutManagerBean.getInstitut(user.getName(), ctx);
                Vector insitutes = InstitutManagerBean.getAddtionalInstitutes(user.getName(), ctx, mainInstitute);
                insitutes.add(0, mainInstitute);
                Vector apps = this.getApplicationsForUser(user.getName());
                Vector<RightOfResourceVO> allRights = new Vector<RightOfResourceVO>();
                int i = 0;
                while (i != apps.size()) {
                    ApplicationVO appVO = (ApplicationVO)apps.get(i);
                    Vector rights = RightsManagementBean.getRightOfResource(appVO.getApplicationname(), user.getName());
                    int j = 0;
                    while (j != rights.size()) {
                        allRights.add((RightOfResourceVO)rights.get(j));
                        ++j;
                    }
                    ++i;
                }
                StringTokenizer tokenizer = new StringTokenizer(aUser.getFullName(), " ");
                String firstname = null;
                String lastname = null;
                if (tokenizer.countTokens() > 1) {
                    firstname = tokenizer.nextToken();
                    lastname = tokenizer.nextToken();
                }
                PwdUserVO pwdUser = new PwdUserVO(user.getId(), user.getName(), user.getPasswordHash(), firstname, lastname, aUser.getEmail(), aUser.getFullName(), insitutes, allRights);
                allUsers.add(pwdUser);
            }
        }
        catch (FinderException ex) {
            logger_.debug((Object)ex.getMessage());
        }
        catch (NamingException ex) {
            ex.printStackTrace();
        }
        catch (EntityNotFoundException ene) {
            ene.printStackTrace();
        }
        return allUsers;
    }

    public Vector getUsersExtWhereUserIsInstAdmin(Long userId) {
        Vector institutes = InstitutManagerBean.getInstitutesWherUserIsAdmin(userId, true);
        Hashtable<String, String> userHash = new Hashtable<String, String>();
        Vector<ExtendedUserVO> users = new Vector<ExtendedUserVO>();
        ExtendedUserVO adminUser = this.getUserByIDExtended(userId);
        users.add(adminUser);
        userHash.put(adminUser.getName(), adminUser.getName());
        int i = 0;
        while (i != institutes.size()) {
            InstitutVO instVO = (InstitutVO)institutes.get(i);
            Vector usersOfInst = InstitutManagerBean.getAllUsersOfInstitut(instVO.getId(), false);
            int j = 0;
            while (j != usersOfInst.size()) {
                InstitutMembersVO membersVO = (InstitutMembersVO)usersOfInst.get(j);
                if (!userHash.containsKey(membersVO.getUsername()) && !membersVO.getUsername().equalsIgnoreCase("admin")) {
                    users.add(this.getUserVOExtended(membersVO.getUsername()));
                    userHash.put(membersVO.getUsername(), membersVO.getUsername());
                }
                ++j;
            }
            ++i;
        }
        Collections.sort(users, new GeneralComparator("at.tugraz.genome.usermanagement.server.user.VO.UserVO", "getName", "java.lang.String"));
        return users;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

