/*
 * Decompiled with CFR 0.152.
 */
package server.security;

import at.tugraz.genome.usermanagement.server.group.VO.SmallGroupVO;
import at.tugraz.genome.usermanagement.server.user.cache.ExtendedUserVOCache;
import com.opensymphony.module.access.provider.ejb.OsGroupInRealm;
import com.opensymphony.module.access.provider.ejb.OsGroupInRealmHome;
import com.opensymphony.module.access.provider.ejb.OsUserInRealm;
import com.opensymphony.module.access.provider.ejb.OsUserInRealmHome;
import com.opensymphony.module.user.EntityNotFoundException;
import com.opensymphony.module.user.User;
import com.opensymphony.module.user.UserManager;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import server.security.AuthenticationHandler;

public class AuthenticationManagerBean
implements SessionBean {
    SessionContext sessionContext;
    private static final Log logger = LogFactory.getLog((Class)(class$server$security$AuthenticationManagerBean == null ? (class$server$security$AuthenticationManagerBean = AuthenticationManagerBean.class$("server.security.AuthenticationManagerBean")) : class$server$security$AuthenticationManagerBean));
    static /* synthetic */ Class class$server$security$AuthenticationManagerBean;
    static /* synthetic */ Class class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome;
    static /* synthetic */ Class class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome;

    public void ejbCreate() throws CreateException {
        System.out.println("---------------------AuthenticationManagerBean create----------------------------");
    }

    public void ejbRemove() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    public String getAuthenticationID(String username) {
        AuthenticationHandler.getInstance();
        return AuthenticationHandler.getID(username);
    }

    public boolean isLogged(String username, String id) {
        AuthenticationHandler.getInstance();
        return AuthenticationHandler.isLogged(username, id);
    }

    public boolean isUserAdminOfApplication(String username, String realm) {
        AuthenticationHandler.getInstance();
        return AuthenticationHandler.isUserAdminOfApplication(username, realm);
    }

    public int isApplicationRegistered(String realm, String password, String version) {
        AuthenticationHandler.getInstance();
        return AuthenticationHandler.isApplicationRegistered(realm, password, version);
    }

    public boolean isUserallowedInApplication(String username, String applicationname) {
        String error;
        Object home;
        Object ref;
        InitialContext ctx;
        logger.info((Object)("isUserallowedInApplication " + username + " " + applicationname));
        boolean valid = false;
        boolean exlipcitDisabled = false;
        if (AuthenticationHandler.getInstance().isUserAllowdInApplication(username, applicationname) == 1) {
            return true;
        }
        if (AuthenticationHandler.getInstance().isUserAllowdInApplication(username, applicationname) == 0) {
            return false;
        }
        logger.info((Object)"not found in cache... will continue ");
        try {
            ctx = new InitialContext();
            ref = ctx.lookup("OsUserInRealm");
            home = (OsUserInRealmHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome = AuthenticationManagerBean.class$("com.opensymphony.module.access.provider.ejb.OsUserInRealmHome")) : class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome));
            OsUserInRealm userInRealm = null;
            try {
                userInRealm = home.findUserInRealm(username, applicationname);
                logger.debug((Object)(username + " isEnabled() " + userInRealm.getIsEnabled()));
                valid = true;
                if (userInRealm.getIsEnabled() == 0L) {
                    exlipcitDisabled = true;
                    String error2 = "you account exists in this Application, but was explicit disabled";
                    logger.error((Object)error2);
                    AuthenticationHandler.getInstance().setInCacheIsUserAllowedInApplication(username, applicationname, false);
                    return false;
                }
            }
            catch (FinderException ex) {
                error = "user \"" + username + "\" not enabled in this application " + applicationname;
                logger.debug((Object)error);
            }
        }
        catch (NamingException ex) {
            logger.error((Object)"could not connect to server");
            String error3 = "Internal Error in authentication error";
            AuthenticationHandler.getInstance().setInCacheIsUserAllowedInApplication(username, applicationname, false);
            return false;
        }
        if (!valid && !exlipcitDisabled) {
            logger.debug((Object)"look if user is in enabled group");
            try {
                ctx = new InitialContext();
                ref = ctx.lookup("OsGroupInRealm");
                home = (OsGroupInRealmHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome = AuthenticationManagerBean.class$("com.opensymphony.module.access.provider.ejb.OsGroupInRealmHome")) : class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome));
                User user = null;
                try {
                    user = UserManager.getInstance().getUser(username);
                }
                catch (EntityNotFoundException ex) {
                    logger.error((Object)"no entity found");
                    error = "Internal Error in authentication error, user not found";
                    logger.error((Object)error);
                    AuthenticationHandler.getInstance().setInCacheIsUserAllowedInApplication(username, applicationname, false);
                    return false;
                }
                Vector groupList = new Vector(user.getGroups());
                logger.debug((Object)("user is in " + groupList.size() + " groups"));
                if (groupList.size() != 0) {
                    Iterator iter = groupList.iterator();
                    while (iter.hasNext()) {
                        SmallGroupVO group = (SmallGroupVO)iter.next();
                        logger.debug((Object)("looking for: " + group.getName()));
                        try {
                            OsGroupInRealm osGroupInRealm = home.findGroupInRealm(group.getName(), applicationname);
                            if (osGroupInRealm.getRealm().equals(applicationname) && osGroupInRealm.getIsEnabled() > 0L) {
                                logger.debug((Object)("group \"" + group.getName() + "\" of user \"" + username + "\" enabled for application " + applicationname));
                                valid = true;
                                AuthenticationHandler.getInstance().setInCacheIsUserAllowedInApplication(username, applicationname, valid);
                                return valid;
                            }
                            logger.debug((Object)("group \"" + group.getName() + "\" of user \"" + username + "\" disabled for application " + applicationname));
                        }
                        catch (FinderException ex) {
                            logger.debug((Object)("group " + group.getName() + " not enabled for realm " + applicationname));
                        }
                    }
                }
            }
            catch (NamingException ex) {
                logger.error((Object)"Bean not found");
                String error4 = "Internal Error in authentication error (NamingException)";
                logger.error((Object)error4);
                AuthenticationHandler.getInstance().setInCacheIsUserAllowedInApplication(username, applicationname, false);
                return false;
            }
        }
        AuthenticationHandler.getInstance().setInCacheIsUserAllowedInApplication(username, applicationname, valid);
        return valid;
    }

    public String getCookieKey(String realm) {
        return AuthenticationHandler.getInstance().getCookieKey(realm);
    }

    public void triggerCheckExpiryDate() {
        UserManager userManager_ = UserManager.getInstance();
        List userList = userManager_.getUsers();
        Iterator iter = userList.iterator();
        while (iter.hasNext()) {
            User user = (User)iter.next();
            if (user.getName().startsWith("prj_") || user.getName().endsWith("$")) continue;
            ExtendedUserVOCache cache = ExtendedUserVOCache.getInstance();
            cache.checkForExpiryEmail(user.getName());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

