/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.rpc.JAXRPCException;
import org.apache.axis.client.AxisClientProxy;
import org.jboss.logging.Logger;
import org.jboss.webservice.client.CallImpl;
import org.jboss.webservice.client.Stub;

public class PortProxy
implements InvocationHandler {
    private static final Logger log = Logger.getLogger((Class)PortProxy.class);
    private Remote port;
    private CallImpl call;
    private List seiMethods = new ArrayList();
    private List objectMethods = new ArrayList();
    private List stubMethods = new ArrayList();
    private Method getPropertyMethod;
    private Method setPropertyMethod;

    public PortProxy(Remote port, Class seiClass) {
        this.port = port;
        AxisClientProxy axisClientProxy = (AxisClientProxy)Proxy.getInvocationHandler(port);
        this.call = (CallImpl)axisClientProxy.getCall();
        this.objectMethods.addAll(Arrays.asList(Object.class.getMethods()));
        this.seiMethods.addAll(Arrays.asList(seiClass.getMethods()));
        this.stubMethods.addAll(Arrays.asList(Stub.class.getMethods()));
        try {
            this.getPropertyMethod = Stub.class.getMethod("_getProperty", String.class);
            this.setPropertyMethod = Stub.class.getMethod("_setProperty", String.class, Object.class);
        }
        catch (NoSuchMethodException ignore) {
            // empty catch block
        }
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        List<Object> arglist = new ArrayList();
        if (log.isDebugEnabled() && args != null) {
            arglist = Arrays.asList(args);
        }
        try {
            Object retObj = null;
            if (this.seiMethods.contains(method)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Invoke on service endpoint interface: " + methodName + " " + arglist));
                }
                retObj = method.invoke((Object)this.port, args);
                return retObj;
            }
            if (this.stubMethods.contains(method)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Invoke on stub interface: " + methodName + " " + arglist));
                }
                if ("getUsername".equals(methodName)) {
                    retObj = this.getPropertyMethod.invoke((Object)this.port, "javax.xml.rpc.security.auth.username");
                } else if ("setUsername".equals(methodName)) {
                    retObj = this.setPropertyMethod.invoke((Object)this.port, "javax.xml.rpc.security.auth.username", args[0]);
                } else if ("getPassword".equals(methodName)) {
                    retObj = this.getPropertyMethod.invoke((Object)this.port, "javax.xml.rpc.security.auth.password");
                } else if ("setPassword".equals(methodName)) {
                    retObj = this.setPropertyMethod.invoke((Object)this.port, "javax.xml.rpc.security.auth.password", args[0]);
                } else if ("getEndpointAddress".equals(methodName)) {
                    retObj = this.getPropertyMethod.invoke((Object)this.port, "javax.xml.rpc.service.endpoint.address");
                } else if ("setEndpointAddress".equals(methodName)) {
                    retObj = this.setPropertyMethod.invoke((Object)this.port, "javax.xml.rpc.service.endpoint.address", args[0]);
                } else if ("getSessionMaintain".equals(methodName)) {
                    retObj = this.getPropertyMethod.invoke((Object)this.port, "javax.xml.rpc.session.maintain");
                } else if ("setSessionMaintain".equals(methodName)) {
                    retObj = this.setPropertyMethod.invoke((Object)this.port, "javax.xml.rpc.session.maintain", args[0]);
                } else if ("getTimeout".equals(methodName)) {
                    retObj = this.call.getTimeout();
                } else if ("setTimeout".equals(methodName)) {
                    this.call.setTimeout((Integer)args[0]);
                } else if (this.getPropertyMethod.equals(method) && "org.jboss.webservice.client.timeout".equals(args[0])) {
                    retObj = this.call.getTimeout();
                } else if (this.setPropertyMethod.equals(method) && "org.jboss.webservice.client.timeout".equals(args[0])) {
                    this.call.setTimeout((Integer)args[1]);
                } else if ("addAttachment".equals(methodName)) {
                    this.call.addAttachment((String)args[0], args[1]);
                } else if ("removeAttachment".equals(methodName)) {
                    this.call.removeAttachment((String)args[0]);
                } else {
                    retObj = "getAttachments".equals(methodName) ? this.call.getAttachmentIdentifiers() : ("getAttachment".equals(methodName) ? this.call.getAttachment((String)args[0]) : method.invoke((Object)this.port, args));
                }
                return retObj;
            }
            if (this.objectMethods.contains(method)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Invoke on object: " + methodName + " " + arglist));
                }
                retObj = method.invoke((Object)this.port, args);
                return retObj;
            }
            throw new JAXRPCException("Don't know how to invoke: " + method);
        }
        catch (Exception e) {
            Throwable th = this.processException(e);
            if (this.seiMethods.contains(method) && (th instanceof JAXRPCException || th instanceof RuntimeException)) {
                RemoteException re = new RemoteException(th.getMessage(), th);
                th = re;
            }
            throw th;
        }
    }

    private Throwable processException(Exception ex) {
        Throwable th = ex;
        if (ex instanceof InvocationTargetException) {
            th = ((InvocationTargetException)ex).getTargetException();
        }
        log.error((Object)"Port error", th);
        return th;
    }
}

