/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.wsdl.Definition;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;
import org.jboss.logging.Logger;
import org.jboss.webservice.client.ServiceImpl;
import org.jboss.webservice.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.webservice.util.WSDLUtilities;

public class ServiceProxy
implements InvocationHandler {
    private static final Logger log = Logger.getLogger((Class)ServiceProxy.class);
    private ServiceImpl jaxrpcService;
    private List objectMethods = new ArrayList();
    private List jaxrpcServiceMethods = new ArrayList();
    private List serviceInterfaceMethods = new ArrayList();
    private List endorsedServiceEndpointClasses = new ArrayList();
    private Method getPortMethod;

    public ServiceProxy(ServiceImpl service, Class siClass) {
        this.jaxrpcService = service;
        this.objectMethods.addAll(Arrays.asList(Object.class.getMethods()));
        this.jaxrpcServiceMethods.addAll(Arrays.asList(Service.class.getMethods()));
        if (!siClass.getName().equals("javax.xml.rpc.Service")) {
            this.serviceInterfaceMethods.addAll(Arrays.asList(siClass.getDeclaredMethods()));
        }
        try {
            this.getPortMethod = Service.class.getMethod("getPort", Class.class);
        }
        catch (NoSuchMethodException e) {
            throw new JAXRPCException(e.toString());
        }
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        List<Object> arglist = new ArrayList();
        if (log.isDebugEnabled() && args != null) {
            arglist = Arrays.asList(args);
        }
        try {
            Object retObj = null;
            if (this.jaxrpcServiceMethods.contains(method)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Invoke on jaxrpc service: " + methodName + " " + arglist));
                }
                if (method.getName().equals("getPort")) {
                    Class seiClass = (Class)(args.length == 1 ? args[0] : args[1]);
                    this.endorseServiceEndpointClass(seiClass);
                    Remote port = (Remote)method.invoke((Object)this.jaxrpcService, args);
                    return port;
                }
                retObj = method.invoke((Object)this.jaxrpcService, args);
                return retObj;
            }
            if (this.serviceInterfaceMethods.contains(method)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Invoke on service interface: " + methodName + " " + arglist));
                }
                Class<?> seiClass = method.getReturnType();
                retObj = this.getPortMethod.invoke((Object)this.jaxrpcService, seiClass);
                return retObj;
            }
            if (this.objectMethods.contains(method)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Invoke on object: " + methodName + " " + arglist));
                }
                retObj = method.invoke((Object)this.jaxrpcService, args);
                return retObj;
            }
            throw new JAXRPCException("Don't know how to invoke: " + method);
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    private void handleException(Exception ex) throws Throwable {
        Throwable th = ex;
        if (ex instanceof InvocationTargetException) {
            th = ((InvocationTargetException)ex).getTargetException();
        }
        log.error((Object)"Service error", th);
        throw th;
    }

    private void endorseServiceEndpointClass(Class seiClass) throws ServiceException {
        if (this.endorsedServiceEndpointClasses.contains(seiClass)) {
            return;
        }
        Definition wsdlDefinition = this.jaxrpcService.getWsdlDefinition();
        JavaWsdlMapping jaxrpcMapping = this.jaxrpcService.getJavaWsdlMapping();
        WSDLUtilities.endorseServiceEndpointInterface(wsdlDefinition, seiClass, jaxrpcMapping);
        this.endorsedServiceEndpointClasses.add(seiClass);
    }
}

