/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice.client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.URL;
import javax.management.MBeanServer;
import javax.naming.BinaryRefAddr;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.webservice.AxisServiceMBean;
import org.jboss.webservice.client.ServiceObjectFactory;
import org.jboss.webservice.metadata.PortComponentRefMetaData;
import org.jboss.webservice.metadata.ServiceRefMetaData;

public class ServiceReferenceable
implements Referenceable {
    public static final String SERVICE_REF_META_DATA = "SERVICE_REF_META_DATA";
    public static final String DEPLOYMENT_URL = "DEPLOYMENT_URL";
    public static final String PORT_COMPONENT_LINK = "PORT_COMPONENT_LINK";
    public static final String PORT_COMPONENT_LINK_SERVLET = "PORT_COMPONENT_LINK_SERVLET";
    private ServiceRefMetaData refMetaData;
    private DeploymentInfo di;

    public ServiceReferenceable(ServiceRefMetaData refMetaData, DeploymentInfo di) {
        this.refMetaData = refMetaData;
        this.di = di;
    }

    public Reference getReference() throws NamingException {
        Reference myRef = new Reference(ServiceReferenceable.class.getName(), ServiceObjectFactory.class.getName(), null);
        URL deploymentURL = this.di.localUrl != null ? this.di.localUrl : this.di.url;
        myRef.add(new StringRefAddr(DEPLOYMENT_URL, deploymentURL.toExternalForm()));
        myRef.add(new BinaryRefAddr(SERVICE_REF_META_DATA, this.marshallServiceRef()));
        PortComponentRefMetaData[] pcrArr = this.refMetaData.getPortComponentRefs();
        for (int i = 0; i < pcrArr.length; ++i) {
            PortComponentRefMetaData pcr = pcrArr[i];
            String pcLink = pcr.getPortComponentLink();
            if (pcLink == null) continue;
            String deploymentName = this.di.getCanonicalName();
            int hashIndex = pcLink.indexOf("#");
            if (hashIndex > 0) {
                deploymentName = pcLink.substring(0, hashIndex);
                pcLink = pcLink.substring(hashIndex + 1);
                while (deploymentName.startsWith(".") || deploymentName.startsWith("/")) {
                    deploymentName = deploymentName.substring(1);
                }
            }
            String serviceID = deploymentName + "#" + pcLink;
            myRef.add(new StringRefAddr(PORT_COMPONENT_LINK, serviceID));
            try {
                MBeanServer server = MBeanServerLocator.locateJBoss();
                String host = (String)server.getAttribute(AxisServiceMBean.OBJECT_NAME, "WebServiceHost");
                int port = (Integer)server.getAttribute(AxisServiceMBean.OBJECT_NAME, "WebServicePort");
                String servletURL = "http://" + host + ":" + port + "/ws4ee/pclink";
                myRef.add(new StringRefAddr(PORT_COMPONENT_LINK_SERVLET, servletURL));
                continue;
            }
            catch (Exception e) {
                throw new NamingException("Cannot obtain path to PortComponentLinkServlet, cause is " + e);
            }
        }
        return myRef;
    }

    private byte[] marshallServiceRef() throws NamingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this.refMetaData);
            oos.close();
        }
        catch (IOException e) {
            throw new NamingException("Cannot marshall_01 service ref meta data, cause: " + e.toString());
        }
        return baos.toByteArray();
    }
}

