/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.tma.AlgorithmAdapter;

import at.tugraz.genome.tma.AlgorithmAdapter.AlgorithmAdapterPunchData;
import at.tugraz.genome.tma.AlgorithmAdapter.AlgorithmAdapterResult;
import at.tugraz.genome.tma.ejb.entity.Algorithm;
import at.tugraz.genome.tma.ejb.entity.AlgorithmUtil;
import at.tugraz.genome.tma.ejb.entity.AlgorithmspersectionUtil;
import at.tugraz.genome.tma.ejb.entity.Punch;
import at.tugraz.genome.tma.ejb.entity.PunchUtil;
import at.tugraz.genome.tma.ejb.entity.Result;
import at.tugraz.genome.tma.ejb.entity.ResultUtil;
import at.tugraz.genome.tma.ejb.entity.Section;
import at.tugraz.genome.tma.ejb.entity.SectionUtil;
import at.tugraz.genome.tma.ejb.vos.AlgorithmVO;
import at.tugraz.genome.tma.ejb.vos.AlgorithmspersectionVO;
import at.tugraz.genome.tma.ejb.vos.PunchVO;
import at.tugraz.genome.tma.ejb.vos.ResultVO;
import at.tugraz.genome.tma.ejb.vos.SectionVO;
import at.tugraz.genome.tma.exceptions.TmaGlobalException;
import at.tugraz.genome.voutils.ValueTreeBuilder;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AlgorithmAdapterBean
implements SessionBean {
    protected SessionContext _ctx = null;
    Log log = LogFactory.getLog(this.getClass());

    public abstract void ejbActivate() throws EJBException, RemoteException;

    public abstract void ejbCreate() throws CreateException;

    public abstract void ejbPassivate() throws EJBException, RemoteException;

    public abstract void ejbRemove() throws EJBException, RemoteException;

    protected abstract Collection executeAlgorithm(AlgorithmAdapterPunchData var1, Hashtable var2) throws TmaGlobalException;

    private AlgorithmVO getAlgorithmVO(String algorithmname) throws TmaGlobalException {
        try {
            this.log.debug((Object)("algorithmvo is null findAlgorithmByAlgorithmname:" + algorithmname));
            Algorithm entity = AlgorithmUtil.getLocalHome().findAlgorithmByAlgorithmname(algorithmname);
            AlgorithmVO returnvo = (AlgorithmVO)ValueTreeBuilder.getValueTree((Object)entity, (ValueTreeBuilder.IncludeTree)ValueTreeBuilder.createIncludeTree((String)""));
            this.log.debug((Object)"findAlgorithmByAlgorithmname sucsessfull");
            return returnvo;
        }
        catch (ObjectNotFoundException onfex) {
            this.log.error((Object)"findAlgorithmByAlgorithmname: ObjectNotFoundException thrown");
            this.log.error((Object)onfex);
            throw new TmaGlobalException(onfex.getMessage());
        }
        catch (FinderException fex) {
            this.log.error((Object)"findAlgorithmByAlgorithmname: FinderException thrown");
            this.log.error((Object)fex);
            throw new TmaGlobalException(fex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error((Object)"findAlgorithmByAlgorithmname: NamingException thrown");
            this.log.error((Object)nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    private PunchVO getPunchVOById(Long punchId) throws TmaGlobalException {
        this.log.debug((Object)("getPunchVOById: begin punchId=" + punchId));
        Punch entity = null;
        try {
            entity = PunchUtil.getLocalHome().findByPrimaryKey(punchId);
        }
        catch (FinderException fex) {
            this.log.error((Object)("getPunchVOById(punchId=" + punchId + "): FinderException thrown"));
            this.log.error((Object)fex);
            return null;
        }
        catch (NamingException nex) {
            this.log.error((Object)("getPunchVOById(punchId=" + punchId + "): NamingException thrown"));
            this.log.error((Object)nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        PunchVO returnVO = (PunchVO)ValueTreeBuilder.getValueTree((Object)entity, (ValueTreeBuilder.IncludeTree)ValueTreeBuilder.createIncludeTree((String)"Punchimages"));
        this.log.debug((Object)"getPunchVOById: finished successfuly");
        return returnVO;
    }

    private Collection getPunchVOsBySectionId(Long sectionId) throws TmaGlobalException {
        this.log.debug((Object)("getPunchVOsBySectionId: begin sectionId=" + sectionId));
        ArrayList<PunchVO> punchs = new ArrayList<PunchVO>();
        Iterator iter = this.getSectionVOById(sectionId).getPunchs().iterator();
        while (iter.hasNext()) {
            PunchVO punchvo = (PunchVO)iter.next();
            punchs.add(punchvo);
        }
        return punchs;
    }

    private SectionVO getSectionVOById(Long id) throws TmaGlobalException {
        this.log.debug((Object)("getSectionVOById: begin id=" + id));
        Section entity = null;
        try {
            entity = SectionUtil.getLocalHome().findByPrimaryKey(id);
        }
        catch (FinderException fex) {
            this.log.error((Object)("getSectionVOById(id=" + id + "): FinderException thrown"));
            this.log.error((Object)fex);
            return null;
        }
        catch (NamingException nex) {
            this.log.error((Object)("getSectionVOById(id=" + id + "): NamingException thrown"));
            this.log.error((Object)nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        SectionVO returnVO = (SectionVO)ValueTreeBuilder.getValueTree((Object)entity, (ValueTreeBuilder.IncludeTree)ValueTreeBuilder.createIncludeTree((String)"Punchs,Punchs.Punchimages"));
        this.log.debug((Object)("getSectionVOById: finished successfuly returnVO=" + returnVO));
        return returnVO;
    }

    protected SessionContext getSessionContext() {
        return this._ctx;
    }

    public abstract String getVersion();

    private void insertAlgorithmpersectionEntry(Long sectionId, AlgorithmVO algorithmvo) throws TmaGlobalException {
        AlgorithmspersectionVO apsVo = new AlgorithmspersectionVO();
        apsVo.setAlgorithmId(algorithmvo.getAlgorithmId());
        apsVo.setSection(this.getSectionVOById(sectionId));
        try {
            AlgorithmspersectionUtil.getLocalHome().create(apsVo);
        }
        catch (NamingException nex) {
            this.log.error((Object)"insertAlgorithmpersectionEntry: NamingException thrown");
            this.log.error((Object)nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        catch (CreateException ex) {
            this.log.error((Object)"insertAlgorithmpersectionEntry: CreateException thrown");
            this.log.error((Object)ex);
            throw new TmaGlobalException(ex.getMessage());
        }
    }

    private void insertResult(AlgorithmVO algorithmVO, PunchVO punchVO, Collection punchimages, String resultName, String resultValue) throws TmaGlobalException {
        this.log.info((Object)("insertResult: begin algorithm=" + algorithmVO.getAlgorithmname() + ", punchID=" + punchVO.getPunchId() + ", resultName=" + resultName + ", resultValue=" + resultValue));
        ResultVO resVO = new ResultVO();
        resVO.setPunch(punchVO);
        resVO.setResultname(resultName);
        resVO.setResultvalue(resultValue);
        resVO.setAlgorithm(algorithmVO);
        resVO.setPunchimages(punchimages);
        Result entity = null;
        try {
            entity = ResultUtil.getLocalHome().create(resVO);
            this.log.info((Object)("insertResult(): finished id=" + entity.getResultId()));
        }
        catch (CreateException cex) {
            this.log.error((Object)("insertResult: vo=" + resVO + "CreateException thrown"));
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error((Object)("insertResult: vo=" + resVO + "NamingException thrown"));
            this.log.error((Object)nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    private void insertResults(Collection results, AlgorithmVO algorithmvo) throws TmaGlobalException {
        Iterator iter = results.iterator();
        while (iter.hasNext()) {
            AlgorithmAdapterResult result = (AlgorithmAdapterResult)iter.next();
            this.insertResult(algorithmvo, result.getPunchVO(), result.getPunchimages(), result.getResultName(), result.getResultValue());
        }
    }

    public abstract Boolean isStartable();

    public void setSessionContext(SessionContext ctx) {
        this._ctx = ctx;
    }

    public String start(ObjectMessage inputmsg) {
        String return_message;
        block12: {
            Long sectionID = null;
            Long punchID = null;
            try {
                sectionID = new Long(inputmsg.getLongProperty("sectionID"));
            }
            catch (JMSException ex) {
                try {
                    punchID = new Long(inputmsg.getLongProperty("punchID"));
                }
                catch (JMSException ex1) {
                }
            }
            try {
                AlgorithmVO algorithmvo = this.getAlgorithmVO(inputmsg.getStringProperty("Algorithm"));
                Hashtable params = (Hashtable)inputmsg.getObject();
                if (sectionID != null) {
                    Collection punch = this.getPunchVOsBySectionId(sectionID);
                    if (!punch.isEmpty()) {
                        Iterator iter = punch.iterator();
                        while (iter.hasNext()) {
                            PunchVO punchvo = (PunchVO)iter.next();
                            AlgorithmAdapterPunchData data = new AlgorithmAdapterPunchData(punchvo);
                            this.insertResults(this.executeAlgorithm(data, params), algorithmvo);
                        }
                        this.insertAlgorithmpersectionEntry(sectionID, algorithmvo);
                        return_message = "Algorithm sucsessfully executed on Section:" + sectionID;
                    } else {
                        return_message = "No Punches found ! Cannot execute Algorithm on Section:" + sectionID;
                    }
                    break block12;
                }
                if (punchID != null) {
                    AlgorithmAdapterPunchData data = new AlgorithmAdapterPunchData(this.getPunchVOById(punchID));
                    this.insertResults(this.executeAlgorithm(data, params), algorithmvo);
                    return_message = "Algorithm successfully executed on Punch:" + punchID;
                    break block12;
                }
                return_message = "Algorithm not executed: No sectionID or punchID defined";
            }
            catch (JMSException ex2) {
                return_message = "JMSException thrown:" + ex2.getMessage();
            }
            catch (TmaGlobalException tex) {
                System.err.println("TMAExc: " + tex);
                this.getSessionContext().setRollbackOnly();
                return_message = "TmaGlobalException thrown:" + tex.getMessage();
            }
        }
        return return_message;
    }
}

