/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.http;

import java.net.InetAddress;
import java.util.Properties;
import org.jboss.mq.il.ServerIL;
import org.jboss.mq.il.ServerILJMXService;
import org.jboss.mq.il.http.HTTPServerIL;
import org.jboss.mq.il.http.HTTPServerILFactory;
import org.jboss.mq.il.http.HTTPServerILServiceMBean;
import org.jboss.system.server.ServerConfigUtil;

public class HTTPServerILService
extends ServerILJMXService
implements HTTPServerILServiceMBean {
    private HTTPServerIL serverIL;
    private String url = null;
    private String urlPrefix = "http://";
    private int urlPort = 8080;
    private String urlSuffix = "jbossmq-httpil/HTTPServerILServlet";
    private String urlHostName = null;
    private boolean useHostName = false;
    private long timeout = 60000L;
    private long restInterval = 0L;

    public String getName() {
        return "JBossMQ-HTTPServerIL";
    }

    public ServerIL getServerIL() {
        return this.serverIL;
    }

    public Properties getClientConnectionProperties() {
        Properties properties = super.getClientConnectionProperties();
        properties.setProperty("ClientILService", HTTPServerILFactory.CLIENT_IL_SERVICE);
        properties.setProperty("org.jboss.mq.il.http.url", this.url);
        properties.setProperty("org.jboss.mq.il.http.timeout", String.valueOf(this.timeout));
        properties.setProperty("org.jboss.mq.il.http.restinterval", String.valueOf(this.restInterval));
        return properties;
    }

    public void startService() throws Exception {
        super.startService();
        this.pingPeriod = 0L;
        if (this.url == null) {
            this.url = this.getConstructedURL();
        }
        this.serverIL = new HTTPServerIL(this.url);
        super.bindJNDIReferences();
    }

    public void stopService() {
        try {
            this.unbindJNDIReferences();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setTimeOut(int timeout) {
        this.timeout = timeout * 1000;
    }

    public int getTimeOut() {
        return (int)this.timeout / 1000;
    }

    public void setRestInterval(int restInterval) {
        this.restInterval = restInterval * 1000;
    }

    public int getRestInterval() {
        return (int)this.restInterval / 1000;
    }

    public void setURL(String url) {
        this.url = url;
        this.urlPrefix = null;
        this.urlHostName = null;
        this.urlPort = 0;
        this.urlSuffix = null;
        this.useHostName = false;
    }

    public String getURL() {
        return this.url;
    }

    public void setURLPrefix(String prefix) {
        this.urlPrefix = prefix;
    }

    public String getURLPrefix() {
        return this.urlPrefix;
    }

    public void setURLHostName(String hostname) {
        this.urlHostName = hostname;
    }

    public String getURLHostName() {
        return this.urlHostName;
    }

    public void setURLPort(int port) {
        this.urlPort = port;
    }

    public int getURLPort() {
        return this.urlPort;
    }

    public void setURLSuffix(String suffix) {
        this.urlSuffix = suffix;
    }

    public String getURLSuffix() {
        return this.urlSuffix;
    }

    public void setUseHostName(boolean value) {
        this.useHostName = value;
    }

    public boolean getUseHostName() {
        return this.useHostName;
    }

    private String getConstructedURL() throws Exception {
        if (System.getProperty("org.jboss.mq.il.http.url") != null) {
            return System.getProperty("org.jboss.mq.il.http.url");
        }
        String hostName = this.urlHostName;
        if (hostName == null) {
            hostName = ServerConfigUtil.getSpecificBindAddress();
        }
        if (hostName == null) {
            hostName = this.useHostName ? InetAddress.getLocalHost().getHostName() : InetAddress.getLocalHost().getHostAddress();
        }
        return this.urlPrefix + hostName + ":" + String.valueOf(this.urlPort) + "/" + this.urlSuffix;
    }
}

