/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.oil2;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.jms.JMSException;
import org.jboss.mq.il.oil2.OIL2Request;

public class OIL2Response {
    Integer correlationRequestId;
    byte operation;
    Object result;
    Throwable exception;

    public OIL2Response() {
    }

    public OIL2Response(OIL2Request request) {
        this.correlationRequestId = request.requestId;
        this.operation = request.operation;
    }

    public Object evalThrowsJMSException() throws JMSException, IOException {
        if (this.exception != null) {
            if (this.exception instanceof JMSException) {
                throw (JMSException)this.exception;
            }
            throw new IOException("Protocol violation: unexpected exception found in response: " + this.exception);
        }
        return this.result;
    }

    public Object evalThrowsException() throws Exception {
        if (this.exception != null) {
            if (this.exception instanceof Exception) {
                throw (Exception)this.exception;
            }
            throw new IOException("Protocol violation: unexpected exception found in response: " + this.exception);
        }
        return this.result;
    }

    public Object evalThrowsThrowable() throws Throwable {
        if (this.exception != null) {
            throw this.exception;
        }
        return this.result;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(this.operation);
        if (this.correlationRequestId == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeInt(this.correlationRequestId);
        }
        if (this.exception != null) {
            out.writeByte(3);
            out.writeObject(this.exception);
            return;
        }
        if (this.result == null) {
            out.writeByte(1);
            return;
        }
        switch (this.operation) {
            default: 
        }
        out.writeByte(2);
        out.writeObject(this.result);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.operation = in.readByte();
        if (in.readByte() == 1) {
            this.correlationRequestId = new Integer(in.readInt());
        }
        byte responseType = in.readByte();
        switch (responseType) {
            case 1: {
                this.result = null;
                this.exception = null;
                break;
            }
            case 3: {
                this.result = null;
                this.exception = (Throwable)in.readObject();
                break;
            }
            case 2: {
                this.exception = null;
                switch (this.operation) {
                    default: 
                }
                this.result = in.readObject();
                break;
            }
            default: {
                throw new IOException("Protocol Error: Bad response type code '" + responseType + "' ");
            }
        }
    }

    public String toString() {
        return "[operation:" + this.operation + "," + "correlationRequestId:" + this.correlationRequestId + ",result:" + this.result + ",exception:" + this.exception + "]";
    }
}

