/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.oil2;

import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import EDU.oswego.cs.dl.util.concurrent.Slot;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import org.jboss.logging.Logger;
import org.jboss.mq.il.oil2.OIL2Request;
import org.jboss.mq.il.oil2.OIL2RequestListner;
import org.jboss.mq.il.oil2.OIL2Response;

public final class OIL2SocketHandler
implements Cloneable,
Runnable {
    private static final Logger log = Logger.getLogger((Class)OIL2SocketHandler.class);
    private ObjectInputStream in;
    private ObjectOutputStream out;
    private boolean running;
    private final ThreadGroup partentThreadGroup;
    private Thread worker;
    private static int threadNumber = 0;
    private static final int STATE_CREATED = 0;
    private static final int STATE_CONNECTION_ERROR = 3;
    private int state = 0;
    volatile ConcurrentHashMap responseSlots = new ConcurrentHashMap();
    OIL2RequestListner requestListner;
    private volatile boolean pumpingData = false;
    private Object pumpMutex = new Object();
    LinkedQueue requestQueue = new LinkedQueue();
    PooledExecutor pool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OIL2SocketHandler(ObjectInputStream in, ObjectOutputStream out, ThreadGroup partentThreadGroup) {
        this.in = in;
        this.out = out;
        this.partentThreadGroup = partentThreadGroup;
        Class clazz = OIL2SocketHandler.class;
        synchronized (clazz) {
            if (this.pool == null) {
                this.pool = new PooledExecutor(50);
                log.debug((Object)"Setting the OIL2SocketHandler's thread factory");
                this.pool.setThreadFactory(new ThreadFactory(){
                    private int threadNo = 0;

                    public Thread newThread(Runnable r) {
                        Thread t = new Thread(OIL2SocketHandler.this.partentThreadGroup, r, "OIL2SocketHandler Thread-" + this.threadNo++);
                        t.setDaemon(true);
                        return t;
                    }
                });
                this.pool.setMinimumPoolSize(1);
                this.pool.setKeepAliveTime(60000L);
                this.pool.runWhenBlocked();
                this.pool.createThreads(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRequest(OIL2Request request) throws IOException {
        try {
            ObjectOutputStream objectOutputStream = this.out;
            synchronized (objectOutputStream) {
                this.out.writeByte(1);
                request.writeExternal(this.out);
                this.out.reset();
                this.out.flush();
            }
        }
        catch (IOException e) {
            this.state = 3;
            throw e;
        }
    }

    private void registerResponseSlot(OIL2Request request, Slot responseSlot) throws IOException {
        this.responseSlots.put((Object)request.requestId, (Object)responseSlot);
    }

    public void setRequestListner(OIL2RequestListner requestListner) {
        this.requestListner = requestListner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendResponse(OIL2Response response) throws IOException {
        try {
            ObjectOutputStream objectOutputStream = this.out;
            synchronized (objectOutputStream) {
                this.out.writeByte(2);
                response.writeExternal(this.out);
                this.out.reset();
                this.out.flush();
            }
        }
        catch (IOException e) {
            this.state = 3;
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object pumpMessages(OIL2Request request, Channel mySlot) throws IOException, ClassNotFoundException, InterruptedException {
        OIL2Response oIL2Response;
        block32: {
            OIL2Request oIL2Request;
            block31: {
                Object object;
                Object object2;
                block30: {
                    Object object3 = this.pumpMutex;
                    synchronized (object3) {
                        if (this.pumpingData) {
                            return null;
                        }
                        this.pumpingData = true;
                    }
                    try {
                        while (true) {
                            if (mySlot != null) {
                                Object o;
                                while ((o = mySlot.peek()) != null) {
                                    o = mySlot.take();
                                    if (o == this) continue;
                                    object2 = o;
                                    Object var8_9 = null;
                                    object = this.pumpMutex;
                                    break block30;
                                }
                            }
                            byte code = this.in.readByte();
                            switch (code) {
                                case 1: {
                                    OIL2Request newRequest = new OIL2Request();
                                    newRequest.readExternal(this.in);
                                    if (request == null) {
                                        oIL2Request = newRequest;
                                        break block31;
                                    } else {
                                        this.requestQueue.put((Object)newRequest);
                                        break;
                                    }
                                }
                                case 2: {
                                    OIL2Response response = new OIL2Response();
                                    response.readExternal(this.in);
                                    if (response.correlationRequestId == null) break;
                                    if (request != null && request.requestId.equals(response.correlationRequestId)) {
                                        oIL2Response = response;
                                        break block32;
                                    } else {
                                        Slot slot = (Slot)this.responseSlots.remove((Object)response.correlationRequestId);
                                        if (slot != null) {
                                            slot.put((Object)response);
                                            break;
                                        }
                                        if (!log.isTraceEnabled()) break;
                                        log.warn((Object)("No slot registered for: " + response));
                                        break;
                                    }
                                }
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_12 = null;
                        Object object4 = this.pumpMutex;
                        synchronized (object4) {
                            this.pumpingData = false;
                        }
                        Thread thread = Thread.currentThread();
                        boolean interrupted = thread.isInterrupted();
                        Iterator i = this.responseSlots.values().iterator();
                        while (i.hasNext()) {
                            Slot s = (Slot)i.next();
                            if (s == mySlot) continue;
                            s.offer((Object)this, 0L);
                        }
                        if (request != null) {
                            this.requestQueue.put((Object)this);
                        }
                        if (!interrupted) throw throwable;
                        thread.interrupt();
                        throw throwable;
                    }
                }
                synchronized (object) {
                    this.pumpingData = false;
                }
                Thread thread = Thread.currentThread();
                boolean interrupted = thread.isInterrupted();
                Iterator i = this.responseSlots.values().iterator();
                while (i.hasNext()) {
                    Slot s = (Slot)i.next();
                    if (s == mySlot) continue;
                    s.offer((Object)this, 0L);
                }
                if (request != null) {
                    this.requestQueue.put((Object)this);
                }
                if (!interrupted) return object2;
                thread.interrupt();
                return object2;
            }
            Object var8_10 = null;
            Object object = this.pumpMutex;
            synchronized (object) {
                this.pumpingData = false;
            }
            Thread thread = Thread.currentThread();
            boolean interrupted = thread.isInterrupted();
            Iterator i = this.responseSlots.values().iterator();
            while (i.hasNext()) {
                Slot s = (Slot)i.next();
                if (s == mySlot) continue;
                s.offer((Object)this, 0L);
            }
            if (request != null) {
                this.requestQueue.put((Object)this);
            }
            if (!interrupted) return oIL2Request;
            thread.interrupt();
            return oIL2Request;
        }
        Object var8_11 = null;
        Object object = this.pumpMutex;
        synchronized (object) {
            this.pumpingData = false;
        }
        Thread thread = Thread.currentThread();
        boolean interrupted = thread.isInterrupted();
        Iterator i = this.responseSlots.values().iterator();
        while (i.hasNext()) {
            Slot s = (Slot)i.next();
            if (s == mySlot) continue;
            s.offer((Object)this, 0L);
        }
        if (request != null) {
            this.requestQueue.put((Object)this);
        }
        if (!interrupted) return oIL2Response;
        thread.interrupt();
        return oIL2Response;
    }

    public OIL2Response synchRequest(OIL2Request request) throws IOException, InterruptedException, ClassNotFoundException {
        Slot slot = new Slot();
        this.registerResponseSlot(request, slot);
        this.sendRequest(request);
        Object o = null;
        while (true) {
            if (o != null) {
                if (o != this) {
                    return (OIL2Response)o;
                }
                o = slot.peek();
                if (o == null) continue;
                o = slot.take();
                continue;
            }
            o = this.pumpMessages(request, (Channel)slot);
            if (o != null) continue;
            o = slot.take();
        }
    }

    public void run() {
        try {
            Object o = null;
            while (this.running) {
                if (o != null) {
                    if (o != this) {
                        this.pool.execute((Runnable)new RequestRunner((OIL2Request)o));
                    }
                    if ((o = this.requestQueue.peek()) == null) continue;
                    o = this.requestQueue.take();
                    continue;
                }
                o = this.pumpMessages(null, (Channel)this.requestQueue);
                if (o != null) continue;
                o = this.requestQueue.take();
            }
        }
        catch (InterruptedException e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Stopped due to interruption");
            }
        }
        catch (Exception e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Stopping due to unexcpected exception: ", (Throwable)e);
            }
            this.state = 3;
            this.requestListner.handleConnectionException(e);
        }
        this.running = false;
        if (log.isTraceEnabled()) {
            log.trace((Object)"Stopped");
        }
    }

    public void start() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Starting");
        }
        this.running = true;
        this.worker = new Thread(this.partentThreadGroup, this, "OIL2 Worker-" + threadNumber++);
        this.worker.setDaemon(true);
        this.worker.start();
    }

    public void stop() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Stopping");
        }
        this.running = false;
        this.worker.interrupt();
    }

    public class RequestRunner
    implements Runnable {
        OIL2Request request;

        RequestRunner(OIL2Request request) {
            this.request = request;
        }

        public void run() {
            OIL2SocketHandler.this.requestListner.handleRequest(this.request);
        }
    }
}

