/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.server.jmx;

import java.util.Arrays;
import java.util.List;
import javax.jms.IllegalStateException;
import org.jboss.mq.MessageStatistics;
import org.jboss.mq.SpyQueue;
import org.jboss.mq.server.JMSDestinationManager;
import org.jboss.mq.server.JMSQueue;
import org.jboss.mq.server.MessageCounter;
import org.jboss.mq.server.jmx.DestinationMBeanSupport;
import org.jboss.mq.server.jmx.QueueMBean;

public class Queue
extends DestinationMBeanSupport
implements QueueMBean {
    JMSQueue destination;

    public String getQueueName() {
        return this.destinationName;
    }

    public int getQueueDepth() throws Exception {
        return this.destination.queue.getQueueDepth();
    }

    public int getScheduledMessageCount() throws Exception {
        return this.destination.queue.getScheduledMessageCount();
    }

    public void startService() throws Exception {
        if (this.destinationName == null || this.destinationName.length() == 0) {
            throw new IllegalStateException("QueueName was not set");
        }
        JMSDestinationManager jmsServer = (JMSDestinationManager)this.server.getAttribute(this.jbossMQService, "Interceptor");
        this.spyDest = new SpyQueue(this.destinationName);
        this.destination = new JMSQueue((SpyQueue)this.spyDest, null, jmsServer, this.parameters);
        jmsServer.addDestination(this.destination);
        if (this.jndiName == null) {
            this.setJNDIName("queue/" + this.destinationName);
        } else {
            this.setJNDIName(this.jndiName);
        }
        super.startService();
    }

    public void removeAllMessages() throws Exception {
        this.destination.removeAllMessages();
    }

    public int getReceiversCount() {
        return this.destination.queue.getReceiversCount();
    }

    public List listReceivers() {
        return this.destination.queue.getReceivers();
    }

    public List listMessages() throws Exception {
        return Arrays.asList(this.destination.queue.browse(null));
    }

    public List listMessages(String selector) throws Exception {
        return Arrays.asList(this.destination.queue.browse(selector));
    }

    public MessageCounter[] getMessageCounter() {
        return this.destination.getMessageCounter();
    }

    public MessageStatistics[] getMessageStatistics() throws Exception {
        return MessageCounter.getMessageStatistics(this.destination.getMessageCounter());
    }
}

