/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.client;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.holders.Holder;
import org.apache.axis.AxisFault;
import org.apache.axis.client.Call;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ParameterDesc;
import org.apache.axis.enum.Style;
import org.apache.axis.enum.Use;
import org.apache.axis.utils.JavaUtils;
import org.jboss.logging.Logger;

public class AxisClientProxy
implements InvocationHandler {
    private static Logger log = Logger.getLogger((String)AxisClientProxy.class.getName());
    private Call call;
    private QName portName;
    static /* synthetic */ Class class$javax$xml$rpc$holders$Holder;

    AxisClientProxy(Call call, QName portName) {
        this.call = call;
        this.portName = portName;
    }

    private Object[] proxyParams2CallParams(Object[] proxyParams) throws JavaUtils.HolderException, ServiceException {
        boolean isDocumentLiteral;
        ArrayList<Object> callParams = new ArrayList<Object>();
        OperationDesc operationDesc = this.call.getOperation();
        if (operationDesc == null || proxyParams == null) {
            return proxyParams;
        }
        boolean bl = isDocumentLiteral = Style.DOCUMENT.equals(operationDesc.getStyle()) && Use.LITERAL.equals(operationDesc.getUse());
        if (isDocumentLiteral) {
            int proxyIndex = 0;
            ArrayList opParams = operationDesc.getParameters();
            for (int i = 0; i < opParams.size(); ++i) {
                ParameterDesc parameterDesc = (ParameterDesc)opParams.get(i);
                Class javaType = parameterDesc.getJavaType();
                if (javaType == null || proxyParams[proxyIndex] == null) {
                    callParams.add(proxyParams[proxyIndex++]);
                    continue;
                }
                Class<?> proxyType = proxyParams[proxyIndex].getClass();
                if (javaType.isAssignableFrom(proxyType)) {
                    callParams.add(proxyParams[proxyIndex++]);
                    continue;
                }
                if (JavaUtils.isConvertable(proxyType, javaType)) {
                    Object param = JavaUtils.convert(proxyParams[proxyIndex++], javaType);
                    callParams.add(param);
                    continue;
                }
                boolean ctorFound = false;
                Constructor<?>[] ctors = javaType.getConstructors();
                for (int j = 0; j < ctors.length; ++j) {
                    boolean paramsMatch = true;
                    Constructor<?> ctor = ctors[j];
                    Class<?>[] ctorTypes = ctor.getParameterTypes();
                    if (ctorTypes.length <= 0) continue;
                    Object[] ctorVals = new Object[ctorTypes.length];
                    for (int k = 0; paramsMatch && k < ctorTypes.length; ++k) {
                        if (ctorTypes[k].isAssignableFrom(proxyParams[proxyIndex + k].getClass())) {
                            ctorVals[k] = proxyParams[proxyIndex + k];
                            continue;
                        }
                        paramsMatch = false;
                    }
                    if (!paramsMatch) continue;
                    try {
                        Object inst = ctor.newInstance(ctorVals);
                        proxyIndex += ctorVals.length;
                        callParams.add(inst);
                        ctorFound = true;
                        break;
                    }
                    catch (Exception e) {
                        throw new ServiceException("Cannot map proxy params to: " + javaType);
                    }
                }
                if (ctorFound) continue;
                callParams.add(proxyParams[proxyIndex++]);
            }
        } else {
            for (int i = 0; proxyParams != null && i < proxyParams.length; ++i) {
                Object param = proxyParams[i];
                ParameterDesc paramDesc = operationDesc.getParameter(i);
                if (paramDesc == null) {
                    throw new ServiceException("Cannot obtain parameter " + i + " for: " + operationDesc);
                }
                if (paramDesc.getMode() == 3) {
                    callParams.add(JavaUtils.getHolderValue((Holder)param));
                    continue;
                }
                if (paramDesc.getMode() != 1) continue;
                callParams.add(param);
            }
        }
        return callParams.toArray();
    }

    private void proxyReturn2CallReturn(Class proxyReturn) {
        OperationDesc operationDesc = this.call.getOperation();
        if (operationDesc != null) {
            Class operationReturn = operationDesc.getReturnClass();
            if (proxyReturn != null && operationReturn != null) {
                boolean isConvertible = JavaUtils.isConvertable(operationReturn, proxyReturn);
                if (!isConvertible) {
                    boolean bl = isConvertible = this.getDocLitResultWrapper(operationReturn, proxyReturn) != null;
                }
                if (!isConvertible) {
                    log.debug((Object)("Fixing return class: " + operationReturn + " -> " + proxyReturn));
                    operationDesc.setReturnClass(proxyReturn);
                }
            }
            if (proxyReturn == null && operationReturn != null) {
                log.debug((Object)("Forcing return class to null: " + operationReturn));
                operationDesc.setReturnClass(null);
            }
        }
    }

    private Method getDocLitResultWrapper(Class callReturn, Class proxyReturn) {
        boolean isDocumentLiteral;
        Method getter = null;
        OperationDesc operationDesc = this.call.getOperation();
        boolean bl = isDocumentLiteral = Style.DOCUMENT.equals(operationDesc.getStyle()) && Use.LITERAL.equals(operationDesc.getUse());
        if (isDocumentLiteral) {
            Method[] methods = callReturn.getMethods();
            for (int i = 0; getter == null && i < methods.length; ++i) {
                Method method = methods[i];
                if (!method.getName().startsWith("get") || method.getParameterTypes().length != 0 || !proxyReturn.isAssignableFrom(method.getReturnType())) continue;
                log.debug((Object)("Trying to unwrap proxy return with: " + method));
                getter = method;
            }
        }
        return getter;
    }

    private void callOutputParams2proxyParams(Object[] proxyParams) throws JavaUtils.HolderException {
        OperationDesc operationDesc = this.call.getOperation();
        if (operationDesc == null) {
            return;
        }
        Map outputParams = this.call.getOutputParams();
        for (int i = 0; i < operationDesc.getNumParams(); ++i) {
            Object value;
            Object param = proxyParams[i];
            ParameterDesc paramDesc = operationDesc.getParameter(i);
            if (paramDesc.getMode() == 1) continue;
            if ((class$javax$xml$rpc$holders$Holder == null ? AxisClientProxy.class$("javax.xml.rpc.holders.Holder") : class$javax$xml$rpc$holders$Holder).isAssignableFrom((value = outputParams.get(paramDesc.getQName())).getClass())) {
                value = JavaUtils.getHolderValue(value);
            }
            JavaUtils.setHolderValue((Holder)param, value);
        }
    }

    public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
        try {
            Object outValue;
            if (method.getName().equals("_setProperty")) {
                this.call.setProperty((String)objects[0], objects[1]);
                return null;
            }
            if (method.getName().equals("_getProperty")) {
                return this.call.getProperty((String)objects[0]);
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(this.call.hashCode());
            }
            if (method.getName().equals("toString")) {
                return this.call.toString();
            }
            if (method.getName().equals("equals")) {
                return new Boolean(o == objects[0]);
            }
            if (this.call.getTargetEndpointAddress() != null && this.call.getPortName() != null) {
                this.call.setOperation(method.getName());
                Object[] paramsCall = this.proxyParams2CallParams(objects);
                this.proxyReturn2CallReturn(method.getReturnType());
                outValue = this.call.invoke(paramsCall);
            } else if (this.portName != null) {
                this.call.setOperation(this.portName, method.getName());
                Object[] paramsCall = this.proxyParams2CallParams(objects);
                this.proxyReturn2CallReturn(method.getReturnType());
                outValue = this.call.invoke(paramsCall);
            } else {
                Object[] paramsCall = objects;
                this.proxyReturn2CallReturn(method.getReturnType());
                outValue = this.call.invoke(method.getName(), paramsCall);
            }
            this.callOutputParams2proxyParams(objects);
            outValue = this.callReturn2ProxyReturn(outValue, method.getReturnType());
            return outValue;
        }
        catch (AxisFault af) {
            if (af.detail != null) {
                throw af.detail;
            }
            throw af;
        }
    }

    private Object callReturn2ProxyReturn(Object callReturn, Class proxyReturnType) {
        if (callReturn == null) {
            return callReturn;
        }
        if (JavaUtils.isConvertable(callReturn, proxyReturnType)) {
            return JavaUtils.convert(callReturn, proxyReturnType);
        }
        if (callReturn instanceof ArrayList) {
            return this.convertArrayList(callReturn);
        }
        Class<?> callReturnType = callReturn.getClass();
        Method docLitResultWrapper = this.getDocLitResultWrapper(callReturnType, proxyReturnType);
        if (docLitResultWrapper != null) {
            try {
                Object proxyReturn = docLitResultWrapper.invoke(callReturn, new Object[0]);
                return proxyReturn;
            }
            catch (Exception e) {
                log.error((Object)"Cannot unwrap call return", (Throwable)e);
            }
        }
        log.warn((Object)("Cannot convert call return " + callReturnType.getName() + " to: " + proxyReturnType.getName()));
        return callReturn;
    }

    private Object convertArrayList(Object outValue) {
        Object value = ((ArrayList)outValue).toArray();
        if (value.getClass().isArray() && !value.getClass().getComponentType().isPrimitive()) {
            int len = Array.getLength(value);
            Class<?> type = null;
            for (int x = 0; x < len; ++x) {
                Object o = Array.get(value, x);
                if (o == null) continue;
                if (type == null) {
                    type = o.getClass();
                    continue;
                }
                if (type.getName().equals(o.getClass().getName())) continue;
                type = null;
                break;
            }
            if (type != null) {
                Object convertedArray = Array.newInstance(type, len);
                System.arraycopy(value, 0, convertedArray, 0, len);
                value = convertedArray;
            }
        }
        return value;
    }

    public Call getCall() {
        return this.call;
    }
}

