/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import java.util.ArrayList;
import java.util.List;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.Text;
import org.apache.axis.message.SOAPElementAxisImpl;
import org.apache.axis.message.SOAPElementImpl;
import org.apache.axis.message.TextImpl;
import org.jboss.logging.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class NodeImpl
implements Node {
    private static Logger log = Logger.getLogger((String)NodeImpl.class.getName());
    protected SOAPElementImpl soapParent;
    protected org.w3c.dom.Node domNode;
    private List soapChildren = new ArrayList();

    NodeImpl(org.w3c.dom.Node node) {
        if (node.getNodeName().startsWith(":")) {
            throw new IllegalArgumentException("Illegal node name: " + node.getNodeName());
        }
        this.domNode = node;
    }

    public void detachNode() {
        this.assertSOAPParent();
        org.w3c.dom.Node parent = this.domNode.getParentNode();
        if (parent != null) {
            parent.removeChild(this.domNode);
            this.soapParent.soapChildren.remove(this);
            if (this.soapParent instanceof SOAPElementAxisImpl) {
                ((SOAPElementAxisImpl)this.soapParent).removeChild((org.w3c.dom.Node)((Object)this));
            }
            this.soapParent = null;
        }
    }

    public SOAPElement getParentElement() {
        return this.soapParent;
    }

    public void setParentElement(SOAPElement parent) throws SOAPException {
        if (this.soapParent != null) {
            this.detachNode();
        }
        this.soapParent = (SOAPElementImpl)parent;
    }

    public String getValue() {
        if (this instanceof Text) {
            throw new IllegalStateException("javax.xml.soap.Text should take care of this");
        }
        org.w3c.dom.Node child = this.getFirstChild();
        if (child instanceof org.w3c.dom.Text) {
            return ((org.w3c.dom.Text)child).getNodeValue();
        }
        return null;
    }

    public void setValue(String value) {
        if (this instanceof Text) {
            throw new IllegalStateException("javax.xml.soap.Text should take care of this");
        }
        org.w3c.dom.Node child = this.getFirstChild();
        if (child instanceof org.w3c.dom.Text) {
            ((org.w3c.dom.Text)child).setNodeValue(value);
        }
        if (child == null && value != null) {
            child = this.domNode.getOwnerDocument().createTextNode(value);
            this.appendChild((org.w3c.dom.Node)((Object)new TextImpl(child)));
        }
    }

    public void recycleNode() {
    }

    public String getNodeName() {
        return this.domNode.getNodeName();
    }

    public String getNodeValue() throws DOMException {
        return this.domNode.getNodeValue();
    }

    public void setNodeValue(String nodeValue) throws DOMException {
        this.domNode.setNodeValue(nodeValue);
    }

    public short getNodeType() {
        return this.domNode.getNodeType();
    }

    public org.w3c.dom.Node getParentNode() {
        this.assertSOAPParent();
        return this.domNode.getParentNode();
    }

    public NodeList getChildNodes() {
        return this.domNode.getChildNodes();
    }

    public org.w3c.dom.Node getFirstChild() {
        return this.domNode.getFirstChild();
    }

    public org.w3c.dom.Node getLastChild() {
        return this.domNode.getLastChild();
    }

    public org.w3c.dom.Node getPreviousSibling() {
        return this.domNode.getPreviousSibling();
    }

    public org.w3c.dom.Node getNextSibling() {
        return this.domNode.getNextSibling();
    }

    public NamedNodeMap getAttributes() {
        return this.domNode.getAttributes();
    }

    public Document getOwnerDocument() {
        return this.domNode.getOwnerDocument();
    }

    public org.w3c.dom.Node insertBefore(org.w3c.dom.Node newChild, org.w3c.dom.Node refChild) throws DOMException {
        this.assertSOAPNode(newChild);
        this.assertSOAPNode(refChild);
        int index = this.soapChildren.indexOf(refChild);
        if (index < 0) {
            throw new IllegalArgumentException("Cannot find refChild in list of javax.xml.soap.Node children");
        }
        NodeImpl soapNewNode = (NodeImpl)((Object)newChild);
        NodeImpl soapRefNode = (NodeImpl)((Object)refChild);
        this.domNode.insertBefore(soapNewNode.domNode, soapRefNode.domNode);
        this.soapChildren.add(index, soapNewNode);
        return newChild;
    }

    public org.w3c.dom.Node replaceChild(org.w3c.dom.Node newChild, org.w3c.dom.Node oldChild) throws DOMException {
        this.assertSOAPNode(newChild);
        this.assertSOAPNode(oldChild);
        int index = this.soapChildren.indexOf(oldChild);
        if (index < 0) {
            throw new DOMException(8, "Cannot find oldChild in list of javax.xml.soap.Node children");
        }
        NodeImpl soapNewNode = (NodeImpl)((Object)newChild);
        NodeImpl soapOldNode = (NodeImpl)((Object)oldChild);
        this.domNode.replaceChild(soapNewNode.domNode, soapOldNode.domNode);
        this.soapChildren.remove(index);
        this.soapChildren.add(index, soapNewNode);
        return newChild;
    }

    public org.w3c.dom.Node removeChild(org.w3c.dom.Node oldChild) throws DOMException {
        this.assertSOAPNode(oldChild);
        int index = this.soapChildren.indexOf(oldChild);
        if (index < 0) {
            throw new DOMException(8, "Cannot find oldChild in list of javax.xml.soap.Node children");
        }
        NodeImpl soapOldNode = (NodeImpl)((Object)oldChild);
        this.domNode.removeChild(soapOldNode.domNode);
        this.soapChildren.remove(index);
        return oldChild;
    }

    public org.w3c.dom.Node appendChild(org.w3c.dom.Node newChild) throws DOMException {
        this.assertSOAPNode(newChild);
        if (!(this instanceof SOAPElementImpl)) {
            throw new DOMException(15, "Cannot append child to this node: " + this);
        }
        NodeImpl soapNode = (NodeImpl)((Object)newChild);
        this.domNode.appendChild(soapNode.domNode);
        soapNode.soapParent = (SOAPElementImpl)this;
        this.soapChildren.add(soapNode);
        return newChild;
    }

    public boolean hasChildNodes() {
        return this.domNode.hasChildNodes();
    }

    public org.w3c.dom.Node cloneNode(boolean deep) {
        NodeImpl soapNode = new NodeImpl(this.domNode.cloneNode(deep));
        if (deep) {
            for (int i = 0; i < this.soapChildren.size(); ++i) {
                NodeImpl node = (NodeImpl)this.soapChildren.get(i);
                soapNode.soapChildren.add(node.cloneNode(deep));
            }
        }
        return soapNode;
    }

    public void normalize() {
        this.domNode.normalize();
    }

    public boolean isSupported(String feature, String version) {
        return this.domNode.isSupported(feature, version);
    }

    public String getNamespaceURI() {
        return this.domNode.getNamespaceURI();
    }

    public String getPrefix() {
        return this.domNode.getPrefix();
    }

    public void setPrefix(String prefix) throws DOMException {
        this.domNode.setPrefix(prefix);
    }

    public String getLocalName() {
        return this.domNode.getLocalName();
    }

    public boolean hasAttributes() {
        return this.domNode.hasAttributes();
    }

    public int hashCode() {
        return this.domNode.hashCode();
    }

    public String toString() {
        return super.toString() + "[" + this.domNode.toString() + "]";
    }

    private void assertSOAPNode(org.w3c.dom.Node node) {
        if (!(node instanceof NodeImpl)) {
            throw new DOMException(9, "Operation only supported for javax.xml.soap.Node, this is a " + node);
        }
    }

    private void assertSOAPParent() {
        org.w3c.dom.Node domParent = this.domNode.getParentNode();
        if (domParent != null && this.soapParent == null) {
            throw new IllegalStateException("Inconsistent node, has a DOM parent but no SOAP parent: " + this);
        }
        if (domParent == null && this.soapParent != null) {
            throw new IllegalStateException("Inconsistent node, has a SOAP parent but no DOM parent: " + this);
        }
    }
}

