/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import org.apache.axis.AxisFault;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.message.NameImpl;
import org.apache.axis.message.SOAPBodyElementAxisImpl;
import org.apache.axis.message.SOAPBodyImpl;
import org.apache.axis.message.SOAPElementAxisImpl;
import org.apache.axis.message.SOAPEnvelopeAxisImpl;
import org.apache.axis.message.SOAPFaultImpl;
import org.apache.axis.message.TextImpl;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.Messages;
import org.jboss.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;

public class SOAPBodyAxisImpl
extends SOAPBodyImpl {
    private static Logger log = Logger.getLogger((String)SOAPBodyAxisImpl.class.getName());
    private SOAPConstants soapConstants;
    private boolean disableFormatting;
    private boolean doSAAJEncodingCompliance;
    private static ArrayList knownEncodingStyles = new ArrayList();

    SOAPBodyAxisImpl(SOAPEnvelopeAxisImpl env, SOAPConstants soapConsts) {
        super(soapConsts.getEnvelopeURI(), "Body");
        this.soapConstants = soapConsts;
        try {
            this.setParentElement(env);
        }
        catch (SOAPException ex) {
            log.fatal((Object)Messages.getMessage("exception00"), (Throwable)ex);
        }
    }

    public SOAPBodyAxisImpl(String namespace, String localPart, String prefix, Attributes attributes, DeserializationContext context, SOAPConstants soapConsts) throws AxisFault {
        super(namespace, localPart, prefix, attributes, context);
        this.soapConstants = soapConsts;
    }

    public void setParentElement(SOAPElement parent) throws SOAPException {
        if (parent == null) {
            throw new IllegalArgumentException(Messages.getMessage("nullParent00"));
        }
        try {
            SOAPEnvelopeAxisImpl env = (SOAPEnvelopeAxisImpl)parent;
            super.setParentElement(env);
            this.setEnvelope(env);
        }
        catch (Throwable t) {
            throw new SOAPException(t);
        }
    }

    public void disableFormatting() {
        this.disableFormatting = true;
    }

    public void setEncodingStyle(String encodingStyle) throws SOAPException {
        if (encodingStyle == null) {
            encodingStyle = "";
        }
        if (this.doSAAJEncodingCompliance && !knownEncodingStyles.contains(encodingStyle)) {
            throw new IllegalArgumentException(Messages.getMessage("badEncodingStyle1", encodingStyle));
        }
        super.setEncodingStyle(encodingStyle);
    }

    protected void outputImpl(SerializationContext context) throws Exception {
        boolean oldPretty = context.getPretty();
        context.setPretty(!this.disableFormatting);
        if (this.getChildren().isEmpty()) {
            // empty if block
        }
        context.startElement(new QName(this.soapConstants.getEnvelopeURI(), "Body"), this.getAttributesEx());
        Iterator it = this.getChildElements();
        while (it.hasNext()) {
            Node childNode = (Node)it.next();
            if (childNode instanceof SOAPElementAxisImpl) {
                ((SOAPElementAxisImpl)((Object)childNode)).output(context);
                continue;
            }
            if (!(childNode instanceof TextImpl)) continue;
            context.writeString(childNode.getNodeValue());
        }
        context.outputMultiRefs();
        context.endElement();
        context.setPretty(oldPretty);
    }

    List getBodyElements() throws AxisFault {
        return this.getChildren();
    }

    void addBodyElement(SOAPBodyElementAxisImpl element) {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("addBody00"));
        }
        try {
            element.setParentElement(this);
        }
        catch (SOAPException ex) {
            log.fatal((Object)Messages.getMessage("exception00"), (Throwable)ex);
        }
    }

    void clearBody() {
        this.removeContents();
    }

    void removeBodyElement(SOAPBodyElementAxisImpl element) {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("removeBody00"));
        }
        this.removeChild((Node)((Object)element));
    }

    SOAPBodyElementAxisImpl getBodyByName(String namespace, String localPart) throws AxisFault {
        return (SOAPBodyElementAxisImpl)this.findElement(this.getChildren(), namespace, localPart);
    }

    protected SOAPElementAxisImpl findElement(List list, String namespace, String localPart) {
        if (list.isEmpty()) {
            return null;
        }
        QName qname = new QName(namespace, localPart);
        Iterator it = list.iterator();
        while (it.hasNext()) {
            SOAPElementAxisImpl element = (SOAPElementAxisImpl)it.next();
            if (!element.getQName().equals(qname)) continue;
            return element;
        }
        return null;
    }

    SOAPBodyElementAxisImpl getFirstBody() throws AxisFault {
        if (this.getChildren().isEmpty()) {
            return null;
        }
        return (SOAPBodyElementAxisImpl)this.getChildren().get(0);
    }

    public SOAPBodyElement addBodyElement(Name name) throws SOAPException {
        SOAPBodyElementAxisImpl bodyElement = new SOAPBodyElementAxisImpl(name);
        this.addBodyElement(bodyElement);
        return bodyElement;
    }

    public SOAPFault addFault(Name name, String s, Locale locale) throws SOAPException {
        AxisFault af = new AxisFault(new QName(name.getURI(), name.getLocalName()), s, "", new Element[0]);
        SOAPFaultImpl fault = new SOAPFaultImpl(af);
        this.addBodyElement(fault);
        return fault;
    }

    public SOAPFault addFault(Name name, String s) throws SOAPException {
        AxisFault af = new AxisFault(new QName(name.getURI(), name.getLocalName()), s, "", new Element[0]);
        SOAPFaultImpl fault = new SOAPFaultImpl(af);
        this.addBodyElement(fault);
        return fault;
    }

    public SOAPBodyElement addDocument(Document document) throws SOAPException {
        return (SOAPBodyElement)this.importDOMElement(this, document.getDocumentElement());
    }

    public SOAPFault addFault() throws SOAPException {
        AxisFault af = new AxisFault(new QName("http://xml.apache.org/axis/", "Server.generalException"), "", "", new Element[0]);
        SOAPFaultImpl fault = new SOAPFaultImpl(af);
        this.addBodyElement(fault);
        return fault;
    }

    public SOAPFault getFault() {
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            Object element = it.next();
            if (!(element instanceof SOAPFault)) continue;
            return (SOAPFault)element;
        }
        return null;
    }

    public boolean hasFault() {
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            if (!(it.next() instanceof SOAPFault)) continue;
            return true;
        }
        return false;
    }

    public void setSAAJEncodingCompliance(boolean comply) {
        this.doSAAJEncodingCompliance = true;
    }

    public SOAPElement addChildElement(Name name) throws SOAPException {
        SOAPBodyElementAxisImpl soapBodyElement = new SOAPBodyElementAxisImpl(name);
        super.addChildElement(soapBodyElement);
        return soapBodyElement;
    }

    private SOAPElementAxisImpl importDOMElement(SOAPElementAxisImpl soapParent, Element domElement) {
        try {
            NameImpl name = new NameImpl(domElement.getLocalName(), domElement.getPrefix(), domElement.getNamespaceURI());
            SOAPElementAxisImpl soapChild = (SOAPElementAxisImpl)soapParent.addChildElement(name);
            NamedNodeMap attrs = domElement.getAttributes();
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node att = attrs.item(i);
                soapChild.setAttribute(att.getNamespaceURI(), att.getLocalName(), att.getPrefix());
            }
            StringBuffer content = new StringBuffer();
            NodeList children = domElement.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node domChild = children.item(i);
                if (domChild.getNodeType() == 1) {
                    this.importDOMElement(soapChild, (Element)domChild);
                }
                if (domChild.getNodeType() != 3 || domChild.getNodeValue().trim().length() <= 0) continue;
                content.append(domChild.getNodeValue());
            }
            if (content.length() > 0) {
                String value = content.toString();
                soapChild.addTextNode(value);
            }
            return soapChild;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JAXRPCException((Throwable)e);
        }
    }

    static {
        knownEncodingStyles.add("http://schemas.xmlsoap.org/soap/encoding/");
        knownEncodingStyles.add("http://www.w3.org/2002/12/soap-encoding");
        knownEncodingStyles.add("");
        knownEncodingStyles.add("http://www.w3.org/2002/12/soap-envelope/encoding/none");
    }
}

