/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.security.servlet;

import java.security.Principal;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.axis.MessageContext;
import org.apache.axis.security.AuthenticatedUser;
import org.apache.axis.security.SecurityProvider;
import org.apache.axis.security.servlet.ServletAuthenticatedUser;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.axis.utils.Messages;
import org.jboss.logging.Logger;

public class ServletSecurityProvider
implements SecurityProvider {
    private static Logger log = Logger.getLogger((String)ServletSecurityProvider.class.getName());
    static HashMap users = null;

    public AuthenticatedUser authenticate(MessageContext msgContext) {
        HttpServletRequest req = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        if (req == null) {
            return null;
        }
        log.debug((Object)Messages.getMessage("got00", "HttpServletRequest"));
        Principal principal = req.getUserPrincipal();
        if (principal == null) {
            log.debug((Object)Messages.getMessage("noPrincipal00"));
            return null;
        }
        log.debug((Object)Messages.getMessage("gotPrincipal00", principal.getName()));
        return new ServletAuthenticatedUser(req);
    }

    public boolean userMatches(AuthenticatedUser user, String principal) {
        if (user == null) {
            return principal == null;
        }
        if (user instanceof ServletAuthenticatedUser) {
            ServletAuthenticatedUser servletUser = (ServletAuthenticatedUser)user;
            return servletUser.getRequest().isUserInRole(principal);
        }
        return false;
    }
}

