/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.jms;

import java.util.HashMap;
import java.util.Iterator;
import javax.jms.Destination;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.client.Call;
import org.apache.axis.client.Transport;
import org.apache.axis.transport.jms.JMSConnector;
import org.apache.axis.transport.jms.JMSConnectorFactory;
import org.apache.axis.utils.Messages;
import org.jboss.logging.Logger;

public class JMSTransport
extends Transport {
    protected static Logger log = Logger.getLogger((Class)JMSTransport.class);
    private HashMap connectors;
    private HashMap connectorProps;
    private HashMap connectionFactoryProps;
    private JMSConnector defaultConnector;
    private HashMap passwords;
    private Object connectorLock;

    public JMSTransport(HashMap connectorProps, HashMap connectionFactoryProps) {
        this.transportName = "JMSTransport";
        this.connectors = new HashMap();
        this.passwords = new HashMap();
        this.connectorProps = connectorProps;
        this.connectionFactoryProps = connectionFactoryProps;
        this.connectorLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setupMessageContextImpl(MessageContext context, Call message, AxisEngine engine) throws AxisFault {
        JMSConnector connector;
        block18: {
            String username = message.getUsername();
            connector = null;
            try {
                if (username == null) {
                    this.initConnectorIfNecessary();
                    connector = this.defaultConnector;
                    break block18;
                }
                String password = message.getPassword();
                Object object = this.connectorLock;
                synchronized (object) {
                    if (this.connectors.containsKey(username)) {
                        String oldPassword = (String)this.passwords.get(username);
                        if (!password.equals(oldPassword)) throw new AxisFault("badUserPass");
                        connector = (JMSConnector)this.connectors.get(username);
                    } else {
                        connector = this.createConnector(username, password);
                        this.connectors.put(username, connector);
                        this.passwords.put(username, password);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)Messages.getMessage("cannotConnectError"), (Throwable)e);
                if (!(e instanceof AxisFault)) throw new AxisFault("cannotConnect", e);
                throw (AxisFault)e;
            }
        }
        context.setProperty("transport.jms.Connector", connector);
        Object tmp = message.getProperty("transport.jms.Destination");
        if (tmp != null && (tmp instanceof String || tmp instanceof Destination)) {
            context.setProperty("transport.jms.Destination", tmp);
        } else {
            context.removeProperty("transport.jms.Destination");
        }
        tmp = message.getProperty("transport.jms.WaitForResponse");
        if (tmp != null && tmp instanceof Boolean) {
            context.setProperty("transport.jms.WaitForResponse", tmp);
        } else {
            context.removeProperty("transport.jms.WaitForResponse");
        }
        tmp = message.getProperty("transport.jms.DeliveryMode");
        if (tmp != null && tmp instanceof Integer) {
            context.setProperty("transport.jms.DeliveryMode", tmp);
        } else {
            context.removeProperty("transport.jms.DeliveryMode");
        }
        tmp = message.getProperty("transport.jms.Priority");
        if (tmp != null && tmp instanceof Integer) {
            context.setProperty("transport.jms.Priority", tmp);
        } else {
            context.removeProperty("transport.jms.Priority");
        }
        tmp = message.getProperty("transport.jms.TimeToLive");
        if (tmp != null && tmp instanceof Long) {
            context.setProperty("transport.jms.TimeToLive", tmp);
            return;
        } else {
            context.removeProperty("transport.jms.TimeToLive");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConnectorIfNecessary() throws Exception {
        if (this.defaultConnector != null) {
            return;
        }
        Object object = this.connectorLock;
        synchronized (object) {
            if (this.defaultConnector != null) {
                return;
            }
            this.defaultConnector = this.createConnector(null, null);
        }
    }

    private JMSConnector createConnector(String username, String password) throws Exception {
        JMSConnector connector = JMSConnectorFactory.createClientConnector(this.connectorProps, this.connectionFactoryProps, username, password);
        connector.start();
        return connector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.connectorLock;
        synchronized (object) {
            if (this.defaultConnector != null) {
                this.defaultConnector.shutdown();
            }
            Iterator connectorIter = this.connectors.values().iterator();
            while (connectorIter.hasNext()) {
                ((JMSConnector)connectorIter.next()).shutdown();
            }
        }
    }
}

