/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils.bytecode;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.bytecode.ParamReader;
import org.jboss.logging.Logger;

public class ParamNameExtractor {
    private static Logger log = Logger.getLogger((String)ParamNameExtractor.class.getName());

    public static String[] getParameterNamesFromDebugInfo(Method method) {
        int numParams = method.getParameterTypes().length;
        if (numParams == 0) {
            return null;
        }
        Class<?> c = method.getDeclaringClass();
        if (Proxy.isProxyClass(c)) {
            return null;
        }
        try {
            ParamReader pr = new ParamReader(c);
            String[] names = pr.getParameterNames(method);
            return names;
        }
        catch (IOException e) {
            log.info((Object)(Messages.getMessage("error00") + ":" + e));
            return null;
        }
    }
}

