/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.dbutilities;

import at.tugraz.genome.dbutilities.DatabaseTableField;
import at.tugraz.genome.dbutilities.GenericDAOInterface;
import at.tugraz.genome.dbutilities.SearchableField;
import at.tugraz.genome.dbutilities.dao.MysqlDAOFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class MysqlGenericDAOImpl
implements GenericDAOInterface {
    Logger log_ = Logger.getLogger(this.getClass());

    public MysqlGenericDAOImpl() {
        this.log_.info((Object)"MysqlGenericDAOImpl");
    }

    public String generateWhereClause(Collection searchCriteria) {
        System.out.println("Oracle Generic DA Impl - searchCriteria.size: " + searchCriteria.size());
        String whereClause = "";
        if (searchCriteria == null || searchCriteria.size() == 0) {
            whereClause = "(1=1)";
        } else {
            Iterator iterator = searchCriteria.iterator();
            while (iterator.hasNext()) {
                SearchableField field;
                if (whereClause.trim().length() > 0) {
                    whereClause = whereClause + " AND ";
                }
                if ((field = (SearchableField)iterator.next()).getORCombinedFields().size() > 0) {
                    whereClause = whereClause + "(";
                }
                whereClause = whereClause + this.parseField(field);
                if (field.getORCombinedFields().size() > 0) {
                    whereClause = whereClause + " OR " + this.generateWhereClause(field.getORCombinedFields()) + ")";
                }
                if (field.getANDCombinedFields().size() <= 0) continue;
                whereClause = whereClause + " AND " + this.generateWhereClause(field.getANDCombinedFields());
            }
        }
        System.out.println("WHERECLAUSE: " + whereClause);
        return whereClause;
    }

    public String[] getTableNames(DatabaseTableField field) {
        int i;
        this.log_.info((Object)("+++ getTableNames(): " + field));
        Hashtable<Integer, String> hashtable = new Hashtable<Integer, String>();
        if (field.getFakeTableAlias() != null) {
            if (field.getFakeTableName() != null) {
                hashtable.put(new Integer((field.getFakeTableName() + " " + field.getFakeTableAlias()).hashCode()), field.getFakeTableName() + " " + field.getFakeTableAlias());
            }
        } else if (field.getFakeTableName() != null) {
            hashtable.put(new Integer(field.getFakeTableName().hashCode()), field.getFakeTableName());
        }
        if (field.getFakeTableAliases() != null) {
            if (field.getFakeTableNames() != null) {
                i = 0;
                while (i < field.getFakeTableAliases().length) {
                    hashtable.put(new Integer((field.getFakeTableNames()[i] + " " + field.getFakeTableAliases()[i]).hashCode()), field.getFakeTableNames()[i] + " " + field.getFakeTableAliases()[i]);
                    ++i;
                }
            }
        } else if (field.getFakeTableNames() != null) {
            i = 0;
            while (i < field.getFakeTableNames().length) {
                hashtable.put(new Integer(field.getFakeTableNames()[i].hashCode()), field.getFakeTableNames()[i]);
                ++i;
            }
        }
        this.log_.info((Object)"+++ fetching additional tables");
        String[] additionalTables = field.getAdditionalTables();
        int i2 = 0;
        while (i2 < additionalTables.length) {
            hashtable.put(new Integer(additionalTables[i2].hashCode()), additionalTables[i2]);
            ++i2;
        }
        this.log_.info((Object)("--- fetching additional tables: " + additionalTables.length));
        String[] retValues = new String[hashtable.size()];
        Iterator iterator = hashtable.values().iterator();
        int numElements = hashtable.values().size();
        int i3 = 0;
        while (iterator.hasNext()) {
            retValues[i3] = (String)iterator.next();
            ++i3;
        }
        this.log_.info((Object)("--- getTableNames(): " + retValues));
        return retValues;
    }

    public String[] getTableNames(Collection searchCriteria) {
        this.log_.info((Object)"+++ getTableNames()");
        Hashtable<Integer, String> hashtable = new Hashtable<Integer, String>();
        Iterator<Object> iterator = searchCriteria.iterator();
        while (iterator.hasNext()) {
            SearchableField field = (SearchableField)iterator.next();
            if (field.isFake()) {
                if (field.getFakeTableAlias() != null) {
                    if (field.getFakeTableName() != null) {
                        hashtable.put(new Integer((field.getFakeTableName() + " " + field.getFakeTableAlias()).hashCode()), field.getFakeTableName() + " " + field.getFakeTableAlias());
                    }
                } else if (field.getFakeTableName() != null) {
                    hashtable.put(new Integer(field.getFakeTableName().hashCode()), field.getFakeTableName());
                }
                if (field.getFakeTableAliases() != null) {
                    if (field.getFakeTableNames() != null) {
                        int i = 0;
                        while (i < field.getFakeTableAliases().length) {
                            hashtable.put(new Integer((field.getFakeTableNames()[i] + " " + field.getFakeTableAliases()[i]).hashCode()), field.getFakeTableNames()[i] + " " + field.getFakeTableAliases()[i]);
                            ++i;
                        }
                    }
                } else if (field.getFakeTableNames() != null) {
                    int i = 0;
                    while (i < field.getFakeTableNames().length) {
                        hashtable.put(new Integer(field.getFakeTableNames()[i].hashCode()), field.getFakeTableNames()[i]);
                        ++i;
                    }
                }
            }
            this.log_.info((Object)"+++ fetching additional tables");
            String[] additionalTables = field.getAdditionalTables();
            int i = 0;
            while (i < additionalTables.length) {
                hashtable.put(new Integer(additionalTables[i].hashCode()), additionalTables[i]);
                ++i;
            }
            this.log_.info((Object)("--- fetching additional tables: " + additionalTables.length));
        }
        String[] retValues = new String[hashtable.size()];
        iterator = hashtable.values().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            retValues[i] = (String)iterator.next();
            this.log_.info((Object)("* " + retValues[i]));
            ++i;
        }
        this.log_.info((Object)("--- getTableNames(): " + retValues));
        return retValues;
    }

    private String parseField(SearchableField field) {
        String searchValue;
        System.out.println("parseField: " + field);
        String whereClause = "";
        if (field.getOperator().equalsIgnoreCase("like") && field.getSearchValue() != null) {
            searchValue = field.getSearchValue();
            searchValue = searchValue.replace('*', '%');
            searchValue = searchValue.replace('?', '_');
            searchValue = searchValue.toUpperCase();
            field.setSearchValue(searchValue);
        }
        if (field.isFake()) {
            if (field.getFakeTableConnectorFieldName() != null && field.getDBFieldName() != null) {
                if (field.getFakeTableAlias() != null && field.getFakeTableName() != null) {
                    whereClause = field.getDBTableAlias() != null ? whereClause + "(" + field.getDBTableAlias() : whereClause + "(" + field.getDBTableName();
                    whereClause = whereClause + "." + field.getDBFieldName() + " = ";
                    whereClause = field.getFakeTableAlias() != null ? whereClause + field.getFakeTableAlias() + "." + field.getFakeTableConnectorFieldName() + ") AND " : whereClause + field.getFakeTableName() + "." + field.getFakeTableConnectorFieldName() + ") AND ";
                } else if (field.getFakeTableAliases() != null) {
                    int i = 0;
                    while (i < field.getFakeTableAliases().length) {
                        whereClause = field.getDBTableAlias() != null ? whereClause + "(" + field.getDBTableAlias() : whereClause + "(" + field.getDBTableName();
                        whereClause = whereClause + "." + field.getDBFieldName() + " = ";
                        whereClause = field.getFakeTableAliases()[i] != null ? whereClause + field.getFakeTableAliases()[i] + "." + field.getFakeTableConnectorFieldName() + ") AND " : whereClause + field.getFakeTableNames()[i] + "." + field.getFakeTableConnectorFieldName() + ") AND ";
                        ++i;
                    }
                } else if (field.getFakeTableName() != null) {
                    whereClause = field.getDBTableAlias() != null ? whereClause + "(" + field.getDBTableAlias() : whereClause + "(" + field.getDBTableName();
                    whereClause = whereClause + "." + field.getDBFieldName() + " = ";
                    whereClause = field.getFakeTableAlias() != null ? whereClause + field.getFakeTableAlias() + "." + field.getFakeTableConnectorFieldName() + ") AND " : whereClause + field.getFakeTableName() + "." + field.getFakeTableConnectorFieldName() + ") AND ";
                }
            }
            if (field.getOperator().equalsIgnoreCase("between") || field.getOperator().equalsIgnoreCase("not between")) {
                String searchValue2 = field.getSearchValue();
                searchValue2 = searchValue2.trim();
                Pattern pattern = Pattern.compile("([-+a-zA-Z_0-9\\s\\.]+),([-+a-zA-Z_0-9\\s\\.]+)");
                Matcher matcher = pattern.matcher(searchValue2);
                if (matcher.matches()) {
                    System.out.println("MATCH BETWEEN");
                    String value1 = matcher.group(1).trim();
                    String value2 = matcher.group(2).trim();
                    whereClause = field.getSQLSubStatement() != null ? whereClause + "(" + field.getSQLSubStatement() + " " + field.getOperator() + " " + "'" + value1 + "'" + " AND " + "'" + value2 + "'" + ")" : (field.getFakeTableAlias() != null ? whereClause + "(" + field.getFakeTableAlias() + "." + field.getFakeDBTableField() + " " + field.getOperator() + " " + "'" + value1 + "'" + " AND " + "'" + value2 + "'" + ")" : whereClause + "(" + field.getFakeTableName() + "." + field.getFakeDBTableField() + " " + field.getOperator() + " " + "'" + value1 + "'" + " AND " + "'" + value2 + "'" + ")");
                }
            } else if (field.getOperator().equalsIgnoreCase("in") || field.getOperator().equalsIgnoreCase("not in")) {
                Pattern pattern;
                Matcher matcher;
                String searchValue3 = field.getSearchValue();
                if (!(searchValue3 = searchValue3.trim()).endsWith(",")) {
                    searchValue3 = searchValue3 + ",";
                }
                if ((matcher = (pattern = Pattern.compile("([-+a-zA-Z_0-9\\s\\.]{1,},){1,}")).matcher(searchValue3)).matches()) {
                    System.out.println("MATCH IN");
                    whereClause = field.getSQLSubStatement() != null ? (field.getSearchValue() != null ? whereClause + "(" + field.getSQLSubStatement() + " " + field.getOperator() + " ('" + field.getSearchValue().trim().replaceAll(",", "','") + "'))" : whereClause + "(" + field.getSQLSubStatement() + ")") : (field.getFakeTableAlias() != null ? (field.getSearchValue() != null ? whereClause + "(" + field.getFakeTableAlias() + "." + field.getFakeDBTableField() + " " + field.getOperator() + " ('" + field.getSearchValue().trim().replaceAll(",", "','") + "'))" : whereClause + "(" + field.getFakeTableAlias() + "." + field.getFakeDBTableField() + ")") : (field.getSearchValue() != null ? whereClause + "(" + field.getFakeTableName() + "." + field.getFakeDBTableField() + " " + field.getOperator() + " ('" + field.getSearchValue().trim().replaceAll(",", "','") + "'))" : whereClause + "(" + field.getFakeTableName() + "." + field.getFakeDBTableField() + ")"));
                }
            } else {
                whereClause = field.getOperator().equalsIgnoreCase("like") ? (field.getSQLSubStatement() != null ? (field.getSearchValue() != null ? whereClause + "(UPPER(" + field.getSQLSubStatement() + ") " + field.getOperator() + " " + "'" + field.getSearchValue() + "'" + ")" : whereClause + "(UPPER(" + field.getSQLSubStatement() + ") " + ")") : (field.getFakeTableAlias() != null ? (field.getSearchValue() != null ? whereClause + "(UPPER(" + field.getFakeTableAlias() + "." + field.getFakeDBTableField() + ") " + field.getOperator() + " " + "'" + field.getSearchValue() + "'" + ")" : whereClause + "(UPPER(" + field.getFakeTableAlias() + "." + field.getFakeDBTableField() + "))") : (field.getSearchValue() != null ? whereClause + "(UPPER(" + field.getFakeTableName() + "." + field.getFakeDBTableField() + ") " + field.getOperator() + " " + "'" + field.getSearchValue() + "'" + ")" : whereClause + "(UPPER(" + field.getFakeTableName() + "." + field.getFakeDBTableField() + "))"))) : (field.getSQLSubStatement() != null ? (field.getSearchValue() != null ? whereClause + "(" + field.getSQLSubStatement() + field.getOperator() + " " + "'" + field.getSearchValue() + "'" + ")" : whereClause + "(" + field.getSQLSubStatement() + ")") : (field.getFakeTableAlias() != null ? (field.getSearchValue() != null ? whereClause + "(" + field.getFakeTableAlias() + "." + field.getFakeDBTableField() + " " + field.getOperator() + " " + "'" + field.getSearchValue() + "'" + ")" : whereClause + "(" + field.getFakeTableAlias() + "." + field.getFakeDBTableField() + ")") : (field.getSearchValue() != null ? whereClause + "(" + field.getFakeTableName() + "." + field.getFakeDBTableField() + " " + field.getOperator() + " " + "'" + field.getSearchValue() + "'" + ")" : whereClause + "(" + field.getFakeTableName() + "." + field.getFakeDBTableField() + ")")));
            }
        } else if (field.getOperator().equalsIgnoreCase("between") || field.getOperator().equalsIgnoreCase("not between")) {
            if (field.getSearchValue() != null) {
                searchValue = field.getSearchValue();
                searchValue = searchValue.trim();
                Pattern pattern = Pattern.compile("([-+a-zA-Z_0-9\\s\\.]+),([-+a-zA-Z_0-9\\s\\.]+)");
                Matcher matcher = pattern.matcher(searchValue);
                if (matcher.matches()) {
                    System.out.println("MATCH BETWEEN");
                    String value1 = matcher.group(1).trim();
                    String value2 = matcher.group(2).trim();
                    whereClause = field.getDBTableAlias() != null ? whereClause + "(" + field.getDBTableAlias() + "." + field.getDBFieldName() + " " + field.getOperator() + " " + "'" + value1 + "'" + " AND " + "'" + value2 + "'" + ")" : whereClause + "(" + field.getDBTableName() + "." + field.getDBFieldName() + " " + field.getOperator() + " " + "'" + value1 + "'" + " AND " + "'" + value2 + "'" + ")";
                }
            }
        } else if (field.getOperator().equalsIgnoreCase("in") || field.getOperator().equalsIgnoreCase("not in")) {
            if (field.getSearchValue() != null) {
                Pattern pattern;
                Matcher matcher;
                searchValue = field.getSearchValue();
                if (!(searchValue = searchValue.trim()).endsWith(",")) {
                    searchValue = searchValue + ",";
                }
                if ((matcher = (pattern = Pattern.compile("([-+a-zA-Z_0-9\\s\\.]{1,},){1,}")).matcher(searchValue)).matches()) {
                    System.out.println("MATCH IN");
                    whereClause = field.getDBTableAlias() != null ? whereClause + "(" + field.getDBTableAlias() + "." + field.getDBFieldName() + " " + field.getOperator() + " (" + "'" + field.getSearchValue().trim().replaceAll(",", "','") + "'" + "))" : whereClause + "(" + field.getDBTableName() + "." + field.getDBFieldName() + " " + field.getOperator() + " (" + "'" + field.getSearchValue().trim().replaceAll(",", "','") + "'" + "))";
                }
            }
        } else {
            whereClause = field.getOperator().equalsIgnoreCase("like") ? (field.getDBTableAlias() != null ? (field.getSearchValue() != null ? whereClause + "(UPPER(" + field.getDBTableAlias() + "." + field.getDBFieldName() + ") " + field.getOperator() + " " + "'" + field.getSearchValue() + "'" + ")" : whereClause + "(UPPER(" + field.getDBTableAlias() + "." + field.getDBFieldName() + ") ") : (field.getSearchValue() != null ? whereClause + "(UPPER(" + field.getDBTableName() + "." + field.getDBFieldName() + ") " + field.getOperator() + " " + "'" + field.getSearchValue() + "'" + ")" : whereClause + "(UPPER(" + field.getDBTableName() + "." + field.getDBFieldName() + ") ")) : (field.getDBTableAlias() != null ? (field.getSearchValue() != null ? whereClause + "(" + field.getDBTableAlias() + "." + field.getDBFieldName() + " " + field.getOperator() + " " + "'" + field.getSearchValue() + "'" + ")" : whereClause + "(" + field.getDBTableAlias() + "." + field.getDBFieldName() + ")") : (field.getSearchValue() != null ? whereClause + "(" + field.getDBTableName() + "." + field.getDBFieldName() + " " + field.getOperator() + " " + "'" + field.getSearchValue() + "'" + ")" : whereClause + "(" + field.getDBTableName() + "." + field.getDBFieldName() + ")"));
        }
        return whereClause;
    }

    private List prepareResult(ResultSet rs) throws SQLException {
        Hashtable<Long, Long> ht = new Hashtable<Long, Long>();
        System.out.println("+++ prepareResult");
        ArrayList<Long> list = new ArrayList<Long>();
        while (rs.next()) {
            Long key = new Long(rs.getLong(1));
            if (ht.get(key) == null) {
                ht.put(key, key);
                list.add(new Long(rs.getLong(1)));
                continue;
            }
            this.log_.debug((Object)"key already in list");
        }
        System.out.println("--- prepareResult");
        return list;
    }

    public List selectAll(String tableName, String pkFieldName, DatabaseTableField orderBy, String direction) {
        this.log_.info((Object)"selectAll");
        List list = null;
        Connection con = MysqlDAOFactory.createConnection();
        String sqlSelect = "SELECT " + pkFieldName + " FROM " + tableName;
        if (orderBy != null) {
            if (orderBy != null) {
                this.log_.info((Object)("FIELDNAME 3: " + this.getTableNames(orderBy)));
            }
            if (orderBy.isFake()) {
                sqlSelect = sqlSelect + ", " + orderBy.getFakeTableName();
                sqlSelect = sqlSelect + " WHERE (" + orderBy.getDBTableName() + "." + orderBy.getDBFieldName() + "=" + orderBy.getFakeTableName() + "." + orderBy.getFakeTableConnectorFieldName() + ")";
                sqlSelect = sqlSelect + " ORDER BY " + orderBy.getFakeTableName() + "." + orderBy.getFakeOrderByField();
            }
            if (!orderBy.isFake()) {
                sqlSelect = sqlSelect + " ORDER BY " + orderBy.getDBTableName() + "." + orderBy.getDBFieldName();
            }
        }
        if (direction != null && (direction.toUpperCase().equals("ASC") || direction.toUpperCase().equals("DESC"))) {
            sqlSelect = sqlSelect + " " + direction;
        }
        try {
            System.out.println("SQL: " + sqlSelect);
            PreparedStatement pStmt = con.prepareStatement(sqlSelect);
            ResultSet rs = pStmt.executeQuery();
            list = this.prepareResult(rs);
            rs.close();
            pStmt.close();
            con.close();
            return list;
        }
        catch (SQLException sqlExc) {
            this.log_.error((Object)sqlExc);
            return null;
        }
    }

    public List selectCustom(String tableName, String pkFieldName, Collection searchCriteria, DatabaseTableField orderBy, String direction) {
        this.log_.info((Object)"++++ selectCustom");
        List list = null;
        Connection con = MysqlDAOFactory.createConnection();
        String sqlSelect = "SELECT " + tableName + "." + pkFieldName + " FROM ";
        String[] aTables = this.getTableNames(searchCriteria);
        String[] bTables = new String[]{};
        if (orderBy != null) {
            bTables = this.getTableNames(orderBy);
        }
        Hashtable<String, String> tableHash = new Hashtable<String, String>();
        int i = 0;
        while (i < aTables.length) {
            tableHash.put(aTables[i], aTables[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < bTables.length) {
            tableHash.put(bTables[i2], bTables[i2]);
            ++i2;
        }
        String[] tables = new String[tableHash.size()];
        Enumeration enumeration = tableHash.elements();
        int z = 0;
        while (enumeration.hasMoreElements()) {
            tables[z] = (String)enumeration.nextElement();
            ++z;
        }
        int i3 = 0;
        while (i3 < tables.length) {
            if (orderBy == null || !orderBy.isFake() || !orderBy.getFakeTableName().equals(tables[i3])) {
                sqlSelect = sqlSelect + tables[i3] + ",";
            }
            ++i3;
        }
        sqlSelect = sqlSelect + tableName;
        if (orderBy != null && orderBy.isFake()) {
            this.log_.info((Object)("XXXX   sqlSelect: " + sqlSelect));
            if (sqlSelect.indexOf(orderBy.getDBTableName() + ",") != -1) {
                this.log_.info((Object)"sqlSelect: found item");
                sqlSelect = sqlSelect.replaceAll(orderBy.getDBTableName() + ",", "");
                sqlSelect = sqlSelect + ", " + orderBy.getDBTableName();
            }
            this.log_.info((Object)("xxxx   sqlSelect: " + sqlSelect));
            sqlSelect = sqlSelect + " LEFT JOIN " + orderBy.getFakeTableName() + " ON (" + orderBy.getDBTableName() + "." + orderBy.getDBFieldName() + "=" + orderBy.getFakeTableName() + "." + orderBy.getFakeTableConnectorFieldName() + ")";
        }
        sqlSelect = sqlSelect + " WHERE " + this.generateWhereClause(searchCriteria);
        if (orderBy != null) {
            if (orderBy.getANDCombinedFields().size() > 0) {
                sqlSelect = sqlSelect + " AND " + this.generateWhereClause(orderBy.getANDCombinedFields());
            }
            if (orderBy.getORCombinedFields().size() > 0) {
                sqlSelect = sqlSelect + " OR " + this.generateWhereClause(orderBy.getANDCombinedFields());
            }
            sqlSelect = orderBy.isFake() ? sqlSelect + " ORDER BY " + orderBy.getFakeTableName() + "." + orderBy.getFakeOrderByField() : (orderBy.getDBTableAlias() == null || orderBy.getDBTableAlias().trim().equals("") ? sqlSelect + " ORDER BY " + orderBy.getDBTableName() + "." + orderBy.getDBFieldName() : sqlSelect + " ORDER BY " + orderBy.getDBTableAlias() + "." + orderBy.getDBFieldName());
        }
        if (direction != null && (direction.toUpperCase().equals("ASC") || direction.toUpperCase().equals("DESC"))) {
            sqlSelect = sqlSelect + " " + direction;
        }
        this.log_.info((Object)("SQL Statement: " + sqlSelect));
        try {
            PreparedStatement pStmt = con.prepareStatement(sqlSelect);
            ResultSet rs = pStmt.executeQuery();
            list = this.prepareResult(rs);
            rs.close();
            pStmt.close();
            con.close();
            return list;
        }
        catch (SQLException sqlExc) {
            this.log_.error((Object)sqlExc);
            return null;
        }
    }

    public List selectCustom(String tableName, String tableNameAlias, String pkFieldName, Collection searchCriteria, DatabaseTableField orderBy, String direction) {
        int i;
        this.log_.info((Object)"selectCustom");
        List list = null;
        Connection con = MysqlDAOFactory.createConnection();
        String sqlSelect = "SELECT " + tableNameAlias + "." + pkFieldName + " FROM ";
        String[] tables = this.getTableNames(searchCriteria);
        Hashtable<String, String> tableHash = new Hashtable<String, String>();
        if (orderBy != null) {
            this.log_.info((Object)("FIELDNAME 2: " + this.getTableNames(orderBy)));
        }
        if (orderBy != null && orderBy.isFake() && orderBy.getFakeTableName() != null) {
            String dummyTable = orderBy.getFakeTableName();
            if (orderBy.getFakeTableAlias() != null) {
                dummyTable = dummyTable + " " + orderBy.getFakeTableAlias();
            }
            i = 0;
            while (i < tables.length) {
                if (!tables[i].equalsIgnoreCase(dummyTable)) {
                    tableHash.put(tables[i], tables[i]);
                    sqlSelect = sqlSelect + tables[i] + ", ";
                }
                ++i;
            }
        } else {
            int i2 = 0;
            while (i2 < tables.length) {
                tableHash.put(tables[i2], tables[i2]);
                sqlSelect = sqlSelect + tables[i2] + ", ";
                ++i2;
            }
        }
        this.log_.info((Object)("sqlSelect A: " + sqlSelect));
        if (orderBy != null && orderBy.isFake() && orderBy.getSQLSubStatement() != null) {
            String[] additionalTables = this.getTableNames(orderBy);
            i = 0;
            while (i < additionalTables.length) {
                if (!tableHash.containsKey(additionalTables[i])) {
                    tableHash.put(additionalTables[i], additionalTables[i]);
                    sqlSelect = sqlSelect + additionalTables[i] + ", ";
                }
                ++i;
            }
        }
        this.log_.info((Object)("sqlSelect B: " + sqlSelect));
        sqlSelect = sqlSelect + tableName + " " + tableNameAlias;
        this.log_.info((Object)("sqlSelect C: " + sqlSelect));
        String whereStatmentInLeftJoin = "";
        if (orderBy != null && orderBy.isFake() && orderBy.getFakeTableName() != null) {
            String dummyTable = orderBy.getFakeTableName();
            if (orderBy.getFakeTableAlias() != null) {
                dummyTable = dummyTable + " " + orderBy.getFakeTableAlias();
            }
            whereStatmentInLeftJoin = " (";
            whereStatmentInLeftJoin = orderBy.getDBTableAlias() != null ? whereStatmentInLeftJoin + orderBy.getDBTableAlias() + "." + orderBy.getDBFieldName() + "=" + orderBy.getFakeTableAlias() + "." + orderBy.getFakeTableConnectorFieldName() + ")" : whereStatmentInLeftJoin + orderBy.getDBTableName() + "." + orderBy.getDBFieldName() + "=" + orderBy.getFakeTableAlias() + "." + orderBy.getFakeTableConnectorFieldName() + ")";
            sqlSelect = sqlSelect + " LEFT JOIN " + dummyTable + " ON " + whereStatmentInLeftJoin;
        }
        sqlSelect = sqlSelect + " WHERE " + this.generateWhereClause(searchCriteria);
        if (whereStatmentInLeftJoin.length() > 0) {
            sqlSelect = sqlSelect + " AND " + whereStatmentInLeftJoin;
        }
        this.log_.info((Object)("sqlSelect D: " + sqlSelect));
        if (orderBy != null) {
            if (orderBy.getANDCombinedFields().size() > 0) {
                sqlSelect = sqlSelect + " AND " + this.generateWhereClause(orderBy.getANDCombinedFields());
            }
            if (orderBy.getORCombinedFields().size() > 0) {
                sqlSelect = sqlSelect + " OR " + this.generateWhereClause(orderBy.getANDCombinedFields());
            }
            if (orderBy.getSQLSubStatement() == null) {
                sqlSelect = orderBy.isFake() ? (orderBy.getFakeTableAlias() != null ? sqlSelect + " ORDER BY " + orderBy.getFakeTableAlias() + "." + orderBy.getFakeOrderByField() : sqlSelect + " ORDER BY " + orderBy.getFakeTableName() + "." + orderBy.getFakeOrderByField()) : (orderBy.getDBTableAlias() != null ? sqlSelect + " ORDER BY " + orderBy.getDBTableAlias() + "." + orderBy.getDBFieldName() : sqlSelect + " ORDER BY " + orderBy.getDBTableName() + "." + orderBy.getDBFieldName());
            } else {
                if (orderBy.getFakeTableAlias() != null && orderBy.getFakeTableName() != null) {
                    sqlSelect = orderBy.getDBTableAlias() != null ? sqlSelect + " AND (" + orderBy.getDBTableAlias() : sqlSelect + " AND (" + orderBy.getDBTableName();
                    sqlSelect = sqlSelect + "." + orderBy.getDBFieldName() + " = ";
                    sqlSelect = orderBy.getFakeTableAlias() != null ? sqlSelect + orderBy.getFakeTableAlias() + "." + orderBy.getFakeTableConnectorFieldName() + ") " : sqlSelect + orderBy.getFakeTableName() + "." + orderBy.getFakeTableConnectorFieldName() + ") ";
                } else {
                    int i3 = 0;
                    while (i3 < orderBy.getFakeTableAliases().length) {
                        sqlSelect = orderBy.getDBTableAlias() != null ? sqlSelect + " AND (" + orderBy.getDBTableAlias() : sqlSelect + " AND (" + orderBy.getDBTableName();
                        sqlSelect = sqlSelect + "." + orderBy.getDBFieldName() + " = ";
                        sqlSelect = orderBy.getFakeTableAliases()[i3] != null ? sqlSelect + orderBy.getFakeTableAliases()[i3] + "." + orderBy.getFakeTableConnectorFieldName() + ") " : sqlSelect + orderBy.getFakeTableNames()[i3] + "." + orderBy.getFakeTableConnectorFieldName() + ") ";
                        ++i3;
                    }
                }
                sqlSelect = sqlSelect + " ORDER BY " + orderBy.getSQLSubStatement();
            }
        }
        if (direction != null && (direction.toUpperCase().equals("ASC") || direction.toUpperCase().equals("DESC"))) {
            sqlSelect = sqlSelect + " " + direction;
        }
        this.log_.info((Object)("SQL Statement: " + sqlSelect));
        try {
            PreparedStatement pStmt = con.prepareStatement(sqlSelect);
            ResultSet rs = pStmt.executeQuery();
            list = this.prepareResult(rs);
            rs.close();
            pStmt.close();
            con.close();
            return list;
        }
        catch (SQLException sqlExc) {
            this.log_.error((Object)sqlExc);
            return null;
        }
    }
}

