/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.dbutilities;

import at.tugraz.genome.dbutilities.Base64;
import at.tugraz.genome.dbutilities.PKGenerator;
import java.math.BigInteger;
import java.net.InetAddress;

public class TSSGUIDPKGenerator
implements PKGenerator {
    private byte[] bytes12;
    private static TSSGUIDPKGenerator instance;
    public short loopCounter = 0;

    private TSSGUIDPKGenerator() {
        try {
            this.bytes12 = new byte[12];
            byte[] bytesIP = InetAddress.getLocalHost().getAddress();
            this.bytes12[0] = bytesIP[3];
            int memAdr = System.identityHashCode(this);
            byte[] bytes4 = new byte[4];
            TSSGUIDPKGenerator.toFixSizeByteArray(new BigInteger(String.valueOf(memAdr)), bytes4);
            this.bytes12[1] = bytes4[0];
            this.bytes12[2] = bytes4[1];
            this.bytes12[3] = bytes4[2];
            this.bytes12[4] = bytes4[3];
        }
        catch (Exception ignore) {
        }
    }

    public String generateBase64ID() {
        long timeNow = System.currentTimeMillis() & 0xFFFFFFFFFFL;
        byte[] bytes5 = new byte[5];
        TSSGUIDPKGenerator.toFixSizeByteArray(new BigInteger(String.valueOf(timeNow)), bytes5);
        this.bytes12[5] = bytes5[0];
        this.bytes12[6] = bytes5[1];
        this.bytes12[7] = bytes5[2];
        this.bytes12[8] = bytes5[3];
        this.bytes12[9] = bytes5[4];
        short counter = this.getLoopCounter();
        byte[] bytes2 = new byte[2];
        TSSGUIDPKGenerator.toFixSizeByteArray(new BigInteger(String.valueOf(counter)), bytes2);
        this.bytes12[10] = bytes2[0];
        this.bytes12[11] = bytes2[1];
        return new String(Base64.encode(this.bytes12));
    }

    public String generateID() {
        return this.generateBase64ID().replace('+', '$').replace('/', '_');
    }

    public static TSSGUIDPKGenerator getInstance() {
        if (instance == null) {
            return new TSSGUIDPKGenerator();
        }
        return instance;
    }

    public Long getLongPrimaryKey() {
        return new Long(this.generateID().hashCode());
    }

    private synchronized short getLoopCounter() {
        short s = this.loopCounter;
        this.loopCounter = (short)(s + 1);
        return s;
    }

    public Long getPrimaryKey(String s) {
        return this.getLongPrimaryKey();
    }

    public String getStringPrimaryKey() {
        return this.generateID();
    }

    private static void toFixSizeByteArray(BigInteger bigInt, byte[] destination) {
        int i = 0;
        while (i < destination.length) {
            destination[i] = 0;
            ++i;
        }
        byte[] source = bigInt.toByteArray();
        if (source.length <= destination.length) {
            int i2 = 0;
            while (i2 < source.length) {
                destination[destination.length - source.length + i2] = source[i2];
                ++i2;
            }
        } else {
            int i3 = 0;
            while (i3 < destination.length) {
                destination[i3] = source[source.length - destination.length + i3];
                ++i3;
            }
        }
    }

    public String toString() {
        return "TSSGUIDPKGenerator";
    }
}

