/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.dbutilities;

import at.tugraz.genome.dbutilities.ValueListIterator;
import at.tugraz.genome.dbutilities.exception.IteratorException;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class ValueListHandler
extends ValueListIterator
implements Serializable {
    protected int currentIndex_;
    protected transient ListIterator listIterator_;
    protected LinkedList list_;

    public ValueListHandler(LinkedList list) throws IteratorException {
        this.setList(list);
    }

    public ValueListHandler() {
    }

    protected Object getCurrentElement() throws IteratorException {
        int currentIndex;
        Object obj = null;
        if (this.list_ != null) {
            currentIndex = this.listIterator_.nextIndex();
            if (currentIndex == this.getSize()) {
                currentIndex = this.getSize() - 1;
            }
        } else {
            throw new IteratorException("List is empty: getCurrentElement()");
        }
        this.currentIndex_ = currentIndex;
        obj = this.list_.get(currentIndex);
        return obj;
    }

    protected Collection getList() {
        return this.list_;
    }

    protected List getNextElements(int count) throws IteratorException {
        int i = 0;
        Object object = null;
        LinkedList<Object> list = new LinkedList<Object>();
        if (this.listIterator_ != null) {
            while (this.listIterator_.hasNext() && i < count) {
                object = this.listIterator_.next();
                list.add(object);
                ++i;
                this.currentIndex_ = this.listIterator_.nextIndex();
            }
        } else {
            throw new IteratorException("List is empty: getNextElements()");
        }
        System.out.println("currentIndex after getNextElements(): " + this.currentIndex_);
        return list;
    }

    public int getNumberOfElements() throws IteratorException {
        return this.getSize();
    }

    public int getNumberOfPages(int count) throws IteratorException {
        return (int)Math.ceil((double)this.getSize() / (double)count);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    protected List getPreviousElements(int count) throws IteratorException {
        LinkedList<Object> list;
        block3: {
            Object object;
            int i;
            block2: {
                i = 0;
                object = null;
                list = new LinkedList<Object>();
                if (this.listIterator_ == null) throw new IteratorException("List is empty: getPreviousElements()");
                if (!true) break block2;
                if (!this.listIterator_.hasPrevious()) return list;
                if (i >= count) break block3;
            }
            do {
                object = this.listIterator_.previous();
                list.add(object);
                ++i;
                this.currentIndex_ = this.listIterator_.nextIndex();
                if (!this.listIterator_.hasPrevious()) return list;
            } while (i < count);
        }
        return list;
    }

    public int getSize() throws IteratorException {
        int size = 0;
        if (this.list_ == null) {
            throw new IteratorException("List is empty: getSize()");
        }
        size = this.list_.size();
        return size;
    }

    public boolean hasNext() throws IteratorException {
        if (this.listIterator_ != null) {
            return this.listIterator_.hasNext();
        }
        throw new IteratorException("List is empty: hasNext()");
    }

    public boolean hasPrevious() throws IteratorException {
        if (this.listIterator_ != null) {
            return this.listIterator_.hasPrevious();
        }
        throw new IteratorException("List is empty: hasPrevious()");
    }

    public void lastIndex() throws IteratorException {
        if (this.listIterator_ == null) {
            throw new IteratorException("List is empty: lastIndex()");
        }
        this.listIterator_ = this.list_.listIterator(this.getSize());
        this.currentIndex_ = this.listIterator_.nextIndex();
    }

    public void resetIndex() throws IteratorException {
        if (this.listIterator_ == null) {
            throw new IteratorException("List is empty: resetIndex()");
        }
        this.listIterator_ = this.list_.listIterator();
        this.currentIndex_ = this.listIterator_.nextIndex();
    }

    public void setIndex(int idx) throws IteratorException {
        if (idx < 0) {
            idx = 0;
        }
        if (this.listIterator_ != null) {
            if (idx < this.getSize()) {
                this.listIterator_ = this.list_.listIterator(idx);
                this.currentIndex_ = idx;
            } else {
                if (idx > this.getSize()) {
                    throw new IteratorException("Index " + idx + " is greater than the number of elements in the list!");
                }
                if (idx == this.getSize()) {
                    this.lastIndex();
                }
            }
        } else {
            throw new IteratorException("List is empty: setIndex()");
        }
    }

    protected void setList(LinkedList list, boolean preserveIndex) throws IteratorException {
        System.out.println("[ValueListHandler] currentIndex = " + this.currentIndex_);
        this.setList(list);
        if (preserveIndex) {
            this.setIndex(this.currentIndex_);
        }
    }

    protected void setList(LinkedList list) throws IteratorException {
        this.list_ = new LinkedList(list);
        if (this.list_ == null) {
            throw new IteratorException("List is empty: setList()");
        }
        this.listIterator_ = this.list_.listIterator();
    }
}

