/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.marsejb.utils;

import at.tugraz.genome.dbutilities.EJBExceptionFactory;
import at.tugraz.genome.dbutilities.PKGenerator;
import at.tugraz.genome.dbutilities.PKGeneratorFactory;
import at.tugraz.genome.dbutilities.exception.EJBCreateException;
import at.tugraz.genome.dbutilities.exception.EJBFinderException;
import at.tugraz.genome.dbutilities.exception.EJBServerException;
import at.tugraz.genome.dbutilities.exception.ForeignKeyException;
import at.tugraz.genome.dbutilities.exception.UniqueException;
import at.tugraz.genome.marsejb.exception.FileUploadException;
import at.tugraz.genome.marsejb.exception.ValidationException;
import at.tugraz.genome.marsejb.utils.GlobalConstants;
import at.tugraz.genome.marsejb.utils.ejb.Download;
import at.tugraz.genome.marsejb.utils.ejb.DownloadHome;
import at.tugraz.genome.marsejb.utils.ejb.Upload;
import at.tugraz.genome.marsejb.utils.ejb.UploadHome;
import at.tugraz.genome.marsejb.utils.sql.InsertShared;
import at.tugraz.genome.marsejb.utils.sql.SelectShared;
import at.tugraz.genome.marsejb.utils.vo.FileDownloadVO;
import at.tugraz.genome.marsejb.utils.vo.FileUploadVO;
import at.tugraz.genome.marsejb.utils.vo.SharedVO;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Date;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class FilesSBBean
implements SessionBean {
    SessionContext sessionContext;
    private UploadHome uploadHome;
    private DownloadHome downloadHome;
    private Logger log = Logger.getLogger(this.getClass());

    public void ejbCreate() throws CreateException, EJBServerException {
        this.log.info((Object)"FilesSBBean create");
        try {
            InitialContext ctx = new InitialContext();
            this.uploadHome = (UploadHome)ctx.lookup("java:comp/env/ejb/Upload");
            this.downloadHome = (DownloadHome)ctx.lookup("java:comp/env/ejb/Download");
        }
        catch (NamingException ne) {
            this.log.error((Object)"Naming Exception");
            EJBExceptionFactory.throwEJBServerException(GlobalConstants.getDatabase(), ne);
        }
    }

    public void ejbRemove() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    public String getDataRootPath() {
        return GlobalConstants.getDataRootDirectory();
    }

    public FileUploadVO setFile(String filename, byte[] filedata, FileUploadVO uploadVO) throws FileUploadException, UniqueException, ForeignKeyException, EJBCreateException {
        this.log.info((Object)("setFile " + filename));
        String filepathPostFix_ = "";
        filepathPostFix_ = filepathPostFix_ + "uploads" + File.separator;
        filepathPostFix_ = filepathPostFix_ + uploadVO.getUserid().toString();
        File path = new File(GlobalConstants.getDataRootDirectory() + filepathPostFix_);
        if (!path.exists()) {
            this.log.info((Object)("Creating new Directory for : " + GlobalConstants.getDataRootDirectory() + filepathPostFix_));
            if (!path.mkdir()) {
                throw new FileUploadException("Could not create directory " + GlobalConstants.getDataRootDirectory() + filepathPostFix_);
            }
            this.log.info((Object)"Directory Successfully created");
            path = null;
        }
        filepathPostFix_ = filepathPostFix_ + File.separator + uploadVO.getCategory();
        System.out.println("Filepath: " + GlobalConstants.getDataRootDirectory() + filepathPostFix_);
        path = new File(GlobalConstants.getDataRootDirectory() + filepathPostFix_);
        if (!path.exists()) {
            this.log.info((Object)("Creating new Directory for : " + GlobalConstants.getDataRootDirectory() + filepathPostFix_));
            if (!path.mkdir()) {
                throw new FileUploadException("Could not create directory " + GlobalConstants.getDataRootDirectory() + filepathPostFix_);
            }
            this.log.info((Object)"Directory Successfully created");
            path = null;
        }
        String filename_ = filepathPostFix_ + File.separator + filename;
        File file = new File(GlobalConstants.getDataRootDirectory() + filename_);
        if (!file.exists()) {
            try {
                BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file));
                output.write(filedata, 0, filedata.length);
                output.close();
                try {
                    try {
                        PKGenerator pkGenerator = PKGeneratorFactory.getPKGenerator("ORACLE");
                        Long pk = pkGenerator.getPrimaryKey("UPLOAD");
                        uploadVO.setId(pk);
                        uploadVO.setAddeddate(new Date(System.currentTimeMillis()));
                        uploadVO.setFilepathname(filename_);
                        uploadVO.setFilesize(new Long(file.length()));
                        this.uploadHome.create(uploadVO);
                    }
                    catch (CreateException ce) {
                        this.log.error((Object)"EJBCreateException");
                        this.log.info((Object)("Deleting file :" + filename_));
                        file.delete();
                        uploadVO = null;
                        EJBExceptionFactory.throwEJBCreateExceptions(GlobalConstants.getDatabase(), ce);
                        Object var12_16 = null;
                        file = null;
                    }
                    catch (ValidationException ve) {
                        this.log.error((Object)"ValidationException");
                        this.log.info((Object)("Deleting file :" + filename_));
                        file.delete();
                        uploadVO = null;
                        throw new EJBCreateException("VO had already an id");
                    }
                    Object var12_15 = null;
                    file = null;
                }
                catch (Throwable throwable) {
                    Object var12_17 = null;
                    file = null;
                    throw throwable;
                }
            }
            catch (FileNotFoundException e) {
                this.log.error((Object)("java.io.FileNotFoundException" + e));
                uploadVO = null;
                throw new FileUploadException(e.getMessage());
            }
            catch (IOException e1) {
                this.log.error((Object)("java.io.IOException " + e1));
                uploadVO = null;
                throw new FileUploadException(e1.getMessage());
            }
        } else {
            this.log.info((Object)("File" + filename_ + " already exsits"));
            uploadVO = null;
            throw new FileUploadException("File already exists");
        }
        return uploadVO;
    }

    public byte[] getFile(Long id) throws EJBFinderException, EJBServerException {
        try {
            FileUploadVO fileUploadVO = this.getFileUploadVO(id);
            this.log.info((Object)("fileUploadVO.getFilepathname(): " + fileUploadVO.getFilepathname()));
            this.log.info((Object)("GlobalConstants.getDataRootDirectory(): " + GlobalConstants.getDataRootDirectory()));
            File file = new File(GlobalConstants.getDataRootDirectory() + fileUploadVO.getFilepathname());
            BufferedInputStream din = new BufferedInputStream(new FileInputStream(file));
            byte[] filedata = new byte[(int)file.length()];
            din.read(filedata);
            return filedata;
        }
        catch (IOException ioEx) {
            throw new EJBServerException(ioEx.getMessage());
        }
    }

    public Collection getMyFiles(Long userid) throws EJBFinderException {
        this.log.info((Object)"getMyFiles");
        Vector<FileUploadVO> collVO = new Vector<FileUploadVO>();
        Upload uploadEO = null;
        FileUploadVO fileVO = null;
        try {
            Collection collEO = this.uploadHome.findByUserid(userid);
            Iterator it = collEO.iterator();
            while (it.hasNext()) {
                uploadEO = (Upload)it.next();
                fileVO = new FileUploadVO(uploadEO);
                collVO.add(fileVO);
            }
        }
        catch (FinderException fe) {
            collVO = null;
            this.log.error((Object)"EJBFinder Exception");
            EJBExceptionFactory.throwEJBFinderException(GlobalConstants.getDatabase(), fe);
        }
        return collVO;
    }

    public Collection getAllFiles(Long userid) throws EJBFinderException, EJBServerException {
        this.log.info((Object)"getAllFiles");
        Vector<FileUploadVO> collVO = new Vector<FileUploadVO>();
        Upload uploadEO = null;
        FileUploadVO fileVO = null;
        try {
            Collection collEO = this.uploadHome.findByUserid(userid);
            Iterator it = collEO.iterator();
            while (it.hasNext()) {
                uploadEO = (Upload)it.next();
                fileVO = new FileUploadVO(uploadEO);
                collVO.add(fileVO);
            }
            SelectShared sharedFile = new SelectShared("Upload");
            Collection sharedFiles = sharedFile.findByUserId(userid);
            it = sharedFiles.iterator();
            while (it.hasNext()) {
                SharedVO sharedFileVO = (SharedVO)it.next();
                uploadEO = this.uploadHome.findByPrimaryKey(sharedFileVO.getItemId());
                fileVO = new FileUploadVO(uploadEO);
                collVO.add(fileVO);
            }
            sharedFile.closeConnection();
        }
        catch (FinderException fe) {
            collVO = null;
            this.log.error((Object)"EJBFinder Exception");
            EJBExceptionFactory.throwEJBFinderException(GlobalConstants.getDatabase(), fe);
        }
        return collVO;
    }

    public Collection getAllFiles(Long userid, String category) throws EJBFinderException, EJBServerException {
        this.log.info((Object)"getAllFiles (Long userid, String category)");
        Vector<FileUploadVO> collVO = new Vector<FileUploadVO>();
        Upload uploadEO = null;
        FileUploadVO fileVO = null;
        try {
            Collection collEO = this.uploadHome.findByUserid(userid);
            Iterator it = collEO.iterator();
            while (it.hasNext()) {
                uploadEO = (Upload)it.next();
                if (!uploadEO.getCategory().equalsIgnoreCase(category)) continue;
                fileVO = new FileUploadVO(uploadEO);
                collVO.add(fileVO);
            }
            SelectShared sharedFile = new SelectShared("Upload");
            Collection sharedFiles = sharedFile.findByUserId(userid);
            it = sharedFiles.iterator();
            while (it.hasNext()) {
                SharedVO sharedFileVO = (SharedVO)it.next();
                uploadEO = this.uploadHome.findByPrimaryKey(sharedFileVO.getItemId());
                if (!uploadEO.getCategory().equalsIgnoreCase(category)) continue;
                fileVO = new FileUploadVO(uploadEO);
                collVO.add(fileVO);
            }
            sharedFile.closeConnection();
        }
        catch (FinderException fe) {
            collVO = null;
            this.log.error((Object)"EJBFinder Exception");
            EJBExceptionFactory.throwEJBFinderException(GlobalConstants.getDatabase(), fe);
        }
        return collVO;
    }

    public FileUploadVO getFileUploadVO(Long id) throws EJBFinderException {
        this.log.info((Object)"getFileUploadVO");
        Upload uploadEO = null;
        try {
            uploadEO = this.uploadHome.findByPrimaryKey(id);
        }
        catch (FinderException fe) {
            uploadEO = null;
            this.log.error((Object)"EJBFinder Exception");
            EJBExceptionFactory.throwEJBFinderException(GlobalConstants.getDatabase(), fe);
        }
        return new FileUploadVO(uploadEO);
    }

    public void markFileShared(Long fileId, Collection userids) throws EJBServerException {
        InsertShared sharedSQL = null;
        Iterator it = userids.iterator();
        try {
            sharedSQL = new InsertShared("upload");
            while (it.hasNext()) {
                Long userid = (Long)it.next();
                sharedSQL.insert(fileId, userid);
            }
            Object var7_7 = null;
            sharedSQL.close();
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            sharedSQL.close();
            throw throwable;
        }
    }

    public String getFilePathName(Long id) throws EJBFinderException {
        this.log.info((Object)"getFileParserInfo");
        Upload uploadEO = null;
        try {
            uploadEO = this.uploadHome.findByPrimaryKey(id);
        }
        catch (FinderException fe) {
            uploadEO = null;
            this.log.error((Object)"EJBFinder Exception");
            EJBExceptionFactory.throwEJBFinderException(GlobalConstants.getDatabase(), fe);
        }
        return GlobalConstants.getDataRootDirectory() + uploadEO.getFilepathname();
    }

    public boolean deleteFile(Long id) throws EJBServerException, EJBFinderException {
        this.log.info((Object)"deleteFile");
        Upload uploadEO = null;
        try {
            uploadEO = this.uploadHome.findByPrimaryKey(id);
            String filename = uploadEO.getFilepathname();
            uploadEO.remove();
            File file = new File(GlobalConstants.getDataRootDirectory() + filename);
            file.delete();
            return true;
        }
        catch (FinderException fe) {
            uploadEO = null;
            this.log.error((Object)"EJBFinder Exception");
            EJBExceptionFactory.throwEJBFinderException(GlobalConstants.getDatabase(), fe);
        }
        catch (RemoveException re) {
            uploadEO = null;
            this.log.error((Object)"EJBRemove Exception");
            throw new EJBServerException("EJBRemove Exception" + (Object)((Object)re));
        }
        return false;
    }

    public void edit(FileUploadVO vo) throws EJBFinderException {
        this.log.info((Object)"edit");
        Upload uploadEO = null;
        try {
            uploadEO = this.uploadHome.findByPrimaryKey(vo.getId());
            uploadEO.update(vo);
        }
        catch (FinderException fe) {
            uploadEO = null;
            this.log.error((Object)"EJBFinder Exception");
            EJBExceptionFactory.throwEJBFinderException(GlobalConstants.getDatabase(), fe);
        }
    }

    public FileDownloadVO addDownloadableFile(FileDownloadVO downloadVO) throws EJBServerException, EJBCreateException, UniqueException, ForeignKeyException {
        this.log.info((Object)"addDownloadableFile");
        try {
            PKGenerator pkGenerator = PKGeneratorFactory.getPKGenerator("ORACLE");
            Long pk = pkGenerator.getPrimaryKey("DOWNLOAD");
            downloadVO.setId(pk);
            downloadVO.setAddeddate(new Date(System.currentTimeMillis()));
            downloadVO.setFilepathname(downloadVO.getFilepathname());
            downloadVO.setFilesize(downloadVO.getFilesize());
            this.downloadHome.create(downloadVO);
        }
        catch (CreateException ce) {
            this.log.error((Object)"EJBCreateException");
            downloadVO = null;
            EJBExceptionFactory.throwEJBCreateExceptions(GlobalConstants.getDatabase(), ce);
        }
        catch (ValidationException ve) {
            this.log.error((Object)"ValidationException");
            downloadVO = null;
            throw new EJBCreateException("VO had already an id");
        }
        return downloadVO;
    }

    public FileDownloadVO setFile(String filename, byte[] filedata, FileDownloadVO downloadVO) throws FileUploadException, UniqueException, ForeignKeyException, EJBCreateException {
        this.log.info((Object)("setFile: " + filename));
        String filepathPostFix_ = "";
        filepathPostFix_ = filepathPostFix_ + "downloads" + File.separator;
        filepathPostFix_ = filepathPostFix_ + downloadVO.getUserid().toString();
        File path = new File(GlobalConstants.getDataRootDirectory() + filepathPostFix_);
        if (!path.exists()) {
            this.log.info((Object)("Creating new Directory for : " + GlobalConstants.getDataRootDirectory() + filepathPostFix_));
            if (!path.mkdir()) {
                throw new FileUploadException("Could not create directory " + GlobalConstants.getDataRootDirectory() + filepathPostFix_);
            }
            this.log.info((Object)"Directory Successfully created");
            path = null;
        }
        filepathPostFix_ = filepathPostFix_ + File.separator + downloadVO.getCategory();
        System.out.println("Filepath: " + GlobalConstants.getDataRootDirectory() + filepathPostFix_);
        path = new File(GlobalConstants.getDataRootDirectory() + filepathPostFix_);
        if (!path.exists()) {
            this.log.info((Object)("Creating new Directory for : " + GlobalConstants.getDataRootDirectory() + filepathPostFix_));
            if (!path.mkdir()) {
                throw new FileUploadException("Could not create directory " + GlobalConstants.getDataRootDirectory() + filepathPostFix_);
            }
            this.log.info((Object)"Directory Successfully created");
            path = null;
        }
        String filename_ = filepathPostFix_ + File.separator + filename;
        File file = new File(GlobalConstants.getDataRootDirectory() + filename_);
        if (!file.exists()) {
            try {
                BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file));
                output.write(filedata, 0, filedata.length);
                output.close();
                try {
                    try {
                        PKGenerator pkGenerator = PKGeneratorFactory.getPKGenerator("ORACLE");
                        Long pk = pkGenerator.getPrimaryKey("DOWNLOAD");
                        downloadVO.setId(pk);
                        downloadVO.setAddeddate(new Date(System.currentTimeMillis()));
                        downloadVO.setFilepathname(filename_);
                        downloadVO.setFilesize(new Long(file.length()));
                        this.downloadHome.create(downloadVO);
                    }
                    catch (CreateException ce) {
                        this.log.error((Object)"EJBCreateException");
                        this.log.info((Object)("Deleting file :" + filename_));
                        file.delete();
                        downloadVO = null;
                        EJBExceptionFactory.throwEJBCreateExceptions(GlobalConstants.getDatabase(), ce);
                        Object var12_16 = null;
                        file = null;
                    }
                    catch (ValidationException ve) {
                        this.log.error((Object)"ValidationException");
                        this.log.info((Object)("Deleting file :" + filename_));
                        file.delete();
                        downloadVO = null;
                        throw new EJBCreateException("VO had already an id");
                    }
                    Object var12_15 = null;
                    file = null;
                }
                catch (Throwable throwable) {
                    Object var12_17 = null;
                    file = null;
                    throw throwable;
                }
            }
            catch (FileNotFoundException e) {
                this.log.error((Object)("java.io.FileNotFoundException" + e));
                downloadVO = null;
                throw new FileUploadException(e.getMessage());
            }
            catch (IOException e1) {
                this.log.error((Object)("java.io.IOException " + e1));
                downloadVO = null;
                throw new FileUploadException(e1.getMessage());
            }
        } else {
            this.log.info((Object)("File" + filename_ + " already exsits"));
            downloadVO = null;
            throw new FileUploadException("File already exists");
        }
        return downloadVO;
    }

    public Collection getMyDownloadableFiles(Long userid) throws EJBFinderException {
        this.log.info((Object)"getMyDownloadableFiles");
        Vector<FileDownloadVO> collVO = new Vector<FileDownloadVO>();
        Download downloadEO = null;
        FileDownloadVO fileVO = null;
        try {
            Collection collEO = this.downloadHome.findByUserid(userid);
            Iterator it = collEO.iterator();
            while (it.hasNext()) {
                downloadEO = (Download)it.next();
                fileVO = new FileDownloadVO(downloadEO);
                collVO.add(fileVO);
            }
        }
        catch (FinderException fe) {
            collVO = null;
            this.log.error((Object)"EJBFinder Exception");
            EJBExceptionFactory.throwEJBFinderException(GlobalConstants.getDatabase(), fe);
        }
        return collVO;
    }

    public Collection getAllDownloadableFiles(Long userid) throws EJBFinderException, EJBServerException {
        this.log.info((Object)"getAllDownloadableFiles");
        Vector<FileDownloadVO> collVO = new Vector<FileDownloadVO>();
        Download downloadEO = null;
        FileDownloadVO fileVO = null;
        try {
            Collection collEO = this.downloadHome.findByUserid(userid);
            Iterator it = collEO.iterator();
            while (it.hasNext()) {
                downloadEO = (Download)it.next();
                fileVO = new FileDownloadVO(downloadEO);
                collVO.add(fileVO);
            }
            SelectShared sharedFile = new SelectShared("Download");
            Collection sharedFiles = sharedFile.findByUserId(userid);
            it = sharedFiles.iterator();
            while (it.hasNext()) {
                SharedVO sharedFileVO = (SharedVO)it.next();
                downloadEO = this.downloadHome.findByPrimaryKey(sharedFileVO.getItemId());
                fileVO = new FileDownloadVO(downloadEO);
                collVO.add(fileVO);
            }
            sharedFile.closeConnection();
        }
        catch (FinderException fe) {
            collVO = null;
            this.log.error((Object)"EJBFinder Exception");
            EJBExceptionFactory.throwEJBFinderException(GlobalConstants.getDatabase(), fe);
        }
        return collVO;
    }

    public Collection getAllDownloadableFiles(Long userid, String category) throws EJBFinderException, EJBServerException {
        this.log.info((Object)"getAllDownloadableFiles (Long userid, String category)");
        Vector<FileDownloadVO> collVO = new Vector<FileDownloadVO>();
        Download downloadEO = null;
        FileDownloadVO fileVO = null;
        try {
            Collection collEO = this.downloadHome.findByUserid(userid);
            Iterator it = collEO.iterator();
            while (it.hasNext()) {
                downloadEO = (Download)it.next();
                if (!downloadEO.getCategory().equalsIgnoreCase(category)) continue;
                fileVO = new FileDownloadVO(downloadEO);
                collVO.add(fileVO);
            }
            SelectShared sharedFile = new SelectShared("Download");
            Collection sharedFiles = sharedFile.findByUserId(userid);
            it = sharedFiles.iterator();
            while (it.hasNext()) {
                SharedVO sharedFileVO = (SharedVO)it.next();
                downloadEO = this.downloadHome.findByPrimaryKey(sharedFileVO.getItemId());
                if (!downloadEO.getCategory().equalsIgnoreCase(category)) continue;
                fileVO = new FileDownloadVO(downloadEO);
                collVO.add(fileVO);
            }
            sharedFile.closeConnection();
        }
        catch (FinderException fe) {
            collVO = null;
            this.log.error((Object)"EJBFinder Exception");
            EJBExceptionFactory.throwEJBFinderException(GlobalConstants.getDatabase(), fe);
        }
        return collVO;
    }

    public FileDownloadVO getFileDownloadVO(Long id) throws EJBFinderException {
        this.log.info((Object)"getFileDownloadVO");
        Download downloadEO = null;
        try {
            downloadEO = this.downloadHome.findByPrimaryKey(id);
        }
        catch (FinderException fe) {
            downloadEO = null;
            this.log.error((Object)"EJBFinder Exception");
            EJBExceptionFactory.throwEJBFinderException(GlobalConstants.getDatabase(), fe);
        }
        return new FileDownloadVO(downloadEO);
    }

    public void markDownloadableFileShared(Long fileId, Collection userids) throws EJBServerException {
        InsertShared sharedSQL = null;
        Iterator it = userids.iterator();
        try {
            sharedSQL = new InsertShared("download");
            while (it.hasNext()) {
                Long userid = (Long)it.next();
                sharedSQL.insert(fileId, userid);
            }
            Object var7_7 = null;
            sharedSQL.close();
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            sharedSQL.close();
            throw throwable;
        }
    }

    public String getDownloadableFilePathName(Long id) throws EJBFinderException {
        this.log.info((Object)"getDownloadableFilePathName");
        Download downloadEO = null;
        try {
            downloadEO = this.downloadHome.findByPrimaryKey(id);
        }
        catch (FinderException fe) {
            downloadEO = null;
            this.log.error((Object)"EJBFinder Exception");
            EJBExceptionFactory.throwEJBFinderException(GlobalConstants.getDatabase(), fe);
        }
        return GlobalConstants.getDataRootDirectory() + downloadEO.getFilepathname();
    }

    public boolean deleteDownloadableFile(Long id) throws EJBServerException, EJBFinderException {
        this.log.info((Object)"deleteDownloadableFile");
        Download downloadEO = null;
        try {
            downloadEO = this.downloadHome.findByPrimaryKey(id);
            String filename = downloadEO.getFilepathname();
            downloadEO.remove();
            File file = new File(GlobalConstants.getDataRootDirectory() + filename);
            file.delete();
            return true;
        }
        catch (FinderException fe) {
            downloadEO = null;
            this.log.error((Object)"EJBFinder Exception");
            EJBExceptionFactory.throwEJBFinderException(GlobalConstants.getDatabase(), fe);
        }
        catch (RemoveException re) {
            downloadEO = null;
            this.log.error((Object)"EJBRemove Exception");
            throw new EJBServerException("EJBRemove Exception" + (Object)((Object)re));
        }
        return false;
    }

    public void editDownloadableFile(FileDownloadVO vo) throws EJBFinderException {
        this.log.info((Object)"editDownloadableFile");
        Download downloadEO = null;
        try {
            downloadEO = this.downloadHome.findByPrimaryKey(vo.getId());
            downloadEO.update(vo);
        }
        catch (FinderException fe) {
            downloadEO = null;
            this.log.error((Object)"EJBFinder Exception");
            EJBExceptionFactory.throwEJBFinderException(GlobalConstants.getDatabase(), fe);
        }
    }
}

