/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.marsejb.utils;

import at.tugraz.genome.dbutilities.EJBExceptionFactory;
import at.tugraz.genome.dbutilities.PKGenerator;
import at.tugraz.genome.dbutilities.PKGeneratorFactory;
import at.tugraz.genome.dbutilities.exception.EJBCreateException;
import at.tugraz.genome.dbutilities.exception.EJBFinderException;
import at.tugraz.genome.dbutilities.exception.EJBServerException;
import at.tugraz.genome.dbutilities.exception.ForeignKeyException;
import at.tugraz.genome.dbutilities.exception.UniqueException;
import at.tugraz.genome.marsejb.exception.ValidationException;
import at.tugraz.genome.marsejb.utils.GlobalConstants;
import at.tugraz.genome.marsejb.utils.ejb.Protocol;
import at.tugraz.genome.marsejb.utils.ejb.ProtocolHome;
import at.tugraz.genome.marsejb.utils.ejb.Protocoltype;
import at.tugraz.genome.marsejb.utils.ejb.ProtocoltypeHome;
import at.tugraz.genome.marsejb.utils.vo.ProtocolVO;
import at.tugraz.genome.marsejb.utils.vo.ProtocoltypeVO;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class ProtocolSBBean
implements SessionBean {
    SessionContext sessionContext;
    Logger log = Logger.getLogger((String)"ProtocolSBBean");
    ProtocoltypeHome protocoltypeHome;
    ProtocolHome protocolHome;

    public void ejbCreate() throws CreateException, EJBServerException {
        try {
            InitialContext ctx = new InitialContext();
            this.protocoltypeHome = (ProtocoltypeHome)ctx.lookup("java:comp/env/ejb/Protocoltype");
            this.protocolHome = (ProtocolHome)ctx.lookup("java:comp/env/ejb/Protocol");
        }
        catch (NamingException ne) {
            this.log.error((Object)"Naming Exception");
            EJBExceptionFactory.throwEJBServerException(GlobalConstants.getDatabase(), ne);
        }
    }

    public void ejbRemove() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    public ProtocoltypeVO addProtocoltype(ProtocoltypeVO vo) throws EJBCreateException, UniqueException, ForeignKeyException {
        this.log.info((Object)"addProtocoltype");
        try {
            PKGenerator pkGenerator = PKGeneratorFactory.getPKGenerator(GlobalConstants.getDatabase());
            Long pk = pkGenerator.getPrimaryKey("PROTOCOLTYPE");
            vo.setId(pk);
            this.log.debug((Object)("ProtocoltypeVO " + vo.getId() + " " + vo.getName()));
            this.log.debug((Object)("Home" + this.protocoltypeHome));
            this.protocoltypeHome.create(vo);
        }
        catch (CreateException ce) {
            this.log.error((Object)"EJBCreateException");
            EJBExceptionFactory.throwEJBCreateExceptions(GlobalConstants.getDatabase(), ce);
        }
        catch (ValidationException ve) {
            this.log.error((Object)"EJBFinder Exception");
            EJBExceptionFactory.throwEJBCreateExceptions(GlobalConstants.getDatabase(), ve.getMessage());
        }
        return vo;
    }

    public ProtocoltypeVO getProtocoltype(Long id) throws EJBFinderException {
        this.log.info((Object)"getProtocoltype");
        Protocoltype protocoltypeEO = null;
        try {
            protocoltypeEO = this.protocoltypeHome.findByPrimaryKey(id);
        }
        catch (FinderException fe) {
            protocoltypeEO = null;
            this.log.error((Object)"EJBFinder Exception");
            EJBExceptionFactory.throwEJBFinderException(GlobalConstants.getDatabase(), fe);
        }
        return new ProtocoltypeVO(protocoltypeEO);
    }

    public Collection getAllProtocoltypes() throws EJBFinderException {
        this.log.info((Object)"getAllProtocoltypes");
        Vector<ProtocoltypeVO> collVO = new Vector<ProtocoltypeVO>();
        Protocoltype protocoltypeEO = null;
        ProtocoltypeVO protocoltypeVO = null;
        try {
            Collection collEO = this.protocoltypeHome.findAll();
            Iterator it = collEO.iterator();
            while (it.hasNext()) {
                protocoltypeEO = (Protocoltype)it.next();
                protocoltypeVO = new ProtocoltypeVO(protocoltypeEO);
                collVO.add(protocoltypeVO);
            }
        }
        catch (FinderException fe) {
            fe.printStackTrace();
            collVO = null;
            this.log.error((Object)"EJBFinder Exception");
            EJBExceptionFactory.throwEJBFinderException(GlobalConstants.getDatabase(), fe);
        }
        return collVO;
    }

    public ProtocoltypeVO editProtocoltype(ProtocoltypeVO vo) throws EJBFinderException {
        this.log.info((Object)"editProtocoltype");
        Protocoltype protocoltypeEO = null;
        try {
            protocoltypeEO = this.protocoltypeHome.findByPrimaryKey(vo.getId());
            protocoltypeEO.update(vo);
        }
        catch (FinderException fe) {
            vo = null;
            this.log.error((Object)"EJBFinder Exception");
            EJBExceptionFactory.throwEJBFinderException(GlobalConstants.getDatabase(), fe);
        }
        return vo;
    }

    public ProtocolVO addProtocol(ProtocolVO vo, byte[] docFiledata, byte[] txtFiledata) throws EJBCreateException, UniqueException, ForeignKeyException {
        this.log.info((Object)"addProtocol");
        try {
            PKGenerator pkGenerator = PKGeneratorFactory.getPKGenerator(GlobalConstants.getDatabase());
            Long pk = pkGenerator.getPrimaryKey("PROTOCOL");
            vo.setId(pk);
            this.protocolHome.create(vo, docFiledata, txtFiledata);
        }
        catch (CreateException ce) {
            this.log.error((Object)"EJBCreateException");
            EJBExceptionFactory.throwEJBCreateExceptions(GlobalConstants.getDatabase(), ce);
        }
        catch (ValidationException ve) {
            this.log.error((Object)"EJBFinder Exception");
            EJBExceptionFactory.throwEJBCreateExceptions(GlobalConstants.getDatabase(), ve.getMessage());
        }
        return vo;
    }

    public ProtocolVO getProtocol(Long id) throws EJBFinderException {
        this.log.info((Object)"getProtocol");
        Protocol protocolEO = null;
        try {
            protocolEO = this.protocolHome.findByPrimaryKey(id);
        }
        catch (FinderException fe) {
            protocolEO = null;
            this.log.error((Object)"EJBFinder Exception");
            EJBExceptionFactory.throwEJBFinderException(GlobalConstants.getDatabase(), fe);
        }
        return new ProtocolVO(protocolEO, 5);
    }

    public Collection getAllProtocols() throws EJBFinderException {
        this.log.info((Object)"getAllProtocol");
        Vector<ProtocolVO> collVO = new Vector<ProtocolVO>();
        Protocol protocolEO = null;
        ProtocolVO protocolVO = null;
        try {
            Collection collEO = this.protocolHome.findAll();
            Iterator it = collEO.iterator();
            while (it.hasNext()) {
                protocolEO = (Protocol)it.next();
                protocolVO = new ProtocolVO(protocolEO, 1);
                collVO.add(protocolVO);
            }
        }
        catch (FinderException fe) {
            fe.printStackTrace();
            collVO = null;
            this.log.error((Object)"EJBFinder Exception");
            EJBExceptionFactory.throwEJBFinderException(GlobalConstants.getDatabase(), fe);
        }
        return collVO;
    }

    public Collection getAllProtocols(Long protocoltypeId) throws EJBFinderException {
        this.log.info((Object)"getAllProtocolByProtcoltypeid");
        Vector<ProtocolVO> collVO = new Vector<ProtocolVO>();
        Protocol protocolEO = null;
        ProtocolVO protocolVO = null;
        try {
            Collection collEO = this.protocolHome.findByProtocoltypeId(protocoltypeId);
            Iterator it = collEO.iterator();
            while (it.hasNext()) {
                protocolEO = (Protocol)it.next();
                protocolVO = new ProtocolVO(protocolEO, 1);
                collVO.add(protocolVO);
            }
        }
        catch (FinderException fe) {
            fe.printStackTrace();
            collVO = null;
            this.log.error((Object)"EJBFinder Exception");
            EJBExceptionFactory.throwEJBFinderException(GlobalConstants.getDatabase(), fe);
        }
        return collVO;
    }

    public Collection getAllProtocols(String protocoltype) throws EJBFinderException {
        this.log.info((Object)"getAllProtocolByProtcoltypeid");
        Vector<ProtocolVO> collVO = new Vector<ProtocolVO>();
        Protocol protocolEO = null;
        ProtocolVO protocolVO = null;
        try {
            Collection collEO = this.protocolHome.findByProtocoltype(protocoltype);
            Iterator it = collEO.iterator();
            while (it.hasNext()) {
                protocolEO = (Protocol)it.next();
                protocolVO = new ProtocolVO(protocolEO, 1);
                collVO.add(protocolVO);
            }
        }
        catch (FinderException fe) {
            fe.printStackTrace();
            collVO = null;
            this.log.error((Object)"EJBFinder Exception");
            EJBExceptionFactory.throwEJBFinderException(GlobalConstants.getDatabase(), fe);
        }
        return collVO;
    }

    public void editProtocol(ProtocolVO vo) throws EJBFinderException, EJBServerException {
        this.log.info((Object)"editProtocol");
        Protocol protocolEO = null;
        try {
            protocolEO = this.protocolHome.findByPrimaryKey(vo.getId());
            protocolEO.update(vo);
        }
        catch (FinderException fe) {
            vo = null;
            this.log.error((Object)"EJBFinder Exception");
            EJBExceptionFactory.throwEJBFinderException(GlobalConstants.getDatabase(), fe);
        }
    }
}

