/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.marsejb.utils;

import at.tugraz.genome.dbutilities.EJBExceptionFactory;
import at.tugraz.genome.dbutilities.PKGenerator;
import at.tugraz.genome.dbutilities.PKGeneratorFactory;
import at.tugraz.genome.dbutilities.exception.EJBCreateException;
import at.tugraz.genome.dbutilities.exception.EJBFinderException;
import at.tugraz.genome.dbutilities.exception.EJBServerException;
import at.tugraz.genome.dbutilities.exception.ForeignKeyException;
import at.tugraz.genome.dbutilities.exception.UniqueException;
import at.tugraz.genome.marsejb.exception.ValidationException;
import at.tugraz.genome.marsejb.utils.GlobalConstants;
import at.tugraz.genome.marsejb.utils.ejb.Provider;
import at.tugraz.genome.marsejb.utils.ejb.ProviderHome;
import at.tugraz.genome.marsejb.utils.vo.ProviderVO;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class ProviderSBBean
implements SessionBean {
    SessionContext sessionContext;
    Logger log = null;
    ProviderHome providerHome = null;
    Context ctx = null;

    public void ejbCreate() throws CreateException, EJBServerException {
        this.log = Logger.getLogger((String)"ProviderSB");
        try {
            this.ctx = new InitialContext();
            this.providerHome = (ProviderHome)this.ctx.lookup("java:comp/env/ejb/Provider");
        }
        catch (NamingException ne) {
            this.log.error((Object)"Naming Exception");
            EJBExceptionFactory.throwEJBServerException(GlobalConstants.getDatabase(), ne);
        }
    }

    public void ejbRemove() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    public ProviderVO addProvider(ProviderVO vo) throws UniqueException, ForeignKeyException, EJBCreateException {
        this.log.info((Object)"addProvider");
        try {
            ProviderVO dummyProviderVO;
            vo = dummyProviderVO = this.getProvider(vo.getName());
            throw new EJBCreateException("Provider with given name already exists!");
        }
        catch (EJBFinderException finderExc) {
            try {
                PKGenerator pkGenerator = PKGeneratorFactory.getPKGenerator("ORACLE");
                Long pk = pkGenerator.getPrimaryKey("PROVIDER");
                vo.setId(pk);
                this.providerHome.create(vo);
            }
            catch (CreateException ce) {
                this.log.error((Object)"EJBCreateException");
                EJBExceptionFactory.throwEJBCreateExceptions(GlobalConstants.getDatabase(), ce);
            }
            catch (ValidationException ve) {
                this.log.error((Object)"EJBFinder Exception");
                EJBExceptionFactory.throwEJBCreateExceptions(GlobalConstants.getDatabase(), ve.getMessage());
            }
            return vo;
        }
    }

    public ProviderVO getProvider(Long id) throws EJBFinderException {
        this.log.info((Object)("getProvider" + id));
        Provider providerEO = null;
        if (id == null) {
            return null;
        }
        try {
            providerEO = this.providerHome.findByPrimaryKey(id);
        }
        catch (FinderException fe) {
            providerEO = null;
            this.log.error((Object)"EJBFinder Exception");
            EJBExceptionFactory.throwEJBFinderException(GlobalConstants.getDatabase(), fe);
        }
        return new ProviderVO(providerEO);
    }

    public Collection getAllProviders() throws EJBFinderException {
        this.log.info((Object)"getAllProviders");
        Vector<ProviderVO> collVO = new Vector<ProviderVO>();
        Provider providerEO = null;
        ProviderVO providerVO = null;
        try {
            Collection collEO = this.providerHome.findAll();
            Iterator it = collEO.iterator();
            while (it.hasNext()) {
                providerEO = (Provider)it.next();
                providerVO = new ProviderVO(providerEO);
                collVO.add(providerVO);
            }
        }
        catch (FinderException fe) {
            collVO = null;
            this.log.error((Object)"EJBFinder Exception");
            EJBExceptionFactory.throwEJBFinderException(GlobalConstants.getDatabase(), fe);
        }
        return collVO;
    }

    public ProviderVO editProvider(ProviderVO vo) throws EJBFinderException {
        this.log.info((Object)"editProvider");
        Provider providerEO = null;
        try {
            providerEO = this.providerHome.findByPrimaryKey(vo.getId());
            providerEO.update(vo);
        }
        catch (FinderException fe) {
            vo = null;
            this.log.error((Object)"EJBFinder Exception");
            EJBExceptionFactory.throwEJBFinderException(GlobalConstants.getDatabase(), fe);
        }
        return vo;
    }

    public ProviderVO getProvider(String name) throws EJBFinderException {
        this.log.info((Object)("getProvider: " + name));
        Provider providerEO = null;
        if (name == null) {
            return null;
        }
        try {
            Connection con = null;
            DataSource ds = (DataSource)this.ctx.lookup("java:comp/env/jdbc/DefaultDS");
            con = ds.getConnection();
            PreparedStatement ps = con.prepareStatement("SELECT id FROM PROVIDER WHERE UPPER(name) = ?");
            ps.setString(1, name.toUpperCase());
            ResultSet rs = ps.executeQuery();
            Long providerID = null;
            while (rs.next()) {
                providerID = new Long(rs.getLong(1));
            }
            rs.close();
            ps.close();
            con.close();
            providerEO = this.providerHome.findByPrimaryKey(providerID);
        }
        catch (FinderException fe) {
            providerEO = null;
            this.log.error((Object)"EJBFinder Exception");
            EJBExceptionFactory.throwEJBFinderException(GlobalConstants.getDatabase(), fe);
        }
        catch (NamingException namingExc) {
            providerEO = null;
            this.log.error((Object)"EJBNaming Exception");
            EJBExceptionFactory.throwEJBFinderException(GlobalConstants.getDatabase(), namingExc.getMessage());
        }
        catch (SQLException sqlExc) {
            providerEO = null;
            this.log.error((Object)"SQL - Exception");
            EJBExceptionFactory.throwEJBFinderException(GlobalConstants.getDatabase(), sqlExc.getMessage());
        }
        return new ProviderVO(providerEO);
    }
}

