/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.tma.AlgorithmAdapter;

import at.tugraz.genome.tma.ejb.vos.PunchVO;
import at.tugraz.genome.tma.ejb.vos.PunchimageVO;
import at.tugraz.genome.tma.exceptions.TmaGlobalException;
import com.sun.media.jai.codec.ByteArraySeekableStream;
import com.sun.media.jai.codec.TIFFDecodeParam;
import java.awt.image.BufferedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;

public class AlgorithmAdapterPunchData {
    private Hashtable punchimageVOs = null;
    private PunchVO punchvo = null;

    public AlgorithmAdapterPunchData(PunchVO punchvo) throws TmaGlobalException {
        Hashtable<Long, PunchimageVO> newPunchimageVOs = new Hashtable<Long, PunchimageVO>();
        Collection punchimages = punchvo.getPunchimages();
        if (punchimages.isEmpty()) {
            throw new TmaGlobalException("No Punchimages ! 1");
        }
        Iterator iter = punchimages.iterator();
        while (iter.hasNext()) {
            PunchimageVO punchimagevo = (PunchimageVO)iter.next();
            newPunchimageVOs.put(punchimagevo.getPunchimageId(), punchimagevo);
        }
        this.punchimageVOs = newPunchimageVOs;
        this.punchvo = punchvo;
    }

    public Hashtable getBufferedImages() throws TmaGlobalException {
        Hashtable<String, Object> image_table = new Hashtable<String, Object>();
        if (this.punchimageVOs == null || this.punchimageVOs.isEmpty()) {
            throw new TmaGlobalException("No Punchimages !");
        }
        try {
            Enumeration enumeration = this.punchimageVOs.elements();
            while (enumeration.hasMoreElements()) {
                PunchimageVO image_vo = (PunchimageVO)enumeration.nextElement();
                String imagename = image_vo.getImagename();
                String image_color = null;
                int startindex = imagename.indexOf("COLOR") + 5;
                int stopindex = imagename.indexOf(".tif");
                image_color = imagename.substring(startindex, stopindex);
                byte[] byte_array = image_vo.getImage();
                ByteArraySeekableStream stream = null;
                stream = new ByteArraySeekableStream(byte_array);
                ParameterBlock params = new ParameterBlock();
                params.add(stream);
                TIFFDecodeParam decode_param = new TIFFDecodeParam();
                decode_param.setDecodePaletteAsShorts(true);
                RenderedOp rendered_op = JAI.create((String)"tiff", (ParameterBlock)params);
                String[] property_names = rendered_op.getPropertyNames();
                int array_length = property_names.length;
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                int hash_count = 0;
                while (hash_count < array_length) {
                    hashtable.put(property_names[hash_count], rendered_op.getProperty(property_names[hash_count]));
                    ++hash_count;
                }
                BufferedImage buff_image = new BufferedImage(rendered_op.getColorModel(), rendered_op.copyData(), false, hashtable);
                String image_key = image_color + "image";
                String id_key = image_color + "ID";
                image_table.put(image_key, buff_image);
                image_table.put(id_key, image_vo.getPunchimageId());
            }
            return image_table;
        }
        catch (Exception exc) {
            throw new TmaGlobalException(exc.getMessage());
        }
    }

    public PunchVO getPunchVO() {
        return this.punchvo;
    }

    public ArrayList getPunchimageVOs(Long[] punchimageIds) {
        ArrayList punchimageArrayList = new ArrayList();
        int count = 0;
        while (count < punchimageIds.length) {
            punchimageArrayList.add(this.punchimageVOs.get(punchimageIds[count]));
            ++count;
        }
        return punchimageArrayList;
    }
}

