/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.tma;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.JPanel;

class BufferedImagePanel
extends JPanel {
    private boolean DEBUG = true;
    private BufferedImage image_ = null;
    Vector neighbour_vector_ = null;
    private double scale_ = 0.0;
    private int[] sorted_col_array_ = null;
    private int[] sorted_row_array_ = null;
    private int[] translation_vec_ = null;

    public BufferedImagePanel(BufferedImage bufi) {
        this.setImage(bufi);
    }

    public void paintChildren(Graphics g) {
        System.err.println("BufferedImagePanel.paintChildren: " + g + " / " + this.image_);
        Graphics2D g2d = (Graphics2D)g;
        if (this.image_ != null) {
            float draw_width = this.getBounds().width;
            float draw_height = this.getBounds().height;
            this.scale_ = draw_width / (float)this.image_.getWidth() < draw_height / (float)this.image_.getHeight() ? (double)(draw_width / (float)this.image_.getWidth()) : (double)(draw_height / (float)this.image_.getHeight());
            System.err.println("Canvas: " + this.getBounds().width + "/" + this.getBounds().height + " - " + this.scale_);
            g2d.scale(this.scale_, this.scale_);
            g2d.drawImage(this.image_, null, 0, 0);
        }
        if (this.sorted_row_array_ != null && this.sorted_col_array_ != null) {
            g2d.setColor(Color.RED);
            int row_count = 0;
            while (row_count < this.sorted_row_array_.length) {
                g2d.drawLine(0, this.sorted_row_array_[row_count], this.image_.getWidth(), this.sorted_row_array_[row_count]);
                ++row_count;
            }
            int col_count = 0;
            while (col_count < this.sorted_col_array_.length) {
                g2d.drawLine(this.sorted_col_array_[col_count], 0, this.sorted_col_array_[col_count], this.image_.getHeight());
                ++col_count;
            }
        }
        if (this.neighbour_vector_ != null) {
            int[] neighbour_array = null;
            int vector_index = 0;
            while (vector_index < this.neighbour_vector_.size()) {
                g2d.setColor(Color.BLUE);
                Object elem = this.neighbour_vector_.get(vector_index);
                if (elem instanceof int[]) {
                    neighbour_array = (int[])elem;
                    int width = Math.abs(neighbour_array[2] - neighbour_array[3]);
                    int height = Math.abs(neighbour_array[0] - neighbour_array[1]);
                    g2d.drawOval(neighbour_array[2] + 5, neighbour_array[0] + 5, width - 10, height - 10);
                    g2d.setColor(Color.BLUE);
                    g2d.drawOval(neighbour_array[2] + width / 2, neighbour_array[0] + height / 2, 10, 10);
                } else {
                    if (this.translation_vec_ != null) {
                        g2d.translate(this.translation_vec_[0], this.translation_vec_[1]);
                    }
                    if (!(elem instanceof Polygon)) {
                        g2d.setColor(Color.BLACK);
                    }
                    g2d.draw((Shape)elem);
                }
                ++vector_index;
            }
        } else {
            System.err.println("No neighbour vector");
        }
    }

    public void setImage(BufferedImage bufi) {
        System.err.println("BufferedImagePanel: " + bufi);
        this.image_ = bufi;
    }

    public void setLineCoordinates(int[] rows, int[] cols) {
        this.sorted_row_array_ = new int[rows.length];
        System.arraycopy(rows, 0, this.sorted_row_array_, 0, rows.length);
        this.sorted_col_array_ = new int[cols.length];
        System.arraycopy(cols, 0, this.sorted_col_array_, 0, cols.length);
        if (this.DEBUG) {
            // empty if block
        }
    }

    public void setNeighbourVector(Vector neighbour_vector) {
        this.neighbour_vector_ = neighbour_vector;
        if (this.DEBUG) {
            System.err.println("neighbour_vector: " + this.neighbour_vector_.size());
        }
    }

    public void setTranslation(int[] trans) {
        this.translation_vec_ = new int[trans.length];
        System.arraycopy(trans, 0, this.translation_vec_, 0, trans.length);
    }
}

