/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.tma;

import at.tugraz.genome.tma.CircledShapeIterator;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;

public class CircledShape
extends Ellipse2D.Double {
    public static final int BACKSLASH = 2;
    public static final int CROSS = 0;
    public static final int OUTERCROSS = 3;
    public static final int SLASH = 1;
    private Line2D.Double[] lines_ = null;
    private int type_ = 0;

    public CircledShape(double x, double y, double w, double h, int type) {
        super(x, y, w, h);
        this.type_ = type;
        double radius = w / 2.0;
        double offset = radius - radius / Math.sqrt(2.0);
        switch (type) {
            case 0: 
            case 1: 
            case 2: {
                this.lines_ = new Line2D.Double[2];
                this.lines_[0] = new Line2D.Double(x + offset, y + offset, x + w - offset, y + h - offset);
                this.lines_[1] = new Line2D.Double(x + w - offset, y + offset, x + offset, y + h - offset);
                if (type == 1) {
                    this.lines_[0] = new Line2D.Double(x, y, x, y);
                }
                if (type != 2) break;
                this.lines_[1] = new Line2D.Double(x, y, x, y);
                break;
            }
            case 3: {
                this.lines_ = new Line2D.Double[4];
                this.lines_[0] = new Line2D.Double(x, y, x + offset, y + offset);
                this.lines_[1] = new Line2D.Double(x + w - offset, y + h - offset, x + w, y + h);
                this.lines_[2] = new Line2D.Double(x + w, y, x + w - offset, y + offset);
                this.lines_[3] = new Line2D.Double(x, y + h, x + offset, y + h - offset);
                break;
            }
        }
    }

    public CircledShape() {
    }

    public Line2D.Double[] getLines() {
        return this.lines_;
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return new CircledShapeIterator(this, at);
    }
}

