/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.tma;

import at.tugraz.genome.tma.CircledShape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.util.NoSuchElementException;

public class CircledShapeIterator
implements PathIterator {
    private static final double a = 1.0 - Math.cos(0.7853981633974483);
    private AffineTransform affine;
    private static final double angle = 0.7853981633974483;
    private static final double b = Math.tan(0.7853981633974483);
    private static final double c = Math.sqrt(1.0 + b * b) - 1.0 + a;
    private static double[][] ctrlpts;
    private static final double cv;
    private int end_index_;
    private double h;
    private int index_;
    private double[] line_coords_x_ = null;
    private double[] line_coords_y_ = null;
    private int num_segments_;
    private double w;
    private double x;
    private double y;

    static {
        cv = 1.3333333333333333 * a * b / c;
        ctrlpts = new double[][]{{1.0, cv, cv, 1.0, 0.0, 1.0}, {-cv, 1.0, -1.0, cv, -1.0, 0.0}, {-1.0, -cv, -cv, -1.0, 0.0, -1.0}, {cv, -1.0, 1.0, -cv, 1.0, 0.0}};
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 6) {
                CircledShapeIterator.ctrlpts[i][j] = ctrlpts[i][j] * 0.5 + 0.5;
                ++j;
            }
            ++i;
        }
    }

    CircledShapeIterator(CircledShape e, AffineTransform at) {
        this.x = e.getX();
        this.y = e.getY();
        this.w = e.getWidth();
        this.h = e.getHeight();
        this.affine = at;
        Line2D.Double[] lines = e.getLines();
        this.num_segments_ = lines.length * 2;
        this.line_coords_x_ = new double[this.num_segments_];
        this.line_coords_y_ = new double[this.num_segments_];
        int i = 0;
        while (i < lines.length) {
            this.line_coords_x_[i * 2] = lines[i].getP1().getX();
            this.line_coords_x_[i * 2 + 1] = lines[i].getP2().getX();
            this.line_coords_y_[i * 2] = lines[i].getP1().getY();
            this.line_coords_y_[i * 2 + 1] = lines[i].getP2().getY();
            ++i;
        }
        this.end_index_ = this.num_segments_ + 5;
        if (this.w < 0.0 || this.h < 0.0) {
            this.index_ = this.end_index_ + 1;
        }
    }

    public int currentSegment(double[] coords) {
        if (this.isDone()) {
            throw new NoSuchElementException("circle shape iterator out of bounds");
        }
        if (this.index_ == this.end_index_) {
            return 4;
        }
        int seg_type = 0;
        if (this.index_ < this.num_segments_) {
            coords[0] = this.line_coords_x_[this.index_];
            coords[1] = this.line_coords_y_[this.index_];
            if (this.index_ % 2 == 1) {
                seg_type = 1;
            }
            if (this.affine != null) {
                this.affine.transform(coords, 0, coords, 0, 1);
            }
            return seg_type;
        }
        int ell_index = this.index_ - this.num_segments_;
        if (ell_index == 0) {
            double[] ctrls = ctrlpts[3];
            coords[0] = this.x + ctrls[4] * this.w;
            coords[1] = this.y + ctrls[5] * this.h;
            if (this.affine != null) {
                this.affine.transform(coords, 0, coords, 0, 1);
            }
            return 0;
        }
        double[] ctrls = ctrlpts[ell_index - 1];
        coords[0] = this.x + ctrls[0] * this.w;
        coords[1] = this.y + ctrls[1] * this.h;
        coords[2] = this.x + ctrls[2] * this.w;
        coords[3] = this.y + ctrls[3] * this.h;
        coords[4] = this.x + ctrls[4] * this.w;
        coords[5] = this.y + ctrls[5] * this.h;
        if (this.affine != null) {
            this.affine.transform(coords, 0, coords, 0, 3);
        }
        return 3;
    }

    public int currentSegment(float[] coords) {
        if (this.isDone()) {
            throw new NoSuchElementException("circled shape iterator out of bounds");
        }
        if (this.index_ == this.end_index_) {
            return 4;
        }
        int seg_type = 0;
        if (this.index_ < this.num_segments_) {
            coords[0] = (float)this.line_coords_x_[this.index_];
            coords[1] = (float)this.line_coords_y_[this.index_];
            if (this.index_ % 2 == 1) {
                seg_type = 1;
            }
            if (this.affine != null) {
                this.affine.transform(coords, 0, coords, 0, 1);
            }
            return seg_type;
        }
        int ell_index = this.index_ - this.num_segments_;
        if (ell_index == 0) {
            double[] ctrls = ctrlpts[3];
            coords[0] = (float)(this.x + ctrls[4] * this.w);
            coords[1] = (float)(this.y + ctrls[5] * this.h);
            if (this.affine != null) {
                this.affine.transform(coords, 0, coords, 0, 1);
            }
            return 0;
        }
        double[] ctrls = ctrlpts[ell_index - 1];
        coords[0] = (float)(this.x + ctrls[0] * this.w);
        coords[1] = (float)(this.y + ctrls[1] * this.h);
        coords[2] = (float)(this.x + ctrls[2] * this.w);
        coords[3] = (float)(this.y + ctrls[3] * this.h);
        coords[4] = (float)(this.x + ctrls[4] * this.w);
        coords[5] = (float)(this.y + ctrls[5] * this.h);
        if (this.affine != null) {
            this.affine.transform(coords, 0, coords, 0, 3);
        }
        return 3;
    }

    public int getWindingRule() {
        return 1;
    }

    public boolean isDone() {
        return this.index_ > this.end_index_;
    }

    public void next() {
        ++this.index_;
    }
}

