/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.tma;

import at.tugraz.genome.tma.BufferedImagePanel;
import at.tugraz.genome.tma.CircledShape;
import at.tugraz.genome.tma.ImageUtils;
import com.sun.media.jai.codec.ByteArraySeekableStream;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.media.jai.JAI;
import javax.media.jai.RenderedImageAdapter;
import javax.media.jai.RenderedOp;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.devlib.schmidt.imageinfo.ImageInfoHelper;

public class DisplayDonor {
    private String out_filename_ = null;
    private int[] radius_ = null;
    private int[] x_ = null;
    private int[] y_ = null;

    public BufferedImage drawPunches(BufferedImage bi, PunchInfo[] punch_info, double scale_factor, double resolution) {
        Graphics2D g2d = bi.createGraphics();
        PunchInfo punch = null;
        int diameter = 0;
        this.radius_ = new int[punch_info.length];
        this.x_ = new int[punch_info.length];
        this.y_ = new int[punch_info.length];
        int index = 0;
        while (index < punch_info.length) {
            punch = punch_info[index];
            diameter = (int)(punch.getDiameter() * resolution / 25.4);
            this.radius_[index] = diameter / 2;
            this.x_[index] = (int)(scale_factor * (double)punch.getX());
            this.y_[index] = (int)(scale_factor * (double)punch.getY());
            CircledShape cs = new CircledShape(this.x_[index] - this.radius_[index], this.y_[index] - this.radius_[index], diameter, diameter, 3);
            g2d.setColor(Color.BLACK);
            g2d.draw(cs);
            ++index;
        }
        return bi;
    }

    public String getDonorImageWithPunches(byte[] image, PunchInfo[] punch_info, double scale_factor) throws IOException {
        ByteArraySeekableStream ss = new ByteArraySeekableStream(image);
        double resolution = ImageInfoHelper.getResolution((InputStream)ss);
        ParameterBlock pb = new ParameterBlock();
        pb.add(ss);
        RenderedOp ri = JAI.create((String)"stream", (ParameterBlock)pb);
        return this.getDonorImageWithPunches((RenderedImage)ri, punch_info, scale_factor, resolution);
    }

    public String getDonorImageWithPunches(RenderedImage ri, PunchInfo[] punch_info, double scale_factor, double resolution) {
        String suffix = "jpeg";
        File tempFile = null;
        try {
            String prefix = "jfreechart-onetime-";
            tempFile = File.createTempFile(prefix, "." + suffix, new File(System.getProperty("java.io.tmpdir")));
            RenderedImageAdapter ria = new RenderedImageAdapter(ri);
            BufferedImage bi = ria.getAsBufferedImage();
            ImageIO.write((RenderedImage)this.drawPunches(bi, punch_info, scale_factor, resolution), suffix, tempFile);
            this.out_filename_ = tempFile.getName();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return this.out_filename_;
    }

    public String getImageMap(String[] tool_tips, int tip_width) {
        StringBuffer map = new StringBuffer("<MAP name=\"" + this.out_filename_ + "\">\n");
        int i = 0;
        while (i < tool_tips.length) {
            map.append("  <AREA shape=\"circle\" coords=\"");
            map.append(this.x_[i] + "," + this.y_[i] + "," + this.radius_[i] + "\" ");
            map.append("onmouseover=\"this.T_WIDTH=" + tip_width + ";return escape('");
            map.append(tool_tips[i] + "')\" />\n");
            ++i;
        }
        map.append("</MAP>");
        return map.toString();
    }

    public static void main(String[] args) throws HeadlessException {
        String filename1 = "documentation/donor_images/0000000000628.jpg";
        double dpi1 = 1400.0;
        double scale_factor1 = 1.0;
        int[][] punch_info1 = new int[][]{{0, 287, 272}, {1, 360, 255}, {2, 238, 323}};
        String filename2 = "documentation/donor_images/0000000012560.jpg";
        double dpi2 = 1400.0;
        double scale_factor2 = 1.0;
        int[][] punch_info2 = new int[][]{{0, 342, 554}, {1, 356, 612}, {2, 402, 563}, {3, 409, 634}};
        String filename = "documentation/donor_images/0000000000628 small.jpg";
        double dpi = 700.0;
        double scale_factor = 0.5;
        int[][] punch_info = new int[][]{{0, 287, 272}, {1, 360, 255}, {2, 238, 323}};
        double res_factor = dpi / 25.4;
        double punch_offset_mm = 1.0;
        int punch_offset_px = (int)(punch_offset_mm * res_factor);
        double punch_diameter_mm = 0.7;
        int punch_diameter_px = (int)(punch_diameter_mm * res_factor);
        Vector<CircledShape> punches = new Vector<CircledShape>();
        PunchInfo[] pia = new PunchInfo[punch_info.length];
        String[] tool_tips = new String[punch_info.length];
        int i = 0;
        while (i < punch_info.length) {
            pia[i] = new PunchInfo(punch_info[i][1], punch_info[i][2], punch_info[i][0], punch_diameter_mm);
            punches.add(new CircledShape(punch_info[i][1] - punch_diameter_px / 2, punch_info[i][2] - punch_diameter_px / 2, punch_diameter_px, punch_diameter_px, 3));
            tool_tips[i] = new String("Punch " + i + ": " + punch_info[i][1] + "," + punch_info[i][2]);
            ++i;
        }
        JFrame frame = new JFrame(filename);
        DisplayDonor dd = new DisplayDonor();
        try {
            BufferedImage bufi = null;
            RenderedOp ri = null;
            ParameterBlock pb = new ParameterBlock();
            pb.add(filename);
            ri = JAI.create((String)"fileload", (ParameterBlock)pb);
            System.err.println("ImageMetadata: " + ri.getProperty("JAI.ImageMetadata").getClass());
            System.err.println("ImageMetadata: " + ri.getProperty("ximage_width"));
            RenderedImageAdapter ria = new RenderedImageAdapter((RenderedImage)ri);
            bufi = ria.getAsBufferedImage();
            System.err.println("Image: " + bufi.getWidth() + "/" + bufi.getHeight());
            double resolution = ImageInfoHelper.getResolution(filename);
            System.err.println("------------------------ call with RenderedImage");
            String fname = dd.getDonorImageWithPunches((RenderedImage)ri, pia, scale_factor, resolution);
            System.err.println(dd.getImageMap(tool_tips, 180));
            byte[] image_data = ImageUtils.loadBytesFromFile(new File(filename));
            System.err.println("---------------------- call with Stream");
            fname = dd.getDonorImageWithPunches(image_data, pia, scale_factor);
            BufferedImagePanel bip = new BufferedImagePanel(null);
            bip.setImage(dd.drawPunches(bufi, pia, scale_factor, dpi));
            ((Component)frame).setSize(1200, 800);
            frame.setDefaultCloseOperation(3);
            JScrollPane scrollpane = new JScrollPane(bip);
            Container content = frame.getContentPane();
            content.add(scrollpane);
            ((Component)frame).setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static class PunchInfo {
        private double core_diameter_;
        private int core_index_;
        private int core_x_;
        private int core_y_;

        public PunchInfo(int x, int y, int index, double diameter) {
            this.core_x_ = x;
            this.core_y_ = y;
            this.core_index_ = index;
            this.core_diameter_ = diameter;
        }

        public double getDiameter() {
            return this.core_diameter_;
        }

        public int getIndex() {
            return this.core_index_;
        }

        public int getX() {
            return this.core_x_;
        }

        public int getY() {
            return this.core_y_;
        }
    }
}

