/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.tma;

import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import com.sun.media.jai.codec.ByteArraySeekableStream;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codec.TIFFDecodeParam;
import com.sun.media.jai.codec.TIFFDirectory;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import org.devlib.schmidt.imageinfo.ImageInfo;

public class ImageUtils {
    private static double calcScaleFactor(BufferedImage image, Dimension new_dim) {
        double scaleX = new_dim.getWidth() / (double)image.getWidth();
        double scaleY = new_dim.getHeight() / (double)image.getHeight();
        double scale = Math.min(scaleX, scaleY);
        return scale;
    }

    public static byte[] encodeJPEG(BufferedImage bi, float quality, int[] resolution) throws ImageFormatException, IOException {
        JPEGEncodeParam jpeg_params = null;
        ByteArrayOutputStream jpegObjStream = new ByteArrayOutputStream();
        JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)jpegObjStream);
        jpeg_params = encoder.getDefaultJPEGEncodeParam(bi);
        jpeg_params.setQuality(quality, true);
        jpeg_params.setDensityUnit(1);
        jpeg_params.setXDensity(resolution[0]);
        jpeg_params.setYDensity(resolution[1]);
        encoder.encode(bi, jpeg_params);
        jpegObjStream.flush();
        return jpegObjStream.toByteArray();
    }

    public static String getFilenameExtension(String imagename) {
        String extension = "";
        int pos = (imagename = imagename.trim().toLowerCase()).lastIndexOf(".");
        if (pos >= 0) {
            extension = imagename.substring(pos + 1);
        }
        return extension;
    }

    public static int[] getJPEGResolution(InputStream image) {
        int[] res = new int[]{0, 0};
        ImageInfo image_info_ = new ImageInfo();
        image_info_.setInput(image);
        if (!image_info_.check()) {
            System.err.println("Not a supported image file format.");
        } else {
            res[0] = image_info_.getPhysicalWidthDpi();
            res[1] = image_info_.getPhysicalHeightDpi();
        }
        return res;
    }

    public static int[] getTIFFResolution(SeekableStream image) {
        int[] res = new int[]{0, 0};
        int TIFF_FIELD_RESOLUTION_UNIT = 296;
        int TIFF_FIELD_X_RESOLUTION = 282;
        int TIFF_FIELD_Y_RESOLUTION = 282;
        try {
            TIFFDirectory td = new TIFFDirectory(image, 0);
            int resolution_unit = td.getField(296).getAsInt(0);
            double resolution_factor = 1.0;
            switch (resolution_unit) {
                case 2: {
                    resolution_factor = 1.0;
                    break;
                }
                case 3: {
                    resolution_factor = 2.54;
                    break;
                }
                default: {
                    System.err.println("Unrecognized resolution unit: " + resolution_unit);
                    resolution_factor = 0.0;
                }
            }
            res[0] = (int)(td.getField(282).getAsDouble(0) * resolution_factor);
            res[1] = (int)(td.getField(282).getAsDouble(0) * resolution_factor);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return res;
    }

    public static byte[] loadBytesFromFile(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        byte[] bytes = new byte[(int)length];
        int offset = 0;
        int numRead = 0;
        while (offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0) {
            offset += numRead;
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }

    public static void main(String[] args) {
        System.err.println("Ext: " + ImageUtils.getFilenameExtension("image.tif.tiff"));
        System.err.println("Ext: " + ImageUtils.getFilenameExtension("image-tif-tiff"));
        System.err.println("Ext: " + ImageUtils.getFilenameExtension("image.tif"));
        System.err.println("Ext: " + ImageUtils.getFilenameExtension("image."));
        System.err.println("Ext: " + ImageUtils.getFilenameExtension(""));
        String input_file = "documentation/donor_images/0000000000628.jpg";
        String output_file = "0000000000628 small.jpg";
        String tiff_file = "documentation/section_images/csa2_exp4_ck1zu100_6.tif";
        tiff_file = "csa2_exp4_ck1zu100_6.tif";
        String output_file2 = "csa2_exp4_ck1zu100_6 small.jpg";
        Dimension size = new Dimension(820, 650);
        Float[] scale = new Float[1];
        try {
            byte[] ba = ImageUtils.scaleJPEGToJPEG(ImageUtils.loadBytesFromFile(new File(input_file)), size, 0.4f, scale);
            System.err.println("Scale: " + scale[0]);
            ImageUtils.saveBytesToFile(new File(output_file), ba);
            ba = ImageUtils.scaleTIFFToJPEG(ImageUtils.loadBytesFromFile(new File(tiff_file)), size, 0.4f, scale);
            System.err.println("Scale: " + scale[0]);
            ImageUtils.saveBytesToFile(new File(output_file2), ba);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void saveBytesToFile(File file, byte[] byte_array) throws FileNotFoundException, IOException {
        FileOutputStream os = new FileOutputStream(file);
        ((OutputStream)os).write(byte_array);
        ((OutputStream)os).close();
    }

    public static byte[] scaleAndSave(BufferedImage bi, Dimension new_dim, float quality, int[] resolution, Float[] scale_factor) throws ImageFormatException, IOException {
        System.err.println("Res: " + resolution[0] + "/" + resolution[1]);
        double scale = ImageUtils.calcScaleFactor(bi, new_dim);
        scale_factor[0] = new Float(ImageUtils.calcScaleFactor(bi, new_dim));
        System.err.println("Scale: " + scale_factor[0]);
        BufferedImage scaled_image = ImageUtils.scaleImage(bi, scale);
        resolution[0] = (int)((double)resolution[0] * scale);
        resolution[1] = (int)((double)resolution[1] * scale);
        return ImageUtils.encodeJPEG(scaled_image, quality, resolution);
    }

    public static BufferedImage scaleImage(BufferedImage bi, double scale) {
        BufferedImage scaled_image = bi;
        if (scale < 1.0) {
            AffineTransformOp op = new AffineTransformOp(AffineTransform.getScaleInstance(scale, scale), null);
            scaled_image = op.filter(bi, null);
        }
        return scaled_image;
    }

    public static byte[] scaleJPEGToJPEG(byte[] image, Dimension new_dim, float quality, Float[] scale_factor) throws ImageFormatException, IOException {
        ParameterBlock params = new ParameterBlock();
        ByteArraySeekableStream bass = new ByteArraySeekableStream(image);
        params.add(bass);
        RenderedOp jpegobj = JAI.create((String)"jpeg", (ParameterBlock)params);
        BufferedImage bi = jpegobj.getAsBufferedImage();
        bass.seek(0L);
        int[] resolution = ImageUtils.getJPEGResolution((InputStream)bass);
        return ImageUtils.scaleAndSave(bi, new_dim, quality, resolution, scale_factor);
    }

    public static byte[] scaleTIFFToJPEG(byte[] image, Dimension new_dim, float quality, Float[] scale_factor) throws ImageFormatException, IOException {
        TIFFDecodeParam decodeParam = null;
        ParameterBlock params = new ParameterBlock();
        ByteArraySeekableStream bass = new ByteArraySeekableStream(image);
        params.add(bass);
        decodeParam = new TIFFDecodeParam();
        decodeParam.setDecodePaletteAsShorts(true);
        RenderedOp tiffobj = JAI.create((String)"tiff", (ParameterBlock)params);
        BufferedImage bi = tiffobj.getAsBufferedImage();
        bass.seek(0L);
        int[] resolution = ImageUtils.getTIFFResolution((SeekableStream)bass);
        return ImageUtils.scaleAndSave(bi, new_dim, quality, resolution, scale_factor);
    }
}

