/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.tma;

import at.tugraz.genome.tma.ExtXYPlot;
import at.tugraz.genome.tma.TMAGrid;
import at.tugraz.genome.tma.TMAToolTipTagFragmentGenerator;
import at.tugraz.genome.tma.TMAURLTagFragmentGenerator;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Window;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.servlet.http.HttpSession;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.imagemap.ToolTipTagFragmentGenerator;
import org.jfree.chart.imagemap.URLTagFragmentGenerator;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.servlet.ServletUtilities;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.Range;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.RefineryUtilities;

public class VirtualTMA {
    private String image_map_ = null;

    private double calcPixel(double pix, Range range) {
        return pix / range.getLength();
    }

    public JFreeChart drawTMA(TMAGrid tma, Dimension size, boolean bShowLegend, boolean bFillCores) {
        HashMap<String, XYSeries> map = new HashMap<String, XYSeries>();
        String[] tma_row = null;
        XYSeries coords = null;
        String[][] tma_grid = tma.getGrid();
        int irows = tma.getNumRows();
        int icols = tma.getNumColumns();
        double aspect_canvas = size.getWidth() / size.getHeight();
        double aspect_tma = (double)icols / (double)irows;
        RectangleEdge legend_pos = RectangleEdge.RIGHT;
        if (aspect_tma > aspect_canvas) {
            legend_pos = RectangleEdge.BOTTOM;
        }
        int i = 0;
        while (i < irows) {
            tma_row = tma_grid[i];
            int j = 0;
            while (j < icols) {
                String key = tma_row[j];
                if (key.length() > 0) {
                    if (!map.containsKey(key)) {
                        coords = new XYSeries((Comparable)((Object)key));
                        map.put(key, coords);
                    } else {
                        coords = (XYSeries)map.get(key);
                    }
                    coords.add((double)(j + 1), (double)(i + 1));
                }
                ++j;
            }
            ++i;
        }
        JFreeChart tma_chart = null;
        tma_chart = new JFreeChart("", (Plot)new ExtXYPlot());
        tma_chart.getXYPlot().setRangeAxis((ValueAxis)new NumberAxis());
        tma_chart.getXYPlot().setDomainAxis((ValueAxis)new NumberAxis());
        ExtXYPlot plot = (ExtXYPlot)tma_chart.getXYPlot();
        String[] keys = new String[map.size()];
        map.keySet().toArray(keys);
        XYSeriesCollection xy_coll = new XYSeriesCollection();
        XYLineAndShapeRenderer group_renderer = new XYLineAndShapeRenderer();
        group_renderer.setToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator());
        group_renderer.setSeriesPaint(0, (Paint)Color.black);
        int i2 = 0;
        while (i2 < keys.length) {
            xy_coll.addSeries((XYSeries)map.get(keys[i2]));
            ++i2;
        }
        plot.setDataset((XYDataset)xy_coll);
        plot.setRenderer((XYItemRenderer)group_renderer);
        group_renderer.setShapesFilled(bFillCores);
        group_renderer.setBaseLinesVisible(false);
        group_renderer.setShape(Plot.DEFAULT_LEGEND_ITEM_CIRCLE);
        System.err.println(Plot.DEFAULT_LEGEND_ITEM_CIRCLE.getBounds2D());
        NumberAxis range_axis = (NumberAxis)plot.getRangeAxis();
        range_axis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        range_axis.setLabel("Array Row");
        range_axis.setRange(0.4, (double)irows + 0.6);
        range_axis.setInverted(true);
        NumberAxis domain_axis = (NumberAxis)plot.getDomainAxis();
        domain_axis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        domain_axis.setLabel("Array Column");
        domain_axis.setRange(0.4, (double)icols + 0.6);
        plot.setDomainAxisLocation(AxisLocation.TOP_OR_RIGHT);
        LegendTitle tma_legend = tma_chart.getLegend();
        tma_legend.setPosition(legend_pos);
        if (!bShowLegend) {
            tma_chart.removeLegend();
        }
        tma_chart.setPadding(new RectangleInsets(0.0, 0.0, 4.0, 0.0));
        plot.setInsets(new RectangleInsets(0.0, 0.0, 4.0, 4.0));
        BufferedImage image = tma_chart.createBufferedImage((int)size.getWidth(), (int)size.getHeight());
        Rectangle2D plot_area = plot.getPlotArea();
        double x_unit = this.calcPixel(plot_area.getWidth(), plot.getDomainAxis().getRange());
        double y_unit = this.calcPixel(plot_area.getHeight(), plot.getRangeAxis().getRange());
        System.err.println(x_unit + " / " + y_unit);
        if (x_unit < y_unit) {
            y_unit = x_unit = Math.floor(x_unit);
        } else {
            x_unit = y_unit = Math.floor(y_unit);
        }
        System.err.println(x_unit + " / " + y_unit);
        double new_width = x_unit * plot.getDomainAxis().getRange().getLength();
        double space_x = (size.getWidth() - new_width) / 2.0;
        double new_height = y_unit * plot.getRangeAxis().getRange().getLength();
        double space_y = (size.getHeight() - new_height) / 2.0;
        double legend_width = size.getWidth() - plot_area.getWidth() - plot_area.getX();
        double legend_height = size.getHeight() - plot_area.getHeight() - plot_area.getY();
        double top_padding = 0.0;
        double left_padding = 0.0;
        double bottom_padding = 8.0;
        double right_padding = 0.0;
        System.err.println("Legend left: " + RectangleEdge.isLeftOrRight((RectangleEdge)legend_pos));
        if (RectangleEdge.isLeftOrRight((RectangleEdge)legend_pos)) {
            bottom_padding = top_padding = (plot_area.getHeight() - new_height) / 2.0;
            if (legend_width < space_x) {
                left_padding = space_x - plot_area.getX();
                right_padding = space_x - legend_width;
            } else {
                left_padding = space_x - plot_area.getX() - (legend_width - space_x);
            }
        } else {
            right_padding = left_padding = (plot_area.getWidth() - new_width) / 2.0;
            if (legend_height < space_y) {
                top_padding = space_y - plot_area.getY();
                bottom_padding = space_y - legend_height;
            } else {
                left_padding = space_x - plot_area.getX() - (legend_width - space_x);
            }
        }
        System.err.println("[" + new_width + "," + new_height + "]   [" + legend_width + "," + legend_height + "]   [" + space_x + "," + space_y + "]   [" + left_padding + "," + right_padding + "]   [" + top_padding + "," + bottom_padding + "]");
        plot.setInsets(new RectangleInsets(0.0, 0.0, 4.0, 4.0));
        tma_chart.setPadding(new RectangleInsets(top_padding, left_padding, bottom_padding, right_padding));
        if (!bShowLegend) {
            double diam = x_unit * tma.getCoreDiameter() / tma.getColumnOffset();
            Ellipse2D.Double core = new Ellipse2D.Double(-diam / 2.0, -diam / 2.0, diam, diam);
            int i3 = 0;
            while (i3 < keys.length) {
                group_renderer.setSeriesShape(i3, (Shape)core);
                ++i3;
            }
        }
        image = tma_chart.createBufferedImage((int)size.getWidth(), (int)size.getHeight());
        plot_area = plot.getPlotArea();
        System.err.println("PlotArea: " + plot_area);
        x_unit = this.calcPixel(plot_area.getWidth(), plot.getDomainAxis().getRange());
        y_unit = this.calcPixel(plot_area.getHeight(), plot.getRangeAxis().getRange());
        System.err.println(x_unit + " / " + y_unit);
        return tma_chart;
    }

    public String getTMALayout(HttpSession session, TMAGrid tma, Dimension size, boolean bShowLegend, boolean bFillCores) {
        JFreeChart chart = this.drawTMA(tma, size, bShowLegend, bFillCores);
        ChartRenderingInfo info = new ChartRenderingInfo((EntityCollection)new StandardEntityCollection());
        String filename = "";
        try {
            filename = ServletUtilities.saveChartAsPNG((JFreeChart)chart, (int)((int)size.getWidth()), (int)((int)size.getHeight()), (ChartRenderingInfo)info, (HttpSession)session);
            this.image_map_ = ChartUtilities.getImageMap((String)filename, (ChartRenderingInfo)info, (ToolTipTagFragmentGenerator)new TMAToolTipTagFragmentGenerator(tma.getToolTips()), (URLTagFragmentGenerator)new TMAURLTagFragmentGenerator());
            System.err.println("Length: " + this.image_map_.length());
            System.err.println("Start: " + this.image_map_.substring(0, 80));
            System.err.println("End: " + this.image_map_.substring(this.image_map_.length() - 40));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return filename;
    }

    public String getTMALayoutMap() {
        return this.image_map_;
    }

    public static void main(String[] args) {
        String[][] tma_desc = new String[][]{{"A", "B", "", "A", "A", "C", "C"}, {"A", "B", "", "A", "A", "C", "C"}, {"", "B", "B", "D", "D", "C", "C"}, {"", "B", "B", "D", "D", "C", "C"}, {"C", "C", "", "A", "A", "C", "C"}, {"C", "C", "", "A", "A", "C", "C"}};
        String[][] tma_desc1 = new String[][]{{"A", "B", "", "A"}, {"A", "B", "", "A"}, {"", "B", "B", "D"}, {"", "B", "B", "D"}, {"C", "C", "", "A"}, {"C", "C", "", "A"}};
        String[][] tma_53 = new String[][]{{"A", "B", "", "A", "D"}, {"A", "B", "", "A", "D"}, {"", "B", "B", "D", "D"}};
        String[][] tma_240 = new String[][]{{"", "", "", "", "O", "", "", "", "O", "", "", "", "", "O", "O"}, {"O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"}, {"O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"}, {"O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"}, {"O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"}, {"O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"}, {"", "", "O", "", "", "", "", "0", "", "O", "", "", "0", "0", ""}, {"O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"}, {"O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"}, {"O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"}, {"O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"}, {"O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"}, {"", "", "O", "O", "O", "", "O", "", "", "", "", "O", "", "", "O"}, {"O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"}, {"O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"}, {"O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"}, {"O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"}, {"O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"}};
        Dimension size = new Dimension(800, 600);
        String[][] tma = tma_240;
        String[][] tool_tips = new String[tma.length][tma[0].length];
        int i = 0;
        while (i < tma.length) {
            int j = 0;
            while (j < tma[i].length) {
                tool_tips[i][j] = new Integer(i * tma[0].length + j).toString();
                ++j;
            }
            ++i;
        }
        TMAGrid tma_grid = new TMAGrid();
        tma_grid.setGrid(tma, tool_tips);
        tma_grid.setRowOffset(1.0);
        tma_grid.setColumnOffset(1.0);
        tma_grid.setCoreDiameter(0.8);
        VirtualTMA virtualTMA1 = new VirtualTMA();
        ApplicationFrame demo = new ApplicationFrame("Virtual TMA");
        ChartPanel chartPanel = new ChartPanel(virtualTMA1.drawTMA(tma_grid, size, true, true));
        chartPanel.setPreferredSize(size);
        demo.setContentPane((Container)chartPanel);
        demo.pack();
        RefineryUtilities.centerFrameOnScreen((Window)demo);
        demo.setVisible(true);
        virtualTMA1.getTMALayout(null, tma_grid, size, true, true);
    }
}

