/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.tma.csvparser;

import at.tugraz.genome.tma.csvparser.BadDelimeterException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class CSVLexer {
    public static final int AFTER = 2;
    public static final int BEFORE = 1;
    public static final int COMMENT = 3;
    private static final int YYEOF = -1;
    public static final int YYINITIAL = 0;
    private static final byte[] YY_ATTRIBUTE;
    private static final int YY_BUFFERSIZE = 16384;
    private static final String[] YY_ERROR_MSG;
    private static final int YY_ILLEGAL_STATE = 1;
    private static final int YY_NO_MATCH = 2;
    private static final int YY_PUSHBACK_2BIG = 3;
    private static final int YY_UNKNOWN_ERROR = 0;
    private boolean addLine = true;
    private String commentDelims = "";
    private char delimiter;
    private String escapes = "";
    private int lines = 0;
    private String replacements = "";
    private boolean yy_atEOF;
    private char[] yy_buffer;
    private int yy_currentPos;
    private int yy_endRead;
    private int yy_lexical_state = 0;
    private int yy_markedPos;
    private static final String yy_packed0 = "\u0001\u0005\u0001\u0006\u0001\u0007\u0001\b\u0001\t\u0001\n\u0001\u0005\u0001\u000b\u0001\f\u0001\r\u0001\u000e\u0001\u000f\u0001\u0010\u0001\u000b\u0001\u0011\u0001\u0012\u0001\u0007\u0001\b\u0001\u0013\u0002\u0011\u0001\u0014\u0001\u0004\u0001\u0007\u0001\b\u0003\u0014\u0001\u0005\u0001\u0015\u0003\u0000\u0002\u0005\u0001\u0000\u0001\u0016\u0001\u0007\u0001\b\u0006\u0000\u0001\b\n\u0000\u0005\n\u0001\u0017\u0001\u0018\u0001\u000b\u0001\u0019\u0003\u0000\u0002\u000b\u0001\u0000\u0001\f\b\u0000\u0001\u000e\u0003\u0000\u0005\u0010\u0001\u001a\u0001\u001b\u0002\u0011\u0003\u0000\u0003\u0011\u0001\u0012\u0001\u0007\u0001\b\u0001\u0000\u0002\u0011\u0002\u0014\u0002\u0000\u0003\u0014\u0005\n\u0001\u001c\u0001\u0018\u0005\u0010\u0001\u001d\u0001\u001b";
    private int yy_pushbackPos;
    private Reader yy_reader;
    private static final int[] yy_rowMap;
    private int yy_startRead;
    private int yy_state;
    private static final char[] yycmap;
    private char[] yycmap_instance = yycmap;
    private static final String yycmap_packed = "\t\u0000\u0001\u0001\u0001\u0003\u0001\u0000\u0001\u0001\u0001\u0002\u0012\u0000\u0001\u0001\u0001\u0000\u0001\u0005\t\u0000\u0001\u0004/\u0000\u0001\u0006\uffa3\u0000";
    private static final int[] yytrans;

    static {
        yycmap = CSVLexer.yy_unpack_cmap(yycmap_packed);
        yy_rowMap = new int[]{0, 7, 14, 21, 28, 35, 42, 49, 49, 56, 63, 70, 77, 49, 49, 84, 91, 98, 49, 105, 28, 35, 49, 112, 63, 49, 119, 56, 84};
        yytrans = CSVLexer.yy_unpack();
        YY_ERROR_MSG = new String[]{"Unkown internal scanner error", "Internal error: unknown state", "Error: could not match input", "Error: pushback value was too large"};
        YY_ATTRIBUTE = new byte[]{0, 1, 1, 1, 1, 1, 1, 9, 9, 1, 1, 1, 1, 9, 9, 1, 1, 1, 9, 1, 0, 0, 9, 1, 0, 9, 1, 1, 1};
    }

    public CSVLexer(InputStream in) {
        this(new InputStreamReader(in));
    }

    public CSVLexer(Reader in) {
        this.yy_buffer = new char[16384];
        this.delimiter = (char)44;
        this.yy_reader = in;
    }

    public void changeDelimiter(char newDelim) throws BadDelimeterException {
        if (newDelim == this.delimiter) {
            return;
        }
        if (yycmap == this.yycmap_instance) {
            this.yycmap_instance = new char[yycmap.length];
            System.arraycopy(yycmap, 0, this.yycmap_instance, 0, yycmap.length);
        }
        if (this.yycmap_instance[newDelim] != this.yycmap_instance[this.delimiter == 'a' ? 98 : 97]) {
            throw new BadDelimeterException(newDelim + " is not a safe delimiter.");
        }
        char temp = this.yycmap_instance[newDelim];
        this.yycmap_instance[newDelim] = this.yycmap_instance[this.delimiter];
        this.yycmap_instance[this.delimiter] = temp;
        this.delimiter = newDelim;
    }

    public int getLineNumber() {
        return this.lines;
    }

    public String getNextToken() throws IOException {
        int yy_endRead_l = this.yy_endRead;
        char[] yy_buffer_l = this.yy_buffer;
        char[] yycmap_l = this.yycmap_instance;
        int[] yytrans_l = yytrans;
        int[] yy_rowMap_l = yy_rowMap;
        byte[] yy_attr_l = YY_ATTRIBUTE;
        while (true) {
            int yy_input;
            int yy_markedPos_l = this.yy_markedPos;
            int yy_action = -1;
            this.yy_currentPos = this.yy_startRead = yy_markedPos_l;
            int yy_currentPos_l = this.yy_startRead;
            int yy_startRead_l = this.yy_startRead;
            this.yy_state = this.yy_lexical_state;
            while (true) {
                if (yy_currentPos_l < yy_endRead_l) {
                    yy_input = yy_buffer_l[yy_currentPos_l++];
                } else {
                    if (this.yy_atEOF) {
                        yy_input = -1;
                        break;
                    }
                    this.yy_currentPos = yy_currentPos_l;
                    this.yy_markedPos = yy_markedPos_l;
                    boolean eof = this.yy_refill();
                    yy_currentPos_l = this.yy_currentPos;
                    yy_markedPos_l = this.yy_markedPos;
                    yy_buffer_l = this.yy_buffer;
                    yy_endRead_l = this.yy_endRead;
                    if (eof) {
                        yy_input = -1;
                        break;
                    }
                    yy_input = yy_buffer_l[yy_currentPos_l++];
                }
                int yy_next = yytrans_l[yy_rowMap_l[this.yy_state] + yycmap_l[yy_input]];
                if (yy_next == -1) break;
                this.yy_state = yy_next;
                byte yy_attributes = yy_attr_l[this.yy_state];
                if ((yy_attributes & 1) != 1) continue;
                yy_action = this.yy_state;
                yy_markedPos_l = yy_currentPos_l;
                if ((yy_attributes & 8) == 8) break;
            }
            this.yy_markedPos = yy_markedPos_l;
            block0 : switch (yy_action) {
                case 1: 
                case 11: 
                case 30: {
                    break;
                }
                case 2: 
                case 16: 
                case 17: 
                case 31: {
                    break;
                }
                case 3: 
                case 19: 
                case 32: {
                    break;
                }
                case 10: {
                    this.yybegin(2);
                    return this.yytext();
                }
                case 33: {
                    break;
                }
                case 6: 
                case 7: {
                    this.addLine = true;
                    this.yybegin(0);
                }
                case 34: {
                    break;
                }
                case 5: {
                    if (this.addLine) {
                        ++this.lines;
                        this.addLine = false;
                    }
                    this.yybegin(1);
                }
                case 35: {
                    break;
                }
                case 9: 
                case 23: {
                    if (this.addLine) {
                        ++this.lines;
                        this.addLine = false;
                    }
                    this.yybegin(0);
                    return this.yytext();
                }
                case 36: {
                    break;
                }
                case 25: 
                case 28: {
                    this.yybegin(2);
                    return this.unescape(this.yytext());
                }
                case 37: {
                    break;
                }
                case 4: {
                    String text;
                    if (this.addLine) {
                        ++this.lines;
                        this.addLine = false;
                    }
                    if (this.commentDelims.indexOf((text = this.yytext()).charAt(0)) == -1) {
                        this.yybegin(2);
                        return text;
                    }
                    this.yybegin(3);
                }
                case 38: {
                    break;
                }
                case 14: {
                    this.yybegin(1);
                    return "";
                }
                case 39: {
                    break;
                }
                case 18: {
                    this.yybegin(1);
                }
                case 40: {
                    break;
                }
                case 22: 
                case 27: {
                    if (this.addLine) {
                        ++this.lines;
                        this.addLine = false;
                    }
                    this.yybegin(2);
                    return this.unescape(this.yytext());
                }
                case 41: {
                    break;
                }
                case 15: 
                case 26: {
                    this.yybegin(0);
                    return this.yytext();
                }
                case 42: {
                    break;
                }
                case 12: 
                case 13: {
                    this.addLine = true;
                    this.yybegin(0);
                    return "";
                }
                case 43: {
                    break;
                }
                case 8: {
                    if (this.addLine) {
                        ++this.lines;
                        this.addLine = false;
                    }
                    this.yybegin(1);
                    return "";
                }
                case 44: {
                    break;
                }
                default: {
                    if (yy_input == -1 && this.yy_startRead == this.yy_currentPos) {
                        this.yy_atEOF = true;
                        switch (this.yy_lexical_state) {
                            case 1: {
                                this.yybegin(0);
                                this.addLine = true;
                                return "";
                            }
                            case 30: {
                                break block0;
                            }
                        }
                        return null;
                    }
                    this.yy_ScanError(2);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        try {
            String t;
            InputStream in;
            if (args.length > 0) {
                File f = new File(args[0]);
                if (!f.exists()) throw new IOException("Could not find " + args[0]);
                if (!f.canRead()) throw new IOException("Could not open " + args[0]);
                in = new FileInputStream(f);
            } else {
                in = System.in;
            }
            CSVLexer shredder = new CSVLexer(in);
            shredder.setCommentStart("#;!");
            shredder.setEscapes("nrtf", "\n\r\t\f");
            while ((t = shredder.getNextToken()) != null) {
                void var3_4;
                System.out.println("" + shredder.getLineNumber() + " " + (String)var3_4);
            }
            return;
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    public void setCommentStart(String commentDelims) {
        this.commentDelims = commentDelims;
    }

    public void setEscapes(String escapes, String replacements) {
        int length = escapes.length();
        if (replacements.length() < length) {
            length = replacements.length();
        }
        this.escapes = escapes.substring(0, length);
        this.replacements = replacements.substring(0, length);
    }

    private String unescape(String s) {
        if (s.indexOf(92) == -1) {
            return s.substring(1, s.length() - 1);
        }
        StringBuffer sb = new StringBuffer(s.length());
        int i = 1;
        while (i < s.length() - 1) {
            char c = s.charAt(i);
            if (c == '\\') {
                char c1;
                if ((c1 = s.charAt(++i)) == '\\' || c1 == '\"') {
                    sb.append(c1);
                } else {
                    int index = this.escapes.indexOf(c1);
                    if (index != -1) {
                        sb.append(this.replacements.charAt(index));
                    } else {
                        sb.append(c1);
                    }
                }
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    private void yy_ScanError(int errorCode) {
        String message;
        try {
            message = YY_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = YY_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    private boolean yy_refill() throws IOException {
        int numRead;
        if (this.yy_startRead > 0) {
            System.arraycopy(this.yy_buffer, this.yy_startRead, this.yy_buffer, 0, this.yy_endRead - this.yy_startRead);
            this.yy_endRead -= this.yy_startRead;
            this.yy_currentPos -= this.yy_startRead;
            this.yy_markedPos -= this.yy_startRead;
            this.yy_pushbackPos -= this.yy_startRead;
            this.yy_startRead = 0;
        }
        if (this.yy_currentPos >= this.yy_buffer.length) {
            char[] newBuffer = new char[this.yy_currentPos * 2];
            System.arraycopy(this.yy_buffer, 0, newBuffer, 0, this.yy_buffer.length);
            this.yy_buffer = newBuffer;
        }
        if ((numRead = this.yy_reader.read(this.yy_buffer, this.yy_endRead, this.yy_buffer.length - this.yy_endRead)) < 0) {
            return true;
        }
        this.yy_endRead += numRead;
        return false;
    }

    private static int yy_unpack(String packed, int offset, int[] trans) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                trans[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] yy_unpack() {
        int[] trans = new int[126];
        int offset = 0;
        offset = CSVLexer.yy_unpack(yy_packed0, offset, trans);
        return trans;
    }

    private static char[] yy_unpack_cmap(String packed) {
        char[] map = new char[65536];
        int i = 0;
        int j = 0;
        while (i < 30) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    private final void yybegin(int newState) {
        this.yy_lexical_state = newState;
    }

    private final int yylength() {
        return this.yy_markedPos - this.yy_startRead;
    }

    private void yypushback(int number) {
        if (number > this.yylength()) {
            this.yy_ScanError(3);
        }
        this.yy_markedPos -= number;
    }

    private final String yytext() {
        return new String(this.yy_buffer, this.yy_startRead, this.yy_markedPos - this.yy_startRead);
    }
}

