/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.tma.csvparser;

import at.tugraz.genome.tma.csvparser.BadDelimeterException;
import at.tugraz.genome.tma.csvparser.CSVLexer;
import at.tugraz.genome.tma.csvparser.CSVParse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Vector;

public class CSVParser
implements CSVParse {
    private int lastLine = -1;
    private CSVLexer lexer;
    private int lineCache;
    private String tokenCache;

    public CSVParser(Reader in, String escapes, String replacements, String commentDelims) {
        this.lexer = new CSVLexer(in);
        this.setEscapes(escapes, replacements);
        this.setCommentStart(commentDelims);
    }

    public CSVParser(InputStream in, String escapes, String replacements, String commentDelims) {
        this.lexer = new CSVLexer(in);
        this.setEscapes(escapes, replacements);
        this.setCommentStart(commentDelims);
    }

    public CSVParser(Reader in) {
        this.lexer = new CSVLexer(in);
    }

    public CSVParser(InputStream in) {
        this.lexer = new CSVLexer(in);
    }

    public void changeDelimiter(char newDelim) throws BadDelimeterException {
        this.lexer.changeDelimiter(newDelim);
    }

    /*
     * WARNING - void declaration
     */
    public String[][] getAllValues() throws IOException {
        String[] line;
        Vector<void> v = new Vector<void>();
        while ((line = this.getLine()) != null) {
            void var2_2;
            v.add(var2_2);
        }
        if (v.size() == 0) {
            return null;
        }
        String[][] result = new String[v.size()][];
        return (String[][])v.toArray((T[])result);
    }

    public int getLastLineNumber() {
        return this.lastLine;
    }

    public String[] getLine() throws IOException {
        int lineNumber = -1;
        Vector<String> v = new Vector<String>();
        if (this.tokenCache != null) {
            v.add(this.tokenCache);
            lineNumber = this.lineCache;
        }
        while ((this.tokenCache = this.lexer.getNextToken()) != null && (lineNumber == -1 || this.lexer.getLineNumber() == lineNumber)) {
            v.add(this.tokenCache);
            lineNumber = this.lexer.getLineNumber();
        }
        if (v.size() == 0) {
            return null;
        }
        this.lastLine = lineNumber;
        this.lineCache = this.lexer.getLineNumber();
        String[] result = new String[v.size()];
        return v.toArray(result);
    }

    public int lastLineNumber() {
        return this.lastLine;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void main(String[] args) {
        try {
            String[] t;
            InputStream in;
            if (args.length > 0) {
                File f = new File(args[0]);
                if (!f.exists()) throw new IOException("Could not find " + args[0]);
                if (!f.canRead()) throw new IOException("Could not open " + args[0]);
                in = new FileInputStream(f);
            } else {
                in = System.in;
            }
            CSVParser p = new CSVParser(in);
            p.setCommentStart("#;!");
            p.setEscapes("nrtf", "\n\r\t\f");
            while ((t = p.getLine()) != null) {
                void var3_4;
                int i = 0;
                while (i < ((void)var3_4).length) {
                    System.out.print('\"' + (String)var3_4[i] + '\"');
                    if (i < ((void)var3_4).length - 1) {
                        System.out.print(", ");
                    }
                    ++i;
                }
                System.out.println();
            }
            return;
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    public String nextValue() throws IOException {
        if (this.tokenCache == null) {
            this.tokenCache = this.lexer.getNextToken();
            this.lineCache = this.lexer.getLineNumber();
        }
        this.lastLine = this.lineCache;
        String result = this.tokenCache;
        this.tokenCache = null;
        return result;
    }

    public static String[][] parse(Reader in, String escapes, String replacements, String commentDelims) throws IOException {
        return new CSVParser(in, escapes, replacements, commentDelims).getAllValues();
    }

    public static String[][] parse(Reader in) throws IOException {
        return new CSVParser(in).getAllValues();
    }

    public static String[][] parse(String s, String escapes, String replacements, String commentDelims) {
        try {
            return new CSVParser(new StringReader(s), escapes, replacements, commentDelims).getAllValues();
        }
        catch (IOException x) {
            return null;
        }
    }

    public static String[][] parse(String s) {
        try {
            return new CSVParser(new StringReader(s)).getAllValues();
        }
        catch (IOException x) {
            return null;
        }
    }

    public void setCommentStart(String commentDelims) {
        this.lexer.setCommentStart(commentDelims);
    }

    public void setEscapes(String escapes, String replacements) {
        this.lexer.setEscapes(escapes, replacements);
    }
}

