/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.tma.ejb.entity;

import at.tugraz.genome.dbutilities.DummyPKGeneratorFactory;
import at.tugraz.genome.tma.ejb.entity.Algorithm;
import at.tugraz.genome.tma.ejb.entity.Result;
import at.tugraz.genome.tma.ejb.entity.ResultLocalHome;
import at.tugraz.genome.tma.ejb.entity.ResultUtil;
import at.tugraz.genome.tma.ejb.vos.AlgorithmVO;
import at.tugraz.genome.tma.ejb.vos.ResultVO;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AlgorithmBean
implements EntityBean {
    private EntityContext context;
    Log log = LogFactory.getLog(this.getClass());

    public abstract void ejbActivate() throws EJBException, RemoteException;

    public Long ejbCreate(AlgorithmVO data) throws CreateException {
        this.log.info("ejbCreate(data): begin data=" + data);
        this.log.debug("ejbCreate(data): data.getAlgorithmname()=" + data.getAlgorithmname());
        this.setAlgorithmname(data.getAlgorithmname());
        this.log.debug("ejbCreate(data): data.getJarname()=" + data.getJarname());
        this.setJarname(data.getJarname());
        this.log.debug("ejbCreate(data): data.getVersion()=" + data.getVersion());
        this.setVersion(data.getVersion());
        this.log.debug("ejbCreate(data): data.getStartable()=" + data.getStartable());
        this.setStartable(data.getStartable());
        this.log.debug("ejbCreate(data): data.getDisabled()=" + data.getDisabled());
        this.setDisabled(data.getDisabled());
        Long primaryKey = data.getPrimaryKey() == null ? (Long)this.getPrimaryKey("Algorithm", "java.lang.Long") : data.getPrimaryKey();
        this.setAlgorithmId(primaryKey);
        this.log.debug("ejbCreate(data): finished successfuly new primaryKey=" + primaryKey);
        return null;
    }

    public Long ejbCreate(String algorithmname, String jarname, String version, Integer startable, Integer disabled) throws CreateException {
        this.log.debug("ejbCreate: algorithmname=" + algorithmname);
        this.setAlgorithmname(algorithmname);
        this.log.debug("ejbCreate: jarname=" + jarname);
        this.setJarname(jarname);
        this.log.debug("ejbCreate: version=" + version);
        this.setVersion(version);
        this.log.debug("ejbCreate: startable=" + startable);
        this.setStartable(startable);
        this.log.debug("ejbCreate: disabled=" + disabled);
        this.setDisabled(disabled);
        Long primaryKey = (Long)this.getPrimaryKey("Algorithm", "java.lang.Long");
        this.setAlgorithmId(primaryKey);
        this.log.debug("ejbCreate: finished successfuly new primaryKey=" + primaryKey);
        return null;
    }

    public abstract void ejbLoad() throws EJBException, RemoteException;

    public abstract void ejbPassivate() throws EJBException, RemoteException;

    public void ejbPostCreate(AlgorithmVO data) throws CreateException {
        this.log.debug("ejbPostCreate(data): begin data=" + data);
        data.setAlgorithmId((Long)this.context.getPrimaryKey());
        try {
            this.setResultVOs(data.getResults());
        }
        catch (NamingException namExc) {
            this.log.error("ejbPostCreate(data): NamingException thrown");
            this.log.error(namExc);
            throw new CreateException(namExc.getMessage());
        }
        catch (FinderException findExc) {
            this.log.error("ejbPostCreate(data): NamingException thrown");
            this.log.error((Object)findExc);
            throw new CreateException(findExc.getMessage());
        }
        catch (EJBException ejbExc) {
            this.log.error("ejbPostCreate(data): EJBException thrown");
            this.log.error((Object)ejbExc);
            throw new CreateException(ejbExc.getMessage());
        }
    }

    public void ejbPostCreate(String algorithmname, String jarname, String version, Integer startable, Integer disabled) throws CreateException {
    }

    public abstract void ejbRemove() throws RemoveException, EJBException, RemoteException;

    public abstract void ejbStore() throws EJBException, RemoteException;

    public abstract Long getAlgorithmId();

    public abstract String getAlgorithmname();

    public abstract Integer getDisabled();

    public abstract String getJarname();

    private Object getPrimaryKey(String className, String type) {
        Object primaryKey = new Object();
        if (type.equalsIgnoreCase("java.lang.Long")) {
            primaryKey = DummyPKGeneratorFactory.getPKGenerator("THESERVERSIDEGUID").getPrimaryKey(className);
        } else {
            System.out.println("This Type of PKGenerator must be implemented");
        }
        return primaryKey;
    }

    public abstract Collection getResults();

    public abstract Integer getStartable();

    public AlgorithmVO getValueObject() {
        AlgorithmVO result = new AlgorithmVO(this.getAlgorithmId(), this.getAlgorithmname(), this.getJarname(), this.getVersion(), this.getStartable(), this.getDisabled());
        this.log.debug("getValueObject: returned AlgorithmVO=" + result);
        return result;
    }

    public abstract String getVersion();

    public abstract void setAlgorithmId(Long var1);

    public abstract void setAlgorithmname(String var1);

    public abstract void setDisabled(Integer var1);

    public void setEntityContext(EntityContext ctx) {
        this.context = ctx;
    }

    public abstract void setJarname(String var1);

    public void setResultVOs(Collection Results) throws FinderException, NamingException, CreateException {
        this.log.debug("setResultVOs: begin");
        if (Results == null) {
            this.log.info("setResultVOs: Results is NULL");
            this.setResults(null);
        } else {
            this.log.debug("begin setResultVOs(Results) Results.size=" + Results.size());
            ArrayList<Result> col = new ArrayList<Result>();
            Iterator iter = Results.iterator();
            while (iter.hasNext()) {
                Result ResultRef;
                ResultVO someVO = (ResultVO)iter.next();
                Long id = someVO.getResultId();
                ResultLocalHome ResultLH = ResultUtil.getLocalHome();
                if (id != null && !id.toString().equals("")) {
                    this.log.debug("setResultVOs: find by primKey: id=" + id);
                    ResultRef = ResultLH.findByPrimaryKey(id);
                    ResultRef.setAlgorithm((Algorithm)this.context.getEJBLocalObject());
                } else {
                    this.log.debug("setResultVOs: create new entity.");
                    ResultRef = ResultLH.create(someVO);
                    ResultRef.setAlgorithm((Algorithm)this.context.getEJBLocalObject());
                }
                col.add(ResultRef);
            }
            this.setResults(col);
        }
    }

    public abstract void setResults(Collection var1);

    public abstract void setStartable(Integer var1);

    public abstract void setVersion(String var1);

    public void unsetEntityContext() {
        this.context = null;
    }

    public void update(AlgorithmVO value) throws FinderException, NamingException, CreateException {
        this.log.debug("update: begin value=" + value);
        this.log.debug("update:  algorithmname=" + value.getAlgorithmname());
        this.setAlgorithmname(value.getAlgorithmname());
        this.log.debug("update:  jarname=" + value.getJarname());
        this.setJarname(value.getJarname());
        this.log.debug("update:  version=" + value.getVersion());
        this.setVersion(value.getVersion());
        this.log.debug("update:  startable=" + value.getStartable());
        this.setStartable(value.getStartable());
        this.log.debug("update:  disabled=" + value.getDisabled());
        this.setDisabled(value.getDisabled());
        this.setResultVOs(value.getResults());
    }

    public void updateCMP(AlgorithmVO value) throws FinderException, NamingException, CreateException {
        this.log.debug("updateCMP: begin value=" + value);
        this.log.debug("update:  algorithmname=" + value.getAlgorithmname());
        this.setAlgorithmname(value.getAlgorithmname());
        this.log.debug("update:  jarname=" + value.getJarname());
        this.setJarname(value.getJarname());
        this.log.debug("update:  version=" + value.getVersion());
        this.setVersion(value.getVersion());
        this.log.debug("update:  startable=" + value.getStartable());
        this.setStartable(value.getStartable());
        this.log.debug("update:  disabled=" + value.getDisabled());
        this.setDisabled(value.getDisabled());
    }
}

