/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.tma.ejb.entity;

import at.tugraz.genome.dbutilities.DummyPKGeneratorFactory;
import at.tugraz.genome.tma.ejb.entity.Antibody;
import at.tugraz.genome.tma.ejb.entity.AntibodyLocalHome;
import at.tugraz.genome.tma.ejb.entity.AntibodyUtil;
import at.tugraz.genome.tma.ejb.entity.Antigen;
import at.tugraz.genome.tma.ejb.entity.Datadictionary;
import at.tugraz.genome.tma.ejb.entity.DatadictionaryLocalHome;
import at.tugraz.genome.tma.ejb.entity.DatadictionaryUtil;
import at.tugraz.genome.tma.ejb.entity.Staining;
import at.tugraz.genome.tma.ejb.entity.StainingLocalHome;
import at.tugraz.genome.tma.ejb.entity.StainingUtil;
import at.tugraz.genome.tma.ejb.vos.AntibodyVO;
import at.tugraz.genome.tma.ejb.vos.AntigenVO;
import at.tugraz.genome.tma.ejb.vos.DatadictionaryVO;
import at.tugraz.genome.tma.ejb.vos.StainingVO;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AntigenBean
implements EntityBean {
    private EntityContext context;
    Log log = LogFactory.getLog(this.getClass());

    public abstract void ejbActivate() throws EJBException, RemoteException;

    public Long ejbCreate(AntigenVO data) throws CreateException {
        this.log.info("ejbCreate(data): begin data=" + data);
        this.log.debug("ejbCreate(data): data.getAntigenname()=" + data.getAntigenname());
        this.setAntigenname(data.getAntigenname());
        this.log.debug("ejbCreate(data): data.getGenname()=" + data.getGenname());
        this.setGenname(data.getGenname());
        this.log.debug("ejbCreate(data): data.getAccession()=" + data.getAccession());
        this.setAccession(data.getAccession());
        Long primaryKey = data.getPrimaryKey() == null ? (Long)this.getPrimaryKey("Antigen", "java.lang.Long") : data.getPrimaryKey();
        this.setAntigenId(primaryKey);
        this.log.debug("ejbCreate(data): finished successfuly new primaryKey=" + primaryKey);
        return null;
    }

    public Long ejbCreate(String antigenname, String genname, String accession) throws CreateException {
        this.log.debug("ejbCreate: antigenname=" + antigenname);
        this.setAntigenname(antigenname);
        this.log.debug("ejbCreate: genname=" + genname);
        this.setGenname(genname);
        this.log.debug("ejbCreate: accession=" + accession);
        this.setAccession(accession);
        Long primaryKey = (Long)this.getPrimaryKey("Antigen", "java.lang.Long");
        this.setAntigenId(primaryKey);
        this.log.debug("ejbCreate: finished successfuly new primaryKey=" + primaryKey);
        return null;
    }

    public abstract void ejbLoad() throws EJBException, RemoteException;

    public abstract void ejbPassivate() throws EJBException, RemoteException;

    public void ejbPostCreate(AntigenVO data) throws CreateException {
        this.log.debug("ejbPostCreate(data): begin data=" + data);
        data.setAntigenId((Long)this.context.getPrimaryKey());
        try {
            this.setStainingVOs(data.getStainings());
            this.setAntibodyVOs(data.getAntibodys());
            this.setDatadictionaryDatabaseVO(data.getDatadictionaryDatabase());
        }
        catch (NamingException namExc) {
            this.log.error("ejbPostCreate(data): NamingException thrown");
            this.log.error(namExc);
            throw new CreateException(namExc.getMessage());
        }
        catch (FinderException findExc) {
            this.log.error("ejbPostCreate(data): NamingException thrown");
            this.log.error((Object)findExc);
            throw new CreateException(findExc.getMessage());
        }
        catch (EJBException ejbExc) {
            this.log.error("ejbPostCreate(data): EJBException thrown");
            this.log.error((Object)ejbExc);
            throw new CreateException(ejbExc.getMessage());
        }
    }

    public void ejbPostCreate(String antigenname, String genname, String accession) throws CreateException {
    }

    public abstract void ejbRemove() throws RemoveException, EJBException, RemoteException;

    public abstract void ejbStore() throws EJBException, RemoteException;

    public abstract String getAccession();

    public abstract Collection getAntibodys();

    public abstract Long getAntigenId();

    public abstract String getAntigenname();

    public abstract Datadictionary getDatadictionaryDatabase();

    public abstract String getGenname();

    private Object getPrimaryKey(String className, String type) {
        Object primaryKey = new Object();
        if (type.equalsIgnoreCase("java.lang.Long")) {
            primaryKey = DummyPKGeneratorFactory.getPKGenerator("THESERVERSIDEGUID").getPrimaryKey(className);
        } else {
            System.out.println("This Type of PKGenerator must be implemented");
        }
        return primaryKey;
    }

    public abstract Collection getStainings();

    public AntigenVO getValueObject() {
        AntigenVO result = new AntigenVO(this.getAntigenId(), this.getAntigenname(), this.getGenname(), this.getAccession());
        this.log.debug("getValueObject: returned AntigenVO=" + result);
        return result;
    }

    public abstract void setAccession(String var1);

    public void setAntibodyVOs(Collection Antibodys) throws FinderException, NamingException, CreateException {
        this.log.debug("setAntibodyVOs: begin");
        if (Antibodys == null) {
            this.log.info("setAntibodyVOs: Antibodys is NULL");
            this.setAntibodys(null);
        } else {
            this.log.debug("begin setAntibodyVOs(Antibodys) Antibodys.size=" + Antibodys.size());
            ArrayList<Antibody> col = new ArrayList<Antibody>();
            Iterator iter = Antibodys.iterator();
            while (iter.hasNext()) {
                Antibody AntibodyRef;
                AntibodyVO someVO = (AntibodyVO)iter.next();
                Long id = someVO.getAntibodyId();
                AntibodyLocalHome AntibodyLH = AntibodyUtil.getLocalHome();
                if (id != null && !id.toString().equals("")) {
                    this.log.debug("setAntibodyVOs: find by primKey: id=" + id);
                    AntibodyRef = AntibodyLH.findByPrimaryKey(id);
                } else {
                    this.log.debug("setAntibodyVOs: create new entity.");
                    AntibodyRef = AntibodyLH.create(someVO);
                }
                col.add(AntibodyRef);
            }
            this.setAntibodys(col);
        }
    }

    public abstract void setAntibodys(Collection var1);

    public abstract void setAntigenId(Long var1);

    public abstract void setAntigenname(String var1);

    public abstract void setDatadictionaryDatabase(Datadictionary var1);

    public void setDatadictionaryDatabaseVO(DatadictionaryVO DatadictionaryVO2) throws FinderException, NamingException, CreateException, EJBException {
        this.log.debug("begin setDatadictionaryDatabase(DatadictionaryVO) DatadictionaryVO=" + DatadictionaryVO2);
        if (DatadictionaryVO2 == null) {
            this.log.debug("setDatadictionaryDatabase: vo is NULL");
            this.setDatadictionaryDatabase(null);
        } else {
            Datadictionary DatadictionaryDatabaseRef;
            Long id = DatadictionaryVO2.getDataId();
            DatadictionaryLocalHome DatadictionaryLH = DatadictionaryUtil.getLocalHome();
            if (id != null && !id.toString().equals("")) {
                this.log.debug("setDatadictionaryDatabase: find by primKey: id=" + id);
                DatadictionaryDatabaseRef = DatadictionaryLH.findByPrimaryKey(id);
            } else {
                this.log.debug("setDatadictionaryDatabase: create new entity.");
                DatadictionaryDatabaseRef = DatadictionaryLH.create(DatadictionaryVO2);
            }
            this.setDatadictionaryDatabase(DatadictionaryDatabaseRef);
        }
    }

    public void setEntityContext(EntityContext ctx) {
        this.context = ctx;
    }

    public abstract void setGenname(String var1);

    public void setStainingVOs(Collection Stainings) throws FinderException, NamingException, CreateException {
        this.log.debug("setStainingVOs: begin");
        if (Stainings == null) {
            this.log.info("setStainingVOs: Stainings is NULL");
            this.setStainings(null);
        } else {
            this.log.debug("begin setStainingVOs(Stainings) Stainings.size=" + Stainings.size());
            ArrayList<Staining> col = new ArrayList<Staining>();
            Iterator iter = Stainings.iterator();
            while (iter.hasNext()) {
                Staining StainingRef;
                StainingVO someVO = (StainingVO)iter.next();
                Long id = someVO.getStainingId();
                StainingLocalHome StainingLH = StainingUtil.getLocalHome();
                if (id != null && !id.toString().equals("")) {
                    this.log.debug("setStainingVOs: find by primKey: id=" + id);
                    StainingRef = StainingLH.findByPrimaryKey(id);
                    StainingRef.setAntigen((Antigen)this.context.getEJBLocalObject());
                } else {
                    this.log.debug("setStainingVOs: create new entity.");
                    StainingRef = StainingLH.create(someVO);
                    StainingRef.setAntigen((Antigen)this.context.getEJBLocalObject());
                }
                col.add(StainingRef);
            }
            this.setStainings(col);
        }
    }

    public abstract void setStainings(Collection var1);

    public void unsetEntityContext() {
        this.context = null;
    }

    public void update(AntigenVO value) throws FinderException, NamingException, CreateException {
        this.log.debug("update: begin value=" + value);
        this.log.debug("update:  antigenname=" + value.getAntigenname());
        this.setAntigenname(value.getAntigenname());
        this.log.debug("update:  genname=" + value.getGenname());
        this.setGenname(value.getGenname());
        this.log.debug("update:  accession=" + value.getAccession());
        this.setAccession(value.getAccession());
        this.setStainingVOs(value.getStainings());
        this.setAntibodyVOs(value.getAntibodys());
        this.setDatadictionaryDatabaseVO(value.getDatadictionaryDatabase());
    }

    public void updateCMP(AntigenVO value) throws FinderException, NamingException, CreateException {
        this.log.debug("updateCMP: begin value=" + value);
        this.log.debug("update:  antigenname=" + value.getAntigenname());
        this.setAntigenname(value.getAntigenname());
        this.log.debug("update:  genname=" + value.getGenname());
        this.setGenname(value.getGenname());
        this.log.debug("update:  accession=" + value.getAccession());
        this.setAccession(value.getAccession());
    }
}

