/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.tma.ejb.entity;

import at.tugraz.genome.dbutilities.DummyPKGeneratorFactory;
import at.tugraz.genome.tma.ejb.entity.Tissue;
import at.tugraz.genome.tma.ejb.entity.TissueLocalHome;
import at.tugraz.genome.tma.ejb.entity.TissueUtil;
import at.tugraz.genome.tma.ejb.entity.Topography;
import at.tugraz.genome.tma.ejb.vos.TissueVO;
import at.tugraz.genome.tma.ejb.vos.TopographyVO;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class TopographyBean
implements EntityBean {
    private EntityContext context;
    Log log = LogFactory.getLog(this.getClass());

    public abstract void ejbActivate() throws EJBException, RemoteException;

    public Long ejbCreate(TopographyVO data) throws CreateException {
        this.log.info("ejbCreate(data): begin data=" + data);
        this.log.debug("ejbCreate(data): data.getTopography()=" + data.getTopography());
        this.setTopography(data.getTopography());
        Long primaryKey = data.getPrimaryKey() == null ? (Long)this.getPrimaryKey("Topography", "java.lang.Long") : data.getPrimaryKey();
        this.setTopographyId(primaryKey);
        this.log.debug("ejbCreate(data): finished successfuly new primaryKey=" + primaryKey);
        return null;
    }

    public Long ejbCreate(String topography) throws CreateException {
        this.log.debug("ejbCreate: topography=" + topography);
        this.setTopography(topography);
        Long primaryKey = (Long)this.getPrimaryKey("Topography", "java.lang.Long");
        this.setTopographyId(primaryKey);
        this.log.debug("ejbCreate: finished successfuly new primaryKey=" + primaryKey);
        return null;
    }

    public abstract void ejbLoad() throws EJBException, RemoteException;

    public abstract void ejbPassivate() throws EJBException, RemoteException;

    public void ejbPostCreate(TopographyVO data) throws CreateException {
        this.log.debug("ejbPostCreate(data): begin data=" + data);
        data.setTopographyId((Long)this.context.getPrimaryKey());
        try {
            this.setTissueVOs(data.getTissues());
        }
        catch (NamingException namExc) {
            this.log.error("ejbPostCreate(data): NamingException thrown");
            this.log.error(namExc);
            throw new CreateException(namExc.getMessage());
        }
        catch (FinderException findExc) {
            this.log.error("ejbPostCreate(data): NamingException thrown");
            this.log.error((Object)findExc);
            throw new CreateException(findExc.getMessage());
        }
        catch (EJBException ejbExc) {
            this.log.error("ejbPostCreate(data): EJBException thrown");
            this.log.error((Object)ejbExc);
            throw new CreateException(ejbExc.getMessage());
        }
    }

    public void ejbPostCreate(String topography) throws CreateException {
    }

    public abstract void ejbRemove() throws RemoveException, EJBException, RemoteException;

    public abstract void ejbStore() throws EJBException, RemoteException;

    private Object getPrimaryKey(String className, String type) {
        Object primaryKey = new Object();
        if (type.equalsIgnoreCase("java.lang.Long")) {
            primaryKey = DummyPKGeneratorFactory.getPKGenerator("THESERVERSIDEGUID").getPrimaryKey(className);
        } else {
            System.out.println("This Type of PKGenerator must be implemented");
        }
        return primaryKey;
    }

    public abstract Collection getTissues();

    public abstract String getTopography();

    public abstract Long getTopographyId();

    public TopographyVO getValueObject() {
        TopographyVO result = new TopographyVO(this.getTopographyId(), this.getTopography());
        this.log.debug("getValueObject: returned TopographyVO=" + result);
        return result;
    }

    public void setEntityContext(EntityContext ctx) {
        this.context = ctx;
    }

    public void setTissueVOs(Collection Tissues) throws FinderException, NamingException, CreateException {
        this.log.debug("setTissueVOs: begin");
        if (Tissues == null) {
            this.log.info("setTissueVOs: Tissues is NULL");
            this.setTissues(null);
        } else {
            this.log.debug("begin setTissueVOs(Tissues) Tissues.size=" + Tissues.size());
            ArrayList<Tissue> col = new ArrayList<Tissue>();
            Iterator iter = Tissues.iterator();
            while (iter.hasNext()) {
                Tissue TissueRef;
                TissueVO someVO = (TissueVO)iter.next();
                Long id = someVO.getTissueId();
                TissueLocalHome TissueLH = TissueUtil.getLocalHome();
                if (id != null && !id.toString().equals("")) {
                    this.log.debug("setTissueVOs: find by primKey: id=" + id);
                    TissueRef = TissueLH.findByPrimaryKey(id);
                    TissueRef.setTopography((Topography)this.context.getEJBLocalObject());
                } else {
                    this.log.debug("setTissueVOs: create new entity.");
                    TissueRef = TissueLH.create(someVO);
                    TissueRef.setTopography((Topography)this.context.getEJBLocalObject());
                }
                col.add(TissueRef);
            }
            this.setTissues(col);
        }
    }

    public abstract void setTissues(Collection var1);

    public abstract void setTopography(String var1);

    public abstract void setTopographyId(Long var1);

    public void unsetEntityContext() {
        this.context = null;
    }

    public void update(TopographyVO value) throws FinderException, NamingException, CreateException {
        this.log.debug("update: begin value=" + value);
        this.log.debug("update:  topography=" + value.getTopography());
        this.setTopography(value.getTopography());
        this.setTissueVOs(value.getTissues());
    }

    public void updateCMP(TopographyVO value) throws FinderException, NamingException, CreateException {
        this.log.debug("updateCMP: begin value=" + value);
        this.log.debug("update:  topography=" + value.getTopography());
        this.setTopography(value.getTopography());
    }
}

