/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.tma.ejb.report;

import at.tugraz.genome.dbutilities.ConnectionManager;
import at.tugraz.genome.dbutilities.DatabaseTableField;
import at.tugraz.genome.dbutilities.GenericDAOFactory;
import at.tugraz.genome.dbutilities.SearchableField;
import at.tugraz.genome.dbutilities.exception.IteratorException;
import at.tugraz.genome.tma.GlobalConstantsGenerated;
import at.tugraz.genome.tma.ejb.entity.Result;
import at.tugraz.genome.tma.ejb.entity.ResultUtil;
import at.tugraz.genome.tma.ejb.report.ResultReportServiceBean;
import at.tugraz.genome.tma.ejb.vos.PunchVO;
import at.tugraz.genome.tma.ejb.vos.ResultReportVO;
import at.tugraz.genome.tma.ejb.vos.ResultVO;
import at.tugraz.genome.usermUtilities.remote.UsermUtilitiesBusinessInterface;
import at.tugraz.genome.usermUtilities.remote.UsermUtilitiesServiceFactory;
import at.tugraz.genome.usermanagement.serverconnection.exception.UserSecurityException;
import at.tugraz.genome.voutils.ValueTreeBuilder;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class ResultReportServiceBeanImpl
extends ResultReportServiceBean
implements SessionBean {
    private transient Logger log_ = Logger.getLogger(this.getClass());
    SessionContext sessionContext;
    private UsermUtilitiesBusinessInterface usermUtilitiesInterface = null;

    public void ejbActivate() {
        this.log_ = Logger.getLogger(this.getClass());
        this.genericDAO_ = GenericDAOFactory.getDAOFactory("at.tugraz.genome.dbutilities.dao.MysqlDAOFactory").getDAO();
        this.log_.info((Object)("list: " + this.list_));
        this.log_.info((Object)("currentIndex: " + this.currentIndex_));
        if (this.list_ != null) {
            this.listIterator_ = this.list_.listIterator(this.currentIndex_);
        } else {
            this.list_ = new LinkedList();
            this.listIterator_ = this.list_.listIterator();
        }
        this.log_.info((Object)"ejbActivate()");
    }

    public void ejbCreate() throws CreateException {
        this.genericDAO_ = GenericDAOFactory.getDAOFactory("at.tugraz.genome.dbutilities.dao.MysqlDAOFactory").getDAO();
        try {
            this.usermUtilitiesInterface = UsermUtilitiesServiceFactory.getInstance(ConnectionManager.getInstance().getJNDIProperties());
        }
        catch (Exception e) {
            this.log_.error((Object)e);
        }
    }

    public void ejbPassivate() {
        this.log_.info((Object)"ejbPassivate()");
    }

    public void ejbRemove() {
        this.log_.info((Object)"ejbRemove");
    }

    public void executeQuery(Collection searchCriteria, Long id) {
        this.executeQuery(searchCriteria, id, null, null);
    }

    public void executeQuery(Collection searchCriteria, Long id, DatabaseTableField orderBy) {
        this.executeQuery(searchCriteria, id, orderBy, null);
    }

    public void executeQuery(Collection searchCriteria, Long id, DatabaseTableField orderBy, String direction) {
        this.log_.info((Object)"executeSearch");
        try {
            List resultList = null;
            Vector searchcriteria = null;
            this.log_.info((Object)("searchCriteria: " + searchCriteria));
            searchcriteria = searchCriteria == null ? new Vector() : new Vector(searchCriteria);
            Iterator it = ((AbstractList)searchcriteria).iterator();
            while (it.hasNext()) {
                SearchableField combinedField;
                DatabaseTableField sectionField;
                SearchableField field = (SearchableField)it.next();
                if (field.getDBFieldName().equalsIgnoreCase("EnteredBy")) {
                    int i;
                    String correctedSearchValue;
                    String searchValue = this.parseSearchValue(field);
                    System.out.println("searchValue: " + searchValue);
                    String[] newSearchValues = searchValue.split(",");
                    this.log_.info((Object)("field.getOperator: " + field.getOperator()));
                    if (!field.getOperator().equalsIgnoreCase("like")) {
                        this.log_.info((Object)("operator: " + field.getOperator()));
                        correctedSearchValue = "";
                        i = 0;
                        while (i < newSearchValues.length) {
                            System.out.println("newSerchValues[i]: " + newSearchValues[i]);
                            Long submitterID = null;
                            submitterID = this.usermUtilitiesInterface.getIdByUserName(newSearchValues[i]);
                            if (submitterID != null) {
                                correctedSearchValue = i < newSearchValues.length - 1 ? correctedSearchValue + submitterID.toString() + "," : correctedSearchValue + submitterID.toString();
                            }
                            ++i;
                        }
                        field.setSearchValue(correctedSearchValue);
                    } else {
                        this.log_.info((Object)("LIKE operator: " + field.getOperator()));
                        correctedSearchValue = "";
                        i = 0;
                        while (i < newSearchValues.length) {
                            System.out.println("newSerchValues[i]: " + newSearchValues[i]);
                            Vector submitterIDs = this.usermUtilitiesInterface.getIDsByUserNameLike(newSearchValues[i]);
                            int j = 0;
                            while (j < submitterIDs.size()) {
                                correctedSearchValue = j < submitterIDs.size() - 1 ? correctedSearchValue + submitterIDs.elementAt(j).toString() + "," : correctedSearchValue + submitterIDs.elementAt(j).toString();
                                ++j;
                            }
                            if (i < newSearchValues.length - 1) {
                                correctedSearchValue = correctedSearchValue + ",";
                            }
                            ++i;
                        }
                        field.setSearchValue(correctedSearchValue);
                    }
                }
                if (field.getDBFieldName().equalsIgnoreCase("Section")) {
                    sectionField = new DatabaseTableField("punch", "SectionID", "", true, "BarcodeID", "section", "SectionID", "BarcodeID");
                    combinedField = new SearchableField(sectionField, field.getOperator(), field.getSearchValue());
                    field.setDBTableName("results");
                    field.setDBFieldName("PunchID");
                    field.setFakeDBTableField("PunchID");
                    field.setFakeTableName("Punch");
                    field.setFakeTableConnectorFieldName("PunchID");
                    field.setFake(true);
                    field.setSearchValue(null);
                    field.addANDCombinedField(combinedField);
                }
                if (field.getDBFieldName().equalsIgnoreCase("Row")) {
                    sectionField = new DatabaseTableField("punch", "ApassociationID", "", true, "Row", "arraypunchassociation", "ApassociationID", "row");
                    combinedField = new SearchableField(sectionField, field.getOperator(), field.getSearchValue());
                    field.setDBTableName("results");
                    field.setDBFieldName("PunchID");
                    field.setFakeDBTableField("PunchID");
                    field.setFakeTableName("Punch");
                    field.setFakeTableConnectorFieldName("PunchID");
                    field.setFake(true);
                    field.setSearchValue(null);
                    field.addANDCombinedField(combinedField);
                }
                if (!field.getDBFieldName().equalsIgnoreCase("Column")) continue;
                sectionField = new DatabaseTableField("punch", "ApassociationID", "", true, "Col", "arraypunchassociation", "ApassociationID", "col");
                combinedField = new SearchableField(sectionField, field.getOperator(), field.getSearchValue());
                field.setDBTableName("results");
                field.setDBFieldName("PunchID");
                field.setFakeDBTableField("PunchID");
                field.setFakeTableName("Punch");
                field.setFakeTableConnectorFieldName("PunchID");
                field.setFake(true);
                field.setSearchValue(null);
                field.addANDCombinedField(combinedField);
            }
            resultList = searchcriteria == null || searchcriteria.size() == 0 ? this.genericDAO_.selectAll("results", "ResultID", orderBy, direction) : this.genericDAO_.selectCustom("results", "ResultID", searchcriteria, orderBy, direction);
            this.setList(new LinkedList(resultList));
        }
        catch (Exception e) {
            this.log_.error((Object)e);
        }
    }

    public Object getCurrentElement() throws IteratorException {
        return this.getElement((Long)super.getCurrentElement());
    }

    private Object getElement(Long id) throws IteratorException {
        Result entity = null;
        ResultReportVO returnVO = null;
        ResultVO resultVO = null;
        try {
            entity = ResultUtil.getLocalHome().findByPrimaryKey(id);
            String value_tree = "Algorithm,Punch,Punch.Section,Punch.Arraypunchassociation";
            resultVO = (ResultVO)ValueTreeBuilder.getValueTree(entity, ValueTreeBuilder.createIncludeTree(value_tree));
            resultVO.setUserVO(this.usermUtilitiesInterface.getSubmitter(resultVO.getUserid()));
            returnVO = new ResultReportVO(resultVO);
        }
        catch (FinderException fex) {
            this.log.error("findResultById(id=" + id + "): FinderException thrown");
            this.log.error((Object)fex);
        }
        catch (NamingException nex) {
            this.log.error("findResultById(id=" + id + "): NamingException thrown");
            throw new IteratorException(nex.getMessage());
        }
        catch (UserSecurityException usex) {
            this.log.error("findResultById(id=" + id + "): UserSecurityException thrown (id=" + resultVO.getUserid() + ")");
        }
        return returnVO;
    }

    public List getElements(List idList) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = idList.iterator();
        while (iterator.hasNext()) {
            try {
                arrayList.add(this.getElement((Long)iterator.next()));
            }
            catch (IteratorException ex) {
            }
        }
        return arrayList;
    }

    public Collection getOperators() {
        return GlobalConstantsGenerated.getSearchOperators();
    }

    public Collection getSearchableFields() {
        Vector<DatabaseTableField> dbFields = new Vector<DatabaseTableField>();
        DatabaseTableField dbField = null;
        dbField = new DatabaseTableField("results", "Resultname", "Resultname", false);
        dbFields.add(dbField);
        dbField = new DatabaseTableField("results", "Resultvalue", "Resultvalue", false);
        dbFields.add(dbField);
        dbField = new DatabaseTableField("section", "EnterdBy", "Userid", false);
        dbFields.add(dbField);
        dbField = new DatabaseTableField("section", "Date", "Date", false);
        dbFields.add(dbField);
        dbField = new DatabaseTableField("results", "AlgorithmID", "Algorithmname", true, "Algoname", "algorithms", "AlgorithmID", "Algoname");
        dbFields.add(dbField);
        dbField = new DatabaseTableField("results", "Section", "Sectionbarcode", false);
        dbField.addAdditionalTable("punch");
        dbField.addAdditionalTable("section");
        dbFields.add(dbField);
        dbField = new DatabaseTableField("results", "Row", "Sectionrow", false);
        dbField.addAdditionalTable("punch");
        dbField.addAdditionalTable("arraypunchassociation");
        dbFields.add(dbField);
        dbField = new DatabaseTableField("results", "Column", "Sectioncolumn", false);
        dbField.addAdditionalTable("punch");
        dbField.addAdditionalTable("arraypunchassociation");
        dbFields.add(dbField);
        return dbFields;
    }

    private String parseSearchValue(SearchableField field) {
        String retValue = "";
        if (field.getOperator().equalsIgnoreCase("between") || field.getOperator().equalsIgnoreCase("not between")) {
            String searchValue = field.getSearchValue();
            searchValue = searchValue.trim();
            Pattern pattern = Pattern.compile("([a-zA-Z_0-9\\s]+),([a-zA-Z_0-9\\s]+)");
            Matcher matcher = pattern.matcher(searchValue);
            if (matcher.matches()) {
                System.out.println("MATCH BETWEEN");
                String value1 = matcher.group(1).trim();
                String value2 = matcher.group(2).trim();
                retValue = value1 + "," + value2;
            }
        } else if (field.getOperator().equalsIgnoreCase("in") || field.getOperator().equalsIgnoreCase("not in")) {
            Pattern pattern;
            Matcher matcher;
            String searchValue = field.getSearchValue();
            if (!(searchValue = searchValue.trim()).endsWith(",")) {
                searchValue = searchValue + ",";
            }
            if ((matcher = (pattern = Pattern.compile("([a-zA-Z_0-9\\s]{1,},){1,}")).matcher(searchValue)).matches()) {
                System.out.println("MATCH IN");
                retValue = field.getSearchValue();
            }
        } else {
            retValue = field.getSearchValue();
        }
        return retValue;
    }

    public void setSectionResultIdList(Collection Punchs) {
        try {
            System.out.println("setSectionResultIdList:begin");
            ArrayList punchs = new ArrayList(Punchs);
            System.out.println("setSectionResultIdList:punchs arraylist");
            LinkedList<Long> resultIdList = new LinkedList<Long>();
            Iterator punch_iter = ((AbstractList)punchs).iterator();
            System.out.println("setSectionResultIdList:punchs iterator");
            while (punch_iter.hasNext()) {
                Collection results_col = ((PunchVO)punch_iter.next()).getResults();
                ArrayList results = new ArrayList(results_col);
                Iterator result_iter = ((AbstractList)results).iterator();
                while (result_iter.hasNext()) {
                    ResultVO resultVO = (ResultVO)result_iter.next();
                    resultIdList.add(resultVO.getResultId());
                }
            }
            System.out.println("setSectionResultIdList:done");
            this.setList(resultIdList);
        }
        catch (Exception e) {
            this.log_.error((Object)e);
        }
    }

    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    public void setValueObjectParameters(Collection parameters) {
    }
}

