/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.tma.ejb.report;

import at.tugraz.genome.dbutilities.ConnectionManager;
import at.tugraz.genome.dbutilities.DatabaseTableField;
import at.tugraz.genome.dbutilities.GenericDAOFactory;
import at.tugraz.genome.dbutilities.SearchableField;
import at.tugraz.genome.dbutilities.exception.IteratorException;
import at.tugraz.genome.tma.GlobalConstantsGenerated;
import at.tugraz.genome.tma.ejb.entity.Section;
import at.tugraz.genome.tma.ejb.entity.SectionUtil;
import at.tugraz.genome.tma.ejb.report.SectionReportServiceBean;
import at.tugraz.genome.tma.ejb.vos.SectionReportVO;
import at.tugraz.genome.tma.ejb.vos.SectionVO;
import at.tugraz.genome.usermUtilities.remote.UsermUtilitiesBusinessInterface;
import at.tugraz.genome.usermUtilities.remote.UsermUtilitiesServiceFactory;
import at.tugraz.genome.usermanagement.serverconnection.exception.UserSecurityException;
import at.tugraz.genome.voutils.ValueTreeBuilder;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class SectionReportServiceBeanImpl
extends SectionReportServiceBean
implements SessionBean {
    private Collection arrayblockQuery = null;
    private transient Logger log_ = Logger.getLogger(this.getClass());
    SessionContext sessionContext;
    private UsermUtilitiesBusinessInterface usermUtilitiesInterface = null;

    public void ejbActivate() {
        this.log_ = Logger.getLogger(this.getClass());
        this.genericDAO_ = GenericDAOFactory.getDAOFactory("at.tugraz.genome.dbutilities.dao.MysqlDAOFactory").getDAO();
        this.log_.info((Object)("list: " + this.list_));
        this.log_.info((Object)("currentIndex: " + this.currentIndex_));
        if (this.list_ != null) {
            this.listIterator_ = this.list_.listIterator(this.currentIndex_);
        } else {
            this.list_ = new LinkedList();
            this.listIterator_ = this.list_.listIterator();
        }
        this.log_.info((Object)"ejbActivate()");
    }

    public void ejbCreate() throws CreateException {
        this.genericDAO_ = GenericDAOFactory.getDAOFactory("at.tugraz.genome.dbutilities.dao.MysqlDAOFactory").getDAO();
        try {
            this.usermUtilitiesInterface = UsermUtilitiesServiceFactory.getInstance(ConnectionManager.getInstance().getJNDIProperties());
        }
        catch (Exception e) {
            this.log_.error((Object)e);
        }
    }

    public void ejbPassivate() {
        this.log_.info((Object)"ejbPassivate()");
    }

    public void ejbRemove() {
        this.log_.info((Object)"ejbRemove");
    }

    public void executeQuery(Collection searchCriteria, Long id) {
        DatabaseTableField orderBy = this.getDatabaseTableField("BarcodeId");
        this.executeQuery(searchCriteria, id, orderBy, null);
    }

    public void executeQuery(Collection searchCriteria, Long id, DatabaseTableField orderBy) {
        this.executeQuery(searchCriteria, id, orderBy, null);
    }

    public void executeQuery(Collection searchCriteria, Long id, DatabaseTableField orderBy, String direction) {
        this.log_.info((Object)"executeSearch");
        try {
            List resultList = null;
            Vector searchcriteria = null;
            this.log_.info((Object)("searchCriteria: " + searchCriteria));
            searchcriteria = searchCriteria == null ? new Vector() : new Vector(searchCriteria);
            Iterator it = ((AbstractList)searchcriteria).iterator();
            while (it.hasNext()) {
                SearchableField combinedField;
                DatabaseTableField stainigField;
                SearchableField field = (SearchableField)it.next();
                if (field.getDBFieldName().equalsIgnoreCase("EnteredBy")) {
                    int i;
                    String correctedSearchValue;
                    String searchValue = this.parseSearchValue(field);
                    System.out.println("searchValue: " + searchValue);
                    String[] newSearchValues = searchValue.split(",");
                    this.log_.info((Object)("field.getOperator: " + field.getOperator()));
                    if (!field.getOperator().equalsIgnoreCase("like")) {
                        this.log_.info((Object)("operator: " + field.getOperator()));
                        correctedSearchValue = "";
                        i = 0;
                        while (i < newSearchValues.length) {
                            System.out.println("newSerchValues[i]: " + newSearchValues[i]);
                            Long submitterID = null;
                            submitterID = this.usermUtilitiesInterface.getIdByUserName(newSearchValues[i]);
                            if (submitterID != null) {
                                correctedSearchValue = i < newSearchValues.length - 1 ? correctedSearchValue + submitterID.toString() + "," : correctedSearchValue + submitterID.toString();
                            }
                            ++i;
                        }
                        field.setSearchValue(correctedSearchValue);
                    } else {
                        this.log_.info((Object)("LIKE operator: " + field.getOperator()));
                        correctedSearchValue = "";
                        i = 0;
                        while (i < newSearchValues.length) {
                            Vector submitterIDs = this.usermUtilitiesInterface.getIDsByUserNameLike(newSearchValues[i]);
                            int j = 0;
                            while (j < submitterIDs.size()) {
                                correctedSearchValue = j < submitterIDs.size() - 1 ? correctedSearchValue + submitterIDs.elementAt(j).toString() + "," : correctedSearchValue + submitterIDs.elementAt(j).toString();
                                ++j;
                            }
                            if (i < newSearchValues.length - 1) {
                                correctedSearchValue = correctedSearchValue + ",";
                            }
                            ++i;
                        }
                        field.setSearchValue(correctedSearchValue);
                    }
                }
                if (field.getDBFieldName().equalsIgnoreCase("Stainingname")) {
                    stainigField = new DatabaseTableField("sectionimages", "StainingID", "", true, "Stainigname", "staining", "StainingID", "Stainigname");
                    combinedField = new SearchableField(stainigField, field.getOperator(), field.getSearchValue());
                    field.setDBTableName("section");
                    field.setDBFieldName("SectionID");
                    field.setFakeDBTableField("SectionID");
                    field.setFakeTableName("sectionimages");
                    field.setFakeTableConnectorFieldName("SectionID");
                    field.setFake(true);
                    field.setSearchValue(null);
                    field.addANDCombinedField(combinedField);
                }
                if (!field.getDBFieldName().equalsIgnoreCase("Dyeing")) continue;
                stainigField = new DatabaseTableField("sectionimages", "DyeingmethodID", "", true, "Datavalue", "datadictionary", "DataID", "Datavalue");
                combinedField = new SearchableField(stainigField, field.getOperator(), field.getSearchValue());
                field.setDBTableName("section");
                field.setDBFieldName("SectionID");
                field.setFakeDBTableField("SectionID");
                field.setFakeTableName("sectionimages");
                field.setFakeTableConnectorFieldName("SectionID");
                field.setFake(true);
                field.setSearchValue(null);
                field.addANDCombinedField(combinedField);
            }
            resultList = searchcriteria == null || searchcriteria.size() == 0 ? this.genericDAO_.selectAll("section", "SectionID", orderBy, direction) : this.genericDAO_.selectCustom("section", "SectionID", searchcriteria, orderBy, direction);
            this.setList(new LinkedList(resultList));
        }
        catch (Exception e) {
            this.log_.error((Object)e);
        }
    }

    public Collection getArrayblockQuery() {
        return this.arrayblockQuery;
    }

    public Object getCurrentElement() throws IteratorException {
        return this.getElement((Long)super.getCurrentElement());
    }

    private Object getElement(Long id) throws IteratorException {
        Section entity = null;
        try {
            entity = SectionUtil.getLocalHome().findByPrimaryKey(id);
            String value_tree = "Arrayblock,Punchs,DatadictionaryPerson,DatadictionaryStorage,DatadictionaryCutter,DatadictionaryMicrotometype,DatadictionaryParaffintype,DatadictionarySlidetype,DatadictionaryCustomer";
            SectionVO sectionVO = (SectionVO)ValueTreeBuilder.getValueTree(entity, ValueTreeBuilder.createIncludeTree(value_tree));
            sectionVO.setUserVO(this.usermUtilitiesInterface.getSubmitter(sectionVO.getUserid()));
            SectionReportVO returnVO = new SectionReportVO(sectionVO);
            return returnVO;
        }
        catch (FinderException fex) {
            this.log.error("findSectionById(id=" + id + "): FinderException thrown");
            this.log.error((Object)fex);
        }
        catch (NamingException nex) {
            this.log.error("findSectionById(id=" + id + "): NamingException thrown");
            throw new IteratorException(nex.getMessage());
        }
        catch (UserSecurityException usx) {
            this.log.error("getSubmitterById: UserSecurityException thrown");
            this.log.error((Object)usx);
        }
        return null;
    }

    public List getElements(List idList) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = idList.iterator();
        while (iterator.hasNext()) {
            try {
                arrayList.add(this.getElement((Long)iterator.next()));
            }
            catch (IteratorException ex) {
            }
        }
        return arrayList;
    }

    public Collection getOperators() {
        return GlobalConstantsGenerated.getSearchOperators();
    }

    public Collection getSearchableFields() {
        Vector<DatabaseTableField> dbFields = new Vector<DatabaseTableField>();
        DatabaseTableField dbField = null;
        dbField = new DatabaseTableField("section", "BarcodeID", "BarcodeId", false);
        dbFields.add(dbField);
        dbField = new DatabaseTableField("section", "Series", "Series", false);
        dbFields.add(dbField);
        dbField = new DatabaseTableField("section", "Sectionnumber", "Sectionnumber", false);
        dbFields.add(dbField);
        dbField = new DatabaseTableField("section", "Thickness", "Thickness", false);
        dbFields.add(dbField);
        dbField = new DatabaseTableField("section", "Stained", "Stained", false);
        dbFields.add(dbField);
        dbField = new DatabaseTableField("section", "StorageID", "Storage", true, "Datavalue", "datadictionary", "DataID", "Datavalue");
        dbFields.add(dbField);
        dbField = new DatabaseTableField("section", "CustomerID", "Customer", true, "Datavalue", "datadictionary", "DataID", "Datavalue");
        dbFields.add(dbField);
        dbField = new DatabaseTableField("section", "PersonID", "Person responsible", true, "Datavalue", "datadictionary", "DataID", "Datavalue");
        dbFields.add(dbField);
        dbField = new DatabaseTableField("section", "Stainingname", "Stainingname", false);
        dbField.addAdditionalTable("staining");
        dbFields.add(dbField);
        dbField = new DatabaseTableField("section", "Dyeing", "Dyeing-Method", false);
        dbField.addAdditionalTable("datadictionary");
        dbFields.add(dbField);
        dbField = new DatabaseTableField("section", "EnterdBy", "Entered by", false);
        dbFields.add(dbField);
        dbField = new DatabaseTableField("section", "Date", "Date", false);
        dbFields.add(dbField);
        return dbFields;
    }

    private String parseSearchValue(SearchableField field) {
        String retValue = "";
        if (field.getOperator().equalsIgnoreCase("between") || field.getOperator().equalsIgnoreCase("not between")) {
            String searchValue = field.getSearchValue();
            searchValue = searchValue.trim();
            Pattern pattern = Pattern.compile("([a-zA-Z_0-9\\s]+),([a-zA-Z_0-9\\s]+)");
            Matcher matcher = pattern.matcher(searchValue);
            if (matcher.matches()) {
                System.out.println("MATCH BETWEEN");
                String value1 = matcher.group(1).trim();
                String value2 = matcher.group(2).trim();
                retValue = value1 + "," + value2;
            }
        } else if (field.getOperator().equalsIgnoreCase("in") || field.getOperator().equalsIgnoreCase("not in")) {
            Pattern pattern;
            Matcher matcher;
            String searchValue = field.getSearchValue();
            if (!(searchValue = searchValue.trim()).endsWith(",")) {
                searchValue = searchValue + ",";
            }
            if ((matcher = (pattern = Pattern.compile("([a-zA-Z_0-9\\s]{1,},){1,}")).matcher(searchValue)).matches()) {
                System.out.println("MATCH IN");
                retValue = field.getSearchValue();
            }
        } else {
            retValue = field.getSearchValue();
        }
        return retValue;
    }

    public void setArrayblockQuery(Long arraybolckId, Integer stained) {
        Vector<SearchableField> query = new Vector<SearchableField>();
        DatabaseTableField dbField = new DatabaseTableField("section", "ArrayblockID", "ArrayblockID", false);
        SearchableField field = new SearchableField(dbField, "=", arraybolckId.toString());
        query.add(field);
        dbField = new DatabaseTableField("section", "Stained", "Stained", false);
        field = new SearchableField(dbField, "=", stained.toString());
        query.add(field);
        this.arrayblockQuery = query;
    }

    public void setArrayblockStainedSectionIdList(Collection Sections) {
        try {
            ArrayList sections = new ArrayList(Sections);
            LinkedList<Long> sectionIdList = new LinkedList<Long>();
            Iterator it = ((AbstractList)sections).iterator();
            while (it.hasNext()) {
                SectionVO sectionVO = (SectionVO)it.next();
                if (sectionVO.getStained() != 1) continue;
                sectionIdList.add(sectionVO.getSectionId());
            }
            this.setList(sectionIdList);
        }
        catch (Exception e) {
            this.log_.error((Object)e);
        }
    }

    public void setArrayblockUnstainedSectionIdList(Collection Sections) {
        try {
            ArrayList sections = new ArrayList(Sections);
            LinkedList<Long> sectionIdList = new LinkedList<Long>();
            Iterator it = ((AbstractList)sections).iterator();
            while (it.hasNext()) {
                SectionVO sectionVO = (SectionVO)it.next();
                if (sectionVO.getStained() != 0) continue;
                sectionIdList.add(sectionVO.getSectionId());
            }
            this.setList(sectionIdList);
        }
        catch (Exception e) {
            this.log_.error((Object)e);
        }
    }

    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    public void setValueObjectParameters(Collection parameters) {
    }
}

