/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.tma.ejb.report;

import at.tugraz.genome.dbutilities.ConnectionManager;
import at.tugraz.genome.dbutilities.DatabaseTableField;
import at.tugraz.genome.dbutilities.GenericDAOFactory;
import at.tugraz.genome.dbutilities.SearchableField;
import at.tugraz.genome.dbutilities.exception.IteratorException;
import at.tugraz.genome.tma.GlobalConstantsGenerated;
import at.tugraz.genome.tma.ejb.entity.Tissue;
import at.tugraz.genome.tma.ejb.entity.TissueUtil;
import at.tugraz.genome.tma.ejb.report.TissuesReportServiceBean;
import at.tugraz.genome.tma.ejb.vos.TissueReportVO;
import at.tugraz.genome.tma.ejb.vos.TissueVO;
import at.tugraz.genome.usermUtilities.remote.UsermUtilitiesBusinessInterface;
import at.tugraz.genome.usermUtilities.remote.UsermUtilitiesServiceFactory;
import at.tugraz.genome.voutils.ValueTreeBuilder;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class TissuesReportServiceBeanImpl
extends TissuesReportServiceBean
implements SessionBean {
    private transient Logger log_ = Logger.getLogger(this.getClass());
    SessionContext sessionContext;
    private UsermUtilitiesBusinessInterface usermUtilitiesInterface = null;

    public void ejbActivate() {
        this.log_ = Logger.getLogger(this.getClass());
        this.genericDAO_ = GenericDAOFactory.getDAOFactory("at.tugraz.genome.dbutilities.dao.MysqlDAOFactory").getDAO();
        this.log_.info((Object)("list: " + this.list_));
        this.log_.info((Object)("currentIndex: " + this.currentIndex_));
        if (this.list_ != null) {
            this.listIterator_ = this.list_.listIterator(this.currentIndex_);
        } else {
            this.list_ = new LinkedList();
            this.listIterator_ = this.list_.listIterator();
        }
        this.log_.info((Object)"ejbActivate()");
    }

    public void ejbCreate() throws CreateException {
        this.genericDAO_ = GenericDAOFactory.getDAOFactory("at.tugraz.genome.dbutilities.dao.MysqlDAOFactory").getDAO();
        try {
            this.usermUtilitiesInterface = UsermUtilitiesServiceFactory.getInstance(ConnectionManager.getInstance().getJNDIProperties());
        }
        catch (Exception e) {
            this.log_.error((Object)e);
        }
    }

    public void ejbPassivate() {
        this.log_.info((Object)"ejbPassivate()");
    }

    public void ejbRemove() {
        this.log_.info((Object)"ejbRemove");
    }

    public void executeQuery(Collection searchCriteria, Long id) {
        DatabaseTableField orderBy = this.getDatabaseTableField("SampleId");
        this.executeQuery(searchCriteria, id, orderBy, null);
    }

    public void executeQuery(Collection searchCriteria, Long id, DatabaseTableField orderBy) {
        this.executeQuery(searchCriteria, id, orderBy, null);
    }

    public void executeQuery(Collection searchCriteria, Long id, DatabaseTableField orderBy, String direction) {
        this.log_.info((Object)"executeSearch");
        System.out.println(" AdditionalTables: " + orderBy.getAdditionalTables() + " DBFieldDisplayName: " + orderBy.getDBFieldDisplayName() + " DBFieldName: " + orderBy.getDBFieldName() + " DBTableAlias: " + orderBy.getDBTableAlias() + " FakeTableName: " + orderBy.getFakeTableName() + " Key: " + orderBy.getKey() + " SQLSubStatement: " + orderBy.getSQLSubStatement() + " isFake: " + orderBy.isFake());
        try {
            List resultList = null;
            Vector searchcriteria = null;
            this.log_.info((Object)("searchCriteria: " + searchCriteria));
            searchcriteria = searchCriteria == null ? new Vector() : new Vector(searchCriteria);
            Iterator it = ((AbstractList)searchcriteria).iterator();
            while (it.hasNext()) {
                int i;
                String correctedSearchValue;
                SearchableField field = (SearchableField)it.next();
                System.out.println("AdditionalTables: " + field.getAdditionalTables() + " FieldDisplayName: " + field.getDBFieldDisplayName() + " DBFieldName: " + field.getDBFieldName() + " DBTableAlias: " + field.getDBTableAlias() + " FakeDBTableField: " + field.getFakeDBTableField() + " FakeOrderByField: " + field.getFakeOrderByField() + " FakeTableAlias: " + field.getFakeTableAlias() + " FakeTableConnectorFieldName: " + field.getFakeTableConnectorFieldName() + " Operator: " + field.getOperator() + " SearchValue: " + field.getSearchValue() + " Key: " + field.getKey() + " SQLSubStatement: " + field.getSQLSubStatement() + " isFake: " + field.isFake());
                if (!field.getDBFieldName().equalsIgnoreCase("userid")) continue;
                String searchValue = this.parseSearchValue(field);
                System.out.println("searchValue: " + searchValue);
                String[] newSearchValues = searchValue.split(",");
                this.log_.info((Object)("field.getOperator: " + field.getOperator()));
                if (!field.getOperator().equalsIgnoreCase("like")) {
                    this.log_.info((Object)("operator: " + field.getOperator()));
                    correctedSearchValue = "";
                    i = 0;
                    while (i < newSearchValues.length) {
                        System.out.println("newSerchValues[i]: " + newSearchValues[i]);
                        Long submitterID = null;
                        submitterID = this.usermUtilitiesInterface.getIdByUserName(newSearchValues[i]);
                        if (submitterID != null) {
                            correctedSearchValue = i < newSearchValues.length - 1 ? correctedSearchValue + submitterID.toString() + "," : correctedSearchValue + submitterID.toString();
                        }
                        ++i;
                    }
                    field.setSearchValue(correctedSearchValue);
                    continue;
                }
                this.log_.info((Object)("LIKE operator: " + field.getOperator()));
                correctedSearchValue = "";
                i = 0;
                while (i < newSearchValues.length) {
                    System.out.println("newSerchValues[i]: " + newSearchValues[i]);
                    Vector submitterIDs = this.usermUtilitiesInterface.getIDsByUserNameLike(newSearchValues[i]);
                    int j = 0;
                    while (j < submitterIDs.size()) {
                        correctedSearchValue = j < submitterIDs.size() - 1 ? correctedSearchValue + submitterIDs.elementAt(j).toString() + "," : correctedSearchValue + submitterIDs.elementAt(j).toString();
                        ++j;
                    }
                    if (i < newSearchValues.length - 1) {
                        correctedSearchValue = correctedSearchValue + ",";
                    }
                    ++i;
                }
                field.setSearchValue(correctedSearchValue);
            }
            resultList = searchcriteria == null || searchcriteria.size() == 0 ? this.genericDAO_.selectAll("tissues", "TissueID", orderBy, direction) : this.genericDAO_.selectCustom("tissues", "TissueID", searchcriteria, orderBy, direction);
            this.setList(new LinkedList(resultList));
        }
        catch (Exception e) {
            this.log_.error((Object)e);
        }
    }

    public Object getCurrentElement() throws IteratorException {
        this.log.debug("getCurrentElement");
        Long id = (Long)super.getCurrentElement();
        Tissue entity = null;
        try {
            entity = TissueUtil.getLocalHome().findByPrimaryKey(id);
            String value_tree = "Topography,Morphology,Grade,Behaviour,DatadictionarySpecies,DatadictionaryStagingT,DatadictionaryStagingN,DatadictionaryStagingM,DatadictionaryStagingR,DatadictionarySite,DatadictionarySource,Donors";
            TissueVO tissVO = (TissueVO)ValueTreeBuilder.getValueTree(entity, ValueTreeBuilder.createIncludeTree(value_tree));
            TissueReportVO returnVO = new TissueReportVO(tissVO);
            return returnVO;
        }
        catch (FinderException fex) {
            this.log.error("findTissuesById(id=" + id + "): FinderException thrown");
            this.log.error((Object)fex);
        }
        catch (NamingException nex) {
            this.log.error("findTissuesById(id=" + id + "): NamingException thrown");
            throw new IteratorException(nex.getMessage());
        }
        return null;
    }

    public List getElements(List idList) {
        this.log.debug("getElements");
        ArrayList<TissueReportVO> arrayList = new ArrayList<TissueReportVO>();
        Tissue entity = null;
        try {
            Iterator iterator = idList.iterator();
            while (iterator.hasNext()) {
                Long id = (Long)iterator.next();
                entity = TissueUtil.getLocalHome().findByPrimaryKey(id);
                String value_tree = "Topography,Morphology,Grade,Behaviour,DatadictionarySpecies,DatadictionaryStagingT,DatadictionaryStagingN,DatadictionaryStagingM,DatadictionaryStagingR,DatadictionarySite,DatadictionarySource,Donors";
                TissueVO tissVO = (TissueVO)ValueTreeBuilder.getValueTree(entity, ValueTreeBuilder.createIncludeTree(value_tree));
                TissueReportVO returnVO = new TissueReportVO(tissVO);
                arrayList.add(returnVO);
            }
        }
        catch (FinderException fex) {
            this.log.error("findTissuesById(id=" + this.id + "): FinderException thrown");
            this.log.error((Object)fex);
            return null;
        }
        catch (NamingException nex) {
            this.log.error("findTissuesById(id=" + this.id + "): NamingException thrown");
            this.log.error(nex);
        }
        this.log.debug("done");
        return arrayList;
    }

    public Collection getOperators() {
        return GlobalConstantsGenerated.getSearchOperators();
    }

    public Collection getSearchableFields() {
        Vector<DatabaseTableField> dbFields = new Vector<DatabaseTableField>();
        DatabaseTableField dbField = null;
        dbField = new DatabaseTableField("tissues", "SpeciesID", "Species", true, "Datavalue", "datadictionary", "DataID", "Datavalue");
        dbFields.add(dbField);
        dbField = new DatabaseTableField("tissues", "SampleID", "SampleId", false);
        dbFields.add(dbField);
        dbField = new DatabaseTableField("tissues", "Tissuecomment", "Tissuecomment", false);
        dbFields.add(dbField);
        dbField = new DatabaseTableField("tissues", "GradeID", "Grade", true, "Grade", "grade", "GradeID", "Grade");
        dbFields.add(dbField);
        dbField = new DatabaseTableField("tissues", "TopographyID", "Topography", true, "Topography", "topography", "TopographyID", "Topography");
        dbFields.add(dbField);
        dbField = new DatabaseTableField("tissues", "MorphologyID", "Morphology", true, "Morphology", "morphology", "MorphologyID", "Morphology");
        dbFields.add(dbField);
        dbField = new DatabaseTableField("tissues", "BehaviourID", "Classification", true, "Behaviour", "behaviour", "BehaviourID", "Behaviour");
        dbFields.add(dbField);
        dbField = new DatabaseTableField("tissues", "StagingTID", "StagingT", true, "Datavalue", "datadictionary", "DataID", "Datavalue");
        dbFields.add(dbField);
        dbField = new DatabaseTableField("tissues", "StagingNID", "StagingN", true, "Datavalue", "datadictionary", "DataID", "Datavalue");
        dbFields.add(dbField);
        dbField = new DatabaseTableField("tissues", "StagingMID", "StagingM", true, "Datavalue", "datadictionary", "DataID", "Datavalue");
        dbFields.add(dbField);
        dbField = new DatabaseTableField("tissues", "StagingRID", "StagingR", true, "Datavalue", "datadictionary", "DataID", "Datavalue");
        dbFields.add(dbField);
        dbField = new DatabaseTableField("tissues", "SiteID", "Site", true, "Datavalue", "datadictionary", "DataID", "Datavalue");
        dbFields.add(dbField);
        dbField = new DatabaseTableField("tissues", "SourceID", "Sourcedb", true, "Datavalue", "datadictionary", "DataID", "Datavalue");
        dbFields.add(dbField);
        return dbFields;
    }

    private String parseSearchValue(SearchableField field) {
        String retValue = "";
        if (field.getOperator().equalsIgnoreCase("between") || field.getOperator().equalsIgnoreCase("not between")) {
            String searchValue = field.getSearchValue();
            searchValue = searchValue.trim();
            Pattern pattern = Pattern.compile("([a-zA-Z_0-9\\s]+),([a-zA-Z_0-9\\s]+)");
            Matcher matcher = pattern.matcher(searchValue);
            if (matcher.matches()) {
                System.out.println("MATCH BETWEEN");
                String value1 = matcher.group(1).trim();
                String value2 = matcher.group(2).trim();
                retValue = value1 + "," + value2;
            }
        } else if (field.getOperator().equalsIgnoreCase("in") || field.getOperator().equalsIgnoreCase("not in")) {
            Pattern pattern;
            Matcher matcher;
            String searchValue = field.getSearchValue();
            if (!(searchValue = searchValue.trim()).endsWith(",")) {
                searchValue = searchValue + ",";
            }
            if ((matcher = (pattern = Pattern.compile("([a-zA-Z_0-9\\s]{1,},){1,}")).matcher(searchValue)).matches()) {
                System.out.println("MATCH IN");
                retValue = field.getSearchValue();
            }
        } else {
            retValue = field.getSearchValue();
        }
        return retValue;
    }

    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    public void setValueObjectParameters(Collection parameters) {
    }
}

