/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.tma.ejb.service;

import at.tugraz.genome.tma.csvparser.CSVParser;
import at.tugraz.genome.tma.ejb.entity.Antibody;
import at.tugraz.genome.tma.ejb.entity.AntibodyUtil;
import at.tugraz.genome.tma.ejb.entity.Antigen;
import at.tugraz.genome.tma.ejb.entity.AntigenUtil;
import at.tugraz.genome.tma.ejb.entity.Arrayblock;
import at.tugraz.genome.tma.ejb.entity.ArrayblockUtil;
import at.tugraz.genome.tma.ejb.entity.ArraypunchassociationUtil;
import at.tugraz.genome.tma.ejb.entity.Arraytype;
import at.tugraz.genome.tma.ejb.entity.ArraytypeUtil;
import at.tugraz.genome.tma.ejb.entity.Datadictionary;
import at.tugraz.genome.tma.ejb.entity.DatadictionaryUtil;
import at.tugraz.genome.tma.ejb.entity.Donor;
import at.tugraz.genome.tma.ejb.entity.DonorUtil;
import at.tugraz.genome.tma.ejb.entity.Section;
import at.tugraz.genome.tma.ejb.entity.SectionUtil;
import at.tugraz.genome.tma.ejb.entity.Staining;
import at.tugraz.genome.tma.ejb.entity.StainingUtil;
import at.tugraz.genome.tma.ejb.service.ArrayblockSectionStainingServiceBean;
import at.tugraz.genome.tma.ejb.vos.AntibodyVO;
import at.tugraz.genome.tma.ejb.vos.AntigenVO;
import at.tugraz.genome.tma.ejb.vos.ArrayblockVO;
import at.tugraz.genome.tma.ejb.vos.ArraypunchassociationVO;
import at.tugraz.genome.tma.ejb.vos.ArraytypeVO;
import at.tugraz.genome.tma.ejb.vos.DatadictionaryVO;
import at.tugraz.genome.tma.ejb.vos.DonorVO;
import at.tugraz.genome.tma.ejb.vos.SectionVO;
import at.tugraz.genome.tma.ejb.vos.StainingVO;
import at.tugraz.genome.tma.exceptions.TmaGlobalException;
import at.tugraz.genome.voutils.ValueTreeBuilder;
import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class ArrayblockSectionStainingServiceBeanImpl
extends ArrayblockSectionStainingServiceBean
implements SessionBean {
    private SessionContext context;
    private int donors_notok = 0;

    public void deleteArrayblock(ArrayblockVO arrayblockVO) throws TmaGlobalException {
        this.log.debug("deleteArrayblock:begin");
        this.removeArrayblock(arrayblockVO.getArrayblockId());
        if (!arrayblockVO.getArraypunchassociations().isEmpty()) {
            Collection arraypunchassociations = arrayblockVO.getArraypunchassociations();
            this.log.info("deleteArrayblock: found " + arraypunchassociations.size() + " arraypunchassociations");
            Iterator iter = arraypunchassociations.iterator();
            while (iter.hasNext()) {
                ArraypunchassociationVO arraypunchassociationVO = (ArraypunchassociationVO)iter.next();
                this.removeArraypunchassociation(arraypunchassociationVO.getApassociationId());
            }
        } else {
            throw new TmaGlobalException("No Arraypunchassociation found");
        }
    }

    public void ejbActivate() {
    }

    public void ejbCreate() throws CreateException {
    }

    public void ejbPassivate() {
    }

    public void ejbRemove() {
    }

    public boolean existArrayblockBarcode(Long barcodeid) throws TmaGlobalException {
        return this.existBarcode(barcodeid);
    }

    private boolean existBarcode(Long barcodeid) throws TmaGlobalException {
        this.log.debug("existArrayblockBarcode(java.lang.Long barcodeid): begin");
        try {
            Arrayblock entity = ArrayblockUtil.getLocalHome().findArrayblockByBarcodeID(barcodeid);
            return true;
        }
        catch (FinderException fex) {
            this.log.debug("BarcodeID not exists");
            return false;
        }
        catch (NamingException nex) {
            this.log.error("findByBarcodeID: NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    private AntibodyVO getAntibodyVO(Long id) throws TmaGlobalException {
        this.log.debug("getAntibodyVO: begin id=" + id);
        Antibody entity = null;
        try {
            entity = AntibodyUtil.getLocalHome().findByPrimaryKey(id);
        }
        catch (FinderException fex) {
            this.log.error("getAntibodyVO(id=" + id + "): FinderException thrown");
            this.log.error((Object)fex);
            return null;
        }
        catch (NamingException nex) {
            this.log.error("getAntibodyVO(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        AntibodyVO returnVO = (AntibodyVO)ValueTreeBuilder.getValueTree(entity, ValueTreeBuilder.createIncludeTree(""));
        this.log.info("getAntibodyVO: finished successfuly returnVO=" + returnVO);
        return returnVO;
    }

    private AntigenVO getAntigenVO(Long id) throws TmaGlobalException {
        this.log.debug("getAntigenVO: begin id=" + id);
        Antigen entity = null;
        try {
            entity = AntigenUtil.getLocalHome().findByPrimaryKey(id);
        }
        catch (FinderException fex) {
            this.log.error("getAntigenVO(id=" + id + "): FinderException thrown");
            this.log.error((Object)fex);
            return null;
        }
        catch (NamingException nex) {
            this.log.error("getAntigenVO(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        AntigenVO returnVO = (AntigenVO)ValueTreeBuilder.getValueTree(entity, ValueTreeBuilder.createIncludeTree(""));
        this.log.info("getAntigenVO: finished successfuly returnVO=" + returnVO);
        return returnVO;
    }

    private ArrayblockVO getArrayblockVO(Long id) throws TmaGlobalException {
        this.log.debug("getArrayblockVO: begin id=" + id);
        Arrayblock entity = null;
        try {
            entity = ArrayblockUtil.getLocalHome().findByPrimaryKey(id);
        }
        catch (FinderException fex) {
            this.log.error("getArrayblockVO(id=" + id + "): FinderException thrown");
            this.log.error((Object)fex);
            throw new TmaGlobalException("getArrayblockVO(id=" + id + "): FinderException thrown");
        }
        catch (NamingException nex) {
            this.log.error("getArrayblockVO(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        ArrayblockVO returnVO = (ArrayblockVO)ValueTreeBuilder.getValueTree(entity, ValueTreeBuilder.createIncludeTree(""));
        this.log.info("getArrayblockVO: finished successfuly returnVO=" + returnVO);
        return returnVO;
    }

    private ArraytypeVO getArraytypeVO(Long id) throws TmaGlobalException {
        this.log.debug("getArraytypeVO: begin id=" + id);
        Arraytype entity = null;
        try {
            entity = ArraytypeUtil.getLocalHome().findByPrimaryKey(id);
        }
        catch (FinderException fex) {
            this.log.error("getArraytypeVO(id=" + id + "): FinderException thrown");
            this.log.error((Object)fex);
            return null;
        }
        catch (NamingException nex) {
            this.log.error("getArraytypeVO(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        ArraytypeVO returnVO = (ArraytypeVO)ValueTreeBuilder.getValueTree(entity, ValueTreeBuilder.createIncludeTree(""));
        this.log.info("getArraytypeVO: finished successfuly returnVO=" + returnVO);
        return returnVO;
    }

    private DatadictionaryVO getDatadictionaryVO(Long id) throws TmaGlobalException {
        this.log.debug("getDatadictionaryVO: begin id=" + id);
        Datadictionary entity = null;
        try {
            entity = DatadictionaryUtil.getLocalHome().findByPrimaryKey(id);
        }
        catch (FinderException fex) {
            this.log.error("getDatadictionaryVO(id=" + id + "): FinderException thrown");
            this.log.error((Object)fex);
            return null;
        }
        catch (NamingException nex) {
            this.log.error("getDatadictionaryVO(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        DatadictionaryVO returnVO = (DatadictionaryVO)ValueTreeBuilder.getValueTree(entity, ValueTreeBuilder.createIncludeTree(""));
        this.log.info("getDatadictionaryVO: finished successfuly returnVO=" + returnVO);
        return returnVO;
    }

    private DonorVO getDonorVO(Long id) throws TmaGlobalException {
        this.log.debug("getDonorVO: begin id=" + id);
        Donor entity = null;
        try {
            entity = DonorUtil.getLocalHome().findDonorByBarcodeID(id);
            DonorVO returnVO = (DonorVO)ValueTreeBuilder.getValueTree(entity, ValueTreeBuilder.createIncludeTree(""));
            this.log.info("getDonorVO: finished successfuly returnVO=" + returnVO);
            return returnVO;
        }
        catch (FinderException fex) {
            this.log.debug("getDonorVO(id=" + id + "): FinderException thrown");
            return null;
        }
        catch (NamingException nex) {
            this.log.debug("getDonorVO: NamingException thrown");
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    private Integer getValue(String[][] data, int row, int col) {
        Integer ret_val = new Integer(-1);
        try {
            ret_val = new Integer(data[row][col]);
        }
        catch (NumberFormatException ex) {
            System.out.println("Invalid number in row " + row + " column " + col + " - ignoring value for barcode:" + data[row][0] + ")");
            ++this.donors_notok;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            System.out.println("Missing data in in row " + row + " column " + col + " - ignoring value for barcode:" + data[row][0] + ")");
            ++this.donors_notok;
        }
        return ret_val;
    }

    public String insertArrayblockData(Long barcodeId, String arrayblockname, String cvsfilename, byte[] cvsfile, Date date, Long arraytypeId, Long customerId, Long userId) throws TmaGlobalException {
        this.log.debug("insertArrayblockData: begin");
        ArrayblockVO vo = new ArrayblockVO(null, barcodeId, userId, date, cvsfilename, cvsfile, arrayblockname);
        vo.setArraytype(this.getArraytypeVO(arraytypeId));
        vo.setDatadictionaryCustomer(this.getDatadictionaryVO(customerId));
        String[][] data = null;
        data = this.parseCsv(cvsfile);
        int donors_ok = 0;
        this.donors_notok = 0;
        int i = 0;
        while (i < data.length) {
            Long id = new Long(data[i][0]);
            DonorVO donorvo_ = this.getDonorVO(id);
            if (donorvo_ == null) {
                System.out.println("No donor found for barcode: " + data[i][0] + " ignoring this entry in csv-file");
                ++this.donors_notok;
            } else {
                ++donors_ok;
                vo.addDonor(donorvo_);
                ArraypunchassociationVO apaVo_ = new ArraypunchassociationVO();
                apaVo_.setRow(this.getValue(data, i, 12));
                apaVo_.setCol(this.getValue(data, i, 13));
                apaVo_.setCoreindex(this.getValue(data, i, 8));
                apaVo_.setCorex(this.getValue(data, i, 10));
                apaVo_.setCorey(this.getValue(data, i, 11));
                apaVo_.setDonor(donorvo_);
                vo.addArraypunchassociation(apaVo_);
            }
            ++i;
        }
        this.addArrayblock(vo);
        return new String("Success: Found " + donors_ok + " Donor-Barcodes in csv-file which really exist. (csv-file had " + data.length + " entries)");
    }

    private boolean insertSection(SectionVO vo) {
        this.log.debug("insertSection: begin vo=" + vo);
        Section entity = null;
        try {
            entity = SectionUtil.getLocalHome().create(vo);
            return true;
        }
        catch (NamingException ex) {
            return false;
        }
        catch (CreateException ex) {
            return false;
        }
    }

    public void insertSectionSeries(Integer thickness, Date date, Long arrayblockId, Long storageId, Long microtometypeId, Long paraffinetypeId, Long slidetypeId, Long customerId, Long cutterId, Long personId, Long userId, int numberofcuts) throws TmaGlobalException {
        DatadictionaryVO person;
        DatadictionaryVO customer;
        DatadictionaryVO slidetype;
        this.log.debug("insertSectionSeries: begin");
        int[] numbers = this.maxSectionNumber(arrayblockId);
        int startsectionNum = numbers[0] + 1;
        int endsectionNum = startsectionNum + numberofcuts;
        ArrayblockVO arrayblockvo = this.getArrayblockVO(arrayblockId);
        int startbcodeID = arrayblockvo.getBarcodeId().intValue() * 1000;
        DatadictionaryVO undefined = this.getDatadictionaryVO(new Long(0L));
        if (undefined == null) {
            throw new TmaGlobalException("undefined is null");
        }
        DatadictionaryVO storage = this.getDatadictionaryVO(storageId);
        if (storage == null) {
            throw new TmaGlobalException("Storage is null");
        }
        DatadictionaryVO microtometype = this.getDatadictionaryVO(microtometypeId);
        if (microtometype == null) {
            throw new TmaGlobalException("Microtometype is null");
        }
        DatadictionaryVO cutter = this.getDatadictionaryVO(cutterId);
        if (cutter == null) {
            throw new TmaGlobalException("Cutter is null");
        }
        DatadictionaryVO paraffinetype = this.getDatadictionaryVO(paraffinetypeId);
        if (paraffinetype == null) {
            paraffinetype = undefined;
        }
        if ((slidetype = this.getDatadictionaryVO(slidetypeId)) == null) {
            slidetype = undefined;
        }
        if ((customer = this.getDatadictionaryVO(customerId)) == null) {
            customer = undefined;
        }
        if ((person = this.getDatadictionaryVO(personId)) == null) {
            person = undefined;
        }
        int sectionNum = startsectionNum;
        while (sectionNum < endsectionNum) {
            SectionVO vo = new SectionVO(null, new Integer(endsectionNum), new Integer(0), new Integer(sectionNum), new Long(startbcodeID + sectionNum), thickness, userId, date, new Integer(numbers[1] + 1));
            vo.setArrayblock(arrayblockvo);
            vo.setDatadictionaryStorage(storage);
            vo.setDatadictionaryMicrotometype(microtometype);
            vo.setDatadictionaryCutter(cutter);
            vo.setDatadictionaryPerson(person);
            vo.setDatadictionarySlidetype(slidetype);
            vo.setDatadictionaryCustomer(customer);
            vo.setDatadictionaryParaffintype(paraffinetype);
            boolean sucsess = this.insertSection(vo);
            if (!sucsess) {
                this.context.setRollbackOnly();
                throw new TmaGlobalException("Insert Error occured");
            }
            ++sectionNum;
        }
    }

    private int[] maxSectionNumber(Long arrayblockID) throws TmaGlobalException {
        int[] ret_ = new int[]{0, 0};
        try {
            InitialContext ctx = new InitialContext();
            Connection con = null;
            DataSource ds = (DataSource)ctx.lookup("java:comp/env/jdbc/MySqlDS");
            con = ds.getConnection();
            StringBuffer sql = new StringBuffer("SELECT ");
            sql.append("MAX(Sectionnumber) AS Sectionnumber, MAX(Series) AS Series ");
            sql.append("FROM section ");
            sql.append("WHERE ArrayBlockID='" + arrayblockID.toString() + "'");
            PreparedStatement ps = con.prepareStatement(sql.toString());
            ResultSet rs = ps.executeQuery();
            rs.first();
            ret_[0] = rs.getInt("Sectionnumber");
            ret_[1] = rs.getInt("Series");
            rs.close();
            ps.close();
            con.close();
            System.out.println("Sectionnumber:" + ret_[0]);
            System.out.println("Series:" + ret_[1]);
        }
        catch (SQLException ex) {
            this.log.error("maxSectionNumber(id=" + arrayblockID + "): SQLException thrown");
            this.log.error(ex);
        }
        catch (NamingException ex) {
            this.log.error("maxSectionNumber(id=" + arrayblockID + "): NamingException thrown");
            this.log.error(ex);
        }
        return ret_;
    }

    /*
     * WARNING - void declaration
     */
    private String[][] parseCsv(byte[] csv_) throws TmaGlobalException {
        CSVParser parser = null;
        String[][] data_ = null;
        try {
            int n;
            byte[] buf = new byte[1024];
            ByteArrayInputStream bs = new ByteArrayInputStream(csv_);
            StringBuffer sb = new StringBuffer();
            while ((n = bs.read(buf)) > 0) {
                void var5_8;
                int i = 0;
                while (i < var5_8) {
                    if (buf[i] == 44) {
                        buf[i] = 46;
                    }
                    if (buf[i] == 9) {
                        buf[i] = 44;
                    }
                    sb.append((char)buf[i]);
                    ++i;
                }
            }
            if (sb.indexOf("Donor") == 0) {
                int pos = sb.indexOf("\n");
                sb = sb.delete(0, pos + 1);
            }
            StringReader sr = new StringReader(sb.toString());
            parser = new CSVParser(sr);
            parser.setCommentStart("#;!");
            parser.setEscapes("nrtf", "\n\r\t\f");
            data_ = parser.getAllValues();
        }
        catch (Exception ex) {
            throw new TmaGlobalException("Caught IOException in insertArrayblockData():parseCsv");
        }
        return data_;
    }

    private void removeArrayblock(Long id) throws TmaGlobalException {
        this.log.info("removeArrayblock: begin id=" + id);
        Object entity = null;
        try {
            ArrayblockUtil.getLocalHome().remove(id);
            this.log.info("removeArrayblock: finished successfuly");
        }
        catch (RemoveException rex) {
            this.log.error("removeArrayblock(id=" + id + "): RemoveException thrown");
            this.log.error((Object)rex);
            throw new TmaGlobalException(rex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("removeArrayblock(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    private void removeArraypunchassociation(Long id) throws TmaGlobalException {
        this.log.info("removeArraypunchassociation: begin id=" + id);
        Object entity = null;
        try {
            ArraypunchassociationUtil.getLocalHome().remove(id);
            this.log.info("removeArraypunchassociation: finished successfuly");
        }
        catch (RemoveException rex) {
            this.log.error("removeArraypunchassociatio(id=" + id + "): RemoveException thrown");
            this.log.error((Object)rex);
            throw new TmaGlobalException(rex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("removeArraypunchassociation(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    public void setSessionContext(SessionContext ctx) {
        this.context = ctx;
    }

    public void updateAntibodyData(Long antibodyId, String antibodyname, String clonenumber, Long antibodytypeId, Long companyId, Long speciesId, Long igtypeId) throws TmaGlobalException {
        this.log.info("updateAntibodyData: begin stainingID =" + antibodyId);
        Antibody entity = null;
        if (antibodyId == null) {
            throw new TmaGlobalException("updateAntibodyData: the primaryKey of the vo is null!");
        }
        try {
            entity = AntibodyUtil.getLocalHome().findByPrimaryKey(antibodyId);
            AntibodyVO oldVO = (AntibodyVO)ValueTreeBuilder.getValueTree(entity, ValueTreeBuilder.createIncludeTree("Antigens,Stainings"));
            if (antibodyname != null) {
                oldVO.setAntibodyname(antibodyname);
            }
            if (clonenumber != null) {
                oldVO.setClonenumber(clonenumber);
            }
            if (antibodytypeId != null) {
                oldVO.setDatadictionaryType(this.getDatadictionaryVO(antibodytypeId));
            }
            if (companyId != null) {
                oldVO.setDatadictionaryCompany(this.getDatadictionaryVO(companyId));
            }
            if (speciesId != null) {
                oldVO.setDatadictionarySpecies(this.getDatadictionaryVO(speciesId));
            }
            if (igtypeId != null) {
                oldVO.setDatadictionaryIgtype(this.getDatadictionaryVO(igtypeId));
            }
            entity.update(oldVO);
            this.log.info("updateAntibodyData: finished successfuly");
        }
        catch (FinderException fex) {
            this.log.error("updateAntibodyData: FinderException thrown");
            this.log.error((Object)fex);
            throw new TmaGlobalException(fex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("updateAntibodyData: NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        catch (CreateException cex) {
            this.log.error("updateAntibodyData: javax.ejb.CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
    }

    public void updateArrayblockData(Long arrayblockId, Long barcodeId, String name, Date date, Long customerId) throws TmaGlobalException {
        this.log.info("updateArrayblockData: begin arrayblockId =" + arrayblockId);
        Arrayblock entity = null;
        if (arrayblockId == null) {
            throw new TmaGlobalException("updateArrayblockData: the primaryKey of the vo is null!");
        }
        try {
            entity = ArrayblockUtil.getLocalHome().findByPrimaryKey(arrayblockId);
            ArrayblockVO oldVO = (ArrayblockVO)ValueTreeBuilder.getValueTree(entity, ValueTreeBuilder.createIncludeTree("Donors,Sections,Arraytype,Arraypunchassociations"));
            if (barcodeId != null) {
                oldVO.setBarcodeId(barcodeId);
            }
            if (name != null) {
                oldVO.setName(name);
            }
            if (date != null) {
                oldVO.setDate(date);
            }
            if (customerId != null) {
                oldVO.setDatadictionaryCustomer(this.getDatadictionaryVO(customerId));
            }
            entity.update(oldVO);
            this.log.info("updateArrayblockData: finished successfuly");
        }
        catch (FinderException fex) {
            this.log.error("updateArrayblockData: FinderException thrown");
            this.log.error((Object)fex);
            throw new TmaGlobalException(fex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("updateArrayblockData: NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        catch (CreateException cex) {
            this.log.error("updateArrayblockData: javax.ejb.CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
    }

    public void updateSectionData(Long sectionId, Integer thickness, Date date, Long storageId, Long microtometypeId, Long customerId, Long paraffintypeId, Long slidetypeId, Long cutterId, Long personId) throws TmaGlobalException {
        this.log.info("updateSectionData: begin sectionID =" + sectionId);
        Section entity = null;
        if (sectionId == null) {
            throw new TmaGlobalException("updateSectionData: the primaryKey of the vo is null!");
        }
        try {
            entity = SectionUtil.getLocalHome().findByPrimaryKey(sectionId);
            SectionVO oldVO = (SectionVO)ValueTreeBuilder.getValueTree(entity, ValueTreeBuilder.createIncludeTree("Arrayblock,Sectionimages,Punchs,Algorithmspersections,DatadictionaryMicrotometype,DatadictionaryParaffintype,DatadictionarySlidetype,DatadictionaryCustomer,DatadictionaryCutter,DatadictionaryPerson"));
            if (date != null) {
                oldVO.setDate(date);
            }
            if (thickness != null) {
                oldVO.setThickness(thickness);
            }
            if (storageId != null) {
                oldVO.setDatadictionaryStorage(this.getDatadictionaryVO(storageId));
            }
            if (microtometypeId != null) {
                oldVO.setDatadictionaryMicrotometype(this.getDatadictionaryVO(microtometypeId));
            }
            if (customerId != null) {
                oldVO.setDatadictionaryCustomer(this.getDatadictionaryVO(customerId));
            }
            if (paraffintypeId != null) {
                oldVO.setDatadictionaryParaffintype(this.getDatadictionaryVO(paraffintypeId));
            }
            if (slidetypeId != null) {
                oldVO.setDatadictionarySlidetype(this.getDatadictionaryVO(slidetypeId));
            }
            if (cutterId != null) {
                oldVO.setDatadictionaryCutter(this.getDatadictionaryVO(cutterId));
            }
            if (personId != null) {
                oldVO.setDatadictionaryPerson(this.getDatadictionaryVO(personId));
            }
            entity.update(oldVO);
            this.log.info("updateSectionData: finished successfuly");
        }
        catch (FinderException fex) {
            this.log.error("updateSectionData: FinderException thrown");
            this.log.error((Object)fex);
            throw new TmaGlobalException(fex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("updateSectionData: NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        catch (CreateException cex) {
            this.log.error("updateSectionData: javax.ejb.CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
    }

    public void updateStainingData(Long stainingId, String stainingname, String comment, String protocolfilename, byte[] protocol, Date date, Long colorId, Long antigenId, Long antibodyId) throws TmaGlobalException {
        this.log.info("updateStainingData: begin stainingID =" + stainingId);
        Staining entity = null;
        if (stainingId == null) {
            throw new TmaGlobalException("updateSectionData: the primaryKey of the vo is null!");
        }
        try {
            entity = StainingUtil.getLocalHome().findByPrimaryKey(stainingId);
            StainingVO oldVO = (StainingVO)ValueTreeBuilder.getValueTree(entity, ValueTreeBuilder.createIncludeTree("Antibody,Antigen,Sectionimages"));
            if (stainingname != null) {
                oldVO.setStainingname(stainingname);
            }
            if (comment != null) {
                oldVO.setComment(comment);
            }
            if (protocolfilename != null && protocol != null) {
                oldVO.setStainingprotocol(protocol);
                oldVO.setProtocolfilename(protocolfilename);
            }
            if (date != null) {
                oldVO.setDate(date);
            }
            if (colorId != null) {
                oldVO.setDatadictionaryColor(this.getDatadictionaryVO(colorId));
            }
            if (antibodyId != null) {
                oldVO.setAntibody(this.getAntibodyVO(antibodyId));
            }
            if (antigenId != null) {
                oldVO.setAntigen(this.getAntigenVO(antigenId));
            }
            entity.update(oldVO);
            this.log.info("updateStainingData: finished successfuly");
        }
        catch (FinderException fex) {
            this.log.error("updateStainingData: FinderException thrown");
            this.log.error((Object)fex);
            throw new TmaGlobalException(fex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("updateStainingData: NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        catch (CreateException cex) {
            this.log.error("updateStainingData: javax.ejb.CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
    }
}

