/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.tma.ejb.service;

import at.tugraz.genome.tma.ejb.entity.PunchUtil;
import at.tugraz.genome.tma.ejb.entity.Sectionimage;
import at.tugraz.genome.tma.ejb.entity.SectionimageUtil;
import at.tugraz.genome.tma.ejb.service.GriddingAppletServiceBean;
import at.tugraz.genome.tma.ejb.vos.ArrayblockVO;
import at.tugraz.genome.tma.ejb.vos.ArraypunchassociationVO;
import at.tugraz.genome.tma.ejb.vos.PunchVO;
import at.tugraz.genome.tma.ejb.vos.PunchimageVO;
import at.tugraz.genome.tma.ejb.vos.SectionVO;
import at.tugraz.genome.tma.ejb.vos.SectionimageVO;
import at.tugraz.genome.tma.exceptions.TmaGlobalException;
import at.tugraz.genome.voutils.ValueTreeBuilder;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.NamingException;

public class GriddingAppletServiceBeanImpl
extends GriddingAppletServiceBean
implements SessionBean {
    private SessionContext context;

    private Hashtable createPunchVOs(SectionVO sectionVo) throws TmaGlobalException {
        this.log.info("createPunchVOs");
        Hashtable<Point, PunchVO> punchVOs = new Hashtable<Point, PunchVO>();
        Collection arraypunchassociation = sectionVo.getArrayblock().getArraypunchassociations();
        Iterator iter = arraypunchassociation.iterator();
        while (iter.hasNext()) {
            PunchVO punchVO = new PunchVO();
            ArraypunchassociationVO arraypunchassociationVO = (ArraypunchassociationVO)iter.next();
            punchVO.setArraypunchassociation(arraypunchassociationVO);
            punchVO.setSection(sectionVo);
            try {
                PunchUtil.getLocalHome().create(punchVO);
                int row = arraypunchassociationVO.getRow();
                int col = arraypunchassociationVO.getCol();
                Point key = new Point(row, col);
                punchVOs.put(key, punchVO);
            }
            catch (Exception ex) {
                this.log.info("ERROR insertPunchimages:createPunchVOs" + ex.getMessage());
                this.context.setRollbackOnly();
                throw new TmaGlobalException("ERROR insertPunchimages:createPunchVOs");
            }
        }
        return punchVOs;
    }

    public void ejbActivate() {
    }

    public void ejbCreate() throws CreateException {
    }

    public void ejbCreate(Long sectionimageId) throws CreateException {
        this.log.debug("ejbCreate(java.lang.Long sectionimageId): begin");
        try {
            SectionimageVO vo = this.getSectionimageVObyID(sectionimageId);
            this.setSectionimageId(sectionimageId);
            this.setSectionimageVO(vo);
            this.setMatrixWidth(vo.getSection().getArrayblock().getArraytype().getCols());
        }
        catch (TmaGlobalException ex) {
            throw new CreateException(ex.getMessage());
        }
    }

    public void ejbPassivate() {
    }

    public void ejbRemove() {
    }

    public Dimension getArrayDimension() throws TmaGlobalException {
        this.log.debug("getArrayDimension(): begin");
        ArrayblockVO arrayblockVO = this.getSectionimageVO().getSection().getArrayblock();
        Dimension array_dimension_ = new Dimension();
        array_dimension_.setSize(arrayblockVO.getArraytype().getCols(), arrayblockVO.getArraytype().getRows());
        return array_dimension_;
    }

    public Vector getFullArrayPositions() throws TmaGlobalException {
        this.log.debug("getFullArrayPositions(): begin");
        ArrayblockVO arrayblockVO = this.getSectionimageVO().getSection().getArrayblock();
        Vector<Dimension> full_array_pos_ = new Vector<Dimension>();
        Iterator iter = arrayblockVO.getArraypunchassociations().iterator();
        while (iter.hasNext()) {
            ArraypunchassociationVO arraypunchassociationVo = (ArraypunchassociationVO)iter.next();
            Dimension dim = new Dimension();
            dim.setSize(arraypunchassociationVo.getCol().doubleValue(), arraypunchassociationVo.getRow().doubleValue());
            full_array_pos_.add(dim);
        }
        return full_array_pos_;
    }

    public byte[] getImage() throws TmaGlobalException {
        this.log.debug("getImage(): begin");
        return this.getSectionimageVO().getImage();
    }

    private Hashtable getPunchVOs(Collection punches) {
        this.log.info("getPunchVOs");
        Hashtable<Point, PunchVO> punchVOs = new Hashtable<Point, PunchVO>();
        Iterator iter = punches.iterator();
        while (iter.hasNext()) {
            PunchVO punchVO = (PunchVO)iter.next();
            int row = punchVO.getArraypunchassociation().getRow();
            int col = punchVO.getArraypunchassociation().getCol();
            Point key = new Point(row, col);
            punchVOs.put(key, punchVO);
        }
        return punchVOs;
    }

    private Point getRowAndCol(int index) {
        int row = (int)((double)index * Math.pow(this.getMatrixWidth(), -1.0));
        int col = index - row * this.getMatrixWidth();
        Point matrix_point = new Point(row, col);
        return matrix_point;
    }

    private SectionimageVO getSectionimageVObyID(Long id) throws TmaGlobalException {
        this.log.debug("getSectionimageVOById: begin id=" + id);
        Sectionimage entity = null;
        try {
            entity = SectionimageUtil.getLocalHome().findByPrimaryKey(id);
        }
        catch (FinderException fex) {
            this.log.error("getSectionimageById(id=" + id + "): FinderException thrown");
            this.log.error((Object)fex);
            return null;
        }
        catch (NamingException nex) {
            this.log.error("getSectionimageById(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        SectionimageVO returnVO = (SectionimageVO)ValueTreeBuilder.getValueTree(entity, ValueTreeBuilder.createIncludeTree("*"));
        this.log.info("getSectionimageById: finished successfuly returnVO=" + returnVO);
        return returnVO;
    }

    public void insertPunchimages(Vector punchimages, int[] point_array) throws TmaGlobalException {
        this.log.debug("insertPunchimages(java.util.Vector punchimages, int [] point_array): begin");
        String sectionbarcode = this.getSectionimageVO().getSection().getBarcodeId().toString();
        String color = "";
        if (this.getSectionimageVO().getStaining() != null) {
            color = this.getSectionimageVO().getStaining().getDatadictionaryColor().getDatavalue();
        }
        this.log.debug("sectionbarcode:" + sectionbarcode);
        Collection punches = this.getSectionimageVO().getSection().getPunchs();
        Hashtable punchVOs = new Hashtable();
        punchVOs = punches.isEmpty() ? this.createPunchVOs(this.getSectionimageVO().getSection()) : this.getPunchVOs(punches);
        this.log.debug("got punches");
        int vector_count = 0;
        while (vector_count < punchimages.size()) {
            int index = point_array[vector_count];
            Point punch_point = this.getRowAndCol(index);
            this.log.debug("punch_point:" + punch_point);
            PunchimageVO punch_img_vo = new PunchimageVO();
            PunchVO punch_vo = (PunchVO)punchVOs.get(punch_point);
            punch_img_vo.setImage((byte[])punchimages.get(vector_count));
            punch_img_vo.setImagename("S" + sectionbarcode + "R" + (int)punch_point.getX() + "C" + (int)punch_point.getY() + "COLOR" + color + ".tif");
            punch_img_vo.setPunch(punch_vo);
            this.getSectionimageVO().addPunchimage(punch_img_vo);
            ++vector_count;
        }
        try {
            this.getSectionimageVO().setGridded(new Integer(1));
            this.sectionimageUpdate(this.getSectionimageVO());
        }
        catch (Exception ex) {
            this.context.setRollbackOnly();
            throw new TmaGlobalException(ex.getMessage());
        }
    }

    public boolean isColored() throws TmaGlobalException {
        boolean ret = true;
        String deyingmethod = this.getSectionimageVO().getDatadictionaryDyeingmethod().getDatavalue();
        if (deyingmethod.equalsIgnoreCase("HE") || deyingmethod.equalsIgnoreCase("unstained")) {
            ret = false;
        }
        return ret;
    }

    private void sectionimageUpdate(SectionimageVO vo) throws Exception {
        this.log.info("sectionimageUpdate: begin vo=" + vo);
        Sectionimage entity = null;
        Long id = vo.getSectionimageId();
        if (id == null) {
            throw new Exception("sectionimageUpdate(vo=" + vo + "): the primaryKey of the vo is null!");
        }
        try {
            entity = SectionimageUtil.getLocalHome().findByPrimaryKey(id);
            entity.update(vo);
            this.log.info("sectionimageUpdate: finished successfuly");
        }
        catch (FinderException fex) {
            this.log.error("sectionimageUpdate(vo=" + vo + "): FinderException thrown");
            this.log.error((Object)fex);
            throw new Exception(fex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("sectionimageUpdate(vo=" + vo + "): NamingException thrown");
            this.log.error(nex);
            throw new Exception(nex.getMessage());
        }
        catch (CreateException cex) {
            this.log.error("sectionimageUpdate(vo=" + vo + "): javax.ejb.CreateException thrown");
            this.log.error((Object)cex);
            throw new Exception(cex.getMessage());
        }
    }

    public void setSessionContext(SessionContext ctx) {
        this.context = ctx;
    }
}

