/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.tma.ejb.service;

import at.tugraz.genome.tma.ejb.entity.Donorimage;
import at.tugraz.genome.tma.ejb.entity.DonorimageUtil;
import at.tugraz.genome.tma.ejb.entity.Sectionimage;
import at.tugraz.genome.tma.ejb.entity.SectionimageUtil;
import at.tugraz.genome.tma.ejb.entity.Smallimage;
import at.tugraz.genome.tma.ejb.entity.SmallimageUtil;
import at.tugraz.genome.tma.ejb.vos.DonorimageVO;
import at.tugraz.genome.tma.ejb.vos.SectionimageVO;
import at.tugraz.genome.tma.ejb.vos.SmallimageVO;
import at.tugraz.genome.tma.exceptions.TmaGlobalException;
import at.tugraz.genome.voutils.ValueTreeBuilder;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ImageServiceBean
implements SessionBean {
    protected SessionContext _ctx = null;
    Log log = LogFactory.getLog(this.getClass());

    public Long addDonorimage(DonorimageVO vo) throws TmaGlobalException {
        this.log.debug("addDonorimage: begin vo=" + vo);
        Donorimage entity = null;
        try {
            entity = DonorimageUtil.getLocalHome().create(vo);
            this.log.info("addDonorimage(): finished id=" + entity.getDonorimageId());
        }
        catch (CreateException cex) {
            this.log.error("addDonorimage: vo=" + vo + "CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("addDonorimage: vo=" + vo + "NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        return entity.getDonorimageId();
    }

    public Long addSectionimage(SectionimageVO vo) throws TmaGlobalException {
        this.log.debug("addSectionimage: begin vo=" + vo);
        Sectionimage entity = null;
        try {
            entity = SectionimageUtil.getLocalHome().create(vo);
            this.log.info("addSectionimage(): finished id=" + entity.getSectionimageId());
        }
        catch (CreateException cex) {
            this.log.error("addSectionimage: vo=" + vo + "CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("addSectionimage: vo=" + vo + "NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        return entity.getSectionimageId();
    }

    public Long addSmallimage(SmallimageVO vo) throws TmaGlobalException {
        this.log.debug("addSmallimage: begin vo=" + vo);
        Smallimage entity = null;
        try {
            entity = SmallimageUtil.getLocalHome().create(vo);
            this.log.info("addSmallimage(): finished id=" + entity.getSmallimageId());
        }
        catch (CreateException cex) {
            this.log.error("addSmallimage: vo=" + vo + "CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("addSmallimage: vo=" + vo + "NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        return entity.getSmallimageId();
    }

    public abstract SmallimageVO createSmallimageVO(String var1, byte[] var2) throws TmaGlobalException;

    public abstract void ejbActivate() throws EJBException, RemoteException;

    public abstract void ejbCreate() throws CreateException;

    public abstract void ejbPassivate() throws EJBException, RemoteException;

    public void ejbPostCreate() throws CreateException {
    }

    public abstract void ejbRemove() throws EJBException, RemoteException;

    public Collection findAllDonorimages(String includeTree) throws TmaGlobalException {
        try {
            this.log.debug("findAllDonorimages: includeTree=" + includeTree);
            Collection items = DonorimageUtil.getLocalHome().findAll();
            ArrayList<DonorimageVO> vos = new ArrayList<DonorimageVO>();
            this.log.info("findAllDonorimages: " + items.size() + " items found");
            Iterator iter = items.iterator();
            while (iter.hasNext()) {
                vos.add((DonorimageVO)ValueTreeBuilder.getValueTree((Donorimage)iter.next(), ValueTreeBuilder.createIncludeTree(includeTree)));
            }
            return vos;
        }
        catch (FinderException fex) {
            this.log.error("findAllDonorimages: FinderException thrown");
            this.log.error((Object)fex);
            return null;
        }
        catch (NamingException nex) {
            this.log.error("findAllDonorimages: NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    public Collection findAllSectionimages(String includeTree) throws TmaGlobalException {
        try {
            this.log.debug("findAllSectionimages: includeTree=" + includeTree);
            Collection items = SectionimageUtil.getLocalHome().findAll();
            ArrayList<SectionimageVO> vos = new ArrayList<SectionimageVO>();
            this.log.info("findAllSectionimages: " + items.size() + " items found");
            Iterator iter = items.iterator();
            while (iter.hasNext()) {
                vos.add((SectionimageVO)ValueTreeBuilder.getValueTree((Sectionimage)iter.next(), ValueTreeBuilder.createIncludeTree(includeTree)));
            }
            return vos;
        }
        catch (FinderException fex) {
            this.log.error("findAllSectionimages: FinderException thrown");
            this.log.error((Object)fex);
            return null;
        }
        catch (NamingException nex) {
            this.log.error("findAllSectionimages: NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    public Collection findAllSmallimages(String includeTree) throws TmaGlobalException {
        try {
            this.log.debug("findAllSmallimages: includeTree=" + includeTree);
            Collection items = SmallimageUtil.getLocalHome().findAll();
            ArrayList<SmallimageVO> vos = new ArrayList<SmallimageVO>();
            this.log.info("findAllSmallimages: " + items.size() + " items found");
            Iterator iter = items.iterator();
            while (iter.hasNext()) {
                vos.add((SmallimageVO)ValueTreeBuilder.getValueTree((Smallimage)iter.next(), ValueTreeBuilder.createIncludeTree(includeTree)));
            }
            return vos;
        }
        catch (FinderException fex) {
            this.log.error("findAllSmallimages: FinderException thrown");
            this.log.error((Object)fex);
            return null;
        }
        catch (NamingException nex) {
            this.log.error("findAllSmallimages: NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    public DonorimageVO findDonorimageById(Long id, String includeTree) throws TmaGlobalException {
        this.log.debug("findDonorimageById: begin id=" + id + " includeTree=" + includeTree);
        Donorimage entity = null;
        try {
            entity = DonorimageUtil.getLocalHome().findByPrimaryKey(id);
        }
        catch (FinderException fex) {
            this.log.error("findDonorimageById(id=" + id + "): FinderException thrown");
            this.log.error((Object)fex);
            return null;
        }
        catch (NamingException nex) {
            this.log.error("findDonorimageById(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        DonorimageVO returnVO = (DonorimageVO)ValueTreeBuilder.getValueTree(entity, ValueTreeBuilder.createIncludeTree(includeTree));
        this.log.info("findDonorimageById: finished successfuly returnVO=" + returnVO);
        return returnVO;
    }

    public SectionimageVO findSectionimageById(Long id, String includeTree) throws TmaGlobalException {
        this.log.debug("findSectionimageById: begin id=" + id + " includeTree=" + includeTree);
        Sectionimage entity = null;
        try {
            entity = SectionimageUtil.getLocalHome().findByPrimaryKey(id);
        }
        catch (FinderException fex) {
            this.log.error("findSectionimageById(id=" + id + "): FinderException thrown");
            this.log.error((Object)fex);
            return null;
        }
        catch (NamingException nex) {
            this.log.error("findSectionimageById(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        SectionimageVO returnVO = (SectionimageVO)ValueTreeBuilder.getValueTree(entity, ValueTreeBuilder.createIncludeTree(includeTree));
        this.log.info("findSectionimageById: finished successfuly returnVO=" + returnVO);
        return returnVO;
    }

    public SmallimageVO findSmallimageById(Long id, String includeTree) throws TmaGlobalException {
        this.log.debug("findSmallimageById: begin id=" + id + " includeTree=" + includeTree);
        Smallimage entity = null;
        try {
            entity = SmallimageUtil.getLocalHome().findByPrimaryKey(id);
        }
        catch (FinderException fex) {
            this.log.error("findSmallimageById(id=" + id + "): FinderException thrown");
            this.log.error((Object)fex);
            return null;
        }
        catch (NamingException nex) {
            this.log.error("findSmallimageById(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        SmallimageVO returnVO = (SmallimageVO)ValueTreeBuilder.getValueTree(entity, ValueTreeBuilder.createIncludeTree(includeTree));
        this.log.info("findSmallimageById: finished successfuly returnVO=" + returnVO);
        return returnVO;
    }

    protected SessionContext getSessionContext() {
        return this._ctx;
    }

    public void removeDonorimageById(Long id) throws TmaGlobalException {
        this.log.info("removeDonorimageById: begin id=" + id);
        Object entity = null;
        try {
            DonorimageUtil.getLocalHome().remove(id);
            this.log.info("removeDonorimageById: finished successfuly");
        }
        catch (RemoveException rex) {
            this.log.error("removeDonorimageById(id=" + id + "): RemoveException thrown");
            this.log.error((Object)rex);
            throw new TmaGlobalException(rex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("removeDonorimageById(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    public void removeSectionimageById(Long id) throws TmaGlobalException {
        this.log.info("removeSectionimageById: begin id=" + id);
        Object entity = null;
        try {
            SectionimageUtil.getLocalHome().remove(id);
            this.log.info("removeSectionimageById: finished successfuly");
        }
        catch (RemoveException rex) {
            this.log.error("removeSectionimageById(id=" + id + "): RemoveException thrown");
            this.log.error((Object)rex);
            throw new TmaGlobalException(rex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("removeSectionimageById(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    public void removeSmallimageById(Long id) throws TmaGlobalException {
        this.log.info("removeSmallimageById: begin id=" + id);
        Object entity = null;
        try {
            SmallimageUtil.getLocalHome().remove(id);
            this.log.info("removeSmallimageById: finished successfuly");
        }
        catch (RemoveException rex) {
            this.log.error("removeSmallimageById(id=" + id + "): RemoveException thrown");
            this.log.error((Object)rex);
            throw new TmaGlobalException(rex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("removeSmallimageById(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    public void setSessionContext(SessionContext ctx) {
        this._ctx = ctx;
    }

    public void updateCMPDonorimage(DonorimageVO vo) throws TmaGlobalException {
        this.log.info("updateDonorimage: begin vo=" + vo);
        Donorimage entity = null;
        Long id = vo.getDonorimageId();
        if (id == null) {
            throw new TmaGlobalException("updateDonorimage(vo=" + vo + "): the primaryKey of the vo is null!");
        }
        try {
            entity = DonorimageUtil.getLocalHome().findByPrimaryKey(id);
            entity.updateCMP(vo);
            this.log.info("updateCMPDonorimage: finished successfuly");
        }
        catch (FinderException fex) {
            this.log.error("updateCMPDonorimage(vo=" + vo + "): FinderException thrown");
            this.log.error((Object)fex);
            throw new TmaGlobalException(fex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("updateCMPDonorimage(vo=" + vo + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        catch (CreateException cex) {
            this.log.error("updateCMPDonorimage(vo=" + vo + "): javax.ejb.CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
    }

    public void updateCMPSectionimage(SectionimageVO vo) throws TmaGlobalException {
        this.log.info("updateSectionimage: begin vo=" + vo);
        Sectionimage entity = null;
        Long id = vo.getSectionimageId();
        if (id == null) {
            throw new TmaGlobalException("updateSectionimage(vo=" + vo + "): the primaryKey of the vo is null!");
        }
        try {
            entity = SectionimageUtil.getLocalHome().findByPrimaryKey(id);
            entity.updateCMP(vo);
            this.log.info("updateCMPSectionimage: finished successfuly");
        }
        catch (FinderException fex) {
            this.log.error("updateCMPSectionimage(vo=" + vo + "): FinderException thrown");
            this.log.error((Object)fex);
            throw new TmaGlobalException(fex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("updateCMPSectionimage(vo=" + vo + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        catch (CreateException cex) {
            this.log.error("updateCMPSectionimage(vo=" + vo + "): javax.ejb.CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
    }

    public void updateCMPSmallimage(SmallimageVO vo) throws TmaGlobalException {
        this.log.info("updateSmallimage: begin vo=" + vo);
        Smallimage entity = null;
        Long id = vo.getSmallimageId();
        if (id == null) {
            throw new TmaGlobalException("updateSmallimage(vo=" + vo + "): the primaryKey of the vo is null!");
        }
        try {
            entity = SmallimageUtil.getLocalHome().findByPrimaryKey(id);
            entity.updateCMP(vo);
            this.log.info("updateCMPSmallimage: finished successfuly");
        }
        catch (FinderException fex) {
            this.log.error("updateCMPSmallimage(vo=" + vo + "): FinderException thrown");
            this.log.error((Object)fex);
            throw new TmaGlobalException(fex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("updateCMPSmallimage(vo=" + vo + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        catch (CreateException cex) {
            this.log.error("updateCMPSmallimage(vo=" + vo + "): javax.ejb.CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
    }

    public void updateDonorimage(DonorimageVO vo) throws TmaGlobalException {
        this.log.info("updateDonorimage: begin vo=" + vo);
        Donorimage entity = null;
        Long id = vo.getDonorimageId();
        if (id == null) {
            throw new TmaGlobalException("updateDonorimage(vo=" + vo + "): the primaryKey of the vo is null!");
        }
        try {
            entity = DonorimageUtil.getLocalHome().findByPrimaryKey(id);
            entity.update(vo);
            this.log.info("updateDonorimage: finished successfuly");
        }
        catch (FinderException fex) {
            this.log.error("updateDonorimage(vo=" + vo + "): FinderException thrown");
            this.log.error((Object)fex);
            throw new TmaGlobalException(fex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("updateDonorimage(vo=" + vo + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        catch (CreateException cex) {
            this.log.error("updateDonorimage(vo=" + vo + "): javax.ejb.CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
    }

    public void updateSectionimage(SectionimageVO vo) throws TmaGlobalException {
        this.log.info("updateSectionimage: begin vo=" + vo);
        Sectionimage entity = null;
        Long id = vo.getSectionimageId();
        if (id == null) {
            throw new TmaGlobalException("updateSectionimage(vo=" + vo + "): the primaryKey of the vo is null!");
        }
        try {
            entity = SectionimageUtil.getLocalHome().findByPrimaryKey(id);
            entity.update(vo);
            this.log.info("updateSectionimage: finished successfuly");
        }
        catch (FinderException fex) {
            this.log.error("updateSectionimage(vo=" + vo + "): FinderException thrown");
            this.log.error((Object)fex);
            throw new TmaGlobalException(fex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("updateSectionimage(vo=" + vo + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        catch (CreateException cex) {
            this.log.error("updateSectionimage(vo=" + vo + "): javax.ejb.CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
    }

    public void updateSmallimage(SmallimageVO vo) throws TmaGlobalException {
        this.log.info("updateSmallimage: begin vo=" + vo);
        Smallimage entity = null;
        Long id = vo.getSmallimageId();
        if (id == null) {
            throw new TmaGlobalException("updateSmallimage(vo=" + vo + "): the primaryKey of the vo is null!");
        }
        try {
            entity = SmallimageUtil.getLocalHome().findByPrimaryKey(id);
            entity.update(vo);
            this.log.info("updateSmallimage: finished successfuly");
        }
        catch (FinderException fex) {
            this.log.error("updateSmallimage(vo=" + vo + "): FinderException thrown");
            this.log.error((Object)fex);
            throw new TmaGlobalException(fex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("updateSmallimage(vo=" + vo + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        catch (CreateException cex) {
            this.log.error("updateSmallimage(vo=" + vo + "): javax.ejb.CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
    }
}

