/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.tma.ejb.service;

import at.tugraz.genome.tma.ImageUtils;
import at.tugraz.genome.tma.ejb.service.ImageServiceBean;
import at.tugraz.genome.tma.ejb.vos.SmallimageVO;
import at.tugraz.genome.tma.exceptions.TmaGlobalException;
import com.sun.image.codec.jpeg.ImageFormatException;
import java.awt.Dimension;
import java.io.IOException;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;

public class ImageServiceBeanImpl
extends ImageServiceBean
implements SessionBean {
    private SessionContext context;

    public SmallimageVO createSmallimageVO(String imagename, byte[] image) throws TmaGlobalException {
        this.log.debug("createSmallimageVO: begin");
        SmallimageVO smallimageVO = null;
        String extension = ImageUtils.getFilenameExtension(imagename);
        byte[] scaled_image = null;
        Dimension size = new Dimension(820, 650);
        float quality = 0.4f;
        String supported_extensions = "*.jpeg,*.jpg,*.tiff,*.tif";
        if (supported_extensions.indexOf("*." + extension) < 0) {
            this.log.error("createSmallimageVO: Unsupported Image Format -'" + extension + "'");
            throw new TmaGlobalException("Wrong Image Format: Only jpeg- and tiff-images are supported (" + supported_extensions + ")");
        }
        try {
            Float[] scale_factor = new Float[1];
            if (extension.equals("tif") || extension.equals("tiff")) {
                this.log.debug("Tiff image, create jpeg image");
                scaled_image = ImageUtils.scaleTIFFToJPEG(image, size, quality, scale_factor);
            }
            if (extension.equals("jpg") || extension.equals("jpeg")) {
                this.log.debug("Scaling JPEG image");
                scaled_image = ImageUtils.scaleJPEGToJPEG(image, size, quality, scale_factor);
            }
            smallimageVO = new SmallimageVO();
            smallimageVO.setImage(scaled_image);
            smallimageVO.setScalefactor(scale_factor[0]);
        }
        catch (IOException ioex) {
            this.log.debug("Caught IOException in createJpgImage()");
            this.log.error(ioex);
            throw new TmaGlobalException("Caught IOException in createJpgImage()");
        }
        catch (ImageFormatException imgex) {
            this.log.debug("Caught ImageFormatException in createImgVoWithThumbnail()");
            this.log.error((Object)imgex);
            throw new TmaGlobalException("Caught ImageFormatException in createJpgImage()");
        }
        return smallimageVO;
    }

    public void ejbActivate() {
    }

    public void ejbCreate() throws CreateException {
    }

    public void ejbPassivate() {
    }

    public void ejbRemove() {
    }

    public void setSessionContext(SessionContext ctx) {
        this.context = ctx;
    }
}

