/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.tma.ejb.service;

import at.tugraz.genome.tma.ejb.entity.Behaviour;
import at.tugraz.genome.tma.ejb.entity.BehaviourUtil;
import at.tugraz.genome.tma.ejb.entity.Donor;
import at.tugraz.genome.tma.ejb.entity.DonorUtil;
import at.tugraz.genome.tma.ejb.entity.Grade;
import at.tugraz.genome.tma.ejb.entity.GradeUtil;
import at.tugraz.genome.tma.ejb.entity.Morphology;
import at.tugraz.genome.tma.ejb.entity.MorphologyUtil;
import at.tugraz.genome.tma.ejb.entity.Tissue;
import at.tugraz.genome.tma.ejb.entity.TissueUtil;
import at.tugraz.genome.tma.ejb.entity.Topography;
import at.tugraz.genome.tma.ejb.entity.TopographyUtil;
import at.tugraz.genome.tma.ejb.vos.BehaviourVO;
import at.tugraz.genome.tma.ejb.vos.DonorVO;
import at.tugraz.genome.tma.ejb.vos.GradeVO;
import at.tugraz.genome.tma.ejb.vos.MorphologyVO;
import at.tugraz.genome.tma.ejb.vos.TissueDonorVO;
import at.tugraz.genome.tma.ejb.vos.TissueVO;
import at.tugraz.genome.tma.ejb.vos.TopographyVO;
import at.tugraz.genome.tma.exceptions.FileDataException;
import at.tugraz.genome.tma.exceptions.FileParserException;
import at.tugraz.genome.tma.exceptions.TmaGlobalException;
import at.tugraz.genome.voutils.ValueTreeBuilder;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class TissueDonorServiceBean
implements SessionBean {
    protected SessionContext _ctx = null;
    Log log = LogFactory.getLog(this.getClass());

    public Long addBehaviour(BehaviourVO vo) throws TmaGlobalException {
        this.log.debug("addBehaviour: begin vo=" + vo);
        Behaviour entity = null;
        try {
            entity = BehaviourUtil.getLocalHome().create(vo);
            this.log.info("addBehaviour(): finished id=" + entity.getBehaviourId());
        }
        catch (CreateException cex) {
            this.log.error("addBehaviour: vo=" + vo + "CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("addBehaviour: vo=" + vo + "NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        return entity.getBehaviourId();
    }

    public Long addDonor(DonorVO vo) throws TmaGlobalException {
        this.log.debug("addDonor: begin vo=" + vo);
        Donor entity = null;
        try {
            entity = DonorUtil.getLocalHome().create(vo);
            this.log.info("addDonor(): finished id=" + entity.getDonorId());
        }
        catch (CreateException cex) {
            this.log.error("addDonor: vo=" + vo + "CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("addDonor: vo=" + vo + "NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        return entity.getDonorId();
    }

    public Long addGrade(GradeVO vo) throws TmaGlobalException {
        this.log.debug("addGrade: begin vo=" + vo);
        Grade entity = null;
        try {
            entity = GradeUtil.getLocalHome().create(vo);
            this.log.info("addGrade(): finished id=" + entity.getGradeId());
        }
        catch (CreateException cex) {
            this.log.error("addGrade: vo=" + vo + "CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("addGrade: vo=" + vo + "NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        return entity.getGradeId();
    }

    public Long addMorphology(MorphologyVO vo) throws TmaGlobalException {
        this.log.debug("addMorphology: begin vo=" + vo);
        Morphology entity = null;
        try {
            entity = MorphologyUtil.getLocalHome().create(vo);
            this.log.info("addMorphology(): finished id=" + entity.getMorphologyId());
        }
        catch (CreateException cex) {
            this.log.error("addMorphology: vo=" + vo + "CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("addMorphology: vo=" + vo + "NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        return entity.getMorphologyId();
    }

    public Long addTissue(TissueVO vo) throws TmaGlobalException {
        this.log.debug("addTissue: begin vo=" + vo);
        Tissue entity = null;
        try {
            entity = TissueUtil.getLocalHome().create(vo);
            this.log.info("addTissue(): finished id=" + entity.getTissueId());
        }
        catch (CreateException cex) {
            this.log.error("addTissue: vo=" + vo + "CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("addTissue: vo=" + vo + "NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        return entity.getTissueId();
    }

    public abstract void addTissueDonor(TissueVO var1, DonorVO var2) throws TmaGlobalException;

    public Long addTopography(TopographyVO vo) throws TmaGlobalException {
        this.log.debug("addTopography: begin vo=" + vo);
        Topography entity = null;
        try {
            entity = TopographyUtil.getLocalHome().create(vo);
            this.log.info("addTopography(): finished id=" + entity.getTopographyId());
        }
        catch (CreateException cex) {
            this.log.error("addTopography: vo=" + vo + "CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("addTopography: vo=" + vo + "NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        return entity.getTopographyId();
    }

    public abstract void ejbActivate() throws EJBException, RemoteException;

    public abstract void ejbCreate() throws CreateException;

    public abstract void ejbPassivate() throws EJBException, RemoteException;

    public void ejbPostCreate() throws CreateException {
    }

    public abstract void ejbRemove() throws EJBException, RemoteException;

    public abstract boolean existDonorBarcode(Long var1) throws TmaGlobalException;

    public abstract boolean existSampleID(Long var1) throws TmaGlobalException;

    public Collection findAllBehaviours(String includeTree) throws TmaGlobalException {
        try {
            this.log.debug("findAllBehaviours: includeTree=" + includeTree);
            Collection items = BehaviourUtil.getLocalHome().findAll();
            ArrayList<BehaviourVO> vos = new ArrayList<BehaviourVO>();
            this.log.info("findAllBehaviours: " + items.size() + " items found");
            Iterator iter = items.iterator();
            while (iter.hasNext()) {
                vos.add((BehaviourVO)ValueTreeBuilder.getValueTree((Behaviour)iter.next(), ValueTreeBuilder.createIncludeTree(includeTree)));
            }
            return vos;
        }
        catch (FinderException fex) {
            this.log.error("findAllBehaviours: FinderException thrown");
            this.log.error((Object)fex);
            return null;
        }
        catch (NamingException nex) {
            this.log.error("findAllBehaviours: NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    public Collection findAllDonors(String includeTree) throws TmaGlobalException {
        try {
            this.log.debug("findAllDonors: includeTree=" + includeTree);
            Collection items = DonorUtil.getLocalHome().findAll();
            ArrayList<DonorVO> vos = new ArrayList<DonorVO>();
            this.log.info("findAllDonors: " + items.size() + " items found");
            Iterator iter = items.iterator();
            while (iter.hasNext()) {
                vos.add((DonorVO)ValueTreeBuilder.getValueTree((Donor)iter.next(), ValueTreeBuilder.createIncludeTree(includeTree)));
            }
            return vos;
        }
        catch (FinderException fex) {
            this.log.error("findAllDonors: FinderException thrown");
            this.log.error((Object)fex);
            return null;
        }
        catch (NamingException nex) {
            this.log.error("findAllDonors: NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    public Collection findAllGrades(String includeTree) throws TmaGlobalException {
        try {
            this.log.debug("findAllGrades: includeTree=" + includeTree);
            Collection items = GradeUtil.getLocalHome().findAll();
            ArrayList<GradeVO> vos = new ArrayList<GradeVO>();
            this.log.info("findAllGrades: " + items.size() + " items found");
            Iterator iter = items.iterator();
            while (iter.hasNext()) {
                vos.add((GradeVO)ValueTreeBuilder.getValueTree((Grade)iter.next(), ValueTreeBuilder.createIncludeTree(includeTree)));
            }
            return vos;
        }
        catch (FinderException fex) {
            this.log.error("findAllGrades: FinderException thrown");
            this.log.error((Object)fex);
            return null;
        }
        catch (NamingException nex) {
            this.log.error("findAllGrades: NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    public Collection findAllMorphologys(String includeTree) throws TmaGlobalException {
        try {
            this.log.debug("findAllMorphologys: includeTree=" + includeTree);
            Collection items = MorphologyUtil.getLocalHome().findAll();
            ArrayList<MorphologyVO> vos = new ArrayList<MorphologyVO>();
            this.log.info("findAllMorphologys: " + items.size() + " items found");
            Iterator iter = items.iterator();
            while (iter.hasNext()) {
                vos.add((MorphologyVO)ValueTreeBuilder.getValueTree((Morphology)iter.next(), ValueTreeBuilder.createIncludeTree(includeTree)));
            }
            return vos;
        }
        catch (FinderException fex) {
            this.log.error("findAllMorphologys: FinderException thrown");
            this.log.error((Object)fex);
            return null;
        }
        catch (NamingException nex) {
            this.log.error("findAllMorphologys: NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    public Collection findAllTissues(String includeTree) throws TmaGlobalException {
        try {
            this.log.debug("findAllTissues: includeTree=" + includeTree);
            Collection items = TissueUtil.getLocalHome().findAll();
            ArrayList<TissueVO> vos = new ArrayList<TissueVO>();
            this.log.info("findAllTissues: " + items.size() + " items found");
            Iterator iter = items.iterator();
            while (iter.hasNext()) {
                vos.add((TissueVO)ValueTreeBuilder.getValueTree((Tissue)iter.next(), ValueTreeBuilder.createIncludeTree(includeTree)));
            }
            return vos;
        }
        catch (FinderException fex) {
            this.log.error("findAllTissues: FinderException thrown");
            this.log.error((Object)fex);
            return null;
        }
        catch (NamingException nex) {
            this.log.error("findAllTissues: NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    public Collection findAllTopographys(String includeTree) throws TmaGlobalException {
        try {
            this.log.debug("findAllTopographys: includeTree=" + includeTree);
            Collection items = TopographyUtil.getLocalHome().findAll();
            ArrayList<TopographyVO> vos = new ArrayList<TopographyVO>();
            this.log.info("findAllTopographys: " + items.size() + " items found");
            Iterator iter = items.iterator();
            while (iter.hasNext()) {
                vos.add((TopographyVO)ValueTreeBuilder.getValueTree((Topography)iter.next(), ValueTreeBuilder.createIncludeTree(includeTree)));
            }
            return vos;
        }
        catch (FinderException fex) {
            this.log.error("findAllTopographys: FinderException thrown");
            this.log.error((Object)fex);
            return null;
        }
        catch (NamingException nex) {
            this.log.error("findAllTopographys: NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    public BehaviourVO findBehaviourById(Long id, String includeTree) throws TmaGlobalException {
        this.log.debug("findBehaviourById: begin id=" + id + " includeTree=" + includeTree);
        Behaviour entity = null;
        try {
            entity = BehaviourUtil.getLocalHome().findByPrimaryKey(id);
        }
        catch (FinderException fex) {
            this.log.error("findBehaviourById(id=" + id + "): FinderException thrown");
            this.log.error((Object)fex);
            return null;
        }
        catch (NamingException nex) {
            this.log.error("findBehaviourById(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        BehaviourVO returnVO = (BehaviourVO)ValueTreeBuilder.getValueTree(entity, ValueTreeBuilder.createIncludeTree(includeTree));
        this.log.info("findBehaviourById: finished successfuly returnVO=" + returnVO);
        return returnVO;
    }

    public TissueVO findBySampleID(Long sampleId, String includeTree) throws TmaGlobalException {
        try {
            this.log.debug("findBySampleID: begin");
            Tissue entity = TissueUtil.getLocalHome().findBySampleID(sampleId);
            TissueVO item = (TissueVO)ValueTreeBuilder.getValueTree(entity, ValueTreeBuilder.createIncludeTree(includeTree));
            this.log.debug("findBySampleID: found item vo=" + item);
            return item;
        }
        catch (ObjectNotFoundException onfex) {
            this.log.error("findBySampleID: ObjectNotFoundException thrown");
            this.log.error((Object)onfex);
            throw new TmaGlobalException(onfex.getMessage());
        }
        catch (FinderException fex) {
            this.log.error("findBySampleID: FinderException thrown");
            this.log.error((Object)fex);
            throw new TmaGlobalException(fex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("findBySampleID: NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    public DonorVO findDonorByBarcodeID(Long barcodeId, String includeTree) throws TmaGlobalException {
        try {
            this.log.debug("findDonorByBarcodeID: begin");
            Donor entity = DonorUtil.getLocalHome().findDonorByBarcodeID(barcodeId);
            DonorVO item = (DonorVO)ValueTreeBuilder.getValueTree(entity, ValueTreeBuilder.createIncludeTree(includeTree));
            this.log.debug("findDonorByBarcodeID: found item vo=" + item);
            return item;
        }
        catch (ObjectNotFoundException onfex) {
            this.log.error("findDonorByBarcodeID: ObjectNotFoundException thrown");
            this.log.error((Object)onfex);
            throw new TmaGlobalException(onfex.getMessage());
        }
        catch (FinderException fex) {
            this.log.error("findDonorByBarcodeID: FinderException thrown");
            this.log.error((Object)fex);
            throw new TmaGlobalException(fex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("findDonorByBarcodeID: NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    public DonorVO findDonorById(Long id, String includeTree) throws TmaGlobalException {
        this.log.debug("findDonorById: begin id=" + id + " includeTree=" + includeTree);
        Donor entity = null;
        try {
            entity = DonorUtil.getLocalHome().findByPrimaryKey(id);
        }
        catch (FinderException fex) {
            this.log.error("findDonorById(id=" + id + "): FinderException thrown");
            this.log.error((Object)fex);
            return null;
        }
        catch (NamingException nex) {
            this.log.error("findDonorById(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        DonorVO returnVO = (DonorVO)ValueTreeBuilder.getValueTree(entity, ValueTreeBuilder.createIncludeTree(includeTree));
        this.log.info("findDonorById: finished successfuly returnVO=" + returnVO);
        return returnVO;
    }

    public GradeVO findGradeById(Long id, String includeTree) throws TmaGlobalException {
        this.log.debug("findGradeById: begin id=" + id + " includeTree=" + includeTree);
        Grade entity = null;
        try {
            entity = GradeUtil.getLocalHome().findByPrimaryKey(id);
        }
        catch (FinderException fex) {
            this.log.error("findGradeById(id=" + id + "): FinderException thrown");
            this.log.error((Object)fex);
            return null;
        }
        catch (NamingException nex) {
            this.log.error("findGradeById(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        GradeVO returnVO = (GradeVO)ValueTreeBuilder.getValueTree(entity, ValueTreeBuilder.createIncludeTree(includeTree));
        this.log.info("findGradeById: finished successfuly returnVO=" + returnVO);
        return returnVO;
    }

    public MorphologyVO findMorphologyById(Long id, String includeTree) throws TmaGlobalException {
        this.log.debug("findMorphologyById: begin id=" + id + " includeTree=" + includeTree);
        Morphology entity = null;
        try {
            entity = MorphologyUtil.getLocalHome().findByPrimaryKey(id);
        }
        catch (FinderException fex) {
            this.log.error("findMorphologyById(id=" + id + "): FinderException thrown");
            this.log.error((Object)fex);
            return null;
        }
        catch (NamingException nex) {
            this.log.error("findMorphologyById(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        MorphologyVO returnVO = (MorphologyVO)ValueTreeBuilder.getValueTree(entity, ValueTreeBuilder.createIncludeTree(includeTree));
        this.log.info("findMorphologyById: finished successfuly returnVO=" + returnVO);
        return returnVO;
    }

    public TissueVO findTissueById(Long id, String includeTree) throws TmaGlobalException {
        this.log.debug("findTissueById: begin id=" + id + " includeTree=" + includeTree);
        Tissue entity = null;
        try {
            entity = TissueUtil.getLocalHome().findByPrimaryKey(id);
        }
        catch (FinderException fex) {
            this.log.error("findTissueById(id=" + id + "): FinderException thrown");
            this.log.error((Object)fex);
            return null;
        }
        catch (NamingException nex) {
            this.log.error("findTissueById(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        TissueVO returnVO = (TissueVO)ValueTreeBuilder.getValueTree(entity, ValueTreeBuilder.createIncludeTree(includeTree));
        this.log.info("findTissueById: finished successfuly returnVO=" + returnVO);
        return returnVO;
    }

    public TopographyVO findTopographyById(Long id, String includeTree) throws TmaGlobalException {
        this.log.debug("findTopographyById: begin id=" + id + " includeTree=" + includeTree);
        Topography entity = null;
        try {
            entity = TopographyUtil.getLocalHome().findByPrimaryKey(id);
        }
        catch (FinderException fex) {
            this.log.error("findTopographyById(id=" + id + "): FinderException thrown");
            this.log.error((Object)fex);
            return null;
        }
        catch (NamingException nex) {
            this.log.error("findTopographyById(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        TopographyVO returnVO = (TopographyVO)ValueTreeBuilder.getValueTree(entity, ValueTreeBuilder.createIncludeTree(includeTree));
        this.log.info("findTopographyById: finished successfuly returnVO=" + returnVO);
        return returnVO;
    }

    protected SessionContext getSessionContext() {
        return this._ctx;
    }

    public abstract Vector insertTissueDonor(TissueDonorVO var1) throws FileDataException, FileParserException, TmaGlobalException;

    public void removeBehaviourById(Long id) throws TmaGlobalException {
        this.log.info("removeBehaviourById: begin id=" + id);
        Object entity = null;
        try {
            BehaviourUtil.getLocalHome().remove(id);
            this.log.info("removeBehaviourById: finished successfuly");
        }
        catch (RemoveException rex) {
            this.log.error("removeBehaviourById(id=" + id + "): RemoveException thrown");
            this.log.error((Object)rex);
            throw new TmaGlobalException(rex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("removeBehaviourById(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    public void removeDonorById(Long id) throws TmaGlobalException {
        this.log.info("removeDonorById: begin id=" + id);
        Object entity = null;
        try {
            DonorUtil.getLocalHome().remove(id);
            this.log.info("removeDonorById: finished successfuly");
        }
        catch (RemoveException rex) {
            this.log.error("removeDonorById(id=" + id + "): RemoveException thrown");
            this.log.error((Object)rex);
            throw new TmaGlobalException(rex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("removeDonorById(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    public void removeGradeById(Long id) throws TmaGlobalException {
        this.log.info("removeGradeById: begin id=" + id);
        Object entity = null;
        try {
            GradeUtil.getLocalHome().remove(id);
            this.log.info("removeGradeById: finished successfuly");
        }
        catch (RemoveException rex) {
            this.log.error("removeGradeById(id=" + id + "): RemoveException thrown");
            this.log.error((Object)rex);
            throw new TmaGlobalException(rex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("removeGradeById(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    public void removeMorphologyById(Long id) throws TmaGlobalException {
        this.log.info("removeMorphologyById: begin id=" + id);
        Object entity = null;
        try {
            MorphologyUtil.getLocalHome().remove(id);
            this.log.info("removeMorphologyById: finished successfuly");
        }
        catch (RemoveException rex) {
            this.log.error("removeMorphologyById(id=" + id + "): RemoveException thrown");
            this.log.error((Object)rex);
            throw new TmaGlobalException(rex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("removeMorphologyById(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    public void removeTissueById(Long id) throws TmaGlobalException {
        this.log.info("removeTissueById: begin id=" + id);
        Object entity = null;
        try {
            TissueUtil.getLocalHome().remove(id);
            this.log.info("removeTissueById: finished successfuly");
        }
        catch (RemoveException rex) {
            this.log.error("removeTissueById(id=" + id + "): RemoveException thrown");
            this.log.error((Object)rex);
            throw new TmaGlobalException(rex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("removeTissueById(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    public void removeTopographyById(Long id) throws TmaGlobalException {
        this.log.info("removeTopographyById: begin id=" + id);
        Object entity = null;
        try {
            TopographyUtil.getLocalHome().remove(id);
            this.log.info("removeTopographyById: finished successfuly");
        }
        catch (RemoveException rex) {
            this.log.error("removeTopographyById(id=" + id + "): RemoveException thrown");
            this.log.error((Object)rex);
            throw new TmaGlobalException(rex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("removeTopographyById(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    public void setSessionContext(SessionContext ctx) {
        this._ctx = ctx;
    }

    public void updateBehaviour(BehaviourVO vo) throws TmaGlobalException {
        this.log.info("updateBehaviour: begin vo=" + vo);
        Behaviour entity = null;
        Long id = vo.getBehaviourId();
        if (id == null) {
            throw new TmaGlobalException("updateBehaviour(vo=" + vo + "): the primaryKey of the vo is null!");
        }
        try {
            entity = BehaviourUtil.getLocalHome().findByPrimaryKey(id);
            entity.update(vo);
            this.log.info("updateBehaviour: finished successfuly");
        }
        catch (FinderException fex) {
            this.log.error("updateBehaviour(vo=" + vo + "): FinderException thrown");
            this.log.error((Object)fex);
            throw new TmaGlobalException(fex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("updateBehaviour(vo=" + vo + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        catch (CreateException cex) {
            this.log.error("updateBehaviour(vo=" + vo + "): javax.ejb.CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
    }

    public void updateCMPBehaviour(BehaviourVO vo) throws TmaGlobalException {
        this.log.info("updateBehaviour: begin vo=" + vo);
        Behaviour entity = null;
        Long id = vo.getBehaviourId();
        if (id == null) {
            throw new TmaGlobalException("updateBehaviour(vo=" + vo + "): the primaryKey of the vo is null!");
        }
        try {
            entity = BehaviourUtil.getLocalHome().findByPrimaryKey(id);
            entity.updateCMP(vo);
            this.log.info("updateCMPBehaviour: finished successfuly");
        }
        catch (FinderException fex) {
            this.log.error("updateCMPBehaviour(vo=" + vo + "): FinderException thrown");
            this.log.error((Object)fex);
            throw new TmaGlobalException(fex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("updateCMPBehaviour(vo=" + vo + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        catch (CreateException cex) {
            this.log.error("updateCMPBehaviour(vo=" + vo + "): javax.ejb.CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
    }

    public void updateCMPDonor(DonorVO vo) throws TmaGlobalException {
        this.log.info("updateDonor: begin vo=" + vo);
        Donor entity = null;
        Long id = vo.getDonorId();
        if (id == null) {
            throw new TmaGlobalException("updateDonor(vo=" + vo + "): the primaryKey of the vo is null!");
        }
        try {
            entity = DonorUtil.getLocalHome().findByPrimaryKey(id);
            entity.updateCMP(vo);
            this.log.info("updateCMPDonor: finished successfuly");
        }
        catch (FinderException fex) {
            this.log.error("updateCMPDonor(vo=" + vo + "): FinderException thrown");
            this.log.error((Object)fex);
            throw new TmaGlobalException(fex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("updateCMPDonor(vo=" + vo + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        catch (CreateException cex) {
            this.log.error("updateCMPDonor(vo=" + vo + "): javax.ejb.CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
    }

    public void updateCMPGrade(GradeVO vo) throws TmaGlobalException {
        this.log.info("updateGrade: begin vo=" + vo);
        Grade entity = null;
        Long id = vo.getGradeId();
        if (id == null) {
            throw new TmaGlobalException("updateGrade(vo=" + vo + "): the primaryKey of the vo is null!");
        }
        try {
            entity = GradeUtil.getLocalHome().findByPrimaryKey(id);
            entity.updateCMP(vo);
            this.log.info("updateCMPGrade: finished successfuly");
        }
        catch (FinderException fex) {
            this.log.error("updateCMPGrade(vo=" + vo + "): FinderException thrown");
            this.log.error((Object)fex);
            throw new TmaGlobalException(fex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("updateCMPGrade(vo=" + vo + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        catch (CreateException cex) {
            this.log.error("updateCMPGrade(vo=" + vo + "): javax.ejb.CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
    }

    public void updateCMPMorphology(MorphologyVO vo) throws TmaGlobalException {
        this.log.info("updateMorphology: begin vo=" + vo);
        Morphology entity = null;
        Long id = vo.getMorphologyId();
        if (id == null) {
            throw new TmaGlobalException("updateMorphology(vo=" + vo + "): the primaryKey of the vo is null!");
        }
        try {
            entity = MorphologyUtil.getLocalHome().findByPrimaryKey(id);
            entity.updateCMP(vo);
            this.log.info("updateCMPMorphology: finished successfuly");
        }
        catch (FinderException fex) {
            this.log.error("updateCMPMorphology(vo=" + vo + "): FinderException thrown");
            this.log.error((Object)fex);
            throw new TmaGlobalException(fex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("updateCMPMorphology(vo=" + vo + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        catch (CreateException cex) {
            this.log.error("updateCMPMorphology(vo=" + vo + "): javax.ejb.CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
    }

    public void updateCMPTissue(TissueVO vo) throws TmaGlobalException {
        this.log.info("updateTissue: begin vo=" + vo);
        Tissue entity = null;
        Long id = vo.getTissueId();
        if (id == null) {
            throw new TmaGlobalException("updateTissue(vo=" + vo + "): the primaryKey of the vo is null!");
        }
        try {
            entity = TissueUtil.getLocalHome().findByPrimaryKey(id);
            entity.updateCMP(vo);
            this.log.info("updateCMPTissue: finished successfuly");
        }
        catch (FinderException fex) {
            this.log.error("updateCMPTissue(vo=" + vo + "): FinderException thrown");
            this.log.error((Object)fex);
            throw new TmaGlobalException(fex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("updateCMPTissue(vo=" + vo + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        catch (CreateException cex) {
            this.log.error("updateCMPTissue(vo=" + vo + "): javax.ejb.CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
    }

    public void updateCMPTopography(TopographyVO vo) throws TmaGlobalException {
        this.log.info("updateTopography: begin vo=" + vo);
        Topography entity = null;
        Long id = vo.getTopographyId();
        if (id == null) {
            throw new TmaGlobalException("updateTopography(vo=" + vo + "): the primaryKey of the vo is null!");
        }
        try {
            entity = TopographyUtil.getLocalHome().findByPrimaryKey(id);
            entity.updateCMP(vo);
            this.log.info("updateCMPTopography: finished successfuly");
        }
        catch (FinderException fex) {
            this.log.error("updateCMPTopography(vo=" + vo + "): FinderException thrown");
            this.log.error((Object)fex);
            throw new TmaGlobalException(fex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("updateCMPTopography(vo=" + vo + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        catch (CreateException cex) {
            this.log.error("updateCMPTopography(vo=" + vo + "): javax.ejb.CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
    }

    public void updateDonor(DonorVO vo) throws TmaGlobalException {
        this.log.info("updateDonor: begin vo=" + vo);
        Donor entity = null;
        Long id = vo.getDonorId();
        if (id == null) {
            throw new TmaGlobalException("updateDonor(vo=" + vo + "): the primaryKey of the vo is null!");
        }
        try {
            entity = DonorUtil.getLocalHome().findByPrimaryKey(id);
            entity.update(vo);
            this.log.info("updateDonor: finished successfuly");
        }
        catch (FinderException fex) {
            this.log.error("updateDonor(vo=" + vo + "): FinderException thrown");
            this.log.error((Object)fex);
            throw new TmaGlobalException(fex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("updateDonor(vo=" + vo + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        catch (CreateException cex) {
            this.log.error("updateDonor(vo=" + vo + "): javax.ejb.CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
    }

    public void updateGrade(GradeVO vo) throws TmaGlobalException {
        this.log.info("updateGrade: begin vo=" + vo);
        Grade entity = null;
        Long id = vo.getGradeId();
        if (id == null) {
            throw new TmaGlobalException("updateGrade(vo=" + vo + "): the primaryKey of the vo is null!");
        }
        try {
            entity = GradeUtil.getLocalHome().findByPrimaryKey(id);
            entity.update(vo);
            this.log.info("updateGrade: finished successfuly");
        }
        catch (FinderException fex) {
            this.log.error("updateGrade(vo=" + vo + "): FinderException thrown");
            this.log.error((Object)fex);
            throw new TmaGlobalException(fex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("updateGrade(vo=" + vo + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        catch (CreateException cex) {
            this.log.error("updateGrade(vo=" + vo + "): javax.ejb.CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
    }

    public void updateMorphology(MorphologyVO vo) throws TmaGlobalException {
        this.log.info("updateMorphology: begin vo=" + vo);
        Morphology entity = null;
        Long id = vo.getMorphologyId();
        if (id == null) {
            throw new TmaGlobalException("updateMorphology(vo=" + vo + "): the primaryKey of the vo is null!");
        }
        try {
            entity = MorphologyUtil.getLocalHome().findByPrimaryKey(id);
            entity.update(vo);
            this.log.info("updateMorphology: finished successfuly");
        }
        catch (FinderException fex) {
            this.log.error("updateMorphology(vo=" + vo + "): FinderException thrown");
            this.log.error((Object)fex);
            throw new TmaGlobalException(fex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("updateMorphology(vo=" + vo + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        catch (CreateException cex) {
            this.log.error("updateMorphology(vo=" + vo + "): javax.ejb.CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
    }

    public void updateTissue(TissueVO vo) throws TmaGlobalException {
        this.log.info("updateTissue: begin vo=" + vo);
        Tissue entity = null;
        Long id = vo.getTissueId();
        if (id == null) {
            throw new TmaGlobalException("updateTissue(vo=" + vo + "): the primaryKey of the vo is null!");
        }
        try {
            entity = TissueUtil.getLocalHome().findByPrimaryKey(id);
            entity.update(vo);
            this.log.info("updateTissue: finished successfuly");
        }
        catch (FinderException fex) {
            this.log.error("updateTissue(vo=" + vo + "): FinderException thrown");
            this.log.error((Object)fex);
            throw new TmaGlobalException(fex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("updateTissue(vo=" + vo + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        catch (CreateException cex) {
            this.log.error("updateTissue(vo=" + vo + "): javax.ejb.CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
    }

    public void updateTopography(TopographyVO vo) throws TmaGlobalException {
        this.log.info("updateTopography: begin vo=" + vo);
        Topography entity = null;
        Long id = vo.getTopographyId();
        if (id == null) {
            throw new TmaGlobalException("updateTopography(vo=" + vo + "): the primaryKey of the vo is null!");
        }
        try {
            entity = TopographyUtil.getLocalHome().findByPrimaryKey(id);
            entity.update(vo);
            this.log.info("updateTopography: finished successfuly");
        }
        catch (FinderException fex) {
            this.log.error("updateTopography(vo=" + vo + "): FinderException thrown");
            this.log.error((Object)fex);
            throw new TmaGlobalException(fex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("updateTopography(vo=" + vo + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        catch (CreateException cex) {
            this.log.error("updateTopography(vo=" + vo + "): javax.ejb.CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
    }
}

