/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.tma.ejb.service;

import at.tugraz.genome.tma.csvparser.CSVParser;
import at.tugraz.genome.tma.ejb.entity.Behaviour;
import at.tugraz.genome.tma.ejb.entity.BehaviourUtil;
import at.tugraz.genome.tma.ejb.entity.Datadictionary;
import at.tugraz.genome.tma.ejb.entity.DatadictionaryUtil;
import at.tugraz.genome.tma.ejb.entity.Donor;
import at.tugraz.genome.tma.ejb.entity.DonorUtil;
import at.tugraz.genome.tma.ejb.entity.Grade;
import at.tugraz.genome.tma.ejb.entity.GradeUtil;
import at.tugraz.genome.tma.ejb.entity.Morphology;
import at.tugraz.genome.tma.ejb.entity.MorphologyUtil;
import at.tugraz.genome.tma.ejb.entity.Tissue;
import at.tugraz.genome.tma.ejb.entity.TissueUtil;
import at.tugraz.genome.tma.ejb.entity.Topography;
import at.tugraz.genome.tma.ejb.entity.TopographyUtil;
import at.tugraz.genome.tma.ejb.service.TissueDonorServiceBean;
import at.tugraz.genome.tma.ejb.vos.BehaviourVO;
import at.tugraz.genome.tma.ejb.vos.DatadictionaryVO;
import at.tugraz.genome.tma.ejb.vos.DonorVO;
import at.tugraz.genome.tma.ejb.vos.GradeVO;
import at.tugraz.genome.tma.ejb.vos.MorphologyVO;
import at.tugraz.genome.tma.ejb.vos.TissueDonorResultVO;
import at.tugraz.genome.tma.ejb.vos.TissueDonorVO;
import at.tugraz.genome.tma.ejb.vos.TissueVO;
import at.tugraz.genome.tma.ejb.vos.TopographyVO;
import at.tugraz.genome.tma.exceptions.FileDataException;
import at.tugraz.genome.tma.exceptions.FileParserException;
import at.tugraz.genome.tma.exceptions.TmaGlobalException;
import at.tugraz.genome.voutils.ValueTreeBuilder;
import java.io.ByteArrayInputStream;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.NamingException;

public class TissueDonorServiceBeanImpl
extends TissueDonorServiceBean
implements SessionBean {
    private static final int HEADER_POS_CLASSIFICATION = 5;
    private static final int HEADER_POS_CORE_COMMENTS = 8;
    private static final int HEADER_POS_DIAGNOSE = 1;
    private static final int HEADER_POS_GRADE = 6;
    private static final int HEADER_POS_MORPHOLOGY = 4;
    private static final int HEADER_POS_PARAFFIN_ID = 7;
    private static final int HEADER_POS_SAMPLE_ID = 2;
    private static final int HEADER_POS_SPECIES = 0;
    private static final int HEADER_POS_TOPOGRAPHY = 3;
    SessionContext context;

    public void addTissueDonor(TissueVO tissueVO, DonorVO donorVO) throws TmaGlobalException {
        this.log.debug("addTissueDonor: begin tissuevo=" + tissueVO + " donorvo=" + donorVO);
        if (tissueVO == null) {
            throw new TmaGlobalException("TissueVO is null");
        }
        if (tissueVO.getMorphology() == null) {
            throw new TmaGlobalException("MorphologyVO is null");
        }
        if (tissueVO.getTopography() == null) {
            throw new TmaGlobalException("TopographyVO is null");
        }
        if (tissueVO.getBehaviour() == null) {
            throw new TmaGlobalException("BehaviourVO is null");
        }
        if (tissueVO.getGrade() == null) {
            throw new TmaGlobalException("GradeVO is null");
        }
        donorVO.setTissue(tissueVO);
        this.addDonor(donorVO);
    }

    public void ejbActivate() {
    }

    public void ejbCreate() throws CreateException {
    }

    public void ejbPassivate() {
    }

    public void ejbRemove() {
    }

    private boolean existBarcode(Long barcodeid) throws TmaGlobalException {
        this.log.debug("findByBarcodeID: begin barcodeid=" + barcodeid);
        Donor entity = null;
        try {
            entity = DonorUtil.getLocalHome().findDonorByBarcodeID(barcodeid);
            return true;
        }
        catch (FinderException fex) {
            this.log.debug("BarcodeID not exists");
            return false;
        }
        catch (NamingException nex) {
            this.log.error("findByBarcodeID(barcodeid=" + barcodeid + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    public boolean existDonorBarcode(Long barcodeid) throws TmaGlobalException {
        return this.existBarcode(barcodeid);
    }

    public boolean existSampleID(Long sampleid) throws TmaGlobalException {
        try {
            this.log.debug("findBySampleID: begin");
            Tissue entity = TissueUtil.getLocalHome().findBySampleID(sampleid);
            return true;
        }
        catch (FinderException fex) {
            this.log.debug("SampleID not exists");
            return false;
        }
        catch (NamingException nex) {
            this.log.error("findBySampleID: NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    private BehaviourVO getBehaviourVO(Long id) throws TmaGlobalException {
        this.log.debug("getBehaviourVO: begin id=" + id);
        Behaviour entity = null;
        try {
            entity = BehaviourUtil.getLocalHome().findByPrimaryKey(id);
        }
        catch (FinderException fex) {
            this.log.debug("getBehaviourVO(id=" + id + "): FinderException thrown");
            return null;
        }
        catch (NamingException nex) {
            this.log.error("getBehaviourVO(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        BehaviourVO returnVO = (BehaviourVO)ValueTreeBuilder.getValueTree(entity, ValueTreeBuilder.createIncludeTree(""));
        this.log.info("getBehaviourVO: finished successfuly returnVO=" + returnVO);
        return returnVO;
    }

    private TissueDonorResultVO getData(int[] positions, String[] line, int lineNr) throws FileParserException {
        TissueDonorResultVO resultvo = new TissueDonorResultVO();
        try {
            resultvo.setError(false);
            resultvo.setLine(lineNr);
            resultvo.setSpecies(line[positions[0]]);
            resultvo.setMorphology(line[positions[4]]);
            resultvo.setTopography(line[positions[3]]);
            resultvo.setBehaviour(line[positions[5]]);
            resultvo.setGrade(line[positions[6]]);
            resultvo.setTissueComment(line[positions[1]]);
            resultvo.setCorecomment(line[positions[8]]);
            resultvo.setBarcode(line[positions[7]]);
            resultvo.setSample(line[positions[2]]);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            ex.printStackTrace();
            throw new FileParserException("Missing Field in tab delimited file in Line " + lineNr);
        }
        return resultvo;
    }

    private GradeVO getGradeVO(Long id) throws TmaGlobalException {
        this.log.debug("getGradeVO: begin id=" + id);
        Grade entity = null;
        try {
            entity = GradeUtil.getLocalHome().findByPrimaryKey(id);
        }
        catch (FinderException fex) {
            this.log.debug("getGradeVO(id=" + id + "): FinderException thrown");
            return null;
        }
        catch (NamingException nex) {
            this.log.error("getGradeVO(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        GradeVO returnVO = (GradeVO)ValueTreeBuilder.getValueTree(entity, ValueTreeBuilder.createIncludeTree(""));
        this.log.info("getGradeVO: finished successfuly returnVO=" + returnVO);
        return returnVO;
    }

    private MorphologyVO getMorphologyVO(Long id) throws TmaGlobalException {
        this.log.debug(" getMorphologyVO: begin id=" + id);
        Morphology entity = null;
        try {
            entity = MorphologyUtil.getLocalHome().findByPrimaryKey(id);
        }
        catch (FinderException fex) {
            this.log.debug("getMorphologyVO(id=" + id + "): FinderException thrown");
            return null;
        }
        catch (NamingException nex) {
            this.log.error("getMorphologyVO(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        MorphologyVO returnVO = (MorphologyVO)ValueTreeBuilder.getValueTree(entity, ValueTreeBuilder.createIncludeTree(""));
        this.log.info("getMorphologyVO: finished successfuly returnVO=" + returnVO);
        return returnVO;
    }

    private DatadictionaryVO getPersonVO(Long id) throws TmaGlobalException {
        this.log.debug("getPersonVO: begin id=" + id);
        Datadictionary entity = null;
        try {
            entity = DatadictionaryUtil.getLocalHome().findByPrimaryKey(id);
        }
        catch (FinderException fex) {
            this.log.debug("getPersonVO(id=" + id + "): FinderException thrown");
            this.log.error((Object)fex);
            return null;
        }
        catch (NamingException nex) {
            this.log.error("getPersonVO(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        DatadictionaryVO returnVO = (DatadictionaryVO)ValueTreeBuilder.getValueTree(entity, ValueTreeBuilder.createIncludeTree(""));
        this.log.info("getPersonVO: finished successfuly returnVO=" + returnVO);
        return returnVO;
    }

    private int[] getPositions(String[] header, String[] searchStrings) throws FileParserException {
        int[] positions_ = new int[searchStrings.length];
        int sscnt = 0;
        while (sscnt < searchStrings.length) {
            positions_[sscnt] = -1;
            int i = 0;
            while (i < header.length) {
                if (header[i].indexOf(searchStrings[sscnt]) != -1) {
                    if (positions_[sscnt] == -1) {
                        positions_[sscnt] = i;
                    } else {
                        throw new FileParserException("Redefine of " + searchStrings[sscnt] + " field, " + positions_[sscnt] + " vs " + i + "in cvs-file header");
                    }
                }
                ++i;
            }
            if (positions_[sscnt] == -1) {
                throw new FileParserException("Field " + searchStrings[sscnt] + " missing in cvs-file header");
            }
            ++sscnt;
        }
        return positions_;
    }

    private DatadictionaryVO getSpeciesVO(String species) throws TmaGlobalException {
        this.log.debug("findSpecies: begin species=" + species);
        String datatype = "SPECIES";
        Datadictionary entity = null;
        try {
            entity = DatadictionaryUtil.getLocalHome().findByValueAndType(species, datatype);
        }
        catch (FinderException fex) {
            this.log.debug("findSpecies(species=" + species + "): FinderException thrown");
            return null;
        }
        catch (NamingException nex) {
            this.log.error("findSpecies(species=" + species + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        DatadictionaryVO returnVO = (DatadictionaryVO)ValueTreeBuilder.getValueTree(entity, ValueTreeBuilder.createIncludeTree(""));
        this.log.info("findSpecies: finished successfuly returnVO=" + returnVO);
        return returnVO;
    }

    private TissueVO getTissueVOBySampleID(Long sampleid) throws TmaGlobalException {
        this.log.debug("getTissueVOBySampleID: begin sampleid=" + sampleid);
        Tissue entity = null;
        try {
            entity = TissueUtil.getLocalHome().findBySampleID(sampleid);
        }
        catch (FinderException fex) {
            this.log.error("getTissueVOBySampleID: begin sampleid=" + sampleid + "): FinderException thrown");
            this.log.error((Object)fex);
            return null;
        }
        catch (NamingException nex) {
            this.log.error("getTissueVOBySampleID: begin sampleid=" + sampleid + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        TissueVO returnVO = (TissueVO)ValueTreeBuilder.getValueTree(entity, ValueTreeBuilder.createIncludeTree("Topography,Morphology,Grade,Behaviour,Datadictionary"));
        this.log.debug("getTissueVOBySampleID: finished successfuly returnVO=" + returnVO);
        return returnVO;
    }

    private TopographyVO getTopographyVO(Long id) throws TmaGlobalException {
        this.log.debug("getTopographyVO: begin id=" + id);
        Topography entity = null;
        try {
            entity = TopographyUtil.getLocalHome().findByPrimaryKey(id);
        }
        catch (FinderException fex) {
            this.log.debug("getTopographyVO(id=" + id + "): FinderException thrown");
            return null;
        }
        catch (NamingException nex) {
            this.log.error("getTopographyVO(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        TopographyVO returnVO = (TopographyVO)ValueTreeBuilder.getValueTree(entity, ValueTreeBuilder.createIncludeTree(""));
        this.log.info("getTopographyVO: finished successfuly returnVO=" + returnVO);
        return returnVO;
    }

    public Vector insertTissueDonor(TissueDonorVO tissueDonorVO) throws FileDataException, FileParserException, TmaGlobalException {
        String ret;
        Vector<Object> retList = new Vector<Object>();
        Vector<Object> errorList = new Vector<Object>();
        String[][] data = null;
        data = this.parseCsv(tissueDonorVO.getCsv());
        String[] headerStrings = new String[]{"Species", "Diagnose", "Sample ID", "Topography", "Morphology", "Classification", "Grade", "Paraffin ID", "Core Comments"};
        int[] positions_ = this.getPositions(data[0], headerStrings);
        int tissueexist = 0;
        int donorexsist = 0;
        boolean noerror = true;
        int i = 1;
        while (i < data.length) {
            MorphologyVO morphvo_ = null;
            TopographyVO topovo_ = null;
            BehaviourVO behavvo_ = null;
            GradeVO gradevo_ = null;
            DatadictionaryVO speciesvo_ = null;
            DatadictionaryVO persvo_ = null;
            DonorVO donorvo_ = new DonorVO();
            TissueDonorResultVO resultvo_ = this.getData(positions_, data[i], i + 1);
            System.out.println("getData ready");
            if (resultvo_.getError()) {
                System.out.println("Error getData");
            } else {
                System.out.println("No Error in Data");
            }
            if (resultvo_.getMorphologyID() != null && (morphvo_ = this.getMorphologyVO(resultvo_.getMorphologyID())) == null) {
                String morph = resultvo_.getMorphology();
                resultvo_.setMorphologyNotFound(morph);
                this.log.debug("No Valid MorpologyID: " + resultvo_.getMorphologyID());
            }
            if (resultvo_.getTopographyID() != null && (topovo_ = this.getTopographyVO(resultvo_.getTopographyID())) == null) {
                String topo = resultvo_.getTopography();
                resultvo_.setTopographyNotFound(topo);
                this.log.debug("No Valid TopographyID: " + resultvo_.getTopographyID());
            }
            if (resultvo_.getBehaviourID() != null && (behavvo_ = this.getBehaviourVO(resultvo_.getBehaviourID())) == null) {
                String behav = resultvo_.getBehaviour();
                resultvo_.setBehaviourNotFound(behav);
                this.log.debug("No Valid BehaviourID: " + resultvo_.getBehaviourID());
            }
            if (resultvo_.getGradeID() != null && (gradevo_ = this.getGradeVO(resultvo_.getGradeID())) == null) {
                String grade = resultvo_.getGrade();
                resultvo_.setGradeNotFound(grade);
                this.log.debug("No Valid GradeID: " + resultvo_.getGradeID());
            }
            if (resultvo_.getSpecies().length() == 0) {
                resultvo_.setSpeciesMissing();
            } else {
                speciesvo_ = this.getSpeciesVO(resultvo_.getSpecies());
                if (speciesvo_ == null) {
                    String species = resultvo_.getSpecies();
                    resultvo_.setSpeciesNotFound(species);
                    this.log.debug("No Valid Species: " + resultvo_.getSpecies());
                }
            }
            persvo_ = this.getPersonVO(tissueDonorVO.getPersonID());
            if (persvo_ == null) {
                this.context.setRollbackOnly();
                throw new TmaGlobalException("Person not found");
            }
            if (resultvo_.getError()) {
                System.out.println("Error FindData");
            } else if (noerror) {
                TissueVO tissvo_ = this.getTissueVOBySampleID(resultvo_.getSampleID());
                if (tissvo_ == null) {
                    System.out.println("No Tissue found with this SampleID: " + resultvo_.getSampleID());
                    tissvo_ = new TissueVO();
                    tissvo_.setTissuecomment(resultvo_.getTissueComment());
                    tissvo_.setSampleId(resultvo_.getSampleID());
                    tissvo_.setBehaviour(behavvo_);
                    tissvo_.setGrade(gradevo_);
                    tissvo_.setMorphology(morphvo_);
                    tissvo_.setTopography(topovo_);
                    tissvo_.setDatadictionarySpecies(speciesvo_);
                } else {
                    ++tissueexist;
                }
                if (this.existBarcode(resultvo_.getBarcodeID())) {
                    ++donorexsist;
                } else {
                    System.out.println("No Donor found with this Barcode: " + resultvo_.getBarcodeID());
                    donorvo_.setBarcodeId(resultvo_.getBarcodeID());
                    donorvo_.setCorecomment(resultvo_.getCorecomment());
                    donorvo_.setDate(tissueDonorVO.getDate());
                    donorvo_.setUserid(tissueDonorVO.getUserid());
                    donorvo_.setDatadictionaryPerson(persvo_);
                    donorvo_.setTissue(tissvo_);
                    try {
                        DonorUtil.getLocalHome().create(donorvo_);
                        retList.add(resultvo_);
                    }
                    catch (Exception ex) {
                        resultvo_.setError(true);
                        this.log.info("ERROR addTissusDonor:" + ex.getMessage());
                    }
                }
            }
            if (resultvo_.getError()) {
                noerror = false;
                errorList.add(resultvo_);
            }
            ++i;
        }
        System.out.print("done");
        if (errorList.size() > 0) {
            System.out.print("rollback");
            ret = "Lines: " + (data.length - 1) + ", Errors: " + errorList.size();
            errorList.add(ret);
            this.context.setRollbackOnly();
            throw new FileDataException(errorList);
        }
        ret = "Lines:" + (data.length - 1) + ", Tissue exists: " + tissueexist + ", Donor exists: " + donorexsist;
        retList.add(ret);
        return retList;
    }

    private String[][] parseCsv(byte[] csv_) throws FileParserException {
        String[][] data_ = null;
        try {
            CSVParser parser = new CSVParser(new ByteArrayInputStream(csv_));
            parser.changeDelimiter(';');
            data_ = parser.getAllValues();
        }
        catch (Exception ex) {
            FileParserException pe = new FileParserException("Caught IOException in insertBulk()");
            pe.initCause(ex);
            throw pe;
        }
        if (data_.length < 2) {
            throw new FileParserException("Wrong cvs-file format, only one line");
        }
        return data_;
    }

    public void setSessionContext(SessionContext ctx) {
        this.context = ctx;
    }
}

