/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.tma.ejb.vos;

import at.tugraz.genome.tma.ejb.vos.DonorVO;
import at.tugraz.genome.tma.ejb.vos.DonorimageVO;
import at.tugraz.genome.tma.ejb.vos.TissueVO;
import at.tugraz.genome.usermUtilities.remote.vos.SubmitterVO;
import java.io.Serializable;
import java.util.Date;

public class DonorReportVO
implements Serializable {
    private Long barcodeid;
    private String corecomment;
    private Date date;
    private String deletable = null;
    private Long donorid;
    private int donorimages;
    private String morphology;
    private String person;
    private Long sampleid;
    private Long smallimageid = null;
    private Long tissueid;
    private String topography;
    private SubmitterVO userVO = null;
    private Long userid;

    public DonorReportVO(DonorVO vo) {
        this.donorid = vo.getDonorId();
        this.barcodeid = vo.getBarcodeId();
        this.corecomment = vo.getCorecomment();
        this.userVO = vo.getUserVO();
        this.userid = vo.getUserid();
        this.date = vo.getDate();
        TissueVO tissue = vo.getTissue();
        this.tissueid = tissue.getTissueId();
        this.sampleid = tissue.getSampleId();
        this.topography = tissue.getTopography().getTopography();
        this.morphology = tissue.getMorphology().getMorphology();
        this.person = vo.getDatadictionaryPerson().getDatavalue();
        this.donorimages = vo.getDonorimages().size();
        if (this.donorimages == 1) {
            DonorimageVO[] divoa = new DonorimageVO[1];
            vo.getDonorimages().toArray(divoa);
            this.smallimageid = divoa[0].getSmallimage().getSmallimageId();
        }
        if (vo.getArrayblocks().isEmpty()) {
            this.deletable = "on";
        }
    }

    public DonorReportVO() {
    }

    public Long getBarcodeid() {
        return this.barcodeid;
    }

    public String getCorecomment() {
        return this.corecomment;
    }

    public Date getDate() {
        return this.date;
    }

    public String getDeletable() {
        return this.deletable;
    }

    public Long getDonorid() {
        return this.donorid;
    }

    public String getDonorimages() {
        return Integer.toString(this.donorimages);
    }

    public String getMorphology() {
        return this.morphology;
    }

    public String getPerson() {
        return this.person;
    }

    public Long getSampleid() {
        return this.sampleid;
    }

    public Long getSmallimageid() {
        return this.smallimageid;
    }

    public Long getTissueid() {
        return this.tissueid;
    }

    public String getTopography() {
        return this.topography;
    }

    public SubmitterVO getUserVO() {
        return this.userVO;
    }

    public Long getUserid() {
        return this.userid;
    }
}

