/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.usermUtilities.remote.ejb;

import at.tugraz.genome.dbutilities.exception.EJBServerException;
import at.tugraz.genome.usermUtilities.UsermConstants;
import at.tugraz.genome.usermUtilities.remote.ejb.UserServiceBean;
import at.tugraz.genome.usermUtilities.remote.vos.SubmitterCache;
import at.tugraz.genome.usermUtilities.remote.vos.SubmitterVO;
import at.tugraz.genome.usermanagement.server.MessageBean;
import at.tugraz.genome.usermanagement.server.user.VO.ExtendedUserVO;
import at.tugraz.genome.usermanagement.server.user.VO.UserVO;
import at.tugraz.genome.usermanagement.serverconnection.ServerConnection;
import at.tugraz.genome.usermanagement.serverconnection.ServerConnectionManager;
import at.tugraz.genome.usermanagement.serverconnection.exception.UserSecurityException;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import server.Management.util.ServerConstants;

public class UserServiceBeanImpl
extends UserServiceBean
implements SessionBean {
    private SessionContext context;
    private static ServerConnection serverConnection = ServerConnectionManager.getInstance().getConnection("tma");

    public Long addSubmitter(SubmitterVO vo, String passwd, String loggedInUserName, String authenticationID, Collection toAdd, Collection toDel) throws UserSecurityException {
        this.log.debug("addSubmitter(at.tugraz.genome.usermUtilities.remote.vos.SubmitterVO vo, java.lang.String passwd, java.lang.String loggedInUserName, java.lang.String authenticationID, java.util.Collection toAdd, java.util.Collection toDel): begin");
        MessageBean mb = null;
        mb = serverConnection.addUser((ExtendedUserVO)vo, "tma", "", passwd, ServerConstants.PERIODE_YEARLY, authenticationID, loggedInUserName, UsermConstants.getMYAPPLICATIONKEY(), true);
        if (!mb.isError()) {
            this.setUserRights(vo.getName(), toAdd, toDel, authenticationID, loggedInUserName);
            return serverConnection.getUserIDFromName(vo.getName(), "tma", UsermConstants.getMYAPPLICATIONKEY());
        }
        return new Long(-1L);
    }

    public MessageBean changePassword(String username, String authenticationID, String oldPasswd, String newPasswd) throws UserSecurityException {
        this.log.info("changePassword");
        this.log.debug("authenticationID" + authenticationID);
        MessageBean mb = serverConnection.changePassword(username, "", authenticationID, newPasswd, oldPasswd, ServerConstants.PERIODE_YEARLY, "tma", UsermConstants.getMYAPPLICATIONKEY());
        System.out.println("MessageBean (Error,Message):" + mb.isError() + " " + mb.getMessage());
        return mb;
    }

    public void editSubmitter(SubmitterVO vo, String passwd, String loggedInUserName, String authenticationID, Collection toAdd, Collection toDel) throws UserSecurityException {
        this.log.debug("editSubmitter(at.tugraz.genome.usermUtilities.remote.vos.SubmitterVO vo, java.lang.String passwd, java.lang.String loggedInUserName, java.lang.String authenticationID, java.util.Collection toAdd, java.util.Collection toDel): begin");
        try {
            SubmitterCache.getInstance().removeFromCache(vo);
            this.log.debug("SubmitterVO id :" + vo.getId());
            serverConnection.editUser((ExtendedUserVO)vo, authenticationID, loggedInUserName, "tma", UsermConstants.getMYAPPLICATIONKEY());
            this.setUserRights(vo.getName(), toAdd, toDel, authenticationID, loggedInUserName);
        }
        catch (EJBServerException ex) {
            ex.printStackTrace();
        }
    }

    public void ejbActivate() {
    }

    public void ejbCreate() {
    }

    public void ejbPassivate() {
    }

    public void ejbRemove() {
    }

    public Collection getAllSubmitters(boolean includeInactive) throws UserSecurityException {
        this.log.debug("getAllSubmitters(boolean includeInactive): begin");
        try {
            return SubmitterCache.getInstance().getAllSubmitters(includeInactive);
        }
        catch (EJBServerException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public Vector getIDsByUserNameLike(String userName) throws UserSecurityException {
        this.log.info("getIDsByUserNameLike");
        Vector userVOs = serverConnection.getUserVOExtendedRegEx(userName, "tma", UsermConstants.getMYAPPLICATIONKEY());
        Vector<Long> returnVector = new Vector<Long>();
        Iterator it = ((AbstractList)userVOs).iterator();
        while (it.hasNext()) {
            UserVO userVO = (UserVO)it.next();
            returnVector.add(userVO.getID());
        }
        return returnVector;
    }

    public Long getIdByUserName(String userName) throws UserSecurityException {
        this.log.info("getIdByUserName");
        try {
            return SubmitterCache.getInstance().getIdByUserName(userName);
        }
        catch (EJBServerException ex) {
            throw new UserSecurityException(ex.getMessage());
        }
    }

    public SubmitterVO getSubmitter(Long id) throws UserSecurityException {
        this.log.debug("addSubmitter(java.lang.Long id): begin");
        System.out.println("In the Userm.getSubmitter: " + id);
        try {
            return SubmitterCache.getInstance().getSubmitter(id);
        }
        catch (EJBServerException ex) {
            ex.printStackTrace();
            SubmitterVO vo = new SubmitterVO("" + id, "", "", "", "", "", "", null, "", "");
            vo.setID(id);
            return vo;
        }
    }

    public void setSessionContext(SessionContext ctx) {
        this.context = ctx;
    }

    public void setUserRights(String username, Collection toAdd, Collection toDel, String authenticationID, String loggedInUserName) throws UserSecurityException {
        Iterator itAdd = toAdd.iterator();
        try {
            while (itAdd.hasNext()) {
                String add = (String)itAdd.next();
                serverConnection.addUserToGroup(username, add, authenticationID, loggedInUserName, "tma", UsermConstants.getMYAPPLICATIONKEY());
                this.log.debug("adding User to group     :" + add);
            }
            Iterator itDel = toDel.iterator();
            while (itDel.hasNext()) {
                String del = (String)itDel.next();
                serverConnection.removeUserFromGroup(username, del, authenticationID, loggedInUserName, "tma", UsermConstants.getMYAPPLICATIONKEY());
                this.log.debug("deleting User from group :" + del);
            }
        }
        catch (Exception e) {
            this.log.error(e);
        }
    }
}

