/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.usermUtilities.remote.vos;

import at.tugraz.genome.dbutilities.exception.EJBServerException;
import at.tugraz.genome.usermUtilities.UsermConstants;
import at.tugraz.genome.usermUtilities.remote.vos.SubmitterVO;
import at.tugraz.genome.usermanagement.server.user.VO.ExtendedUserVO;
import at.tugraz.genome.usermanagement.serverconnection.ServerConnection;
import at.tugraz.genome.usermanagement.serverconnection.ServerConnectionManager;
import at.tugraz.genome.usermanagement.serverconnection.exception.UserSecurityException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;

public class SubmitterCache {
    private static final long MAP_UPDATE_TIME_MS = 43200000L;
    private static final long UPDATE_TIME_MS = 600000L;
    private static SubmitterCache instance_ = null;
    private Logger log;
    private static ServerConnection serverConnection = null;
    HashMap submittersMap = null;
    long submittersMapTimestamp = System.currentTimeMillis();

    private SubmitterCache() throws EJBServerException {
        this.log = Logger.getLogger(this.getClass());
        try {
            serverConnection = ServerConnectionManager.getInstance().getConnection("tma");
            this.submittersMap = new HashMap();
        }
        catch (Exception ex) {
            throw new EJBServerException(ex.getMessage());
        }
    }

    public Collection getAllSubmitters(boolean includeInactive) {
        this.log.info((Object)"getAllSubmitters");
        Vector collORG = null;
        Vector<SubmitterVO> collVO = new Vector<SubmitterVO>();
        try {
            this.submittersMap.clear();
            this.submittersMapTimestamp = System.currentTimeMillis();
            this.log.debug((Object)("serverConnection" + serverConnection));
            collORG = serverConnection.getExtendedUsersOfApplication("tma", UsermConstants.getMYAPPLICATIONKEY(), true, false);
            Iterator it = collORG.iterator();
            while (it.hasNext()) {
                ExtendedUserVO extdUserVO = (ExtendedUserVO)it.next();
                if (!extdUserVO.isActiveAtCurrentApplication() && !includeInactive) continue;
                SubmitterVO submitterVO = new SubmitterVO(extdUserVO, System.currentTimeMillis());
                this.submittersMap.put(submitterVO.getId(), submitterVO);
                collVO.add(submitterVO);
            }
        }
        catch (UserSecurityException use) {
            this.log.error((Object)use.getMessage());
        }
        return collVO;
    }

    private SubmitterVO getFetchSubmitter(Long id) {
        this.log.debug((Object)("fetchSubmitter " + id));
        SubmitterVO submitterVO = null;
        try {
            ExtendedUserVO euVO = serverConnection.getUserByIDExtended(id, "tma", UsermConstants.getMYAPPLICATIONKEY());
            this.log.debug((Object)("fetched:" + euVO.getName() + " id :" + euVO.getID()));
            submitterVO = new SubmitterVO(euVO, System.currentTimeMillis());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error((Object)("Error fetching User:" + id + " " + e.getMessage()));
        }
        return submitterVO;
    }

    public Long getIdByUserName(String userName) throws UserSecurityException {
        this.log.info((Object)("getIdByUserName(String userName)" + userName));
        Vector v = new Vector(this.submittersMap.values());
        int i = 0;
        while (i < v.size()) {
            SubmitterVO vo = (SubmitterVO)v.get(i);
            if (vo.getName().equals(userName)) {
                this.log.debug((Object)"found in cache");
                return vo.getId();
            }
            ++i;
        }
        this.log.debug((Object)"Searching for name in Usermanagement");
        Long id = serverConnection.getUserIDFromName(userName, "tma", UsermConstants.getMYAPPLICATIONKEY());
        if (id != null) {
            this.getSubmitter(id);
        }
        return id;
    }

    public static SubmitterCache getInstance() throws EJBServerException {
        if (instance_ == null) {
            instance_ = new SubmitterCache();
        }
        return instance_;
    }

    public SubmitterVO getSubmitter(Long id) {
        SubmitterVO submitterVO;
        if (System.currentTimeMillis() - this.submittersMapTimestamp > 43200000L) {
            this.submittersMap.clear();
            this.submittersMapTimestamp = System.currentTimeMillis();
            this.log.debug((Object)("Cleared submittersMap size: " + this.submittersMap.size()));
        }
        if (this.submittersMap.containsKey(id)) {
            submitterVO = (SubmitterVO)this.submittersMap.get(id);
            if (System.currentTimeMillis() - submitterVO.getAccessTime() > 600000L) {
                this.log.debug((Object)("updating submittersMap .... " + submitterVO.getId()));
                submitterVO = this.getFetchSubmitter(id);
                this.submittersMap.put(submitterVO.getId(), submitterVO);
            }
        } else {
            submitterVO = this.getFetchSubmitter(id);
            this.submittersMap.put(submitterVO.getId(), submitterVO);
        }
        return submitterVO;
    }

    public void removeFromCache(SubmitterVO vo) {
        this.submittersMap.remove(vo.getId());
    }
}

