/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.utils;

import at.tugraz.genome.tma.GlobalConstantsGenerated;
import at.tugraz.genome.tmaService.ServerSettings;
import at.tugraz.genome.utils.upload.vos.FileUploadTypeVO;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class UtilsConstants {
    public static final String DATABASETYPE = "MYSQL";
    private static FileUploadTypeVO[] ENUM_FILETYPES;
    private static FileUploadTypeVO[] ENUM_FILETYPES_LOCAL;
    public static FileUploadTypeVO E_PLATE;
    public static String FILEUPLOAD_FIELD_ADDED_DATE;
    public static String FILEUPLOAD_FIELD_CATEGORY;
    public static String FILEUPLOAD_FIELD_DESCR;
    public static String FILEUPLOAD_FIELD_ID;
    public static String FILEUPLOAD_FIELD_NAME;
    public static String FILEUPLOAD_FIELD_PATH;
    public static String FILEUPLOAD_FIELD_SIZE;
    public static String FILEUPLOAD_FIELD_USER_ID;
    public static final String KEYGENERATORTYPE = "MYSQL";
    private static UtilsConstants instance_;
    private static ServerSettings serverSettings;

    static {
        serverSettings = null;
        instance_ = null;
        E_PLATE = new FileUploadTypeVO("Plate", "plates");
        ENUM_FILETYPES_LOCAL = new FileUploadTypeVO[]{E_PLATE};
        FILEUPLOAD_FIELD_ID = "ID";
        FILEUPLOAD_FIELD_NAME = "Name";
        FILEUPLOAD_FIELD_CATEGORY = "Category";
        FILEUPLOAD_FIELD_ADDED_DATE = "Added Date";
        FILEUPLOAD_FIELD_PATH = "filepathname";
        FILEUPLOAD_FIELD_SIZE = "filesize";
        FILEUPLOAD_FIELD_USER_ID = "userid";
        FILEUPLOAD_FIELD_DESCR = "descr";
    }

    public static String getDataRootDirectory() {
        if (instance_ == null) {
            instance_ = UtilsConstants.getInstance();
        }
        String dataRootDirectory = serverSettings.getProperty("DATAROOTDIRECTORY");
        return dataRootDirectory;
    }

    public static String getDatabase() {
        String databaseString = "MYSQL";
        if (instance_ == null) {
            instance_ = UtilsConstants.getInstance();
        }
        databaseString = serverSettings.getProperty("DATABASE");
        return databaseString;
    }

    public static FileUploadTypeVO[] getFileUploadTypes() {
        if (instance_ == null) {
            instance_ = UtilsConstants.getInstance();
        }
        return ENUM_FILETYPES;
    }

    public static boolean getGuestUserAllowed() {
        if (instance_ == null) {
            instance_ = UtilsConstants.getInstance();
        }
        String guestUserAllowed = serverSettings.getProperty("GUESTUSERALLOWED");
        boolean retValue = false;
        try {
            retValue = new Boolean(guestUserAllowed);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return retValue;
    }

    public static Long getGuestUserId() {
        return new Long(2012L);
    }

    public static UtilsConstants getInstance() {
        System.out.println("UtilsConstants.getInstance()");
        if (instance_ == null) {
            instance_ = new UtilsConstants();
            try {
                InitialContext ctx = new InitialContext();
                serverSettings = (ServerSettings)ctx.lookup("java:/TMAServerSettings");
                Vector eVect = UtilsConstants.loadFileUploadTypeXML();
                if (eVect != null) {
                    System.out.println("Using FileUploadTypeVO from XML File");
                    ENUM_FILETYPES = new FileUploadTypeVO[eVect.size()];
                    int i = 0;
                    while (i < eVect.size()) {
                        UtilsConstants.ENUM_FILETYPES[i] = (FileUploadTypeVO)eVect.get(i);
                        ++i;
                    }
                } else {
                    System.out.println("Using FileUploadTypeVO from Upload Utils Class");
                    ENUM_FILETYPES = ENUM_FILETYPES_LOCAL;
                }
            }
            catch (NamingException ex) {
                ex.printStackTrace();
                System.out.println(ex);
            }
        }
        return instance_;
    }

    public static Collection getSearchOperators() {
        return GlobalConstantsGenerated.getSearchOperators();
    }

    private static Vector loadFileUploadTypeXML() {
        System.out.println("loadFileUploadTypeXML");
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            Vector eVector = new Vector();
            DocumentBuilder builder = factory.newDocumentBuilder();
            String path = "config/FileUploadTypes.xml";
            if (!UtilsConstants.getDataRootDirectory().endsWith("/")) {
                path = "/" + path;
            }
            File f = new File(UtilsConstants.getDataRootDirectory() + path);
            FileInputStream inStream = new FileInputStream(f);
            document = builder.parse(inStream);
            Element root = document.getDocumentElement();
            root.normalize();
            UtilsConstants.parseXMLDocument(root, eVector);
            builder = null;
            factory = null;
            return eVector;
        }
        catch (SAXParseException spe) {
            Exception x = spe;
            if (spe.getException() != null) {
                x = spe.getException();
            }
            x.printStackTrace();
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            x.printStackTrace();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static void parseXMLDocument(Node currentNode, Vector eVector) {
        String displayName = "";
        String pathName = "";
        if (currentNode.getNodeName().compareTo("FileUploadType") == 0) {
            displayName = currentNode.getAttributes().getNamedItem("DisplayName").getNodeValue();
            pathName = currentNode.getAttributes().getNamedItem("PathName").getNodeValue();
            FileUploadTypeVO fileUploadTypeVO = new FileUploadTypeVO(displayName, pathName);
            eVector.add(fileUploadTypeVO);
        }
        NodeList list = currentNode.getChildNodes();
        int k = 0;
        while (k < list.getLength()) {
            Node nd = list.item(k);
            UtilsConstants.parseXMLDocument(nd, eVector);
            ++k;
        }
    }
}

