/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser;

import com.sun.xml.registry.client.browser.JBPanel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class CardManagerPanel
extends JBPanel {
    private GridBagConstraints c = new GridBagConstraints();
    private CardLayout cardLayout = null;
    protected JPanel selectorPanel = null;
    protected JPanel cardsPanel = null;
    protected String[] cards = null;
    protected JPanel[] cardPanels = null;
    ButtonGroup buttonGroup = null;
    HashMap cardToButtonMap = new HashMap();

    protected CardManagerPanel() {
    }

    public CardManagerPanel(String[] cards, JPanel[] cardPanels) {
        this.cards = cards;
        this.cardPanels = cardPanels;
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        this.selectorPanel = this.createSelectorPanel();
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 11;
        this.c.insets = new Insets(4, 4, 0, 4);
        gbl.setConstraints(this.selectorPanel, this.c);
        this.add(this.selectorPanel);
        this.cardsPanel = this.createCardsPanel();
        this.c.gridx = 0;
        this.c.gridy = 1;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.5;
        this.c.fill = 1;
        this.c.anchor = 11;
        this.c.insets = new Insets(4, 4, 0, 4);
        gbl.setConstraints(this.cardsPanel, this.c);
        this.add(this.cardsPanel);
    }

    private JPanel createSelectorPanel() {
        JPanel selectorPanel = new JPanel();
        this.buttonGroup = new ButtonGroup();
        for (int i = 0; i < this.cards.length; ++i) {
            final String card = this.cards[i];
            JRadioButton radioButton = new JRadioButton(card);
            if (i == 0) {
                radioButton.setSelected(true);
            }
            radioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CardManagerPanel.this.showCardAction(card);
                }
            });
            this.buttonGroup.add(radioButton);
            selectorPanel.add(radioButton);
            this.cardToButtonMap.put(card, radioButton);
        }
        return selectorPanel;
    }

    public void showCard(String card) {
        JRadioButton radioButton = (JRadioButton)this.cardToButtonMap.get(card);
        radioButton.doClick();
    }

    protected void showCardAction(String card) {
        this.cardLayout.show(this.cardsPanel, card);
    }

    private JPanel createCardsPanel() {
        JPanel cardsPanel = new JPanel();
        this.cardLayout = new CardLayout();
        cardsPanel.setLayout(this.cardLayout);
        for (int i = 0; i < this.cardPanels.length; ++i) {
            cardsPanel.add((Component)this.cardPanels[i], this.cards[i]);
        }
        return cardsPanel;
    }
}

