/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser;

import com.sun.xml.registry.client.browser.JAXRClient;
import com.sun.xml.registry.client.browser.NodeInfo;
import com.sun.xml.registry.client.browser.RegistryBrowser;
import com.sun.xml.registry.ebxml.util.ProviderProperties;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.RegistryObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConceptsTreeModel
extends DefaultTreeModel {
    RegistryBrowser registryBrowser;
    ConceptsTreeNode rootNode;
    RegistryObject rootTaxonomyElem = null;
    HashSet hiddenSchemes = null;
    private Log log = LogFactory.getLog(this.getClass());

    public ConceptsTreeModel(boolean updateOnCreate) {
        this(updateOnCreate, null);
    }

    public ConceptsTreeModel(boolean updateOnCreate, RegistryObject rootTaxonomyElem) {
        super(new DefaultMutableTreeNode());
        this.registryBrowser = RegistryBrowser.getInstance();
        if (rootTaxonomyElem != null && !(rootTaxonomyElem instanceof ClassificationScheme) && !(rootTaxonomyElem instanceof Concept)) {
            this.log.error((Object)("Only ClassificationScheme, Concept or null expected, got a " + rootTaxonomyElem));
        }
        this.rootTaxonomyElem = rootTaxonomyElem;
        if (updateOnCreate) {
            this.update();
        }
    }

    public void insertClassificationScheme(ClassificationScheme scheme) {
        NodeInfo nodeInfo = new NodeInfo();
        nodeInfo.obj = scheme;
        nodeInfo.loaded = true;
        ConceptsTreeNode newNode = new ConceptsTreeNode(nodeInfo);
        this.rootNode.add(new ConceptsTreeNode(nodeInfo));
        this.reload(this.rootNode);
    }

    public void insertConcept(Concept concept, DefaultMutableTreeNode parentNode) {
        NodeInfo nodeInfo = new NodeInfo();
        nodeInfo.obj = concept;
        nodeInfo.loaded = false;
        ConceptsTreeNode newNode = new ConceptsTreeNode(nodeInfo);
        parentNode.add(new ConceptsTreeNode(nodeInfo));
        this.reload(parentNode);
    }

    public void update() {
        JAXRClient client = RegistryBrowser.client;
        if (this.rootTaxonomyElem != null) {
            NodeInfo nodeInfo = new NodeInfo();
            nodeInfo.obj = this.rootTaxonomyElem;
            nodeInfo.loaded = false;
            this.rootNode = new ConceptsTreeNode(nodeInfo);
            this.setRoot(this.rootNode);
            String depthStr = ProviderProperties.getInstance().getProperty("jaxr-ebxml.registryBrowser.objectTypeCombo.initialFetchDepth", "4");
            int depth = Integer.parseInt(depthStr);
            this.expandTree(this.rootNode, depth);
        } else {
            this.rootNode = new ConceptsTreeNode("Concepts");
            this.setRoot(this.rootNode);
            Collection schemes = client.getClassificationSchemes();
            Iterator iter = schemes.iterator();
            while (iter.hasNext()) {
                ClassificationScheme scheme = (ClassificationScheme)iter.next();
                if (this.hideScheme(scheme)) continue;
                NodeInfo nodeInfo = new NodeInfo();
                nodeInfo.obj = scheme;
                nodeInfo.loaded = false;
                ConceptsTreeNode newNode = new ConceptsTreeNode(nodeInfo);
                this.rootNode.add(new ConceptsTreeNode(nodeInfo));
            }
        }
        this.reload(this.rootNode);
    }

    private boolean hideScheme(ClassificationScheme scheme) {
        boolean hide = false;
        try {
            String id = scheme.getKey().getId();
            if (this.getHiddenSchemes().contains(id)) {
                hide = true;
            }
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
        return hide;
    }

    private HashSet getHiddenSchemes() {
        if (this.hiddenSchemes == null) {
            this.hiddenSchemes = new HashSet();
            String hiddenSchemesStr = ProviderProperties.getInstance().getProperty("jaxr-ebxml.registryBrowser.ConceptsTreeModel.hiddenSchemesList");
            if (hiddenSchemesStr != null) {
                StringTokenizer tokenizer = new StringTokenizer(hiddenSchemesStr, "|");
                while (tokenizer.hasMoreTokens()) {
                    try {
                        String schemeId = tokenizer.nextToken();
                        this.hiddenSchemes.add(schemeId);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return this.hiddenSchemes;
    }

    public void expandTree(DefaultMutableTreeNode node, int depth) {
        Object userObj = node.getUserObject();
        if (!(userObj instanceof NodeInfo)) {
            return;
        }
        NodeInfo nodeInfo = (NodeInfo)userObj;
        if (nodeInfo.loaded) {
            return;
        }
        nodeInfo.loaded = true;
        Collection childConcepts = null;
        try {
            childConcepts = this.getChildConcepts(nodeInfo.obj);
        }
        catch (JAXRException e) {
            this.log.error((Object)e);
        }
        --depth;
        if (childConcepts != null) {
            Iterator iter = childConcepts.iterator();
            while (iter.hasNext()) {
                nodeInfo = new NodeInfo();
                Concept childConcept = (Concept)iter.next();
                nodeInfo.obj = childConcept;
                nodeInfo.loaded = false;
                ConceptsTreeNode newNode = new ConceptsTreeNode(nodeInfo);
                node.add(newNode);
                if (depth == 0) continue;
                this.expandTree(newNode, depth);
            }
            this.nodeStructureChanged(node);
        }
    }

    private String getName(RegistryObject ro) {
        String name = null;
        try {
            name = RegistryBrowser.getName(ro);
            if ((name == null || name.length() == 0) && ro instanceof Concept) {
                name = ((Concept)ro).getValue();
            }
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
        if (name == null) {
            name = "";
        }
        return name;
    }

    private Collection getChildConcepts(RegistryObject ro) throws JAXRException {
        Collection childConcepts = null;
        if (ro instanceof ClassificationScheme) {
            ClassificationScheme scheme = (ClassificationScheme)ro;
            childConcepts = scheme.getChildrenConcepts();
        } else if (ro instanceof Concept) {
            Concept concept = (Concept)ro;
            childConcepts = concept.getChildrenConcepts();
        }
        return childConcepts;
    }

    private class ConceptsTreeNode
    extends DefaultMutableTreeNode {
        ConceptsTreeNode(Object userObject) {
            super(userObject);
        }

        public String toString() {
            String str = super.toString();
            Object userObj = this.getUserObject();
            if (userObj instanceof NodeInfo) {
                NodeInfo nodeInfo = (NodeInfo)userObj;
                if (nodeInfo.obj instanceof RegistryObject) {
                    str = ConceptsTreeModel.this.getName(nodeInfo.obj);
                }
            }
            if (str == null) {
                str = "[no name info given]";
            }
            return str;
        }
    }
}

